# -*- coding: utf-8 -*-
"""Main module for DOLFIN"""

# Special module to handle import issues
import dolfin.importhandler

# Import UFL form language
from ufl import *

# Add log level present in C++ DOLFIN but not ufl.log
PROGRESS = 16

# Remove some unnecessary imports from UFL
del set_handler, set_level

# Import names from the compiled cpp modules
from . import cpp
from dolfin.cpp import *
from dolfin.cpp import __version__, __swigversion__, __pythonversion__

# Reset dl open flags
import sys
sys.setdlopenflags(dolfin.importhandler.stored_dlopen_flags)
del sys

# Repair namespace
from ufl import FiniteElement

# Import UFL color printing
from ufl.log import info_red, info_green, info_blue

# List of supported elements from FFC
try:
    from ffc import supported_elements, supported_elements_for_plotting
except:
    supported_elements = []
    supported_elements_for_plotting = []

# Imports from pure Python modules
from dolfin.common import *
from dolfin.functions import *
from dolfin.compilemodules import *
from dolfin.fem import *
from dolfin.mesh import *
from dolfin.multistage import *

# Handling of deprecated interfaces
from .deprecation import *

