/* Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com */
package com.db4odoc.Storage;

import java.util.*;

import com.db4o.*;
import com.db4o.config.*;

public class StorageExample {

	private final static String DB4O_FILE_NAME = "reference.db4o";
	
	public static void main(String[] args) {
		storePilot();
		deletePilot();
	}
	
	public static void storePilot(){
		ObjectContainer db = Db4oEmbedded.openFile(getLoggingStorage(), DB4O_FILE_NAME);
		Pilot p = new Pilot("Michael Schumacher", 100);
		db.store(p);
		db.close();
	}
	
	public static void deletePilot(){
		ObjectContainer db = Db4oEmbedded.openFile(getLoggingStorage(), DB4O_FILE_NAME);
		List<Pilot> pilots = db.queryByExample(new Pilot(null,0));
		Pilot pilot = pilots.get(0);
		System.out.println(pilot);
		System.out.println();
		
		db.delete(pilot);
		db.close();
	}
	
	public static EmbeddedConfiguration getLoggingStorage(){
		EmbeddedConfiguration config = Db4oEmbedded.newConfiguration();
		config.file().storage(new LoggingStorage());
		return config;
	} 
	
	
}
