/*
 *  mpadec - MPEG audio decoder
 *  Copyright (C) 2002-2004 Dmitriy Startsev (dstartsev@rambler.ru)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* $Id: tables.c,v 1.1.1.1 2004/07/27 02:58:48 metal_man Exp $ */

#include <math.h>
#include "csoundCore.h"
#include "mpadec_internal.h"

const uint16_t crc_table[256] = {
  0x0000, 0x8005, 0x800F, 0x000A, 0x801B, 0x001E, 0x0014, 0x8011,
  0x8033, 0x0036, 0x003C, 0x8039, 0x0028, 0x802D, 0x8027, 0x0022,
  0x8063, 0x0066, 0x006C, 0x8069, 0x0078, 0x807D, 0x8077, 0x0072,
  0x0050, 0x8055, 0x805F, 0x005A, 0x804B, 0x004E, 0x0044, 0x8041,
  0x80C3, 0x00C6, 0x00CC, 0x80C9, 0x00D8, 0x80DD, 0x80D7, 0x00D2,
  0x00F0, 0x80F5, 0x80FF, 0x00FA, 0x80EB, 0x00EE, 0x00E4, 0x80E1,
  0x00A0, 0x80A5, 0x80AF, 0x00AA, 0x80BB, 0x00BE, 0x00B4, 0x80B1,
  0x8093, 0x0096, 0x009C, 0x8099, 0x0088, 0x808D, 0x8087, 0x0082,
  0x8183, 0x0186, 0x018C, 0x8189, 0x0198, 0x819D, 0x8197, 0x0192,
  0x01B0, 0x81B5, 0x81BF, 0x01BA, 0x81AB, 0x01AE, 0x01A4, 0x81A1,
  0x01E0, 0x81E5, 0x81EF, 0x01EA, 0x81FB, 0x01FE, 0x01F4, 0x81F1,
  0x81D3, 0x01D6, 0x01DC, 0x81D9, 0x01C8, 0x81CD, 0x81C7, 0x01C2,
  0x0140, 0x8145, 0x814F, 0x014A, 0x815B, 0x015E, 0x0154, 0x8151,
  0x8173, 0x0176, 0x017C, 0x8179, 0x0168, 0x816D, 0x8167, 0x0162,
  0x8123, 0x0126, 0x012C, 0x8129, 0x0138, 0x813D, 0x8137, 0x0132,
  0x0110, 0x8115, 0x811F, 0x011A, 0x810B, 0x010E, 0x0104, 0x8101,
  0x8303, 0x0306, 0x030C, 0x8309, 0x0318, 0x831D, 0x8317, 0x0312,
  0x0330, 0x8335, 0x833F, 0x033A, 0x832B, 0x032E, 0x0324, 0x8321,
  0x0360, 0x8365, 0x836F, 0x036A, 0x837B, 0x037E, 0x0374, 0x8371,
  0x8353, 0x0356, 0x035C, 0x8359, 0x0348, 0x834D, 0x8347, 0x0342,
  0x03C0, 0x83C5, 0x83CF, 0x03CA, 0x83DB, 0x03DE, 0x03D4, 0x83D1,
  0x83F3, 0x03F6, 0x03FC, 0x83F9, 0x03E8, 0x83ED, 0x83E7, 0x03E2,
  0x83A3, 0x03A6, 0x03AC, 0x83A9, 0x03B8, 0x83BD, 0x83B7, 0x03B2,
  0x0390, 0x8395, 0x839F, 0x039A, 0x838B, 0x038E, 0x0384, 0x8381,
  0x0280, 0x8285, 0x828F, 0x028A, 0x829B, 0x029E, 0x0294, 0x8291,
  0x82B3, 0x02B6, 0x02BC, 0x82B9, 0x02A8, 0x82AD, 0x82A7, 0x02A2,
  0x82E3, 0x02E6, 0x02EC, 0x82E9, 0x02F8, 0x82FD, 0x82F7, 0x02F2,
  0x02D0, 0x82D5, 0x82DF, 0x02DA, 0x82CB, 0x02CE, 0x02C4, 0x82C1,
  0x8243, 0x0246, 0x024C, 0x8249, 0x0258, 0x825D, 0x8257, 0x0252,
  0x0270, 0x8275, 0x827F, 0x027A, 0x826B, 0x026E, 0x0264, 0x8261,
  0x0220, 0x8225, 0x822F, 0x022A, 0x823B, 0x023E, 0x0234, 0x8231,
  0x8213, 0x0216, 0x021C, 0x8219, 0x0208, 0x820D, 0x8207, 0x0202
};

const MYFLT newcos[8] = {
  0.93969262078590838405410927732473, -0.17364817766693034885171662676931,
 -0.76604444311897803520239265055542,  0.98480775301220805936674302458952,
 -0.34202014332566873304409961468226, -0.64278760968653932632264340990726,
  0.86602540378443864676372317075294,  0.5
};

const MYFLT tfcos36[9] = {
  0.50190991877167369479228784572231, 0.51763809020504152469779767524810,
  0.55168895948124587824344735167135, 0.61038729438072803416729403213053,
  0.70710678118654752440084436210485, 0.87172339781054900991884170836219,
  1.18310079157624925896683916310440, 1.93185165257813657349948639945780,
  5.73685662283492756457461251791420
};

const MYFLT tfcos12[3] = {
  0.5176380902050415246977976752481, 0.70710678118654752440084436210485,
  1.9318516525781365734994863994578
};

const MYFLT cs[8] = {
  0.85749292571254418689325777610964, 0.88174199731770518177557399759066,
  0.94962864910273289204833276115398, 0.98331459249179014599030200066392,
  0.99551781606758576429088040422867, 0.99916055817814750452934664352117,
  0.99989919524444704626703489425565, 0.99999315507028023572010150517204
};

const MYFLT ca[8] = {
 -0.5144957554275265121359546656657900, -0.4717319685649722722499320887110000,
 -0.3133774542039018543759498111808100, -0.1819131996109811770082058701228300,
 -0.0945741925264206476076336384017240, -0.0409655828853040476857032123843680,
 -0.0141985685724711480569918954984300, -0.0036999746737600368721643755691366
};

bandinfo_t band_info[9] = {
  /* MPEG 1.0 */
  { { 0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162,
      196, 238, 288, 342, 418, 576 },
    { 4, 4, 4, 4, 4, 4, 6, 6, 8, 8, 10, 12, 16, 20, 24, 28, 34, 42, 50,
      54, 76, 158 },
    { 0, 4*3, 8*3, 12*3, 16*3, 22*3, 30*3, 40*3, 52*3, 66*3, 84*3, 106*3,
      136*3, 192*3 },
    { 4, 4, 4, 4, 6, 8, 10, 12, 14, 18, 22, 30, 56 } },
  { { 0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156,
      190, 230, 276, 330, 384, 576 },
    { 4, 4, 4, 4, 4, 4, 6, 6, 6, 8, 10, 12, 16, 18, 22, 28, 34, 40, 46,
      54, 54, 192 },
    { 0, 4*3, 8*3, 12*3, 16*3, 22*3, 28*3, 38*3, 50*3, 64*3, 80*3, 100*3,
      126*3, 192*3 },
    { 4, 4, 4, 4, 6, 6, 10, 12, 14, 16, 20, 26, 66 } },
  { { 0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194,
      240, 296, 364, 448, 550, 576 },
    { 4, 4, 4, 4, 4, 4, 6, 6, 8, 10, 12, 16, 20, 24, 30, 38, 46, 56, 68,
      84, 102, 26 },
    { 0, 4*3, 8*3, 12*3, 16*3, 22*3, 30*3, 42*3, 58*3, 78*3, 104*3, 138*3,
      180*3, 192*3 },
    { 4, 4, 4, 4, 6, 8, 12, 16, 20, 26, 34, 42, 12 } },
  /* MPEG 2.0 */
  { { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200,
      238, 284, 336, 396, 464, 522, 576 },
    { 6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60,
      68, 58, 54 },
    { 0, 4*3, 8*3, 12*3, 18*3, 24*3, 32*3, 42*3, 56*3, 74*3, 100*3, 132*3,
      174*3, 192*3 },
    { 4, 4, 4, 6, 6, 8, 10, 14, 18, 26, 32, 42, 18 } },
  { { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 114, 136, 162, 194,
      232, 278, 330, 394, 464, 540, 576 },
    { 6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 18, 22, 26, 32, 38, 46, 52, 64,
      70, 76, 36 },
    { 0, 4*3, 8*3, 12*3, 18*3, 26*3, 36*3, 48*3, 62*3, 80*3, 104*3, 136*3,
      180*3, 192*3 },
    { 4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 32, 44, 12 } },
  { { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200,
      238, 284, 336, 396, 464, 522, 576 },
    { 6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60,
      68, 58, 54 },
    { 0, 4*3, 8*3, 12*3, 18*3, 26*3, 36*3, 48*3, 62*3, 80*3, 104*3, 134*3,
      174*3, 192*3 },
    { 4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18 } },
  /* MPEG 2.5 */
  { { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200,
        238, 284, 336, 396, 464, 522, 576 },
    { 6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60,
        68, 58, 54 },
    { 0, 12, 24, 36, 54, 78, 108, 144, 186, 240, 312, 402, 522, 576 },
    { 4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18 } },
  { { 0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200,
        238, 284, 336, 396, 464, 522, 576 },
    { 6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60,
        68, 58, 54 },
    { 0, 12, 24, 36, 54, 78, 108, 144, 186, 240, 312, 402, 522, 576 },
    { 4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18 } },
  { { 0, 12, 24, 36, 48, 60, 72, 88, 108, 132, 160, 192, 232, 280, 336,
        400, 476, 566, 568, 570, 572, 574, 576 },
    { 12, 12, 12, 12, 12, 12, 16, 20, 24, 28, 32, 40, 48, 56, 64, 76, 90,
        2, 2, 2, 2, 2 },
    { 0, 24, 48, 72, 108, 156, 216, 288, 372, 480, 486, 492, 498, 576 },
    { 8, 8, 8, 12, 16, 20, 24, 28, 36, 2, 2, 2, 26 } },
};

static alloc_table_t alloc_0[] = {
  {4,0}, {5,3}, {3,-3}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511},
  {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383}, {16,-32767},
  {4,0}, {5,3}, {3,-3}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511},
  {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383}, {16,-32767},
  {4,0}, {5,3}, {3,-3}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511},
  {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31},
  {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767}
};

static alloc_table_t alloc_1[] = {
  {4,0}, {5,3}, {3,-3}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511},
  {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383}, {16,-32767},
  {4,0}, {5,3}, {3,-3}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511},
  {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383}, {16,-32767},
  {4,0}, {5,3}, {3,-3}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511},
  {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {3,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767},
  {2,0}, {5,3}, {7,5}, {16,-32767}
};

static alloc_table_t alloc_2[] = {
  {4,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
         {8,-127}, {9,-255},
  {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383},
  {4,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
         {8,-127}, {9,-255},
  {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}
};

static alloc_table_t alloc_3[] = {
  {4,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
         {8,-127}, {9,-255},
  {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383},
  {4,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
         {8,-127}, {9,-255},
  {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191}, {15,-16383},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}
};

static alloc_table_t alloc_4[] = {
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191},
  {4,0}, {5,3}, {7,5}, {3,-3}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63}, {8,-127},
  {9,-255}, {10,-511}, {11,-1023}, {12,-2047}, {13,-4095}, {14,-8191},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {3,0}, {5,3}, {7,5}, {10,9}, {4,-7}, {5,-15}, {6,-31}, {7,-63},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9},
  {2,0}, {5,3}, {7,5}, {10,9}
};

alloc_table_t *alloc_tables[5] = { alloc_0, alloc_1, alloc_2, alloc_3, alloc_4 };

static int16_t tab0[] = { 0 };

static int16_t tab1[] = { -5, -3, -1, 17,  1, 16,  0 };

static int16_t tab2[] = {
   -15,  -11,   -9,   -5,   -3,   -1,   34,    2,   18,  -1,  33,  32,
   17,  -1,   1,  16,    0
};

static int16_t tab3[] = {
   -13,  -11,   -9,   -5,   -3,   -1,   34,    2,   18,  -1,  33,  32,
   16,  17,  -1,  1,    0
};

static int16_t tab5[] = {
   -29,  -25,  -23,  -15,   -7,   -5,   -3,   -1,   51,  35,  50,  49,
   -3,  -1,  19,
     3,   -1,   48,   34,   -3,   -1,   18,   33,   -1,   2,  32,  17,
   -1,   1,  16,
     0
};

static int16_t tab6[] = {
   -25,  -19,  -13,   -9,   -5,   -3,   -1,   51,    3,  35,  -1,  50,
   48,  -1,  19,
    49,   -3,   -1,   34,    2,   18,   -3,   -1,   33,  32,   1,  -1,
   17,  -1,  16,
     0
};

static int16_t tab7[] = {
   -69,  -65,  -57,  -39,  -29,  -17,  -11,   -7,   -3,  -1,  85,  69,
   -1,  84,  83,
    -1,   53,   68,   -3,   -1,   37,   82,   21,   -5,  -1,  81,  -1,
   5,  52,  -1,
    80,   -1,   67,   51,   -5,   -3,   -1,   36,   66,  20,  -1,  65,
   64, -11,  -7,
    -3,   -1,    4,   35,   -1,   50,    3,   -1,   19,  49,  -3,  -1,
   48,  34,  18,
    -5,   -1,   33,   -1,    2,   32,   17,   -1,    1,  16,   0
};

static int16_t tab8[] = {
   -65,  -63,  -59,  -45,  -31,  -19,  -13,   -7,   -5,  -3,  -1,  85,
   84,  69,  83,
    -3,   -1,   53,   68,   37,   -3,   -1,   82,    5,  21,  -5,  -1,
   81,  -1,  52,
    67,   -3,   -1,   80,   51,   36,   -5,   -3,   -1,  66,  20,  65,
   -3,  -1,   4,
    64,   -1,   35,   50,   -9,   -7,   -3,   -1,   19,  49,  -1,   3,
   48,  34,  -1,
     2,   32,   -1,   18,   33,   17,   -3,   -1,    1,  16,   0
};

static int16_t tab9[] = {
   -63,  -53,  -41,  -29,  -19,  -11,   -5,   -3,   -1,  85,  69,  53,
   -1,  83,   -1,
    84,    5,   -3,   -1,   68,   37,   -1,   82,   21,  -3,  -1,  81,
   52,  -1,   67,
    -1,   80,    4,   -7,   -3,   -1,   36,   66,   -1,  51,  64,  -1,
   20,  65,   -5,
    -3,   -1,   35,   50,   19,   -1,   49,   -1,    3,  48,  -5,  -3,
   -1,  34,    2,
    18,   -1,   33,   32,   -3,   -1,   17,    1,   -1,  16,   0
};

static int16_t tab10[] = {
  -125, -121, -111,  -83,  -55,  -35,  -21,  -13,   -7,  -3,  -1, 119,
  103,  -1,  118,
    87,   -3,   -1,  117,  102,   71,   -3,   -1,  116,  86,  -1, 101,
  55,  -9,   -3,
    -1,  115,   70,   -3,   -1,   85,   84,   99,   -1,  39, 114, -11,
  -5,  -3,   -1,
   100,    7,  112,   -1,   98,   -1,   69,   53,   -5,  -1,   6,  -1,
  83,  68,   23,
   -17,   -5,   -1,  113,   -1,   54,   38,   -5,   -3,  -1,  37,  82,
  21,  -1,   81,
    -1,   52,   67,   -3,   -1,   22,   97,   -1,   96,  -1,   5,  80,
  -19, -11,   -7,
    -3,   -1,   36,   66,   -1,   51,    4,   -1,   20,  65,  -3,  -1,
  64,  35,   -1,
    50,    3,   -3,   -1,   19,   49,   -1,   48,   34,  -7,  -3,  -1,
  18,  33,   -1,
     2,   32,   17,   -1,    1,   16,    0
};

static int16_t tab11[] = {
  -121, -113,  -89,  -59,  -43,  -27,  -17,   -7,   -3,  -1, 119, 103,
  -1, 118,  117,
    -3,   -1,  102,   71,   -1,  116,   -1,   87,   85,  -5,  -3,  -1,
  86, 101,   55,
    -1,  115,   70,   -9,   -7,   -3,   -1,   69,   84,  -1,  53,  83,
  39,  -1,  114,
    -1,  100,    7,   -5,   -1,  113,   -1,   23,  112,  -3,  -1,  54,
  99,  -1,   96,
    -1,   68,   37,  -13,   -7,   -5,   -3,   -1,   82,   5,  21,  98,
  -3,  -1,   38,
     6,   22,   -5,   -1,   97,   -1,   81,   52,   -5,  -1,  80,  -1,
  67,  51,   -1,
    36,   66,  -15,  -11,   -7,   -3,   -1,   20,   65,  -1,   4,  64,
  -1,  35,   50,
    -1,   19,   49,   -5,   -3,   -1,    3,   48,   34,  33,  -5,  -1,
  18,  -1,    2,
    32,   17,   -3,   -1,    1,   16,    0
};

static int16_t tab12[] = {
  -115,  -99,  -73,  -45,  -27,  -17,   -9,   -5,   -3,  -1, 119, 103,
  118,  -1,   87,
   117,   -3,   -1,  102,   71,   -1,  116,  101,   -3,  -1,  86,  55,
  -3,  -1,  115,
    85,   39,   -7,   -3,   -1,  114,   70,   -1,  100,  23,  -5,  -1,
  113,  -1,    7,
   112,   -1,   54,   99,  -13,   -9,   -3,   -1,   69,  84,  -1,  68,
  -1,   6,    5,
    -1,   38,   98,   -5,   -1,   97,   -1,   22,   96,  -3,  -1,  53,
  83,  -1,   37,
    82,  -17,   -7,   -3,   -1,   21,   81,   -1,   52,  67,  -5,  -3,
  -1,  80,    4,
    36,   -1,   66,   20,   -3,   -1,   51,   65,   -1,  35,  50, -11,
  -7,  -5,   -3,
    -1,   64,    3,   48,   19,   -1,   49,   34,   -1,  18,  33,  -7,
  -5,  -3,   -1,
     2,   32,    0,   17,   -1,    1,   16
};

static int16_t tab13[] = {
  -509, -503, -475, -405, -333, -265, -205, -153, -115, -83, -53, -35,
  -21, -13,   -9,
    -7,   -5,   -3,   -1,  254,  252,  253,  237,  255,  -1, 239, 223,
  -3,  -1,  238,
   207,   -1,  222,  191,   -9,   -3,   -1,  251,  206,  -1, 220,  -1,
  175, 233,   -1,
   236,  221,   -9,   -5,   -3,   -1,  250,  205,  190,  -1, 235, 159,
  -3,  -1,  249,
   234,   -1,  189,  219,  -17,   -9,   -3,   -1,  143, 248,  -1, 204,
  -1, 174,  158,
    -5,   -1,  142,   -1,  127,  126,  247,   -5,   -1, 218,  -1, 173,
  188,  -3,   -1,
   203,  246,  111,  -15,   -7,   -3,   -1,  232,   95,  -1, 157, 217,
  -3,  -1,  245,
   231,   -1,  172,  187,   -9,   -3,   -1,   79,  244,  -3,  -1, 202,
  230, 243,   -1,
    63,   -1,  141,  216,  -21,   -9,   -3,   -1,   47, 242,  -3,  -1,
  110, 156,   15,
    -5,   -3,   -1,  201,   94,  171,   -3,   -1,  125, 215,  78, -11,
  -5,  -3,   -1,
   200,  214,   62,   -1,  185,   -1,  155,  170,   -1,  31, 241, -23,
  -13,  -5,   -1,
   240,   -1,  186,  229,   -3,   -1,  228,  140,   -1, 109, 227,  -5,
  -1, 226,   -1,
    46,   14,   -1,   30,  225,  -15,   -7,   -3,   -1, 224,  93,  -1,
  213, 124,   -3,
    -1,  199,   77,   -1,  139,  184,   -7,   -3,   -1, 212, 154,  -1,
  169, 108,   -1,
   198,   61,  -37,  -21,   -9,   -5,   -3,   -1,  211, 123,  45,  -1,
  210,  29,   -5,
    -1,  183,   -1,   92,  197,   -3,   -1,  153,  122, 195,  -7,  -5,
  -3,  -1,  167,
   151,   75,  209,   -3,   -1,   13,  208,   -1,  138, 168, -11,  -7,
  -3,  -1,   76,
   196,   -1,  107,  182,   -1,   60,   44,   -3,   -1, 194,  91,  -3,
  -1, 181,  137,
    28,  -43,  -23,  -11,   -5,   -1,  193,   -1,  152,  12,  -1, 192,
  -1, 180,  106,
    -5,   -3,   -1,  166,  121,   59,   -1,  179,   -1, 136,  90, -11,
  -5,  -1,   43,
    -1,  165,  105,   -1,  164,   -1,  120,  135,   -5,  -1, 148,  -1,
  119, 118,  178,
   -11,   -3,   -1,   27,  177,   -3,   -1,   11,  176,  -1, 150,  74,
  -7,  -3,   -1,
    58,  163,   -1,   89,  149,   -1,   42,  162,  -47, -23,  -9,  -3,
  -1,  26,  161,
    -3,   -1,   10,  104,  160,   -5,   -3,   -1,  134,  73, 147,  -3,
  -1,  57,   88,
    -1,  133,  103,   -9,   -3,   -1,   41,  146,   -3,  -1,  87, 117,
  56,  -5,   -1,
   131,   -1,  102,   71,   -3,   -1,  116,   86,   -1, 101, 115, -11,
  -3,  -1,   25,
   145,   -3,   -1,    9,  144,   -1,   72,  132,   -7,  -5,  -1, 114,
  -1,  70,  100,
    40,   -1,  130,   24,  -41,  -27,  -11,   -5,   -3,  -1,  55,  39,
  23,  -1,  113,
    -1,   85,    7,   -7,   -3,   -1,  112,   54,   -1,  99,  69,  -3,
  -1,  84,   38,
    -1,   98,   53,   -5,   -1,  129,   -1,    8,  128,  -3,  -1,  22,
  97,  -1,    6,
    96,  -13,   -9,   -5,   -3,   -1,   83,   68,   37,  -1,  82,   5,
  -1,  21,   81,
    -7,   -3,   -1,   52,   67,   -1,   80,   36,   -3,  -1,  66,  51,
  20, -19,  -11,
    -5,   -1,   65,   -1,    4,   64,   -3,   -1,   35,  50,  19,  -3,
  -1,  49,    3,
    -1,   48,   34,   -3,   -1,   18,   33,   -1,    2,  32,  -3,  -1,
  17,   1,   16,
     0
};

static int16_t tab15[] = {
  -495, -445, -355, -263, -183, -115,  -77,  -43,  -27, -13,  -7,  -3,
  -1, 255,  239,
    -1,  254,  223,   -1,  238,   -1,  253,  207,   -7,  -3,  -1, 252,
  222,  -1,  237,
   191,   -1,  251,   -1,  206,  236,   -7,   -3,   -1, 221, 175,  -1,
  250, 190,   -3,
    -1,  235,  205,   -1,  220,  159,  -15,   -7,   -3,  -1, 249, 234,
  -1, 189,  219,
    -3,   -1,  143,  248,   -1,  204,  158,   -7,   -3,  -1, 233, 127,
  -1, 247,  173,
    -3,   -1,  218,  188,   -1,  111,   -1,  174,   15, -19, -11,  -3,
  -1, 203,  246,
    -3,   -1,  142,  232,   -1,   95,  157,   -3,   -1, 245, 126,  -1,
  231, 172,   -9,
    -3,   -1,  202,  187,   -3,   -1,  217,  141,   79,  -3,  -1, 244,
  63,  -1,  243,
   216,  -33,  -17,   -9,   -3,   -1,  230,   47,   -1, 242,  -1, 110,
  240,  -3,   -1,
    31,  241,   -1,  156,  201,   -7,   -3,   -1,   94, 171,  -1, 186,
  229,  -3,   -1,
   125,  215,   -1,   78,  228,  -15,   -7,   -3,   -1, 140, 200,  -1,
  62, 109,   -3,
    -1,  214,  227,   -1,  155,  185,   -7,   -3,   -1,  46, 170,  -1,
  226,  30,   -5,
    -1,  225,   -1,   14,  224,   -1,   93,  213,  -45, -25, -13,  -7,
  -3,  -1,  124,
   199,   -1,   77,  139,   -1,  212,   -1,  184,  154,  -7,  -3,  -1,
  169, 108,   -1,
   198,   61,   -1,  211,  210,   -9,   -5,   -3,   -1,  45,  13,  29,
  -1, 123,  183,
    -5,   -1,  209,   -1,   92,  208,   -1,  197,  138, -17,  -7,  -3,
  -1, 168,   76,
    -1,  196,  107,   -5,   -1,  182,   -1,  153,   12,  -1,  60, 195,
  -9,  -3,   -1,
   122,  167,   -1,  166,   -1,  192,   11,   -1,  194,  -1,  44,  91,
  -55, -29,  -15,
    -7,   -3,   -1,  181,   28,   -1,  137,  152,   -3,  -1, 193,  75,
  -1, 180,  106,
    -5,   -3,   -1,   59,  121,  179,   -3,   -1,  151, 136,  -1,  43,
  90, -11,   -5,
    -1,  178,   -1,  165,   27,   -1,  177,   -1,  176, 105,  -7,  -3,
  -1, 150,   74,
    -1,  164,  120,   -3,   -1,  135,   58,  163,  -17,  -7,  -3,  -1,
  89, 149,   -1,
    42,  162,   -3,   -1,   26,  161,   -3,   -1,   10, 160, 104,  -7,
  -3,  -1,  134,
    73,   -1,  148,   57,   -5,   -1,  147,   -1,  119,   9,  -1,  88,
  133, -53,  -29,
   -13,   -7,   -3,   -1,   41,  103,   -1,  118,  146,  -1, 145,  -1,
  25, 144,   -7,
    -3,   -1,   72,  132,   -1,   87,  117,   -3,   -1,  56, 131,  -1,
  102,  71,   -7,
    -3,   -1,   40,  130,   -1,   24,  129,   -7,   -3,  -1, 116,   8,
  -1, 128,   86,
    -3,   -1,  101,   55,   -1,  115,   70,  -17,   -7,  -3,  -1,  39,
  114,  -1,  100,
    23,   -3,   -1,   85,  113,   -3,   -1,    7,  112,  54,  -7,  -3,
  -1,  99,   69,
    -1,   84,   38,   -3,   -1,   98,   22,   -3,   -1,   6,  96,  53,
  -33, -19,   -9,
    -5,   -1,   97,   -1,   83,   68,   -1,   37,   82,  -3,  -1,  21,
  81,  -3,   -1,
     5,   80,   52,   -7,   -3,   -1,   67,   36,   -1,  66,  51,  -1,
  65,  -1,   20,
     4,   -9,   -3,   -1,   35,   50,   -3,   -1,   64,   3,  19,  -3,
  -1,  49,   48,
    34,   -9,   -7,   -3,   -1,   18,   33,   -1,    2,  32,  17,  -3,
  -1,   1,   16,
     0
};

static int16_t tab16[] = {
  -509, -503, -461, -323, -103,  -37,  -27,  -15,   -7,  -3,  -1, 239,
  254,  -1,  223,
   253,   -3,   -1,  207,  252,   -1,  191,  251,   -5,  -1, 175,  -1,
  250, 159,   -3,
    -1,  249,  248,  143,   -7,   -3,   -1,  127,  247,  -1, 111, 246,
  255,  -9,   -5,
    -3,   -1,   95,  245,   79,   -1,  244,  243,  -53,  -1, 240,  -1,
  63, -29,  -19,
   -13,   -7,   -5,   -1,  206,   -1,  236,  221,  222,  -1, 233,  -1,
  234, 217,   -1,
   238,   -1,  237,  235,   -3,   -1,  190,  205,   -3,  -1, 220, 219,
  174, -11,   -5,
    -1,  204,   -1,  173,  218,   -3,   -1,  126,  172, 202,  -5,  -3,
  -1, 201,  125,
    94,  189,  242,  -93,   -5,   -3,   -1,   47,   15,  31,  -1, 241,
  -49, -25,  -13,
    -5,   -1,  158,   -1,  188,  203,   -3,   -1,  142, 232,  -1, 157,
  231,  -7,   -3,
    -1,  187,  141,   -1,  216,  110,   -1,  230,  156, -13,  -7,  -3,
  -1, 171,  186,
    -1,  229,  215,   -1,   78,   -1,  228,  140,   -3,  -1, 200,  62,
  -1, 109,   -1,
   214,  155,  -19,  -11,   -5,   -3,   -1,  185,  170, 225,  -1, 212,
  -1, 184,  169,
    -5,   -1,  123,   -1,  183,  208,  227,   -7,   -3,  -1,  14, 224,
  -1,  93,  213,
    -3,   -1,  124,  199,   -1,   77,  139,  -75,  -45, -27, -13,  -7,
  -3,  -1,  154,
   108,   -1,  198,   61,   -3,   -1,   92,  197,   13,  -7,  -3,  -1,
  138, 168,   -1,
   153,   76,   -3,   -1,  182,  122,   60,  -11,   -5,  -3,  -1,  91,
  137,  28,   -1,
   192,   -1,  152,  121,   -1,  226,   -1,   46,   30, -15,  -7,  -3,
  -1, 211,   45,
    -1,  210,  209,   -5,   -1,   59,   -1,  151,  136,  29,  -7,  -3,
  -1, 196,  107,
    -1,  195,  167,   -1,   44,   -1,  194,  181,  -23, -13,  -7,  -3,
  -1, 193,   12,
    -1,   75,  180,   -3,   -1,  106,  166,  179,   -5,  -3,  -1,  90,
  165,  43,   -1,
   178,   27,  -13,   -5,   -1,  177,   -1,   11,  176,  -3,  -1, 105,
  150,  -1,   74,
   164,   -5,   -3,   -1,  120,  135,  163,   -3,   -1,  58,  89,  42,
  -97, -57,  -33,
   -19,  -11,   -5,   -3,   -1,  149,  104,  161,   -3,  -1, 134, 119,
  148,  -5,   -3,
    -1,   73,   87,  103,  162,   -5,   -1,   26,   -1,  10, 160,  -3,
  -1,  57,  147,
    -1,   88,  133,   -9,   -3,   -1,   41,  146,   -3,  -1, 118,   9,
  25,  -5,   -1,
   145,   -1,  144,   72,   -3,   -1,  132,  117,   -1,  56, 131, -21,
  -11,  -5,   -3,
    -1,  102,   40,  130,   -3,   -1,   71,  116,   24,  -3,  -1, 129,
  128,  -3,   -1,
     8,   86,   55,   -9,   -5,   -1,  115,   -1,  101,  70,  -1,  39,
  114,  -5,   -3,
    -1,  100,   85,    7,   23,  -23,  -13,   -5,   -1, 113,  -1, 112,
  54,  -3,   -1,
    99,   69,   -1,   84,   38,   -3,   -1,   98,   22,  -1,  97,  -1,
  6,  96,   -9,
    -5,   -1,   83,   -1,   53,   68,   -1,   37,   82,  -1,  81,  -1,
  21,   5,  -33,
   -23,  -13,   -7,   -3,   -1,   52,   67,   -1,   80,  36,  -3,  -1,
  66,  51,   20,
    -5,   -1,   65,   -1,    4,   64,   -1,   35,   50,  -3,  -1,  19,
  49,  -3,   -1,
     3,   48,   34,   -3,   -1,   18,   33,   -1,    2,  32,  -3,  -1,
  17,   1,   16,
     0
};

static int16_t tab24[] = {
  -451, -117,  -43,  -25,  -15,   -7,   -3,   -1,  239, 254,  -1, 223,
  253,  -3,   -1,
   207,  252,   -1,  191,  251,   -5,   -1,  250,   -1, 175, 159,  -1,
  249, 248,   -9,
    -5,   -3,   -1,  143,  127,  247,   -1,  111,  246,  -3,  -1,  95,
  245,  -1,   79,
   244,  -71,   -7,   -3,   -1,   63,  243,   -1,   47, 242,  -5,  -1,
  241,  -1,   31,
   240,  -25,   -9,   -1,   15,   -3,   -1,  238,  222,  -1, 237, 206,
  -7,  -3,   -1,
   236,  221,   -1,  190,  235,   -3,   -1,  205,  220,  -1, 174, 234,
  -15,  -7,   -3,
    -1,  189,  219,   -1,  204,  158,   -3,   -1,  233, 173,  -1, 218,
  188,  -7,   -3,
    -1,  203,  142,   -1,  232,  157,   -3,   -1,  217, 126,  -1, 231,
  172, 255, -235,
  -143,  -77,  -45,  -25,  -15,   -7,   -3,   -1,  202, 187,  -1, 141,
  216,  -5,   -3,
    -1,   14,  224,   13,  230,   -5,   -3,   -1,  110, 156, 201,  -1,
  94, 186,   -9,
    -5,   -1,  229,   -1,  171,  125,   -1,  215,  228,  -3,  -1, 140,
  200,  -3,   -1,
    78,   46,   62,  -15,   -7,   -3,   -1,  109,  214,  -1, 227, 155,
  -3,  -1,  185,
   170,   -1,  226,   30,   -7,   -3,   -1,  225,   93,  -1, 213, 124,
  -3,  -1,  199,
    77,   -1,  139,  184,  -31,  -15,   -7,   -3,   -1, 212, 154,  -1,
  169, 108,   -3,
    -1,  198,   61,   -1,  211,   45,   -7,   -3,   -1, 210,  29,  -1,
  123, 183,   -3,
    -1,  209,   92,   -1,  197,  138,  -17,   -7,   -3,  -1, 168, 153,
  -1,  76,  196,
    -3,   -1,  107,  182,   -3,   -1,  208,   12,   60,  -7,  -3,  -1,
  195, 122,   -1,
   167,   44,   -3,   -1,  194,   91,   -1,  181,   28, -57, -35, -19,
  -7,  -3,   -1,
   137,  152,   -1,  193,   75,   -5,   -3,   -1,  192,  11,  59,  -3,
  -1, 176,   10,
    26,   -5,   -1,  180,   -1,  106,  166,   -3,   -1, 121, 151,  -3,
  -1, 160,    9,
   144,   -9,   -3,   -1,  179,  136,   -3,   -1,   43,  90, 178,  -7,
  -3,  -1,  165,
    27,   -1,  177,  105,   -1,  150,  164,  -17,   -9,  -5,  -3,  -1,
  74, 120,  135,
    -1,   58,  163,   -3,   -1,   89,  149,   -1,   42, 162,  -7,  -3,
  -1, 161,  104,
    -1,  134,  119,   -3,   -1,   73,  148,   -1,   57, 147, -63, -31,
  -15,  -7,   -3,
    -1,   88,  133,   -1,   41,  103,   -3,   -1,  118, 146,  -1,  25,
  145,  -7,   -3,
    -1,   72,  132,   -1,   87,  117,   -3,   -1,   56, 131,  -1, 102,
  40, -17,   -7,
    -3,   -1,  130,   24,   -1,   71,  116,   -5,   -1, 129,  -1,   8,
  128,  -1,   86,
   101,   -7,   -5,   -1,   23,   -1,    7,  112,  115,  -3,  -1,  55,
  39, 114,  -15,
    -7,   -3,   -1,   70,  100,   -1,   85,  113,   -3,  -1,  54,  99,
  -1,  69,   84,
    -7,   -3,   -1,   38,   98,   -1,   22,   97,   -5,  -3,  -1,   6,
  96,  53,   -1,
    83,   68,  -51,  -37,  -23,  -15,   -9,   -3,   -1,  37,  82,  -1,
  21,  -1,    5,
    80,   -1,   81,   -1,   52,   67,   -3,   -1,   36,  66,  -1,  51,
  20,  -9,   -5,
    -1,   65,   -1,    4,   64,   -1,   35,   50,   -1,  19,  49,  -7,
  -5,  -3,   -1,
     3,   48,   34,   18,   -1,   33,   -1,    2,   32,  -3,  -1,  17,
  1,  -1,   16,
     0
};

static int16_t tab_c0[] = {
   -29,  -21,  -13,   -7,   -3,   -1,   11,   15,   -1,  13,  14,  -3,
   -1,   7,    5,
     9,   -3,   -1,    6,    3,   -1,   10,   12,   -3,  -1,   2,   1,
   -1,   4,    8,
     0
};

static int16_t tab_c1[] = {
   -15,   -7,   -3,   -1,   15,   14,   -1,   13,   12,  -3,  -1,  11,
   10,  -1,    9,
     8,   -7,   -3,   -1,    7,    6,   -1,    5,    4,  -3,  -1,   3,
   2,  -1,    1,
     0
};

newhuff_t hufft[] = {
 {  0, tab0  }, {  0, tab1  }, {  0, tab2  }, {  0, tab3  },
 {  0, tab0  }, {  0, tab5  }, {  0, tab6  }, {  0, tab7  },
 {  0, tab8  }, {  0, tab9  }, {  0, tab10 }, {  0, tab11 },
 {  0, tab12 }, {  0, tab13 }, {  0, tab0  }, {  0, tab15 },
 {  1, tab16 }, {  2, tab16 }, {  3, tab16 }, {  4, tab16 },
 {  6, tab16 }, {  8, tab16 }, { 10, tab16 }, { 13, tab16 },
 {  4, tab24 }, {  5, tab24 }, {  6, tab24 }, {  7, tab24 },
 {  8, tab24 }, {  9, tab24 }, { 11, tab24 }, { 13, tab24 }
};

newhuff_t hufftc[] = { { 0, tab_c0 }, { 0, tab_c1 } };

static int32_t intwinbase[] = {
      0,    -1,    -1,    -1,    -1,    -1,    -1,    -2,    -2,    -2,
     -2,    -3,    -3,    -4,    -4,    -5,    -5,    -6,    -7,    -7,
     -8,    -9,   -10,   -11,   -13,   -14,   -16,   -17,   -19,   -21,
    -24,   -26,   -29,   -31,   -35,   -38,   -41,   -45,   -49,   -53,
    -58,   -63,   -68,   -73,   -79,   -85,   -91,   -97,  -104,  -111,
   -117,  -125,  -132,  -139,  -147,  -154,  -161,  -169,  -176,  -183,
   -190,  -196,  -202,  -208,  -213,  -218,  -222,  -225,  -227,  -228,
   -228,  -227,  -224,  -221,  -215,  -208,  -200,  -189,  -177,  -163,
   -146,  -127,  -106,   -83,   -57,   -29,     2,    36,    72,   111,
    153,   197,   244,   294,   347,   401,   459,   519,   581,   645,
    711,   779,   848,   919,   991,  1064,  1137,  1210,  1283,  1356,
   1428,  1498,  1567,  1634,  1698,  1759,  1817,  1870,  1919,  1962,
   2001,  2032,  2057,  2075,  2085,  2087,  2080,  2063,  2037,  2000,
   1952,  1893,  1822,  1739,  1644,  1535,  1414,  1280,  1131,   970,
    794,   605,   402,   185,   -45,  -288,  -545,  -814, -1095, -1388,
  -1692, -2006, -2330, -2663, -3004, -3351, -3705, -4063, -4425, -4788,
  -5153, -5517, -5879, -6237, -6589, -6935, -7271, -7597, -7910, -8209,
  -8491, -8755, -8998, -9219, -9416, -9585, -9727, -9838, -9916, -9959,
  -9966, -9935, -9863, -9750, -9592, -9389, -9139, -8840, -8492, -8092,
  -7640, -7134, -6574, -5959, -5288, -4561, -3776, -2935, -2037, -1082,
    -70,   998,  2122,  3300,  4533,  5818,  7154,  8540,  9975, 11455,
  12980, 14548, 16155, 17799, 19478, 21189, 22929, 24694, 26482, 28289,
  30112, 31947, 33791, 35640, 37489, 39336, 41176, 43006, 44821, 46617,
  48390, 50137, 51853, 53534, 55178, 56778, 58333, 59838, 61289, 62684,
  64019, 65290, 66494, 67629, 68692, 69679, 70590, 71420, 72169, 72835,
  73415, 73908, 74313, 74630, 74856, 74992, 75038
};

static void make_synth_window(mpadec_t mpadec, MYFLT scale)
{
    register struct mpadec_t *mpa = (struct mpadec_t *)mpadec;
    register int i, j, k;

    scale = -scale;
    for (i = 0, j = 0, k = 0; i < 256; i++, j++, k += 32) {
      if (k < (512 + 16))
        mpa->tables.decwin[k] =
          mpa->tables.decwin[k + 16] = ((MYFLT)intwinbase[j]/65536.0)*scale;
      if ((i & 31) == 31) k -= 1023;
      if ((i & 63) == 63) scale = -scale;
    }
    for (; i < 512; i++, j--, k += 32) {
      if (k < (512 + 16))
        mpa->tables.decwin[k] =
          mpa->tables.decwin[k + 16] = ((MYFLT)intwinbase[j]/65536.0)*scale;
      if ((i & 31) == 31) k -= 1023;
      if ((i & 63) == 63) scale = -scale;
    }
}

static void init_limits(mpadec_t mpadec, int32_t sblimit)
{
    register struct mpadec_t *mpa = (struct mpadec_t *)mpadec;
    register int i, j;

    for (i = 0; i < 9; i++) {
      for (j = 0; j < 23; j++) {
        mpa->tables.long_limit[i][j] = (band_info[i].long_idx[j] + 7)/SSLIMIT + 1;
        if (mpa->tables.long_limit[i][j] > sblimit)
          mpa->tables.long_limit[i][j] = sblimit;
      }
      for (j = 0; j < 14; j++) {
        mpa->tables.short_limit[i][j] =
          (band_info[i].short_idx[j] - 1)/SSLIMIT + 1;
        if (mpa->tables.short_limit[i][j] > sblimit)
          mpa->tables.short_limit[i][j] = sblimit;
      }
    }
}

static void init_layer2(mpadec_t mpadec)
{
    register struct mpadec_t *mpa = (struct mpadec_t *)mpadec;
    int i, j, k; uint8_t *tab;
    static MYFLT mulmul[27] = { 0.0, -2.0/3.0, 2.0/3.0, 2.0/7.0, 2.0/15.0,
                                2.0/31.0, 2.0/63.0, 2.0/127.0, 2.0/255.0,
                                2.0/511.0, 2.0/1023.0, 2.0/2047.0, 2.0/4095.0,
                                2.0/8191.0, 2.0/16383.0, 2.0/32767.0, 2.0/65535.0,
                                -4.0/5.0, -2.0/5.0, 2.0/5.0, 4.0/5.0, -8.0/9.0,
                                -4.0/9.0, -2.0/9.0, 2.0/9.0, 4.0/9.0,  8.0/9.0 };
    static uint8_t base[3][9] = { { 1, 0, 2, }, { 17, 18, 0, 19, 20, },
                                  { 21, 1, 22, 23, 0, 24, 25, 2, 26 } };

    tab = mpa->tables.grp3tab;
    for (i = 0; i < 3; i++)
      for (j = 0; j < 3; j++)
        for (k = 0; k < 3; k++, tab += 3) {
          tab[0] = base[0][k];
          tab[1] = base[0][j];
          tab[2] = base[0][i];
        }
    tab = mpa->tables.grp5tab;
    for (i = 0; i < 5; i++)
      for (j = 0; j < 5; j++)
        for (k = 0; k < 5; k++, tab += 3) {
          tab[0] = base[1][k];
          tab[1] = base[1][j];
          tab[2] = base[1][i];
        }
    tab = mpa->tables.grp9tab;
    for (i = 0; i < 9; i++)
      for (j = 0; j < 9; j++)
        for (k = 0; k < 9; k++, tab += 3) {
          tab[0] = base[2][k];
          tab[1] = base[2][j];
          tab[2] = base[2][i];
        }
    mpa->tables.mp2tables[0] = mpa->tables.mp2tables[1] =
      mpa->tables.mp2tables[2] = NULL;
    mpa->tables.mp2tables[3] = mpa->tables.grp3tab;
    mpa->tables.mp2tables[4] = NULL;
    mpa->tables.mp2tables[5] = mpa->tables.grp5tab;
    mpa->tables.mp2tables[6] = mpa->tables.mp2tables[7] =
      mpa->tables.mp2tables[8] = NULL;
    mpa->tables.mp2tables[9] = mpa->tables.grp9tab;
    for (i = 0; i < 27; i++) {
      for (j = 0, k = 3; j < 63; j++, k--)
        mpa->tables.muls[i][j] = mulmul[i]*pow(2.0, (MYFLT)k/3.0);
      mpa->tables.muls[i][63] = 0.0;
    }
}

static void init_layer3(mpadec_t mpadec)
{
    register struct mpadec_t *mpa = (struct mpadec_t *)mpadec;
    int i, j, k, l;

    for (i = -256; i < 122; i++)
      mpa->tables.gainpow2[i + 256] = pow(2.0, -0.25*(i + 210));
    for (i = 0; i < 8207; i++) mpa->tables.ispow[i] = pow(i, 4.0/3.0);
    for (i = 0; i < 18; i++) {
      mpa->tables.win[0][0][i] =
        mpa->tables.win[0][1][i] =
          0.5*sin((2*i + 1)*M_PI/72.0)/cos((2*i + 19)*M_PI/72.0);
      mpa->tables.win[0][0][i + 18] =
        mpa->tables.win[0][3][i + 18] =
          0.5*sin((2*(i + 18) + 1)*M_PI/72.0)/cos((2*(i + 18) + 19)*M_PI/72.0);
    }
    for (i = 0; i < 6; i++) {
      mpa->tables.win[0][1][i + 18] = 0.5/cos((2*(i + 18) + 19)*M_PI/72.0);
      mpa->tables.win[0][3][i + 12] = 0.5/cos((2*(i + 12) + 19)*M_PI/72.0);
      mpa->tables.win[0][1][i + 24] =
        0.5*sin((2*i + 13)*M_PI/24.0)/cos((2*(i + 24) + 19)*M_PI/72.0);
      mpa->tables.win[0][1][i + 30] = mpa->tables.win[0][3][i] = 0.0;
      mpa->tables.win[0][3][i + 6] =
        0.5*sin((2*i + 1)*M_PI/24.0)/cos((2*(i + 6) + 19)*M_PI/72.0);
    }
    for (i = 0; i < 12; i++) {
      mpa->tables.win[0][2][i] =
        0.5*sin((2*i + 1)*M_PI/24.0)/cos((2*i + 7)*M_PI/24.0);
    }
    for (i = 0; i < 4; i++) {
      int len = (i == 2) ? 12 : 36;
      for (j = 0; j < len; j += 2) {
        mpa->tables.win[1][i][j] = mpa->tables.win[0][i][j];
        mpa->tables.win[1][i][j + 1] = -mpa->tables.win[0][i][j + 1];
      }
    }
    for (i = 0; i < 16; i++) {
      MYFLT tmp = tan(i*M_PI/12.0);
      mpa->tables.tan1_1[i] = tmp/(1.0 + tmp);
      mpa->tables.tan2_1[i] = 1.0/(1.0 + tmp);
      mpa->tables.tan1_2[i] = M_SQRT2*tmp/(1.0 + tmp);
      mpa->tables.tan2_2[i] = M_SQRT2/(1.0 + tmp);
      for (j = 0; j < 2; j++) {
        MYFLT base = pow(2.0, -0.25*(j + 1));
        MYFLT p1 = 1.0, p2 = 1.0;
        if (i > 0) {
          if (i & 1) p1 = pow(base, 0.5*(i + 1));
          else p2 = pow(base, 0.5*i);
        }
        mpa->tables.pow1_1[j][i] = p1;
        mpa->tables.pow2_1[j][i] = p2;
        mpa->tables.pow1_2[j][i] = M_SQRT2*p1;
        mpa->tables.pow2_2[j][i] = M_SQRT2*p2;
      }
    }
    mpa->tables.istabs[0][0][0] = mpa->tables.tan1_1;
    mpa->tables.istabs[0][0][1] = mpa->tables.tan2_1;
    mpa->tables.istabs[0][1][0] = mpa->tables.tan1_2;
    mpa->tables.istabs[0][1][1] = mpa->tables.tan2_2;
    mpa->tables.istabs[1][0][0] = mpa->tables.pow1_1[0];
    mpa->tables.istabs[1][0][1] = mpa->tables.pow2_1[0];
    mpa->tables.istabs[1][1][0] = mpa->tables.pow1_2[0];
    mpa->tables.istabs[1][1][1] = mpa->tables.pow2_2[0];
    mpa->tables.istabs[2][0][0] = mpa->tables.pow1_1[1];
    mpa->tables.istabs[2][0][1] = mpa->tables.pow2_1[1];
    mpa->tables.istabs[2][1][0] = mpa->tables.pow1_2[1];
    mpa->tables.istabs[2][1][1] = mpa->tables.pow2_2[1];
    for (i = 0; i < 9; i++) {
      bandinfo_t *bi = &band_info[i];
      int32_t *mp, cb, lwin; int16_t *bdf;
      mp = mpa->tables.map[i][0] = mpa->tables.mapbuf0[i];
      bdf = bi->long_diff;
      for (cb = 0, j = 0; cb < 8; cb++, j += *bdf++, mp += 4) {
        mp[0] = (*bdf) >> 1;
        mp[1] = j;
        mp[2] = 3;
        mp[3] = cb;
      }
      bdf = bi->short_diff + 3;
      for (cb = 3; cb < 13; cb++) {
        int l = (*bdf++) >> 1;
        for (lwin = 0; lwin < 3; lwin++, mp += 4) {
          mp[0] = l;
          mp[1] = j + lwin;
          mp[2] = lwin;
          mp[3] = cb;
        }
        j += 6*l;
      }
      mpa->tables.mapend[i][0] = mp;
      mp = mpa->tables.map[i][1] = mpa->tables.mapbuf1[i];
      bdf = bi->short_diff;
      for (cb = 0, j = 0; cb < 13; cb++) {
        int l = (*bdf++) >> 1;
        for (lwin = 0; lwin < 3; lwin++, mp += 4) {
          mp[0] = l;
          mp[1] = j + lwin;
          mp[2] = lwin;
          mp[3] = cb;
        }
        j += 6*l;
      }
      mpa->tables.mapend[i][1] = mp;
      mp = mpa->tables.map[i][2] = mpa->tables.mapbuf2[i];
      bdf = bi->long_diff;
      for (cb = 0; cb < 22; cb++, mp += 2) {
        mp[0] = (*bdf++) >> 1;
        mp[1] = cb;
      }
      mpa->tables.mapend[i][2] = mp;
    }
    for (i = 0; i < 5; i++) {
      for (j = 0; j < 6; j++) {
        for (k = 0; k < 6; k++) {
          register int n = k + 6*j + 36*i;
          mpa->tables.i_slen2[n] = i | (j << 3) | (k << 6) | (3 << 12);
        }
      }
    }
    for (i = 0; i < 4; i++) {
      for (j = 0; j < 4; j++) {
        for (k = 0; k < 4; k++) {
          register int n = k + 4*j + 16*i;
          mpa->tables.i_slen2[n + 180] = i | (j << 3) | (k << 6) | (4 << 12);
        }
      }
    }
    for (i = 0; i < 4; i++) {
      for (j = 0; j < 3; j++) {
        register int n = j + 3*i;
        mpa->tables.i_slen2[n + 244] = i | (j << 3) | (5 << 12);
        mpa->tables.n_slen2[n + 500] = i | (j << 3) | (2 << 12) | (1 << 15);
      }
    }
    for (i = 0; i < 5; i++) {
      for (j = 0; j < 5; j++) {
        for (k = 0; k < 4; k++) {
          for (l = 0; l < 4; l++) {
            register int n = l + 4*k + 16*j + 80*i;
            mpa->tables.n_slen2[n] = i | (j << 3) | (k << 6) | (l << 9);
          }
        }
      }
    }
    for (i = 0; i < 5; i++) {
      for (j = 0; j < 5; j++) {
        for (k = 0; k < 4; k++) {
          register int n = k + 4*j + 20*i;
          mpa->tables.n_slen2[n + 400] = i | (j << 3) | (k << 6) | (1 << 12);
        }
      }
    }
}

void init_tables(mpadec_t mpadec, MYFLT scale, int32_t sblimit)
{
    register struct mpadec_t *mpa = (struct mpadec_t *)mpadec;

    if (mpa->state < MPADEC_STATE_START) {
      init_layer2(mpa);
      init_layer3(mpa);
    }
    init_limits(mpa, sblimit);
    make_synth_window(mpa, scale);
}

