! This version converts an unformatted RESTART file to an ASCII file
! and back, so that RESTARTs can be moved from one machine to another
! this version takes RESTARTs generated by CP2K 2005-05-09
PROGRAM Ascii2Restart
  IMPLICIT NONE
  INTEGER, PARAMETER :: restart_unit=17,iunit=18
  INTEGER :: natom_read,nspin_read,nao_read,nset_max,nshell_max, &
             nmo,homo,lfomo,nelectron,i,ispin
  INTEGER, POINTER :: nso_info(:,:,:),nshell_info(:,:), &
                      nset_info(:),offset_info(:,:,:)
  REAL*8, POINTER  :: vecbuffer_read(:,:),evals(:),occups(:)
                      

  OPEN(UNIT=restart_unit,FILE="RESTART",FORM="UNFORMATTED")
  OPEN(UNIT=iunit,FILE="RESTART.ascii",FORM="FORMATTED")

  READ(iunit,*) natom_read,nspin_read,nao_read,nset_max,nshell_max
  WRITE (restart_unit) natom_read,nspin_read,nao_read,nset_max,nshell_max

  ALLOCATE (nso_info(nshell_max,nset_max,natom_read))
  ALLOCATE (nshell_info(nset_max,natom_read))
  ALLOCATE (nset_info(natom_read))
  ALLOCATE (offset_info(nshell_max,nset_max,natom_read))
  
  READ (iunit,*) nset_info
  READ (iunit,*) nshell_info
  READ (iunit,*) nso_info
  WRITE (restart_unit) nset_info
  WRITE (restart_unit) nshell_info
  WRITE (restart_unit) nso_info

  DEALLOCATE(nso_info,nshell_info,nset_info,offset_info)

  ALLOCATE(vecbuffer_read(1,nao_read))

  DO ispin=1,nspin_read

     READ(iunit,*) nmo,homo,lfomo,nelectron
     WRITE (restart_unit) nmo,homo,lfomo,nelectron

     ALLOCATE(evals(nmo),occups(nmo))

     READ(iunit,*) evals,occups
     WRITE (restart_unit) evals,occups

     DEALLOCATE(evals,occups)

     DO i=1,nmo
        READ(iunit,*) vecbuffer_read
        WRITE(restart_unit) vecbuffer_read
     ENDDO

  ENDDO

  DEALLOCATE(vecbuffer_read)

  END
