/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.RestrictedStringValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public final class AnyURIValue
extends StringValue {
    public static final AnyURIValue EMPTY_URI = new AnyURIValue("");

    public AnyURIValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : Whitespace.trimWhitespace(charSequence).toString();
    }

    public static boolean isValidURI(CharSequence charSequence) {
        String string = charSequence.toString().trim();
        if (string.length() == 0) {
            return true;
        }
        try {
            new URI(string);
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            string = EscapeURI.iriToUri(string).toString();
            try {
                new URI(string);
                return true;
            }
            catch (URISyntaxException uRISyntaxException2) {
                return false;
            }
        }
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        int n = builtInAtomicType.getPrimitiveType();
        switch (n) {
            case 88: 
            case 529: 
            case 643: {
                return this;
            }
            case 642: {
                return new UntypedAtomicValue(this.value);
            }
            case 513: {
                return new StringValue(this.value);
            }
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                return RestrictedStringValue.makeRestrictedString(this.value, n, bl ? xPathContext.getConfiguration().getNameChecker() : null);
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert anyURI to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        return new ValidationErrorValue(validationException);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.ANY_URI_TYPE;
    }

    public boolean equals(Object object) {
        AnyURIValue anyURIValue = (AnyURIValue)((AtomicValue)object).getPrimitiveValue();
        return this.getStringValue().equals(anyURIValue.getStringValue());
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == Object.class) {
            return this.value;
        }
        if (clazz.isAssignableFrom(StringValue.class)) {
            return this;
        }
        if (clazz == URI.class) {
            try {
                return new URI(this.value.toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new DynamicError("The anyURI value '" + this.value + "' is not an acceptable Java URI");
            }
        }
        if (clazz == URL.class) {
            try {
                return new URL(this.value.toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new DynamicError("The anyURI value '" + this.value + "' is not an acceptable Java URL");
            }
        }
        if (clazz == String.class) {
            return this.value;
        }
        if (clazz == CharSequence.class) {
            return this.value;
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of anyURI to " + clazz.getName() + " is not supported");
        }
        return object;
    }
}

