/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public final class SimpleMappingExpression
extends ComputedExpression
implements ContextMappingFunction {
    private Expression start;
    private Expression step;
    private boolean isHybrid;

    public SimpleMappingExpression(Expression expression, Expression expression2, boolean bl) {
        this.start = expression;
        this.step = expression2;
        this.isHybrid = bl;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public Expression getStartExpression() {
        return this.start;
    }

    public Expression getStepExpression() {
        return this.step;
    }

    public final ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.step.getItemType(typeHierarchy);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.start = this.doPromotion(this.start, promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 14) {
            this.step = this.doPromotion(this.step, promotionOffer);
        }
        this.resetStaticProperties();
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.start, this.step);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.start == expression) {
            this.start = expression2;
            bl = true;
        }
        if (this.step == expression) {
            this.step = expression2;
            bl = true;
        }
        return bl;
    }

    public int computeDependencies() {
        return this.start.getDependencies() | this.step.getDependencies() & 0x61;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        if ((this.start.getSpecialProperties() & this.step.getSpecialProperties() & 0x400000) != 0) {
            n |= 0x400000;
        }
        return n;
    }

    public int computeCardinality() {
        int n = this.start.getCardinality();
        int n2 = this.step.getCardinality();
        return Cardinality.multiply(n, n2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleMappingExpression)) {
            return false;
        }
        SimpleMappingExpression simpleMappingExpression = (SimpleMappingExpression)object;
        return this.start.equals(simpleMappingExpression.start) && this.step.equals(simpleMappingExpression.step);
    }

    public int hashCode() {
        return "SimpleMappingExpression".hashCode() + this.start.hashCode() + this.step.hashCode();
    }

    public SequenceIterator iterate(final XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.start.iterate(xPathContext);
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        xPathContextMinor.setOriginatingConstructType(2025);
        sequenceIterator = new ContextMappingIterator(this, xPathContextMinor);
        if (this.isHybrid) {
            Item item = sequenceIterator.next();
            if (item == null) {
                return EmptyIterator.getInstance();
            }
            if (item instanceof AtomicValue) {
                ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

                    public Item map(Item item) throws XPathException {
                        if (item instanceof AtomicValue) {
                            return item;
                        }
                        DynamicError dynamicError = new DynamicError("Cannot mix nodes and atomic values in the result of a path expression");
                        dynamicError.setErrorCode("XPTY0018");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                };
                return new ItemMappingIterator(sequenceIterator.getAnother(), itemMappingFunction);
            }
            ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

                public Item map(Item item) throws XPathException {
                    if (item instanceof NodeInfo) {
                        return item;
                    }
                    DynamicError dynamicError = new DynamicError("Cannot mix nodes and atomic values in the result of a path expression");
                    dynamicError.setErrorCode("XPTY0018");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            };
            return new DocumentOrderIterator(new ItemMappingIterator(sequenceIterator.getAnother(), itemMappingFunction), GlobalOrderComparer.getInstance());
        }
        return sequenceIterator;
    }

    public SequenceIterator map(XPathContext xPathContext) throws XPathException {
        return this.step.iterate(xPathContext);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "map /");
        this.start.display(n + 1, printStream, configuration);
        this.step.display(n + 1, printStream, configuration);
    }
}

