/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef SOC_MEDIATEK_MT8192_DEVAPC_H
#define SOC_MEDIATEK_MT8192_DEVAPC_H

#include <device/mmio.h>
#include <soc/addressmap.h>

void dapc_init(void);

#define DEVAPC_AO_MAX 6

enum devapc_ao_offset {
	DOM_REMAP_0_0 = 0x800,
	DOM_REMAP_1_0 = 0x810,
	DOM_REMAP_1_1 = 0x814,
	DOM_REMAP_2_0 = 0x820,
	MAS_DOM_0 = 0x0900,
	MAS_DOM_1 = 0x0904,
	MAS_SEC_0 = 0x0A00,
	AO_APC_CON = 0x0F00,
};

enum scp_offset {
	SCP_DOM = 0xA5080,
	ADSP_DOM = 0xA5088,
	ONETIME_LOCK = 0xA5104,
};

/* INFRA */
DEFINE_BIT(SCP_SSPM_SEC, 3)
DEFINE_BIT(CPU_EB_SEC, 4)

DEFINE_BITFIELD(PCIE_DOM, 19, 16)		/* 2 */
DEFINE_BITFIELD(SCP_SSPM_DOM, 3, 0)		/* 4 */
DEFINE_BITFIELD(CPU_EB_DOM, 11, 8)		/* 5 */

/* PERI */
DEFINE_BITFIELD(SPM_DOM, 3, 0)		/* 0 */

enum master_domain {
	MAS_DOMAIN_0 = 0,
	MAS_DOMAIN_1,
	MAS_DOMAIN_2,
	MAS_DOMAIN_3,
	MAS_DOMAIN_4,
	MAS_DOMAIN_5,
	MAS_DOMAIN_6,
	MAS_DOMAIN_7,
	MAS_DOMAIN_8,
	MAS_DOMAIN_9,
	MAS_DOMAIN_10,
	MAS_DOMAIN_11,
	MAS_DOMAIN_12,
	MAS_DOMAIN_13,
	MAS_DOMAIN_14,
	MAS_DOMAIN_15,
	MAS_DOMAIN_MAX,
};

/* Domain Remap */
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_0,  3,  0)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_1,  7,  4)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_2, 11,  8)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_3, 15, 12)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_4, 19, 16)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_5, 23, 20)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_6, 27, 24)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_7, 31, 28)

DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_0,  2,  0)
DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_1,  5,  3)
DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_2,  8,  6)
DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_3, 11,  9)
DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_4, 14, 12)

DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_0, 1, 0)
DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_1, 3, 2)
DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_2, 5, 4)
DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_3, 7, 6)
DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_4, 9, 8)

#endif /* SOC_MEDIATEK_MT8192_DEVAPC_H */
