/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef SOC_MEDIATEK_MT8183_MCUCFG_H
#define SOC_MEDIATEK_MT8183_MCUCFG_H

#include <soc/addressmap.h>
#include <types.h>

struct mt8183_mcucfg_regs {
	u32 mp0_ca7l_cache_config;
	u32 mp0_cpu0_mem_delsel0;
	u32 mp0_cpu0_mem_delsel1;
	u32 reserved1[6];
	u32 mp0_cache_mem_delsel0;
	u32 mp0_cache_mem_delsel1;
	u32 mp0_axi_config;
	u32 mp0_misc_config0;
	u32 reserved2[1];
	u32 mp0_misc_config2;
	u32 mp0_misc_config3;
	u32 mp0_misc_config4;
	u32 mp0_misc_config5;
	u32 mp0_misc_config6;
	u32 mp0_misc_config7;
	u32 mp0_misc_config8;
	u32 mp0_misc_config9;
	u32 mp0_ca7l_cfg_dis;
	u32 mp0_ca7l_clken_ctrl;
	u32 mp0_ca7l_rst_ctrl;
	u32 mp0_ca7l_misc_config;
	u32 mp0_ca7l_dbg_pwr_ctrl;
	u32 mp0_rw_rsvd0;
	u32 mp0_rw_rsvd1;
	u32 mp0_ro_rsvd;
	u32 reserved3[1];
	u32 mp0_l2_cache_parity1_rdata;
	u32 mp0_l2_cache_parity2_rdata;
	u32 reserved4[1];
	u32 mp0_rgu_dcm_config;
	u32 mp0_ca53_specific_ctrl;
	u32 mp0_esr_case;
	u32 mp0_esr_mask;
	u32 mp0_esr_trig_en;
	u32 reserved5[1];
	u32 mp0_ses_cg_en;
	u32 reserved6[216];
	u32 mp_dbg_ctrl;
	u32 reserved7[1];
	u32 mp0_ca7l_ir_mon;
	u32 reserved8[32];
	u32 mp_dfd_ctrl;
	u32 dfd_cnt_l;
	u32 dfd_cnt_h;
	u32 misccfg_ro_rsvd;
	u32 reserved9[1];
	u32 dvm_dbg_monitor_gpu;
	u32 dvm_dbg_monitor_psys;
	u32 dvm_dbg_monitor_mp1;
	u32 dvm_dbg_monitor_mp0;
	u32 dvm_dbg_monitor_mp2;
	u32 reserved10[2];
	u32 dvm_op_arid_mp0;
	u32 dvm_op_arid_mp1;
	u32 dvm_op_arid_mp2;
	u32 reserved11[5];
	u32 cci_s6_if_debug;
	u32 reserved12[7];
	u32 mp1_rst_status;
	u32 mp1_dbg_ctrl;
	u32 mp1_dbg_flag;
	u32 mp1_ca7l_ir_mon;
	u32 reserved13[32];
	u32 mcusys_dbg_mon_sel_a;
	u32 mcusys_dbg_mon;
	u32 misccfg_sec_vio_status0;
	u32 misccfg_sec_vio_status1;
	u32 cci_top_if_debug;
	u32 cci_m0_if_debug;
	u32 cci_m1_if_debug;
	u32 cci_m2_if_debug;
	u32 cci_s1_if_debug;
	u32 cci_s2_if_debug;
	u32 cci_s3_if_debug;
	u32 cci_s4_if_debug;
	u32 cci_m0_tra_debug;
	u32 cci_m1_tra_debug;
	u32 cci_m2_tra_debug;
	u32 cci_s1_tra_debug;
	u32 cci_s2_tra_debug;
	u32 cci_s3_tra_debug;
	u32 cci_s4_tra_debug;
	u32 cci_tra_dbg_cfg;
	u32 cci_s5_if_debug;
	u32 cci_s5_tra_debug;
	u32 gic500_int_mask;
	u32 core_rst_en_latch;
	u32 reserved14[3];
	u32 dbg_core_ret;
	u32 mcusys_config_a;
	u32 mcusys_config1_a;
	u32 mcusys_gic_peribase_a;
	u32 mcusys_pinmux;
	u32 sec_range0_start;
	u32 sec_range0_end;
	u32 sec_range_enable;
	u32 l2c_mm_base;
	u32 reserved15[8];
	u32 aclken_div;
	u32 pclken_div;
	u32 l2c_sram_ctrl;
	u32 armpll_jit_ctrl;
	u32 cci_addrmap;
	u32 cci_config;
	u32 cci_periphbase;
	u32 cci_nevntcntovfl;
	u32 cci_status;
	u32 cci_acel_s1_ctrl;
	u32 mcusys_bus_fabric_dcm_ctrl;
	u32 mcu_misc_dcm_ctrl;
	u32 xgpt_ctl;
	u32 xgpt_idx;
	u32 reserved16[3];
	u32 mcusys_rw_rsvd0;
	u32 mcusys_rw_rsvd1;
	u32 reserved17[13];
	u32 gic500_delsel_ctl;
	u32 etb_delsel_ctl;
	u32 etb_rst_ctl;
	u32 reserved18[13];
	u32 mp_gen_timer_reset_mask_secur_en;
	u32 mp_gen_timer_reset_mask_0;
	u32 mp_gen_timer_reset_mask_1;
	u32 mp_gen_timer_reset_mask_2;
	u32 mp_gen_timer_reset_mask_3;
	u32 mp_gen_timer_reset_mask_4;
	u32 mp_gen_timer_reset_mask_5;
	u32 mp_gen_timer_reset_mask_6;
	u32 mp_gen_timer_reset_mask_7;
	u32 reserved19[7];
	u32 mp_cci_adb400_dcm_config;
	u32 mp_sync_dcm_config;
	u32 reserved20[1];
	u32 mp_sync_dcm_cluster_config;
	u32 sw_udi;
	u32 reserved21[1];
	u32 gic_sync_dcm;
	u32 big_dbg_pwr_ctrl;
	u32 gic_cpu_periphbase;
	u32 axi_cpu_config;
	u32 reserved22[2];
	u32 mcsib_sys_ctrl1;
	u32 mcsib_sys_ctrl2;
	u32 mcsib_sys_ctrl3;
	u32 mcsib_sys_ctrl4;
	u32 mcsib_dbg_ctrl1;
	u32 pwrmcu_apb2to1;
	u32 reserved23[1];
	u32 mp1_spmc;
	u32 reserved24[1];
	u32 mp1_spmc_sram_ctl;
	u32 reserved25[1];
	u32 mp1_sw_rst_wait_cycle;
	u32 mp0_pll_divider_cfg;
	u32 reserved26[1];
	u32 mp2_pll_divider_cfg;
	u32 reserved27[5];
	u32 bus_pll_divider_cfg;
	u32 reserved28[7];
	u32 clusterid_aff1;
	u32 clusterid_aff2;
	u32 hack_ice_rom_table_access;
	u32 mp_top_mem_delay_cfg;
	u32 l2c_cfg_mp0;
	u32 reserved29[1];
	u32 l2c_cfg_mp2;
	u32 reserved30[1];
	u32 cci_bw_pmu_ctl;
	u32 cci_bw_pmu_cnt0to1_sel;
	u32 cci_bw_pmu_cnt2to3_sel;
	u32 cci_bw_pmu_cnt4to5_sel;
	u32 cci_bw_pmu_cnt6to7_sel;
	u32 cci_bw_pmu_cnt0to3_mask;
	u32 cci_bw_pmu_cnt4to7_mask;
	u32 cci_bw_pmu_ref_cnt;
	u32 cci_bw_pmu_acc_cnt0;
	u32 cci_bw_pmu_acc_cnt1;
	u32 cci_bw_pmu_acc_cnt2;
	u32 cci_bw_pmu_acc_cnt3;
	u32 cci_bw_pmu_acc_cnt4;
	u32 cci_bw_pmu_acc_cnt5;
	u32 cci_bw_pmu_acc_cnt6;
	u32 cci_bw_pmu_acc_cnt7;
	u32 reserved31[8];
	u32 cci_bw_pmu_id_ext_cnt0to3;
	u32 cci_bw_pmu_id_ext_cnt4to7;
	u32 cci_bw_pmu_mask_ext_cnt0to3;
	u32 cci_bw_pmu_mask_ext_cnt4to7;
	u32 reserved32[16];
	u32 etb_acc_ctl;
	u32 etb_ck_ctl;
	u32 reserved33[4];
	u32 mbista_mp1_ocp_con;
	u32 reserved34[1];
	u32 mbista_gic_con;
	u32 mbista_gic_result;
	u32 mbista_mcsib_sf1_con;
	u32 mbista_mcsib_sf1_result;
	u32 mbista_mcsib_sf2_con;
	u32 mbista_mcsib_sf2_result;
	u32 reserved35[2];
	u32 mbista_rstb;
	u32 mbista_all_result;
	u32 reserved36[2];
	u32 mp0_hang_monitor_ctrl0;
	u32 mp0_hang_monitor_ctrl1;
	u32 reserved37[2];
	u32 mp1_hang_monitor_ctrl0;
	u32 mp1_hang_monitor_ctrl1;
	u32 reserved38[2];
	u32 mp2_hang_monitor_ctrl0;
	u32 mp2_hang_monitor_ctrl1;
	u32 reserved39[6];
	u32 gpu_hang_monitor_ctrl0;
	u32 gpu_hang_monitor_ctrl1;
	u32 reserved40[2];
	u32 psys_hang_monitor_ctrl0;
	u32 psys_hang_monitor_ctrl1;
	u32 reserved41[42];
	u32 sec_pol_ctl_en0;
	u32 sec_pol_ctl_en1;
	u32 sec_pol_ctl_en2;
	u32 sec_pol_ctl_en3;
	u32 sec_pol_ctl_en4;
	u32 sec_pol_ctl_en5;
	u32 sec_pol_ctl_en6;
	u32 sec_pol_ctl_en7;
	u32 sec_pol_ctl_en8;
	u32 sec_pol_ctl_en9;
	u32 sec_pol_ctl_en10;
	u32 sec_pol_ctl_en11;
	u32 sec_pol_ctl_en12;
	u32 sec_pol_ctl_en13;
	u32 sec_pol_ctl_en14;
	u32 sec_pol_ctl_en15;
	u32 sec_pol_ctl_en16;
	u32 sec_pol_ctl_en17;
	u32 sec_pol_ctl_en18;
	u32 sec_pol_ctl_en19;
	u32 reserved42[12];
	u32 int_pol_ctl0;
	u32 int_pol_ctl1;
	u32 int_pol_ctl2;
	u32 int_pol_ctl3;
	u32 int_pol_ctl4;
	u32 int_pol_ctl5;
	u32 int_pol_ctl6;
	u32 int_pol_ctl7;
	u32 int_pol_ctl8;
	u32 int_pol_ctl9;
	u32 int_pol_ctl10;
	u32 int_pol_ctl11;
	u32 int_pol_ctl12;
	u32 int_pol_ctl13;
	u32 int_pol_ctl14;
	u32 int_pol_ctl15;
	u32 int_pol_ctl16;
	u32 int_pol_ctl17;
	u32 int_pol_ctl18;
	u32 int_pol_ctl19;
	u32 reserved43[12];
	u32 dfd_internal_ctl;
	u32 dfd_internal_counter;
	u32 dfd_internal_pwr_on;
	u32 dfd_internal_chain_legth_0;
	u32 dfd_internal_shift_clk_ratio;
	u32 dfd_internal_counter_return;
	u32 dfd_internal_sram_access;
	u32 dfd_internal_chain_length_1;
	u32 dfd_internal_chain_length_2;
	u32 dfd_internal_chain_length_3;
	u32 dfd_internal_test_so_0;
	u32 dfd_internal_test_so_1;
	u32 dfd_internal_num_of_test_so_gp;
	u32 dfd_internal_test_so_over_64;
	u32 dfd_internal_mask_out;
	u32 dfd_internal_sw_ns_trigger;
	u32 dfd_internal_mcsib;
	u32 dfd_internal_mcsib_sel_status;
	u32 dfd_internal_sram_base_addr;
	u32 dfd_internal_sram_delsel;
	u32 mcsib_iccs_ctrl1;
	u32 reserved44[1];
	u32 mcu_all_pwr_on_ctrl;
	u32 emi_wfifo;
	u32 mcsia_dcm_en;
	u32 reserved45[294];
	u32 mcu_apb_base;
	u32 reserved46[384];
	u32 mp0_cpu_avg_stall_ratio;
	u32 mp0_cpu0_avg_stall_ratio_ctrl;
	u32 mp0_cpu1_avg_stall_ratio_ctrl;
	u32 mp0_cpu2_avg_stall_ratio_ctrl;
	u32 mp0_cpu3_avg_stall_ratio_ctrl;
	u32 mp0_avg_stall_ratio_status;
	u32 mp0_cpu0_stall_counter;
	u32 mp0_cpu1_stall_counter;
	u32 mp0_cpu2_stall_counter;
	u32 mp0_cpu3_stall_counter;
	u32 mp0_cpu0_non_wfi_counter;
	u32 mp0_cpu1_non_wfi_counter;
	u32 mp0_cpu2_non_wfi_counter;
	u32 mp0_cpu3_non_wfi_counter;
	u32 reserved47[370];
	u32 cpusys0_sparkvretcntrl;
	u32 cpusys0_sparken;
	u32 cpusys0_amuxsel;
	u32 cpusys0_cg_dis;
	u32 cpusys0_cpu0_counter;
	u32 cpusys0_cpu1_counter;
	u32 cpusys0_cpu2_counter;
	u32 cpusys0_cpu3_counter;
	u32 cpusys0_spark_debug_overwrite;
	u32 reserved48[3];
	u32 cpusys0_cpu0_spmc_ctl;
	u32 cpusys0_cpu1_spmc_ctl;
	u32 cpusys0_cpu2_spmc_ctl;
	u32 cpusys0_cpu3_spmc_ctl;
	u32 sesv3_rg_toggle;
	u32 reserved49[7];
	u32 mp0_sync_dcm_cgavg_ctrl;
	u32 mp0_sync_dcm_cgavg_fact;
	u32 mp0_sync_dcm_cgavg_rfact;
	u32 mp0_sync_dcm_cgavg;
};

check_member(mt8183_mcucfg_regs, mp0_cache_mem_delsel0, 0x0024);
check_member(mt8183_mcucfg_regs, mp_dbg_ctrl, 0x0404);
check_member(mt8183_mcucfg_regs, mp_dfd_ctrl, 0x0490);
check_member(mt8183_mcucfg_regs, dvm_op_arid_mp0, 0x04c0);
check_member(mt8183_mcucfg_regs, cci_s6_if_debug, 0x04e0);
check_member(mt8183_mcucfg_regs, mp1_rst_status, 0x0500);
check_member(mt8183_mcucfg_regs, mcusys_dbg_mon_sel_a, 0x0590);
check_member(mt8183_mcucfg_regs, dbg_core_ret, 0x05fc);
check_member(mt8183_mcucfg_regs, aclken_div, 0x0640);
check_member(mt8183_mcucfg_regs, mcusys_rw_rsvd0, 0x0684);
check_member(mt8183_mcucfg_regs, gic500_delsel_ctl, 0x06c0);
check_member(mt8183_mcucfg_regs, mp_gen_timer_reset_mask_secur_en, 0x0700);
check_member(mt8183_mcucfg_regs, mp_cci_adb400_dcm_config, 0x0740);
check_member(mt8183_mcucfg_regs, mcsib_sys_ctrl1, 0x0770);
check_member(mt8183_mcucfg_regs, bus_pll_divider_cfg, 0x07c0);
check_member(mt8183_mcucfg_regs, clusterid_aff1, 0x07e0);
check_member(mt8183_mcucfg_regs, cci_bw_pmu_id_ext_cnt0to3, 0x0860);
check_member(mt8183_mcucfg_regs, etb_acc_ctl, 0x08b0);
check_member(mt8183_mcucfg_regs, mbista_mp1_ocp_con, 0x08c8);
check_member(mt8183_mcucfg_regs, mbista_rstb, 0x08f0);
check_member(mt8183_mcucfg_regs, mp0_hang_monitor_ctrl0, 0x0900);
check_member(mt8183_mcucfg_regs, mp1_hang_monitor_ctrl0, 0x0910);
check_member(mt8183_mcucfg_regs, mp2_hang_monitor_ctrl0, 0x0920);
check_member(mt8183_mcucfg_regs, gpu_hang_monitor_ctrl0, 0x0940);
check_member(mt8183_mcucfg_regs, psys_hang_monitor_ctrl0, 0x0950);
check_member(mt8183_mcucfg_regs, sec_pol_ctl_en0, 0x0a00);
check_member(mt8183_mcucfg_regs, int_pol_ctl0, 0x0a80);
check_member(mt8183_mcucfg_regs, dfd_internal_ctl, 0x0b00);
check_member(mt8183_mcucfg_regs, mcu_apb_base, 0x0ffc);
check_member(mt8183_mcucfg_regs, mp0_cpu_avg_stall_ratio, 0x1600);
check_member(mt8183_mcucfg_regs, cpusys0_sparkvretcntrl, 0x1c00);
check_member(mt8183_mcucfg_regs, cpusys0_cpu0_spmc_ctl, 0x1c30);
check_member(mt8183_mcucfg_regs, mp0_sync_dcm_cgavg_ctrl, 0x1c60);
check_member(mt8183_mcucfg_regs, mp0_sync_dcm_cgavg, 0x1c6c);

static struct mt8183_mcucfg_regs *const mt8183_mcucfg = (void *)MCUCFG_BASE;

#endif  /* SOC_MEDIATEK_MT8183_MCUCFG_H */
