/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_PCH_GPIO_H
#define CFG_PCH_GPIO_H

#include <soc/gpio.h>

/* GPIO configuration table for C627 Lewisburg PCH */
static const struct pad_config gpio_table[] = {
	/* ------- GPIO Community 0 ------- */
	/* ------- GPIO Group GPP_A ------- */
	/* GPP_A0 - ESPI_ALERT1# */
	PAD_CFG_NF(GPP_A0, NONE, DEEP, NF3),
	/* GPP_A1 - ESPI_IO0 */
	PAD_CFG_NF(GPP_A1, UP_20K, DEEP, NF3),
	/* GPP_A2 - ESPI_IO1 */
	PAD_CFG_NF(GPP_A2, UP_20K, DEEP, NF3),
	/* GPP_A3 - ESPI_IO2 */
	PAD_CFG_NF(GPP_A3, UP_20K, DEEP, NF3),
	/* GPP_A4 - ESPI_IO3 */
	PAD_CFG_NF(GPP_A4, UP_20K, DEEP, NF3),
	/* GPP_A5 - ESPI_CS0# */
	PAD_CFG_NF(GPP_A5, UP_20K, DEEP, NF3),
	/* GPP_A6 - ESPI_CS1# */
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF3),
	/* GPP_A7 - ESPI_ALERT0# */
	PAD_CFG_NF(GPP_A7, NONE, DEEP, NF3),
	/* GPP_A8 - CLKRUN# */
	PAD_CFG_NF(GPP_A8, NONE, DEEP, NF1),
	/* GPP_A9 - ESPI_CLK */
	PAD_CFG_NF(GPP_A9, DN_20K, DEEP, NF3),
	/* GPP_A10 - CLKOUT_LPC1 */
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1),
	/* GPP_A11 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A11, NONE, DEEP, OFF, DRIVER),
	/* GPP_A12 - GPIO */
	PAD_CFG_GPI_SCI(GPP_A12, NONE, PLTRST, LEVEL, INVERT),
	/* GPP_A13 - GPIO */
	PAD_CFG_GPO(GPP_A13, 0, DEEP),
	/* GPP_A14 - ESPI_RESET# */
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF3),
	/* GPP_A15 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A15, NONE, DEEP, OFF, DRIVER),
	/* GPP_A16 - GPIO */
	PAD_CFG_GPO(GPP_A16, 1, DEEP),
	/* GPP_A17 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A17, NONE, RSMRST, OFF, ACPI),
	/* GPP_A18 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A18, NONE, RSMRST, OFF, ACPI),
	/* GPP_A19 - RESERVED */
	/* GPP_A20 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A20, NONE, RSMRST, OFF, ACPI),
	/* GPP_A21 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A21, NONE, RSMRST, OFF, ACPI),
	/* GPP_A22 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A22, NONE, RSMRST, OFF, ACPI),
	/* GPP_A23 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A23, NONE, RSMRST, OFF, ACPI),

	/* ------- GPIO Group GPP_B ------- */
	/* GPP_B0 - CORE_VID0 */
	PAD_CFG_NF(GPP_B0, NONE, RSMRST, NF1),
	/* GPP_B1 - CORE_VID1 */
	PAD_CFG_NF(GPP_B1, NONE, RSMRST, NF1),
	/* GPP_B2 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B2, NONE, RSMRST, OFF, ACPI),
	/* GPP_B3 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B3, NONE, RSMRST, OFF, ACPI),
	/* GPP_B4 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B4, NONE, RSMRST, OFF, ACPI),
	/* GPP_B5 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B5, NONE, RSMRST, OFF, ACPI),
	/* GPP_B6 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B6, NONE, RSMRST, OFF, ACPI),
	/* GPP_B7 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B7, NONE, RSMRST, OFF, ACPI),
	/* GPP_B8 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B8, NONE, RSMRST, OFF, ACPI),
	/* GPP_B9 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B9, NONE, RSMRST, OFF, ACPI),
	/* GPP_B10 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B10, NONE, RSMRST, OFF, ACPI),
	/* GPP_B11 - RESERVED */
	/* GPP_B12 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B12, NONE, RSMRST, OFF, ACPI),
	/* GPP_B13 - PLTRST# */
	PAD_CFG_NF(GPP_B13, NONE, RSMRST, NF1),
	/* GPP_B14 - SPKR */
	PAD_CFG_NF(GPP_B14, NONE, RSMRST, NF1),
	/* GPP_B15 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B15, NONE, RSMRST, OFF, ACPI),
	/* GPP_B16 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B16, NONE, RSMRST, OFF, ACPI),
	/* GPP_B17 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B17, NONE, RSMRST, OFF, ACPI),
	/* GPP_B18 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B18, NONE, RSMRST, OFF, ACPI),
	/* GPP_B19 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B19, NONE, RSMRST, OFF, ACPI),
	/* GPP_B20 - GPIO */
	PAD_CFG_GPO(GPP_B20, 0, RSMRST),
	/* GPP_B21 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B21, NONE, RSMRST, OFF, ACPI),
	/* GPP_B22 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B22, NONE, RSMRST, OFF, ACPI),
	/* GPP_B23 - PCHHOT# */
	PAD_CFG_NF(GPP_B23, NONE, RSMRST, NF2),

	/* ------- GPIO Group GPP_F ------- */
	/* GPP_F0 - SATAXPCIE3 */
	PAD_CFG_NF(GPP_F0, NONE, RSMRST, NF1),
	/* GPP_F1 - SATAXPCIE4 */
	PAD_CFG_NF(GPP_F1, NONE, RSMRST, NF1),
	/* GPP_F2 - SATAXPCIE5 */
	PAD_CFG_NF(GPP_F2, NONE, RSMRST, NF1),
	/* GPP_F3 - SATAXPCIE6 */
	PAD_CFG_NF(GPP_F3, NONE, RSMRST, NF1),
	/* GPP_F4 - SATAXPCIE7 */
	PAD_CFG_NF(GPP_F4, NONE, RSMRST, NF1),
	/* GPP_F5 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F5, NONE, RSMRST, OFF, ACPI),
	/* GPP_F6 - GPIO */
	PAD_CFG_GPO(GPP_F6, 0, RSMRST),
	/* GPP_F7 - GPIO */
	PAD_CFG_GPO(GPP_F7, 0, RSMRST),
	/* GPP_F8 - GPIO */
	PAD_CFG_GPO(GPP_F8, 0, RSMRST),
	/* GPP_F9 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F9, NONE, RSMRST, OFF, ACPI),
	/* GPP_F10 - SATA_SCLOCK */
	PAD_CFG_NF(GPP_F10, NONE, RSMRST, NF1),
	/* GPP_F11 - SATA_SLOAD */
	PAD_CFG_NF(GPP_F11, NONE, RSMRST, NF1),
	/* GPP_F12 - SATA_SDATAOUT1 */
	PAD_CFG_NF(GPP_F12, NONE, RSMRST, NF1),
	/* GPP_F13 - SATA_SDATAOUT2 */
	PAD_CFG_NF(GPP_F13, NONE, RSMRST, NF1),
	/* GPP_F14 - SSATA_LED# */
	PAD_CFG_NF(GPP_F14, NONE, RSMRST, NF3),
	/* GPP_F15 - USB_OC4# */
	PAD_CFG_NF(GPP_F15, NONE, RSMRST, NF1),
	/* GPP_F16 - USB_OC5# */
	PAD_CFG_NF(GPP_F16, NONE, RSMRST, NF1),
	/* GPP_F17 - USB_OC6# */
	PAD_CFG_NF(GPP_F17, NONE, RSMRST, NF1),
	/* GPP_F18 - USB_OC7# */
	PAD_CFG_NF(GPP_F18, NONE, RSMRST, NF1),
	/* GPP_F19 - LAN_SMBCLK */
	PAD_CFG_NF(GPP_F19, NONE, RSMRST, NF1),
	/* GPP_F20 - LAN_SMBDATA */
	PAD_CFG_NF(GPP_F20, NONE, RSMRST, NF1),
	/* GPP_F21 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F21, NONE, RSMRST, OFF, ACPI),
	/* GPP_F22 - SSATA_SCLOCK */
	PAD_CFG_NF(GPP_F22, NONE, RSMRST, NF3),
	/* GPP_F23 - SSATA_SLOAD */
	PAD_CFG_NF(GPP_F23, NONE, RSMRST, NF3),

	/* ------- GPIO Community 1 ------- */
	/* ------- GPIO Group GPP_C ------- */
	/* GPP_C0 - RESERVED */
	/* GPP_C1 - RESERVED */
	/* GPP_C2 - GPIO */
	PAD_CFG_GPI(GPP_C2, NONE, RSMRST),
	/* GPP_C3 - RESERVED */
	/* GPP_C4 - RESERVED */
	/* GPP_C5 - SML0ALERT# */
	PAD_CFG_NF(GPP_C5, NONE, RSMRST, NF1),
	/* GPP_C6 - RESERVED */
	/* GPP_C7 - RESERVED */
	/* GPP_C8 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C8, NONE, RSMRST, OFF, ACPI),
	/* GPP_C9 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C9, NONE, RSMRST, OFF, DRIVER),
	/* GPP_C10 - GPIO */
	_PAD_CFG_STRUCT(GPP_C10,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_C11 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C11, NONE, RSMRST, OFF, ACPI),
	/* GPP_C12 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C12, NONE, RSMRST, OFF, ACPI),
	/* GPP_C13 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C13, NONE, RSMRST, OFF, ACPI),
	/* GPP_C14 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C14, NONE, RSMRST, OFF, ACPI),
	/* GPP_C15 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C15, NONE, RSMRST, OFF, ACPI),
	/* GPP_C16 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C16, NONE, RSMRST, OFF, ACPI),
	/* GPP_C17 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C17, NONE, RSMRST, OFF, ACPI),
	/* GPP_C18 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C18, NONE, RSMRST, OFF, ACPI),
	/* GPP_C19 - GPIO */
	PAD_CFG_GPO(GPP_C19, 0, RSMRST),
	/* GPP_C20 - RESERVED */
	/* GPP_C21 - GPIO */
	PAD_CFG_GPO(GPP_C21, 0, RSMRST),
	/* GPP_C22 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C22, NONE, RSMRST, OFF, ACPI),
	/* GPP_C23 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C23, NONE, RSMRST, OFF, ACPI),

	/* ------- GPIO Group GPP_D ------- */
	/* GPP_D0 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D0, NONE, RSMRST, OFF, ACPI),
	/* GPP_D1 - GPIO */
	PAD_CFG_GPO(GPP_D1, 0, RSMRST),
	/* GPP_D2 - GPIO */
	PAD_CFG_GPO(GPP_D2, 0, RSMRST),
	/* GPP_D3 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D3, NONE, RSMRST, OFF, ACPI),
	/* GPP_D4 - GPIO */
	PAD_CFG_GPO(GPP_D4, 1, RSMRST),
	/* GPP_D5 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D5, NONE, RSMRST, OFF, ACPI),
	/* GPP_D6 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D6, NONE, RSMRST, OFF, DRIVER),
	/* GPP_D7 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D7, NONE, RSMRST, OFF, ACPI),
	/* GPP_D8 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D8, NONE, RSMRST, OFF, ACPI),
	/* GPP_D9 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D9, NONE, RSMRST, OFF, ACPI),
	/* GPP_D10 - SSATA_DEVSLP4 */
	PAD_CFG_NF(GPP_D10, NONE, RSMRST, NF3),
	/* GPP_D11 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D11, NONE, RSMRST, OFF, ACPI),
	/* GPP_D12 - SSATA_SDATAOUT1 */
	PAD_CFG_NF(GPP_D12, NONE, RSMRST, NF3),
	/* GPP_D13 - SML0BCLK_IE */
	PAD_CFG_NF(GPP_D13, NONE, RSMRST, NF3),
	/* GPP_D14 - SML0BDATA_IE */
	PAD_CFG_NF(GPP_D14, NONE, RSMRST, NF3),
	/* GPP_D15 - SSATA_SDATAOUT0 */
	PAD_CFG_NF(GPP_D15, NONE, RSMRST, NF3),
	/* GPP_D16 - GPIO */
	PAD_CFG_GPO(GPP_D16, 0, RSMRST),
	/* GPP_D17 - GPIO */
	PAD_CFG_GPO(GPP_D17, 0, RSMRST),
	/* GPP_D18 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D18, NONE, RSMRST, OFF, ACPI),
	/* GPP_D19 - GPIO */
	PAD_CFG_GPO(GPP_D19, 0, RSMRST),
	/* GPP_D20 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D20, NONE, RSMRST, OFF, ACPI),
	/* GPP_D21 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D21, NONE, RSMRST, OFF, ACPI),
	/* GPP_D22 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D22, NONE, RSMRST, OFF, ACPI),
	/* GPP_D23 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D23, NONE, RSMRST, OFF, ACPI),

	/* ------- GPIO Group GPP_E ------- */
	/* GPP_E0 - SATAXPCIE0 */
	PAD_CFG_NF(GPP_E0, NONE, RSMRST, NF1),
	/* GPP_E1 - SATAXPCIE1 */
	PAD_CFG_NF(GPP_E1, NONE, RSMRST, NF1),
	/* GPP_E2 - SATAXPCIE2 */
	PAD_CFG_NF(GPP_E2, NONE, RSMRST, NF1),
	/* GPP_E3 - CPU_GP0 */
	PAD_CFG_NF(GPP_E3, NONE, RSMRST, NF1),
	/* GPP_E4 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E4, NONE, RSMRST, OFF, ACPI),
	/* GPP_E5 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E5, NONE, RSMRST, OFF, ACPI),
	/* GPP_E6 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E6, NONE, RSMRST, OFF, ACPI),
	/* GPP_E7 - GPIO */
	PAD_CFG_GPI_SMI(GPP_E7, NONE, DEEP, LEVEL, INVERT),
	/* GPP_E8 - SATA_LED# */
	PAD_CFG_NF(GPP_E8, NONE, RSMRST, NF1),
	/* GPP_E9 - USB_OC0# */
	PAD_CFG_NF(GPP_E9, NONE, RSMRST, NF1),
	/* GPP_E10 - USB_OC1# */
	PAD_CFG_NF(GPP_E10, NONE, RSMRST, NF1),
	/* GPP_E11 - USB_OC2# */
	PAD_CFG_NF(GPP_E11, NONE, RSMRST, NF1),
	/* GPP_E12 - USB_OC3# */
	PAD_CFG_NF(GPP_E12, NONE, RSMRST, NF1),

	/* ------- GPIO Community 2 ------- */
	/* -------- GPIO Group GPD -------- */
	/* GPD0 - RESERVED */
	/* GPD1 - ACPRESENT */
	PAD_CFG_NF(GPD1, NONE, RSMRST, NF1),
	/* GPD2 - GBE_WAKE# */
	PAD_CFG_NF(GPD2, NONE, RSMRST, NF1),
	/* GPD3 - PWRBTN# */
	PAD_CFG_NF(GPD3, NONE, RSMRST, NF1),
	/* GPD4 - SLP_S3# */
	PAD_CFG_NF(GPD4, NONE, RSMRST, NF1),
	/* GPD5 - SLP_S4# */
	PAD_CFG_NF(GPD5, NONE, RSMRST, NF1),
	/* GPD6 - SLP_A# */
	PAD_CFG_NF(GPD6, NONE, RSMRST, NF1),
	/* GPD7 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPD7, NONE, RSMRST, OFF, ACPI),
	/* GPD8 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPD8, NONE, RSMRST, OFF, ACPI),
	/* GPD9 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPD9, NONE, RSMRST, OFF, ACPI),
	/* GPD10 - SLP_S5# */
	PAD_CFG_NF(GPD10, NONE, RSMRST, NF1),
	/* GPD11 - GBEPHY */
	PAD_CFG_NF(GPD11, NONE, RSMRST, NF1),

	/* ------- GPIO Community 3 ------- */
	/* ------- GPIO Group GPP_I ------- */
	/* GPP_I0 - LAN_TDO */
	PAD_CFG_NF(GPP_I0, NONE, RSMRST, NF2),
	/* GPP_I1 - LAN_TCK */
	PAD_CFG_NF(GPP_I1, NONE, RSMRST, NF2),
	/* GPP_I2 - LAN_TMS */
	PAD_CFG_NF(GPP_I2, NONE, RSMRST, NF2),
	/* GPP_I3 - LAN_TDI */
	PAD_CFG_NF(GPP_I3, NONE, RSMRST, NF2),
	/* GPP_I4 - GPIO */
	_PAD_CFG_STRUCT(GPP_I4,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_I5 - GPIO */
	PAD_CFG_GPO(GPP_I5, 0, RSMRST),
	/* GPP_I6 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I6, NONE, RSMRST, OFF, ACPI),
	/* GPP_I7 - LAN_TRST_IN */
	PAD_CFG_NF(GPP_I7, NONE, RSMRST, NF2),
	/* GPP_I8 - PCI_DIS */
	PAD_CFG_NF(GPP_I8, NONE, RSMRST, NF2),
	/* GPP_I9 - LAN_DIS */
	PAD_CFG_NF(GPP_I9, NONE, RSMRST, NF2),
	/* GPP_I10 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_I10, NONE, RSMRST, OFF, ACPI),

	/* ------- GPIO Community 4 ------- */
	/* ------- GPIO Group GPP_J ------- */
	/* GPP_J0 - GPIO */
	PAD_CFG_GPO(GPP_J0, 0, RSMRST),
	/* GPP_J1 - GPIO */
	PAD_CFG_GPO(GPP_J1, 0, RSMRST),
	/* GPP_J2 - GPIO */
	PAD_CFG_GPO(GPP_J2, 0, RSMRST),
	/* GPP_J3 - GPIO */
	PAD_CFG_GPO(GPP_J3, 0, RSMRST),
	/* GPP_J4 - GPIO */
	PAD_CFG_GPO(GPP_J4, 0, RSMRST),
	/* GPP_J5 - GPIO */
	PAD_CFG_GPO(GPP_J5, 0, RSMRST),
	/* GPP_J6 - GPIO */
	PAD_CFG_GPO(GPP_J6, 0, RSMRST),
	/* GPP_J7 - GPIO */
	PAD_CFG_GPO(GPP_J7, 0, RSMRST),
	/* GPP_J8 - GPIO */
	PAD_CFG_GPO(GPP_J8, 0, RSMRST),
	/* GPP_J9 - GPIO */
	PAD_CFG_GPO(GPP_J9, 0, RSMRST),
	/* GPP_J10 - GPIO */
	PAD_CFG_GPO(GPP_J10, 0, RSMRST),
	/* GPP_J11 - GPIO */
	PAD_CFG_GPO(GPP_J11, 0, RSMRST),
	/* GPP_J12 - GPIO */
	PAD_CFG_GPO(GPP_J12, 0, RSMRST),
	/* GPP_J13 - GPIO */
	_PAD_CFG_STRUCT(GPP_J13,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_J14 - GPIO */
	PAD_CFG_GPO(GPP_J14, 0, RSMRST),
	/* GPP_J15 - GPIO */
	_PAD_CFG_STRUCT(GPP_J15,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_J16 - GPIO */
	PAD_CFG_GPO(GPP_J16, 0, RSMRST),
	/* GPP_J17 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J17, NONE, RSMRST, OFF, ACPI),
	/* GPP_J18 - GPIO */
	PAD_CFG_GPO(GPP_J18, 0, RSMRST),
	/* GPP_J19 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J19, NONE, RSMRST, OFF, ACPI),
	/* GPP_J20 - GPIO */
	PAD_CFG_GPO(GPP_J20, 0, RSMRST),
	/* GPP_J21 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J21, NONE, RSMRST, OFF, ACPI),
	/* GPP_J22 - GPIO */
	PAD_CFG_GPO(GPP_J22, 0, RSMRST),
	/* GPP_J23 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_J23, NONE, RSMRST, OFF, ACPI),

	/* ------- GPIO Group GPP_K ------- */
	/* GPP_K0 - LAN_NCSI_CLK_IN */
	PAD_CFG_NF(GPP_K0, NONE, RSMRST, NF1),
	/* GPP_K1 - LAN_NCSI_TXD0 */
	PAD_CFG_NF(GPP_K1, NONE, RSMRST, NF1),
	/* GPP_K2 - LAN_NCSI_TXD1 */
	PAD_CFG_NF(GPP_K2, NONE, RSMRST, NF1),
	/* GPP_K3 - LAN_NCSI_TX_EN */
	PAD_CFG_NF(GPP_K3, NONE, RSMRST, NF1),
	/* GPP_K4 - LAN_NCSI_CRS_DV */
	PAD_CFG_NF(GPP_K4, NONE, RSMRST, NF1),
	/* GPP_K5 - LAN_NCSI_RXD0 */
	PAD_CFG_NF(GPP_K5, NONE, RSMRST, NF1),
	/* GPP_K6 - LAN_NCSI_RXD1 */
	PAD_CFG_NF(GPP_K6, NONE, RSMRST, NF1),
	/* GPP_K7 - RESERVED */
	PAD_CFG_NF(GPP_K7, NONE, RSMRST, NF1),
	/* GPP_K8 - LAN_NCSI_ARB_IN */
	PAD_CFG_NF(GPP_K8, NONE, RSMRST, NF1),
	/* GPP_K9 - LAN_NCSI_ARB_OUT */
	PAD_CFG_NF(GPP_K9, NONE, RSMRST, NF1),
	/* GPP_K10 - PE_RST# */
	PAD_CFG_NF(GPP_K10, NONE, RSMRST, NF1),

	/* ------- GPIO Community 5 ------- */
	/* ------- GPIO Group GPP_G ------- */
	/* GPP_G0 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G0, NONE, RSMRST, OFF, ACPI),
	/* GPP_G1 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G1, NONE, RSMRST, OFF, ACPI),
	/* GPP_G2 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G2, NONE, RSMRST, OFF, ACPI),
	/* GPP_G3 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G3, NONE, RSMRST, OFF, ACPI),
	/* GPP_G4 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G4, NONE, RSMRST, OFF, ACPI),
	/* GPP_G5 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G5, NONE, RSMRST, OFF, ACPI),
	/* GPP_G6 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G6, NONE, RSMRST, OFF, ACPI),
	/* GPP_G7 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G7, NONE, RSMRST, OFF, ACPI),
	/* GPP_G8 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G8, NONE, RSMRST, OFF, ACPI),
	/* GPP_G9 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G9, NONE, RSMRST, OFF, ACPI),
	/* GPP_G10 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G10, NONE, RSMRST, OFF, ACPI),
	/* GPP_G11 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G11, NONE, RSMRST, OFF, ACPI),
	/* GPP_G12 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G12, NONE, RSMRST, OFF, ACPI),
	/* GPP_G13 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G13, NONE, RSMRST, OFF, ACPI),
	/* GPP_G14 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G14, NONE, RSMRST, OFF, ACPI),
	/* GPP_G15 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G15, NONE, RSMRST, OFF, ACPI),
	/* GPP_G16 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G16, NONE, RSMRST, OFF, ACPI),
	/* GPP_G17 - ADR_COMPLETE */
	PAD_CFG_NF(GPP_G17, NONE, RSMRST, NF1),
	/* GPP_G18 - NMI# */
	PAD_CFG_NF(GPP_G18, NONE, RSMRST, NF1),
	/* GPP_G19 - SMI# */
	PAD_CFG_NF(GPP_G19, NONE, RSMRST, NF1),
	/* GPP_G20 - RESERVED */
	/* GPP_G21 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G21, NONE, RSMRST, OFF, ACPI),
	/* GPP_G22 - n/a */
	PAD_CFG_NF(GPP_G22, NONE, RSMRST, NF3),
	/* GPP_G23 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G23, NONE, RSMRST, OFF, ACPI),

	/* ------- GPIO Group GPP_H ------- */
	/* GPP_H0 - GPIO */
	_PAD_CFG_STRUCT(GPP_H0,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_H1 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H1, NONE, RSMRST, OFF, ACPI),
	/* GPP_H2 - GPIO */
	_PAD_CFG_STRUCT(GPP_H2,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_H3 - GPIO */
	_PAD_CFG_STRUCT(GPP_H3,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_H4 - GPIO */
	_PAD_CFG_STRUCT(GPP_H4,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_H5 - RESERVED */
	/* GPP_H6 - SRCCLKREQ12# */
	PAD_CFG_NF(GPP_H6, NONE, RSMRST, NF1),
	/* GPP_H7 - GPIO */
	_PAD_CFG_STRUCT(GPP_H7,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_H8 - SRCCLKREQ14# */
	PAD_CFG_NF(GPP_H8, NONE, RSMRST, NF1),
	/* GPP_H9 - GPIO */
	_PAD_CFG_STRUCT(GPP_H9,
		PAD_FUNC(GPIO) | PAD_RESET(RSMRST) |
		PAD_CFG0_TRIG_OFF | PAD_CFG0_RX_POL_NONE | PAD_BUF(NO_DISABLE),
		PAD_CFG_OWN_GPIO(ACPI) | PAD_PULL(NONE)),
	/* GPP_H10 - RESERVED */
	/* GPP_H11 - RESERVED */
	/* GPP_H12 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H12, NONE, RSMRST, OFF, ACPI),
	/* GPP_H13 - RESERVED */
	/* GPP_H14 - RESERVED */
	/* GPP_H15 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H15, NONE, RSMRST, OFF, ACPI),
	/* GPP_H16 - RESERVED */
	/* GPP_H17 - RESERVED */
	/* GPP_H18 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H18, NONE, RSMRST, OFF, ACPI),
	/* GPP_H19 - GPIO */
	PAD_CFG_GPO(GPP_H19, 0, RSMRST),
	/* GPP_H20 - SSATAXPCIE2 */
	PAD_CFG_NF(GPP_H20, NONE, RSMRST, NF2),
	/* GPP_H21 - GPIO */
	PAD_CFG_GPO(GPP_H21, 0, RSMRST),
	/* GPP_H22 - SSATAXPCIE4 */
	PAD_CFG_NF(GPP_H22, NONE, RSMRST, NF2),
	/* GPP_H23 - GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H23, NONE, RSMRST, OFF, ACPI),

	/* ------- GPIO Group GPP_L ------- */
	/* GPP_L0 - RESERVED */
	/* GPP_L1 - CSME_INTR_OUT */
	PAD_CFG_NF(GPP_L1, NONE, DEEP, NF1),
	/* GPP_L2 - TESTCH0_D0 */
	PAD_CFG_NF(GPP_L2, NONE, RSMRST, NF1),
	/* GPP_L3 - TESTCH0_D1 */
	PAD_CFG_NF(GPP_L3, NONE, RSMRST, NF1),
	/* GPP_L4 - TESTCH0_D2 */
	PAD_CFG_NF(GPP_L4, NONE, RSMRST, NF1),
	/* GPP_L5 - TESTCH0_D3 */
	PAD_CFG_NF(GPP_L5, NONE, RSMRST, NF1),
	/* GPP_L6 - TESTCH0_D4 */
	PAD_CFG_NF(GPP_L6, NONE, RSMRST, NF1),
	/* GPP_L7 - TESTCH0_D5 */
	PAD_CFG_NF(GPP_L7, NONE, RSMRST, NF1),
	/* GPP_L8 - TESTCH0_D6 */
	PAD_CFG_NF(GPP_L8, NONE, RSMRST, NF1),
	/* GPP_L9 - TESTCH0_D7 */
	PAD_CFG_NF(GPP_L9, NONE, RSMRST, NF1),
	/* GPP_L10 - TESTCH0_CLK */
	PAD_CFG_NF(GPP_L10, NONE, RSMRST, NF1),
	/* GPP_L11 - TESTCH1_D0 */
	PAD_CFG_NF(GPP_L11, NONE, RSMRST, NF1),
	/* GPP_L12 - TESTCH1_D1 */
	PAD_CFG_NF(GPP_L12, NONE, RSMRST, NF1),
	/* GPP_L13 - TESTCH1_D2 */
	PAD_CFG_NF(GPP_L13, NONE, RSMRST, NF1),
	/* GPP_L14 - TESTCH1_D3 */
	PAD_CFG_NF(GPP_L14, NONE, RSMRST, NF1),
	/* GPP_L15 - TESTCH1_D4 */
	PAD_CFG_NF(GPP_L15, NONE, RSMRST, NF1),
	/* GPP_L16 - TESTCH1_D5 */
	PAD_CFG_NF(GPP_L16, NONE, RSMRST, NF1),
	/* GPP_L17 - TESTCH1_D6 */
	PAD_CFG_NF(GPP_L17, NONE, RSMRST, NF1),
	/* GPP_L18 - TESTCH1_D7 */
	PAD_CFG_NF(GPP_L18, NONE, RSMRST, NF1),
	/* GPP_L19 - TESTCH1_CLK */
	PAD_CFG_NF(GPP_L19, NONE, RSMRST, NF1),
};

#endif /* CFG_PCH_GPIO_H */
