#!/usr/bin/perl -w

eval 'exec perl -S $0 ${1+"$@"}'
    if 0;

# This script will create the Makefile to build CLC-INTERCAL's documentation

# This file is part of CLC-INTERCAL

# Copyright (c) 2008, 2023-2024 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

require 5.005;
use strict;
use File::Spec::Functions qw(catfile curdir updir catdir);

use vars qw($VERSION $PERVERSION);
($VERSION) = ($PERVERSION = "CLC-INTERCAL/Docs Makefile.PL 1.00") =~ /\s(\S+)$/;

my $in_bundle;
my @av = map { /^--in-bundle=(.*)$/ ? ($1) : () } @ARGV;
if (@av) {
    $in_bundle = shift @av;
    @ARGV = grep { ! /^--in-bundle=/ } @ARGV;
}

my $reqv = '1.-94.-2.4';
for my $module (qw(InstallModule Exporter)) {
    if (defined $in_bundle) {
	eval {
	    require (catfile(updir(), $in_bundle, 'INTERCAL', "$module.pm"));
	    eval "import Language::INTERCAL::$module '$reqv';";
	    die $@ if $@;
	};
    } else {
	eval "use Language::INTERCAL::$module '$reqv';";
    }
    if ($@) {
	$@ =~ /can't locate/i and die "You don't appear to have CLC-INTERCAL installed:\n$@";
	die "Error loading the CLC-INTERCAL installer:\n$@";
    }
}

$in_bundle and Language::INTERCAL::InstallModule::in_bundle($in_bundle);

my $html_dir = 'doc/html';
my $html_suffix = 'html';
my $htmlgen_suffix = 'hgen';
my $examples_dir = 'doc/examples';

my @htmlcopy = ();
my @htmlgen = ();
my @examples = ();

my @extra_modules = qw(INET);

Language::INTERCAL::InstallModule::add_extra(
    manifest  => \&manifest,
    constants => \&constants,
    postamble => \&postamble,
    (map { (usemodule => $_) } @extra_modules),
);

install Language::INTERCAL::InstallModule 'Docs';

sub manifest {
    if (s#^$html_dir/##o) {
	push @htmlcopy, $1 if /^(.*\.$html_suffix)$/o;
	push @htmlgen, $1 if /^(.*)\.$htmlgen_suffix$/o;
    }
    if (s#^$examples_dir/##o) {
	push @examples, $_;
    }
}

sub constants {
    my $i = '';
    $i .= "INST_HTMLDOC = blib/htmldoc\n";
    $i .= "INST_HTMLEX = blib/htmlexamples\n";
    $i;
}

sub postamble {
    my $i = '';
    my $em = join(',', @extra_modules);

    $i .= <<EOI for @htmlcopy;
all :: \$(INST_HTMLDOC)\$(DFSEP)$_
	\$(NOECHO) \$(NOOP)

\$(INST_HTMLDOC)\$(DFSEP)$_ : \$(INST_HTMLDOC)\$(DFSEP).exists $html_dir\$(DFSEP)$_
	\$(CP) $html_dir\$(DFSEP)$_ \$(INST_HTMLDOC)\$(DFSEP)$_

EOI

    $i .= <<EOI for @htmlgen;
all :: \$(INST_HTMLDOC)\$(DFSEP)$_.$html_suffix
	\$(NOECHO) \$(NOOP)

\$(INST_HTMLDOC)\$(DFSEP)$_.$html_suffix : \$(INST_HTMLDOC)\$(DFSEP).exists $html_dir\$(DFSEP)$_.$htmlgen_suffix aux\$(DFSEP)mkhtml
	\$(PERL) aux\$(DFSEP)mkhtml "$em" $html_dir\$(DFSEP)$_.$htmlgen_suffix \$(INST_HTMLDOC)\$(DFSEP)$_.$html_suffix

EOI

    $i .= "\$(INST_HTMLDOC)\$(DFSEP).exists :: Makefile.PL\n"
	. "\t\$(NOECHO) \$(MKPATH) \$(INST_HTMLDOC)\n"
	. "\t\$(NOECHO) \$(CHMOD) 755 \$(INST_HTMLDOC)\n"
	. "\t\$(NOECHO) \$(TOUCH) \$(INST_HTMLDOC)\$(DFSEP).exists\n\n";

    if (@examples) {
	$i .= <<EOI;
all :: \$(INST_HTMLEX)\$(DFSEP)clc-intercal.css
	\$(NOECHO) \$(NOOP)

\$(INST_HTMLEX)\$(DFSEP)clc-intercal.css : \$(INST_HTMLEX)\$(DFSEP).exists clc-intercal.css
	\$(CP) clc-intercal.css \$(INST_HTMLEX)\$(DFSEP)clc-intercal.css

EOI

	my %exdir = ();
	for my $ex (@examples) {
	    my $dir = '';
	    my $down = '';
	    (my $dst = $ex) =~ s|\.[^.]*$|.html|;
	    if ($ex =~ m|^(.*)/|) {
		my $count = "/$1";
		$dir = $count;
		(my $ep = $ex) =~ s|^.*/||;
		(my $dp = $dst) =~ s|^.*/||;
		push @{$exdir{$dir}}, [$ep, $dp];
		$down .= '../' while $count =~ s|^/[^/]+||;
	    } else {
		push @{$exdir{''}}, [$ex, $dst];
	    }
	    $i .= <<EOI;
all :: \$(INST_HTMLEX)\$(DFSEP)$dst
	\$(NOECHO) \$(NOOP)

\$(INST_HTMLEX)\$(DFSEP)$dst : \$(INST_HTMLEX)$dir\$(DFSEP).exists $examples_dir\$(DFSEP)$ex aux\$(DFSEP)getlink
	\$(SICK) -lNone -Lhtml=${down}clc-intercal.css --output \$(INST_HTMLEX)\$(DFSEP)$dst $examples_dir\$(DFSEP)$ex
	\$(PERL) aux\$(DFSEP)getlink \$(INST_HTMLEX)\$(DFSEP)$dst

EOI
	}

	for my $ex (sort keys %exdir) {
	    my $parent = '';
	    $ex =~ m|^(.*)/[^/]*$| and $parent = "\$(INST_HTMLEX)\$(DFSEP)$1\$(DFSEP).exists";
	    $i .= "\$(INST_HTMLEX)$ex\$(DFSEP).exists :: $parent Makefile.PL\n"
		. "\t\$(NOECHO) \$(MKPATH) \$(INST_HTMLEX)$ex\n"
		. "\t\$(NOECHO) \$(CHMOD) 755 \$(INST_HTMLEX)$ex\n"
		. "\t\$(NOECHO) \$(TOUCH) \$(INST_HTMLEX)$ex\$(DFSEP).exists\n\n";
	    my $deps = '';
	    my $srcs = '';
	    for my $fn (@{$exdir{$ex}}) {
		$deps .= " \\\n\t\t\$(INST_HTMLEX)$ex\$(DFSEP)$fn->[1]";
		$srcs .= " \\\n\t\t\$(INST_HTMLEX)$ex\$(DFSEP)$fn->[1] $fn->[0]";
	    }
	    my $up = $parent eq '' ? '0' : '1';
	    my $re = qr|^\Q$ex\E/([^/]+)$|;
	    for my $ed (sort keys %exdir) {
		$ed =~ $re and $up .= " $1";
	    }
	    $i .= "\$(INST_HTMLEX)$ex\$(DFSEP)index.html :: \$(INST_HTMLEX)$ex\$(DFSEP).exists$deps Makefile.PL aux\$(DFSEP)gettitle\n"
		. "\t\$(NOECHO) \$(PERL) aux\$(DFSEP)gettitle \$(DFSEP)$ex $up -- $srcs > \$(INST_HTMLEX)$ex\$(DFSEP)index.html\n\n";
	    $i .= "all :: \$(INST_HTMLEX)$ex\$(DFSEP)index.html\n"
		. "\t\$(NOECHO) \$(NOOP)\n\n";
	}
    }

    $i;
}

1;
