<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Contribute/Widget.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:b47ae223e6fd74db68394139a309be31)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Contribute_DAO_Widget constructor.
 */
class CRM_Contribute_DAO_Widget extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_contribution_widget';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Contribution Id
   *
   * @var int unsigned
   */
  public $id;
  /**
   * The Contribution Page which triggered this contribution
   *
   * @var int unsigned
   */
  public $contribution_page_id;
  /**
   * Is this property active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Widget title.
   *
   * @var string
   */
  public $title;
  /**
   * URL to Widget logo
   *
   * @var string
   */
  public $url_logo;
  /**
   * Button title.
   *
   * @var string
   */
  public $button_title;
  /**
   * About description.
   *
   * @var text
   */
  public $about;
  /**
   * URL to Homepage.
   *
   * @var string
   */
  public $url_homepage;
  /**
   *
   * @var string
   */
  public $color_title;
  /**
   *
   * @var string
   */
  public $color_button;
  /**
   *
   * @var string
   */
  public $color_bar;
  /**
   *
   * @var string
   */
  public $color_main_text;
  /**
   *
   * @var string
   */
  public $color_main;
  /**
   *
   * @var string
   */
  public $color_main_bg;
  /**
   *
   * @var string
   */
  public $color_bg;
  /**
   *
   * @var string
   */
  public $color_about_link;
  /**
   *
   * @var string
   */
  public $color_homepage_link;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_contribution_widget';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contribution_page_id', 'civicrm_contribution_page', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Widget ID') ,
          'description' => 'Contribution Id',
          'required' => true,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'contribution_page_id' => array(
          'name' => 'contribution_page_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contribution Page') ,
          'description' => 'The Contribution Page which triggered this contribution',
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contribute_DAO_ContributionPage',
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Enabled?') ,
          'description' => 'Is this property active?',
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'title' => array(
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Widget Title') ,
          'description' => 'Widget title.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'url_logo' => array(
          'name' => 'url_logo',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Widget Image Url') ,
          'description' => 'URL to Widget logo',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'button_title' => array(
          'name' => 'button_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Button Title') ,
          'description' => 'Button title.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'about' => array(
          'name' => 'about',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Description') ,
          'description' => 'About description.',
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'url_homepage' => array(
          'name' => 'url_homepage',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Homepage Url') ,
          'description' => 'URL to Homepage.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_title' => array(
          'name' => 'color_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Title Color') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_button' => array(
          'name' => 'color_button',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Button Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_bar' => array(
          'name' => 'color_bar',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Bar Color') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_main_text' => array(
          'name' => 'color_main_text',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Main Text Color') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_main' => array(
          'name' => 'color_main',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Main Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_main_bg' => array(
          'name' => 'color_main_bg',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Backgroup Color') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_bg' => array(
          'name' => 'color_bg',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Other Backgroun Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_about_link' => array(
          'name' => 'color_about_link',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('About Link Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
        'color_homepage_link' => array(
          'name' => 'color_homepage_link',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Homepage Link Colour') ,
          'maxlength' => 10,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_contribution_widget',
          'entity' => 'Widget',
          'bao' => 'CRM_Contribute_BAO_Widget',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'contribution_widget', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'contribution_widget', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array();
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
