<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2015                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2015
 *
 * Generated from xml/schema/CRM/Core/MappingField.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Core_DAO_MappingField extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_mapping_field';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = false;
  /**
   * Mapping Field ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Mapping to which this field belongs
   *
   * @var int unsigned
   */
  public $mapping_id;
  /**
   * Mapping field key
   *
   * @var string
   */
  public $name;
  /**
   * Contact Type in mapping
   *
   * @var string
   */
  public $contact_type;
  /**
   * Column number for mapping set
   *
   * @var int unsigned
   */
  public $column_number;
  /**
   * Location type of this mapping, if required
   *
   * @var int unsigned
   */
  public $location_type_id;
  /**
   * Which type of phone does this number belongs.
   *
   * @var int unsigned
   */
  public $phone_type_id;
  /**
   * Which type of IM Provider does this name belong.
   *
   * @var int unsigned
   */
  public $im_provider_id;
  /**
   * Which type of website does this site belong
   *
   * @var int unsigned
   */
  public $website_type_id;
  /**
   * Relationship type, if required
   *
   * @var int unsigned
   */
  public $relationship_type_id;
  /**
   *
   * @var string
   */
  public $relationship_direction;
  /**
   * Used to group mapping_field records into related sets (e.g. for criteria sets in search builder
   mappings).
   *
   * @var int unsigned
   */
  public $grouping;
  /**
   * SQL WHERE operator for search-builder mapping fields (search criteria).
   *
   * @var string
   */
  public $operator;
  /**
   * SQL WHERE value for search-builder mapping fields.
   *
   * @var string
   */
  public $value;
  /**
   * class constructor
   *
   * @return civicrm_mapping_field
   */
  function __construct()
  {
    $this->__table = 'civicrm_mapping_field';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'mapping_id', 'civicrm_mapping', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'location_type_id', 'civicrm_location_type', 'id');
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'relationship_type_id', 'civicrm_relationship_type', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Mapping Field ID') ,
          'description' => 'Mapping Field ID',
          'required' => true,
        ) ,
        'mapping_id' => array(
          'name' => 'mapping_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Mapping ID') ,
          'description' => 'Mapping to which this field belongs',
          'required' => true,
          'FKClassName' => 'CRM_Core_DAO_Mapping',
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Name') ,
          'description' => 'Mapping field key',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'contact_type' => array(
          'name' => 'contact_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Type') ,
          'description' => 'Contact Type in mapping',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'html' => array(
            'type' => 'Select',
          ) ,
        ) ,
        'column_number' => array(
          'name' => 'column_number',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Column Number') ,
          'description' => 'Column number for mapping set',
          'required' => true,
        ) ,
        'location_type_id' => array(
          'name' => 'location_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Location type ID') ,
          'description' => 'Location type of this mapping, if required',
          'FKClassName' => 'CRM_Core_DAO_LocationType',
        ) ,
        'phone_type_id' => array(
          'name' => 'phone_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Phone type ID') ,
          'description' => 'Which type of phone does this number belongs.',
        ) ,
        'im_provider_id' => array(
          'name' => 'im_provider_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('IM provider ID') ,
          'description' => 'Which type of IM Provider does this name belong.',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'instant_messenger_service',
            'optionEditPath' => 'civicrm/admin/options/instant_messenger_service',
          )
        ) ,
        'website_type_id' => array(
          'name' => 'website_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Website type ID') ,
          'description' => 'Which type of website does this site belong',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'website_type',
            'optionEditPath' => 'civicrm/admin/options/website_type',
          )
        ) ,
        'relationship_type_id' => array(
          'name' => 'relationship_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Relationship type ID') ,
          'description' => 'Relationship type, if required',
          'FKClassName' => 'CRM_Contact_DAO_RelationshipType',
        ) ,
        'relationship_direction' => array(
          'name' => 'relationship_direction',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Direction') ,
          'maxlength' => 6,
          'size' => CRM_Utils_Type::SIX,
        ) ,
        'grouping' => array(
          'name' => 'grouping',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Grouping') ,
          'description' => 'Used to group mapping_field records into related sets (e.g. for criteria sets in search builder
      mappings).
    ',
          'default' => '1',
        ) ,
        'operator' => array(
          'name' => 'operator',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Operator') ,
          'description' => 'SQL WHERE operator for search-builder mapping fields (search criteria).',
          'maxlength' => 16,
          'size' => CRM_Utils_Type::TWELVE,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::getSearchBuilderOperators',
          )
        ) ,
        'value' => array(
          'name' => 'value',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Value') ,
          'description' => 'SQL WHERE value for search-builder mapping fields.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'mapping_id' => 'mapping_id',
        'name' => 'name',
        'contact_type' => 'contact_type',
        'column_number' => 'column_number',
        'location_type_id' => 'location_type_id',
        'phone_type_id' => 'phone_type_id',
        'im_provider_id' => 'im_provider_id',
        'website_type_id' => 'website_type_id',
        'relationship_type_id' => 'relationship_type_id',
        'relationship_direction' => 'relationship_direction',
        'grouping' => 'grouping',
        'operator' => 'operator',
        'value' => 'value',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['mapping_field'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['mapping_field'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
