 // Copyright 2013 The Chromium Authors. All rights reserved.
 // Use of this source code is governed by a BSD-style license that can be
 // found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_VIEWS_FRAME_SCROLL_END_EFFECT_CONTROLLER_H_
#define CHROME_BROWSER_UI_VIEWS_FRAME_SCROLL_END_EFFECT_CONTROLLER_H_

#include "base/basictypes.h"

// The controller receives the raw y-deltas generated by the overscroll
// controller and is resonsible for converting them in to the scroll end
// effect. This effect occurs in the vertical overscroll case and is used to
// visually indicate to the user that they have reached the end of the content
// that they are scrolling.
class ScrollEndEffectController {
 public:
  ScrollEndEffectController() {}
  virtual ~ScrollEndEffectController() {}

  static ScrollEndEffectController* Create();

  // Interface that allows vertical overscroll activies to be communicated to
  // the controller.
  virtual void OverscrollUpdate(int delta_y) = 0;

 private:
  DISALLOW_COPY_AND_ASSIGN(ScrollEndEffectController);
};

#endif  // CHROME_BROWSER_UI_VIEWS_FRAME_SCROLL_END_EFFECT_CONTROLLER_H_
