/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: Trackball.cpp,v 1.7 2002/02/19 20:39:41 vince Exp $
//

// ---------------------------------------------------------------
// Trackball.cpp
// ---------------------------------------------------------------
#include "Quaternion.H"
#include "Point.H"
#include "REAL.H"

// ---------------------------------------------------------------
static Real tb_project(Real x, Real y) {
    Real r2(x * x + y * y);
    return 1.0 / ( 1.0 + 0.5 *( r2 + 0.75 * r2 ) );
}

// ---------------------------------------------------------------
// Compute a quaternion rotation for the given two points,
// assumed to be in the interval -1 to 1
// ---------------------------------------------------------------
AmrQuaternion trackball(Real p1x, Real p1y, Real p2x, Real p2y) {
  AmrSpherePoint s1(p1x, p1y, tb_project(p1x, p1y));
  AmrSpherePoint s2(p2x, p2y, tb_project(p2x, p2y));
  return AmrQuaternion(s2,s1);
}
// ---------------------------------------------------------------
// ---------------------------------------------------------------
