# Locate Xsd from code synthesis include paths and binary
# Xsd can be found at http://codesynthesis.com/products/xsd/
# Written by Frederic Heem, frederic.heem _at_ telsey.it

# This module defines
# XSD_INCLUDE_DIR, where to find elements.hxx, etc.
# XSD_EXECUTABLE, where is the xsd compiler
# XSD_FOUND, If false, don't try to use xsd

FIND_PATH(XSD_INCLUDE_DIR xsd/cxx/parser/elements.hxx
  "[HKEY_CURRENT_USER\\software\\xsd\\include]"
  "[HKEY_CURRENT_USER]\\xsd\\include]"
  $ENV{XSDDIR}/include
  $ENV{XERCESC_ROOT_DIR}/include
  $ENV{XERCESC_DIR}/include
  ${XERCESC_INCLUDE_DIR}
  ${XERCESC_INCLUDE_DIR}/include
  ${XERCESC_INCLUDE_DIR}/..
  /usr/local/include
  /usr/include
)

# check if the plateform can compile the xsd automatically
FIND_PROGRAM(XSD_COMMAND
  NAMES xsdcxx xsd
  PATHS
    "[HKEY_CURRENT_USER\\xsd\\bin"
    $ENV{XSDDIR}/bin 
    /usr/local/bin
    /usr/bin
    ${CMAKE_FIND_ROOT_PATH}/bin #Add paths here
)

# if the include and the program are found then we have it
IF(XSD_INCLUDE_DIR)
  IF(XSD_EXECUTABLE)
    SET( XSD_FOUND "YES" )
  ENDIF(XSD_EXECUTABLE)
ENDIF(XSD_INCLUDE_DIR)

MARK_AS_ADVANCED(
  XSD_INCLUDE_DIR
  XSD_EXECUTABLE
) 
