# -*- coding: UTF-8 -*-

"""
Copyright (C) 2005-07 Adolfo González Blázquez <code@infinicode.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

If you find any bugs or have any suggestions email: code@infinicode.org
"""

import os
from cameramonitor import camglobals as glob

data = """[Desktop Entry]
Encoding=UTF-8
Name=Camera Monitor
Comment=Camera Monitor
Icon=NONE/share/cameramonitor/cameramonitor.png
Exec=NONE/bin/cameramonitor
Terminal=false
Type=Application
Categories="""

filename = os.environ["HOME"] + '/.config/autostart/' + glob.name  + '.desktop'

def create_autostart_file():
	try:
		if not os.path.exists(filename):
			f = open(filename,"w")
			f.writelines(data)
			f.close()
			os.chmod(filename, 0700)
	except:
		print "Error creating " + filename
		
def delete_autostart_file():
	try:
		if os.path.exists(filename):
			os.remove(filename)
	except:
		print "Error deleting " + filename
