/*
 *   This file is part of Auralquiz
 *   Copyright 2011-2012  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef AURALWINDOW_H
#define AURALWINDOW_H

#include <QWidget>
#include <QSettings>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QIcon>
#include <QLabel>
#include <QPixmap>
#include <QMovie>
#include <QPushButton>
#include <QProgressBar>
#include <QLCDNumber>
#include <QCloseEvent>
#include <QTimer>
#include <QDesktopServices>
#include <QDir>
#include <QFile>
#include <QDirIterator>
#include <QString>
#include <QStringList>
#include <QGroupBox>
#include <QMessageBox>
#include <QTime>
#include <QKeySequence>
#include <QProgressDialog>
#include <QDebug>

#include <phonon/MediaObject>
#include <phonon/BackendCapabilities>
#include <phonon/Global>

#include "optionsdialog.h"
#include "answerbox.h"
#include "ranking.h"

// GCC 4.7 requires this
#include <unistd.h>

// TagLib -> libtaglib-devel
#include <taglib/fileref.h>
#include <taglib/tag.h>
//#include <taglib/tstring.h>


#define MAXPLAYERS 8


class AuralWindow : public QWidget
{
    Q_OBJECT

public:
    AuralWindow(QWidget *parent = 0);
    ~AuralWindow();

    void shuffleMusicFiles();
    void updateStatistics();

protected:
    void closeEvent(QCloseEvent *event);

public:
    void initWelcomeScreen();
    void initPlayingScreen();
    void setThemedColors();

public slots:
    void loadSongList();
    void createSongList();

    void playerStateChanged(Phonon::State newstate, Phonon::State oldstate);

    void timerTick();

    void updateConfig(bool startGame, QString directory, bool forceReload,
                      int difficulty, int questions, int players,
                      QStringList playerNameList, bool ownColors);
    void showAbout();


    void toggleScreen();
    void newQuestion();
    void nextSongLoaded();
    void preQuestion();
    void answerQuestion(int numAnswer);
    void answer1();
    void answer2();
    void answer3();
    void answer4();
    void answerFromAnswerBox(bool correct);

    void killRanking();

private:
    QVBoxLayout *mainLayout;

    QWidget *welcomeWidget;
    QVBoxLayout *welcomeLayout;
    QLabel *logoLabel;
    QPushButton *startGameButton;
    QPushButton *configureButton;
    QPushButton *aboutButton;
    QPushButton *quitButton;
    QTimer *postInitTimer;


    QWidget *playingWidget;
    QVBoxLayout *playingLayout;
    QVBoxLayout *playingTopLayout;
    QHBoxLayout *playingMiddleLayout;
    QVBoxLayout *statisticsLayout;
    QVBoxLayout *answersLayout;
    QHBoxLayout *playingBottomLayout;

    QTimer *preQuestionTimer;
    QTimer *postQuestionTimer;

    QLabel *playerNameLabel;
    QLabel *questionLabel;

    QLabel *infoLabel;
    //const QString infoLabelCorrectStyle;
    //const QString infoLabelWrongStyle;
    //const QString infoLabelTimeUpStyle;

    QLabel *aniNoteLabel;
    QGroupBox *statisticsBox;
    QVBoxLayout *statisticsBoxLayout;
    QLabel *statisticsLabel;
    QTimer *gameTimer;
    QProgressBar *timeBar;
    QProgressBar *gameProgressBar;
    QLabel *gameScoreLabel;
    QLCDNumber *gameScore;
    QPushButton *endGameButton;

    QPushButton *answerButton[4];

    Phonon::MediaObject *musicPlayer;

    OptionsDialog *optionsDialog; // Options (configuration) window


    bool firstRun;
    bool useOwnColorTheme;

    bool playing;

    int difficultyLevel;
    int numQuestions;
    int numPlayers;
    int currentPlayer;

    QStringList playerNames;

    int maxTime; // depends on difficulty
    int warningTime;
    int dangerTime;

    int pieceDuration;

    int questionType;
    int correctAnswer;


    // For the "playlist" loader
    QStringList directoryFiles;
    int currentMusicFile;
    QString musicDirectory;
    QStringList musicFiles[3];
    QString dataDirectory;


    // For statistics
    QList<int> goodAnswers;
    QList<int> badAnswers;
    QList<int> timedOutAnswers;
    QList<int> score;

    // Widget for the "type-the-answer" mode
    AnswerBox *answerBox;

    // Ranking window
    Ranking *ranking;
    QTimer *rankingTimer;
};



#endif // AURALWINDOW_H
