/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;
import java.util.List;
import net.sf.jiapi.file.ClassFile;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.ParseException;
import net.sf.jiapi.file.attribute.Attribute;
import net.sf.jiapi.file.attribute.CodeAttribute;
import net.sf.jiapi.file.attribute.LocalVariableTableAttribute;
import net.sf.jiapi.file.attribute.StackMapTableAttribute;
import net.sf.jiapi.reflect.BasicBlock;
import net.sf.jiapi.reflect.BranchInstruction;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.InstructionList;
import net.sf.jiapi.reflect.JiapiClass;
import net.sf.jiapi.reflect.JiapiField;
import net.sf.jiapi.reflect.JiapiMethod;
import net.sf.jiapi.reflect.Loader;
import net.sf.jiapi.reflect.instruction.CPInstruction;
import net.sf.jiapi.reflect.instruction.Opcodes;

public class Javap {
    private JiapiClass jc;
    private ClassFile clazz;

    public static void main(String[] args) throws Exception {
        String mName;
        if (args.length == 0) {
            Javap.help();
            return;
        }
        Javap javap = null;
        try {
            javap = new Javap(args[0]);
        }
        catch (ParseException pe) {
            if (pe.getConstantPool() != null) {
                System.out.println("\n" + pe.getConstantPool());
            }
            throw pe;
        }
        if (System.getProperty("verify") != null) {
            javap.verify();
        }
        if (System.getProperty("constantpool") != null) {
            javap.printConstantPool();
        }
        if ((mName = System.getProperty("method")) != null) {
            System.setProperty("instructions", "");
        }
        javap.printClassInfo();
        javap.printFields();
        javap.printMethods();
    }

    public Javap(String classOrFileName) throws Exception {
        Loader l = new Loader();
        File f = new File(classOrFileName);
        this.jc = f.exists() ? l.loadClass(new FileInputStream(f)) : l.loadClass(classOrFileName);
        this.clazz = this.jc.getClassFile();
    }

    private static void help() {
        System.out.println("Usage: ");
        System.out.println("  java [-Dconstantpool] [-Dinstructions] [-Dmethod=<name>] [-Dverify] [-Dverbose] net.sf.jiapi.tool.Javap <path_to_class | className>");
    }

    private void printFields() {
        JiapiField[] fields = this.jc.getDeclaredFields();
        System.out.println("Fields:");
        for (int i = 0; i < fields.length; ++i) {
            this.printField(fields[i]);
        }
    }

    private void printMethods() {
        String mName = System.getProperty("method");
        JiapiMethod[] methods = this.jc.getDeclaredMethods();
        System.out.println("Methods:");
        for (int i = 0; i < methods.length; ++i) {
            if (mName == null) {
                this.printMethod(methods[i]);
            } else {
                if (!mName.equals(methods[i].getName())) continue;
                this.printMethod(methods[i]);
            }
            if (System.getProperty("instructions") != null) {
                this.printInstructions(methods[i].getInstructionList());
            }
            if (System.getProperty("code-attributes") != null) {
                CodeAttribute code = (CodeAttribute)methods[i].getMethod().getAttribute("Code");
                List attributes = code.getAttributes();
                for (Attribute attr : attributes) {
                    if (attr instanceof StackMapTableAttribute) {
                        this.printStackMapTable((StackMapTableAttribute)attr);
                        continue;
                    }
                    if (attr instanceof LocalVariableTableAttribute) {
                        this.printLocalVariableTable((LocalVariableTableAttribute)attr);
                        continue;
                    }
                    System.out.println(" " + attr);
                }
            }
            System.out.println();
        }
    }

    private void printStackMapTable(StackMapTableAttribute stackMapTable) {
        System.out.println(" StackMapTable:");
        for (StackMapTableAttribute.StackMapFrame smf : stackMapTable.getEntries()) {
            System.out.println("  " + smf);
        }
    }

    private void printLocalVariableTable(LocalVariableTableAttribute lvTable) {
        System.out.println(" LocalVariableTable:");
        for (LocalVariableTableAttribute.LocalVariable lv : lvTable.getEntries()) {
            System.out.println("  " + lv);
        }
    }

    private void printLVTable(List<BasicBlock> basicBlocks) {
        System.out.println(" LVTable");
        for (BasicBlock bb : basicBlocks) {
            System.out.println("  " + bb.getLocalVariables());
        }
    }

    protected void printClassInfo() {
        System.out.println(Modifier.toString(this.jc.getModifiers() & 0xFFDF) + " JiapiClass " + this.jc.getName() + " (" + this.clazz.getMajorVersion() + "." + this.clazz.getMinorVersion() + ")");
    }

    protected void verify() {
    }

    protected void printConstantPool() {
        System.out.println(this.jc.getConstantPool());
    }

    protected void printField(JiapiField jf) {
        System.out.println(jf);
    }

    protected void printMethod(JiapiMethod jm) {
        System.out.println(jm);
        try {
            if (!Modifier.isAbstract(jm.getModifiers()) && !Modifier.isNative(jm.getModifiers())) {
                System.out.println("Max-stack: " + jm.getMaxStack() + ", Max-locals: " + jm.getMaxLocals());
            }
        }
        catch (Exception e) {
            System.out.println("Failed to print max-stack and max-locals. There is something wrong with this class");
        }
    }

    protected void printInstructions(InstructionList il) {
        int offset = 0;
        StringBuffer sb = new StringBuffer("index offset mnemonic       operands                   stack-usage (consumes)\n");
        ConstantPool cp = this.jc.getConstantPool();
        Instruction ins = null;
        for (int i = 0; i < il.size(); ++i) {
            try {
                ins = il.get(i);
                sb.append("  #");
                sb.append(i);
                if (i < 10) {
                    sb.append(' ');
                }
                if (i < 100 && il.size() >= 100) {
                    sb.append(' ');
                }
                sb.append(" (");
                sb.append(offset);
                sb.append(")");
                if (offset < 10) {
                    sb.append("    ");
                } else if (offset < 100) {
                    sb.append("   ");
                } else {
                    sb.append("  ");
                }
                sb.append(this.toString(cp, ins, il));
                if (i < il.size() - 1) {
                    sb.append('\n');
                }
                offset += ins.length();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                sb.append("ERROR: Failed to handle instruction " + Opcodes.opcodeStrings[ins.getOpcode() & 0xFF]);
                if (ins instanceof CPInstruction) {
                    sb.append(", cp-idx: " + ((CPInstruction)ins).getIndex());
                }
                sb.append('\n');
            }
        }
        System.out.println(sb);
    }

    private String toString(ConstantPool cp, Instruction ins, InstructionList il) {
        int opCode = ins.getOpcode() & 0xFF;
        StringBuffer sb = new StringBuffer();
        sb.append(Opcodes.opcodeStrings[opCode]);
        boolean verbose = true;
        if (ins instanceof CPInstruction) {
            CPInstruction cpIns = (CPInstruction)ins;
            short idx = cpIns.getEntry().getEntryIndex();
            sb.append(' ');
            if (verbose) {
                ConstantPool.Entry ce = cp.get((int)idx);
                this.toTabPosition(15, sb);
                if (ce instanceof ConstantPool.ClassInfo) {
                    sb.append(((ConstantPool.ClassInfo)ce).getName().replace('/', '.'));
                } else if (ce instanceof ConstantPool.FieldRefInfo) {
                    ConstantPool.FieldRefInfo fri = (ConstantPool.FieldRefInfo)ce;
                    if (!il.getDeclaringMethod().getDeclaringClass().getName().equals(fri.getClassInfo().getName().replace('/', '.'))) {
                        sb.append(fri.getClassInfo().getName());
                        sb.append('.');
                    }
                    sb.append(fri.getFieldName());
                } else if (ce instanceof ConstantPool.MethodRefInfo) {
                    sb.append(((ConstantPool.MethodRefInfo)ce).getMethodName());
                    sb.append(((ConstantPool.MethodRefInfo)ce).getDescriptor());
                } else if (ce instanceof ConstantPool.InterfaceMethodRefInfo) {
                    sb.append(((ConstantPool.InterfaceMethodRefInfo)ce).getMethodName());
                    sb.append(((ConstantPool.InterfaceMethodRefInfo)ce).getDescriptor());
                } else if (ce instanceof ConstantPool.StringInfo) {
                    sb.append('\"');
                    sb.append(((ConstantPool.StringInfo)ce).stringValue());
                    sb.append('\"');
                } else {
                    sb.append(ce.toString());
                }
                sb.append(" (" + cpIns.getIndex() + ")");
            } else {
                sb.append(idx);
            }
        } else if (ins instanceof BranchInstruction) {
            BranchInstruction bi = (BranchInstruction)ins;
            this.toTabPosition(15, sb);
            Instruction target = bi.getTarget();
            sb.append('#');
            sb.append(il.indexOf(target));
            sb.append(", offset ");
            sb.append(bi.getTargetOffset());
        } else {
            this.toTabPosition(15, sb);
            byte[] bytes = ins.getBytes();
            for (int i = 1; i < bytes.length; ++i) {
                sb.append(bytes[i]);
                sb.append(' ');
            }
        }
        if (verbose) {
            this.toTabPosition(50, sb);
            sb.append(' ');
            if (ins.stackUsage() > 0) {
                sb.append('+');
            } else if (ins.stackUsage() == 0) {
                sb.append(' ');
            }
            sb.append(ins.stackUsage());
            sb.append(" (");
            sb.append(ins.stackConsumption());
            sb.append(")");
        }
        return sb.toString();
    }

    private void toTabPosition(int pos, StringBuffer sb) {
        int count = pos - sb.length();
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
    }
}

