/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:03:23 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GFFUtils;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GFFUtils_ESTest extends GFFUtils_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      // Undeclared exception!
      try { 
        GFFUtils.updateSegmentRangeStore((GFFStreamFeature) null, (Location) null, (Location) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(524);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      Location location1 = location0.getComplement();
      Location location2 = location1.copy();
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location2, qualifierVector0);
      GFFUtils.updateSegmentRangeStore(gFFStreamFeature0, location2, location0);
      assertFalse(location0.equals((Object)location1));
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      Key key0 = new Key("");
      Range range0 = new Range(76);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, qualifierVector0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(blastStreamFeature0, false);
      Location location1 = location0.addRange(range0);
      GFFUtils.updateSegmentRangeStore(gFFStreamFeature0, location0, location1);
      assertNull(gFFStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(524);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      GFFUtils.updateSegmentRangeStore(gFFStreamFeature0, location0, location0);
      assertNull(gFFStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Key key0 = new Key("");
      Range range0 = new Range(76);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, qualifierVector0);
      boolean boolean0 = GFFUtils.isSelenocysteine(blastStreamFeature0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(524);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      GFFUtils.isSelenocysteine(gFFStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      GFFUtils gFFUtils0 = new GFFUtils();
  }
}
