/*
    Copyright (C) 20002 Paul Davis
    Sounds by Nick Mainsbridge.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ardour/session.h"
#include "ardour/types.h"

#ifdef COMPILER_MSVC
#pragma warning(disable:4305)
#endif

using namespace ARDOUR;

const Sample Session::default_click_emphasis[] = {

   0.023108594,
    0.11366423,
    0.21524186,
    0.29314724,
    0.36904865,
    0.42052634,
     0.4606689,
    0.47582414,
    0.47494738,
    0.45008529,
     0.4098801,
     0.3495723,
    0.27648902,
    0.19031713,
   0.096442375,
 -0.0020039971,
   -0.10038775,
   -0.19520187,
   -0.28262626,
   -0.35902867,
   -0.42115258,
   -0.46686876,
   -0.49329648,
   -0.50118723,
     -0.489038,
   -0.45772554,
   -0.40875284,
   -0.34368556,
   -0.26571752,
   -0.17798002,
  -0.084167892,
   0.012399734,
    0.10727649,
     0.1967675,
    0.27730315,
    0.34531381,
    0.39841973,
    0.43467957,
    0.45196404,
    0.45033579,
    0.42954432,
      0.390529,
     0.3352312,
    0.26578015,
    0.18493139,
    0.09612925,
  0.0031938707,
  -0.090493008,
   -0.18067289,
   -0.26377616,
   -0.33685943,
   -0.39641574,
    -0.4403158,
   -0.46686876,
   -0.47488475,
    -0.4641759,
   -0.43555632,
    -0.3897775,
   -0.32884345,
   -0.25563491,
   -0.17284478,
  -0.083917393,
  0.0072644907,
   0.097444375,
    0.18255164,
    0.25914192,
    0.32439707,
    0.37549902,
     0.4103811,
    0.42785344,
    0.42716457,
    0.40818922,
    0.37224251,
    0.32057696,
    0.25525917,
    0.17929514,
   0.095565627,
  0.0075149904,
  -0.081036645,
   -0.16664491,
   -0.24599069,
   -0.31544172,
   -0.37255564,
   -0.41495271,
    -0.4408168,
   -0.44933379,
   -0.44025317,
   -0.41370021,
   -0.37111528,
   -0.31437709,
   -0.24542706,
   -0.16745903,
  -0.083666891,
  0.0028181211,
   0.088175886,
    0.16883678,
    0.24198268,
    0.30429448,
    0.35326717,
    0.38720989,
    0.40449436,
    0.40455697,
    0.38777349,
    0.35445704,
     0.3061106,
     0.2450513,
    0.17353365,
   0.094563628,
    0.01158561,
  -0.072394406,
   -0.15368155,
   -0.22889408,
   -0.29527649,
   -0.34994806,
   -0.39065424,
   -0.41601734,
   -0.42497271,
   -0.41701933,
   -0.39284612,
   -0.35339241,
    -0.3000986,
   -0.23553232,
   -0.16219854,
  -0.082978018,
 -0.0013151234,
   0.079471024,
     0.1563118,
    0.22582547,
    0.28525651,
    0.33247569,
    0.36516591,
    0.38238775,
    0.38345238,
    0.36810927,
    0.33729782,
      0.292521,
    0.23515658,
    0.16789741,
   0.093624253,
   0.015029981,
  -0.064441042,
   -0.14146969,
   -0.21317523,
   -0.27648902,
   -0.32871821,
   -0.36810927,
   -0.39284612,
   -0.40198935,
   -0.39547637,
   -0.37336977,
   -0.33654631,
   -0.28688476,
   -0.22626383,
   -0.15700067,
  -0.082351768,
 -0.0050099934,
   0.071768159,
    0.14460094,
    0.21085811,
    0.26784678,
    0.31306196,
    0.34487542,
    0.36203466,
    0.36360028,
    0.35001067,
    0.32164158,
    0.27962027,
    0.22588808,
    0.16269954,
   0.092371757,
   0.018098602,
  -0.057176551,
   -0.13057296,
   -0.19877149,
   -0.25920455,
   -0.30949235,
   -0.34744305,
   -0.37161627,
   -0.38126052,
   -0.37574952,
   -0.35545903,
   -0.32139108,
   -0.27479814,
   -0.21762159,
   -0.15249168,
  -0.081662895,
 -0.0083291144,
   0.064503666,
    0.13407995,
    0.19739374,
    0.25187743,
    0.29546436,
    0.32640108,
    0.34324719,
    0.34568955,
    0.33341508,
    0.30704999,
    0.26790941,
    0.21743372,
    0.15762692,
   0.091307132,
   0.020854099,
  -0.050726184,
   -0.12042772,
   -0.18555764,
   -0.24348568,
   -0.29158162,
   -0.32821721,
   -0.35195205,
   -0.36159629,
   -0.35708729,
   -0.33861293,
   -0.30673686,
   -0.26308729,
   -0.20941773,
   -0.14773218,
   -0.08084877,
   -0.01146036,
   0.057865425,
    0.12399734,
    0.18424251,
    0.23647171,
    0.27836776,
    0.30811459,
    0.32489809,
    0.32777882,
    0.31681947,
    0.29264624,
    0.25601067,
    0.20854099,
    0.15249168,
   0.089804134,
    0.02317122,
  -0.044463692,
   -0.11065823,
    -0.1726569,
   -0.22764159,
   -0.27379614,
   -0.30905398,
   -0.33197469,
   -0.34186944,
   -0.33829982,
   -0.32126584,
   -0.29183212,
    -0.2510633,
   -0.20058762,
   -0.14265957,
  -0.079658896,
  -0.013902732,
   0.051540309,
    0.11416523,
    0.17159228,
    0.22125383,
    0.26127117,
    0.29014125,
    0.30648636,
    0.30980548,
    0.30022386,
    0.27780415,
    0.24373618,
    0.19958562,
    0.14685544,
   0.087925388,
   0.025300468,
  -0.038702199,
   -0.10126449,
   -0.15981879,
   -0.21223585,
   -0.25619854,
   -0.28989075,
   -0.31218523,
   -0.32207995,
   -0.31919922,
   -0.30385611,
   -0.27661426,
   -0.23853833,
     -0.191507,
    -0.1372112,
  -0.077842776,
  -0.016157229,
   0.045653565,
    0.10489674,
    0.15919255,
    0.20634911,
    0.24461293,
    0.27223052,
     0.2882625,
    0.29208261,
    0.28344039,
    0.26296203,
    0.23152433,
    0.19019188,
    0.14096869,
   0.085858765,
   0.026928716,
  -0.033191206,
  -0.092121255,
   -0.14760694,
   -0.19708062,
   -0.23878883,
   -0.27110328,
     -0.292521,
   -0.30235312,
   -0.30028649,
   -0.28638375,
   -0.26120854,
   -0.22607596,
   -0.18211327,
   -0.13132445,
  -0.075901403,
  -0.017910727,
   0.040205198,
   0.095941377,
    0.14723118,
    0.19194538,
     0.2282052,
    0.25469555,
    0.27028916,
    0.27429714,
    0.26684478,
    0.24818255,
    0.21899934,
    0.18079814,
     0.1349567,
   0.083291143,
   0.028243839,
   -0.02811859,
  -0.083604267,
   -0.13564557,
   -0.18242639,
   -0.22200533,
   -0.25262892,
   -0.27323252,
   -0.28306463,
   -0.28156163,
   -0.26909927,
   -0.24611593,
   -0.21342573,
    -0.1726569,
   -0.12543771,
  -0.073584279,
    -0.0193511,
    0.03500733,
   0.087487013,
     0.1357082,
    0.17785477,
    0.21229848,
     0.2374737,
    0.25250369,
    0.25695004,
    0.25043704,
    0.23340307,
    0.20666224,
    0.17121653,
    0.12856896,
   0.080598271,
   0.029183211,
  -0.023609594,
  -0.075463029,
   -0.12443572,
   -0.16846103,
   -0.20572285,
   -0.23484345,
   -0.25463292,
   -0.26421453,
    -0.2634004,
   -0.25225317,
   -0.23108595,
   -0.20108861,
   -0.16338841,
    -0.1193631,
  -0.071204532,
  -0.020603599,
   0.030310461,
   0.079345772,
    0.12462359,
    0.16439041,
    0.19683012,
    0.22081546,
    0.23540708,
    0.23991606,
    0.23434245,
    0.21899934,
    0.19438775,
    0.16163492,
    0.12224384,
   0.077592274,
   0.029684212,
  -0.019413725,
  -0.068010662,
    -0.1138521,
   -0.15512193,
   -0.19031713,
   -0.21787209,
   -0.23665957,
   -0.24617856,
   -0.24586543,
   -0.23578282,
   -0.21661959,
   -0.18900201,
    -0.1540573,
   -0.11341373,
  -0.068636912,
  -0.021480347,
   0.025926716,
   0.071830783,
    0.11429048,
    0.15148968,
    0.18211327,
    0.20490874,
     0.2188741,
    0.22357095,
     0.2188741,
    0.20490874,
    0.18242639,
     0.1523038,
    0.11579348,
   0.074461028,
   0.029997336,
  -0.015844104,
  -0.061059297,
   -0.10389474,
   -0.14265957,
   -0.17560027,
   -0.20158962,
    -0.2196256,
   -0.22883145,
   -0.22895671,
   -0.22018921,
   -0.20265424,
   -0.17722852,
   -0.14516456,
   -0.10746436,
  -0.065881415,
  -0.022231846,
   0.021981347,
   0.064816791,
    0.10439574,
    0.13940307,
    0.16821053,
    0.18969088,
    0.20315524,
    0.20797736,
    0.20396936,
    0.19144438,
    0.17090341,
    0.14316057,
    0.10953098,
   0.071267158,
   0.029997336,
  -0.012524984,
  -0.054671555,
  -0.094688878,
   -0.13082346,
   -0.16182279,
   -0.18637176,
   -0.20340574,
   -0.21242372,
   -0.21304997,
   -0.20515924,
   -0.18931513,
   -0.16608129,
    -0.1364597,
   -0.10170287,
  -0.063251168,
  -0.022607597,
   0.018474351,
   0.058303799,
   0.095377751,
    0.12806796,
    0.15512193,
    0.17560027,
    0.18843838,
     0.1932605,
    0.19000401,
    0.17873152,
    0.15994404,
    0.13458095,
    0.10351899,
   0.068135912,
    0.02993471,
 -0.0095816129,
  -0.048847437,
  -0.086109264,
   -0.11998935,
   -0.14910993,
    -0.1721559,
   -0.18843838,
   -0.19720587,
   -0.19808262,
   -0.19119388,
   -0.17685277,
   -0.15549767,
   -0.12831846,
  -0.096191876,
  -0.060558297,
  -0.022920721,
    0.01528048,
   0.052479682,
   0.087048639,
    0.11767222,
    0.14322319,
    0.16244904,
    0.17478615,
    0.17973352,
    0.17704065,
    0.16689541,
    0.14986143,
    0.12650234,
   0.097820124,
   0.065192541,
   0.029684212,
 -0.0070766159,
  -0.043524319,
  -0.078406399,
   -0.11009461,
   -0.13733645,
   -0.15919255,
    -0.1746609,
   -0.18311526,
   -0.18436776,
   -0.17835577,
   -0.16526716,
   -0.14585344,
   -0.12074085,
  -0.090994008,
    -0.0580533,
  -0.023045972,
   0.012587609,
   0.047219189,
   0.079596272,
    0.10834111,
    0.13232646,
    0.15061293,
    0.16244904,
    0.16733378,
    0.16526716,
    0.15618655,
    0.14053032,
     0.1191126,
   0.092684881,
   0.062311794,
   0.029433713,
 -0.0047594937,
  -0.038890075,
  -0.071455034,
   -0.10113925,
   -0.12687809,
   -0.14748168,
   -0.16219854,
   -0.17052765,
   -0.17203065,
   -0.16670754,
   -0.15493405,
   -0.13702332,
    -0.1138521,
  -0.086422388,
  -0.055673553,
  -0.023045972,
   0.010082612,
   0.042584945,
   0.072958032,
   0.099949372,
    0.12268222,
    0.14002932,
    0.15136443,
    0.15637442,
    0.15474618,
    0.14660494,
    0.13232646,
    0.11253698,
   0.087988011,
   0.059869424,
   0.029120587,
 -0.0028807465,
   -0.03475683,
   -0.06531779,
  -0.093373755,
    -0.1176096,
    -0.1372112,
   -0.15136443,
   -0.15938042,
   -0.16119654,
    -0.1565623,
   -0.14579081,
   -0.12932046,
   -0.10790274,
  -0.082289145,
  -0.053669555,
   -0.02317122,
  0.0080159898,
   0.038514326,
   0.067133915,
   0.092747505,
    0.11429048,
    0.13082346,
    0.14190807,
    0.14685544,
    0.14566556,
    0.13840107,
    0.12524984,
    0.10690074,
   0.084105266,
   0.057740176,
   0.028932713,
 -0.0010646237,
   -0.03118721,
  -0.060119923,
  -0.086610264,
   -0.10971886,
   -0.12844371,
   -0.14203332,
   -0.15004931,
    -0.1520533,
   -0.14798268,
   -0.13815057,
   -0.12293272,
   -0.10289274,
  -0.078970023,
  -0.052041307,
  -0.023233844,
  0.0061372421,
   0.035069956,
   0.062311794,
   0.086672888,
    0.10727649,
    0.12330846,
     0.1339547,
    0.13902732,
    0.13827582,
    0.13157496,
    0.11948835,
    0.10239174,
   0.080911396,
   0.056111928,
   0.028932713,
 0.00043837447,
   -0.02811859,
  -0.055610927,
  -0.080974021,
   -0.10308062,
   -0.12105397,
   -0.13426783,
   -0.14209594,
   -0.14428781,
   -0.14084344,
   -0.13176283,
   -0.11748435,
  -0.098759499,
  -0.076151902,
  -0.050663561,
   -0.02342172,
  0.0045089941,
   0.032063959,
   0.057990674,
    0.08134977,
    0.10113925,
    0.11654497,
    0.12700334,
    0.13207595,
    0.13157496,
    0.12556296,
    0.11429048,
   0.098195872,
   0.078093274,
   0.054608929,
   0.028807463,
  0.0018161228,
  -0.025300468,
  -0.051602933,
  -0.075776153,
  -0.096943375,
    -0.1143531,
   -0.12706596,
   -0.13476883,
    -0.1372112,
   -0.13407995,
   -0.12575084,
   -0.11247435,
  -0.094814127,
   -0.07345903,
  -0.049411061,
  -0.023546969,
  0.0030059963,
   0.029245838,
   0.054045305,
   0.076339778,
   0.095315127,
    0.11028248,
    0.12049034,
    0.12550034,
    0.12537509,
    0.11992672,
    0.10940573,
   0.094375752,
   0.075337777,
   0.053168557,
   0.028744837,
  0.0030686213,
  -0.022858095,
   -0.04784544,
  -0.070954034,
  -0.091307132,
   -0.10796536,
   -0.12036509,
   -0.12800534,
   -0.13051033,
   -0.12788009,
   -0.12017722,
   -0.10771486,
  -0.091119258,
  -0.071016659,
  -0.048158564,
  -0.023609594,
   0.001628248,
   0.026678215,
   0.050287809,
   0.071705533,
    0.08999201,
    0.10439574,
    0.11429048,
    0.11942572,
    0.11948835,
    0.11447835,
    0.10477149,
   0.090618259,
   0.072707531,
   0.051728184,
   0.028556964,
   0.004133245,
  -0.020478349,
  -0.044401068,
   -0.06657029,
  -0.086046638,
   -0.10214124,
   -0.11422785,
   -0.12161759,
   -0.12431047,
   -0.12205597,
   -0.11491673,
   -0.10333112,
  -0.087674886,
  -0.068636912,
  -0.047031315,
  -0.023734844,
 0.00037574954,
   0.024235845,
   0.046843438,
   0.067384413,
   0.084919391,
   0.098884747,
    0.10859161,
    0.11366423,
    0.11397735,
    0.10946836,
    0.10038775,
   0.087111263,
   0.070202535,
   0.050350435,
   0.028306462,
  0.0051352433,
  -0.018411726,
  -0.041207196,
  -0.062437044,
   -0.08122452,
    -0.0967555,
   -0.10834111,
   -0.11573085,
   -0.11848635,
   -0.11654497,
   -0.11003198,
  -0.099135248,
   -0.08441839,
  -0.066445038,
  -0.045904067,
  -0.023734844,
-0.00081412401,
   0.021981347,
   0.043712195,
   0.063376418,
   0.080285146,
   0.093749503,
    0.10320587,
    0.10827849,
    0.10884211,
    0.10477149,
   0.096317126,
   0.083854767,
   0.067885414,
   0.049035313,
   0.028181214,
  0.0060119922,
  -0.016407729,
  -0.038263825,
  -0.058616925,
  -0.076652902,
  -0.091620257,
   -0.10295537,
   -0.11015723,
   -0.11303798,
   -0.11140973,
   -0.10539774,
  -0.095189878,
   -0.08134977,
  -0.064253167,
  -0.044776816,
  -0.023734844,
 -0.0018161228,
   0.019977349,
   0.040706197,
   0.059681548,
   0.075964026,
   0.088990011,
   0.098258498,
    0.10326849,
    0.10401999,
    0.10038775,
   0.092497006,
   0.080786146,
   0.065693539,
    0.04784544,
   0.027930714,
  0.0068887412,
  -0.014591606,
  -0.035508329,
   -0.05498468,
  -0.072331782,
  -0.086860763,
  -0.097820124,
   -0.10495936,
   -0.10790274,
   -0.10652499,
     -0.101014,
  -0.091495008,
  -0.078343773,
  -0.062249171,
  -0.043774819,
  -0.023609594,
 -0.0027554962,
   0.018098602,
   0.038013326,
   0.056174553,
   0.071893408,
    0.08454364,
    0.09356163,
   0.098571623,
   0.099510998,
   0.096254502,
   0.088927385,
     0.0779054,
   0.063626917,
   0.046655566,
   0.027742839,
  0.0075776153,
  -0.012900733,
  -0.032878084,
  -0.051665558,
  -0.068386411,
  -0.082351768,
   -0.09306063,
   -0.10007462,
   -0.10308062,
   -0.10201599,
  -0.096880749,
  -0.087925388,
  -0.075588278,
  -0.060307798,
  -0.042710194,
  -0.023546969,
 -0.0035696202,
   0.016345104,
   0.035445705,
   0.052918058,
   0.068135912,
   0.080347772,
   0.089177884,
   0.094187879,
   0.095252501,
   0.092309131,
    0.08554564,
   0.075149904,
    0.06162292,
   0.045528315,
   0.027492339,
  0.0083291144,
  -0.011272485,
  -0.030498337,
  -0.048534313,
  -0.064628918,
    -0.0781559,
  -0.088551635,
  -0.095440377,
  -0.098571623,
  -0.097694874,
  -0.092998006,
  -0.084668892,
  -0.072958032,
  -0.058429049,
  -0.041708196,
   -0.02342172,
 -0.0043211193,
   0.014716856,
   0.033065957,
   0.049912062,
   0.064566292,
   0.076402401,
    0.08504464,
   0.090054633,
   0.091244506,
   0.088676887,
   0.082289145,
   0.072519656,
   0.059744174,
   0.044401068,
   0.027241839,
  0.0089553632,
 -0.0098947375,
  -0.028243839,
  -0.045590941,
   -0.06112192,
  -0.074210529,
  -0.084355767,
  -0.091119258,
  -0.094250503,
  -0.093624253,
   -0.08936576,
   -0.08147502,
  -0.070453033,
  -0.056738177,
  -0.040768822,
   -0.02329647,
 -0.0050726184,
   0.013276483,
   0.030874085,
   0.047031315,
   0.061184546,
   0.072707531,
   0.081099271,
   0.086109264,
   0.087424387,
   0.085107266,
   0.079220522,
   0.070014659,
   0.057928051,
    0.04339907,
    0.02699134,
  0.0094563626,
 -0.0085169892,
  -0.026177217,
  -0.042835444,
  -0.057802801,
  -0.070453033,
  -0.080347772,
  -0.086986013,
  -0.090179883,
  -0.089804134,
  -0.085796139,
  -0.078469023,
  -0.068073286,
   -0.05498468,
   -0.03982945,
   -0.02317122,
 -0.0056988676,
    0.01183611,
   0.028744837,
   0.044401068,
   0.057990674,
    0.06913791,
   0.077404401,
   0.082289145,
   0.083792143,
   0.081725519,
   0.076277152,
   0.067634912,
   0.056174553,
   0.042271819,
   0.026678215,
  0.0099573624,
 -0.0072644907,
  -0.024235845,
  -0.040205198,
  -0.054671555,
  -0.066946039,
   -0.07652765,
  -0.083040644,
   -0.08629714,
  -0.086046638,
  -0.082477018,
  -0.075588278,
  -0.065693539,
  -0.053356432,
  -0.038890075,
  -0.022983345,
 -0.0062624919,
   0.010520986,
   0.026803465,
   0.041833446,
    0.05498468,
   0.065818791,
   0.073834781,
   0.078719525,
   0.080285146,
   0.078469023,
   0.073396406,
   0.065255165,
    0.05435843,
   0.041207196,
    0.02636509,
   0.010333112,
 -0.0061372421,
  -0.022357095,
  -0.037825451,
  -0.051728184,
  -0.063564293,
  -0.072895406,
  -0.079283148,
  -0.082539644,
  -0.082477018,
  -0.079157899,
  -0.072707531,
  -0.063439044,
  -0.051665558,
    -0.0379507,
   -0.02279547,
 -0.0067634913,
  0.0093311127,
   0.024924718,
   0.039391075,
   0.052103933,
   0.062562295,
   0.070390409,
   0.075212527,
   0.076903401,
   0.075337777,
   0.070640909,
   0.062938044,
   0.052667557,
   0.040205198,
   0.025989342,
   0.010708862,
 -0.0050726184,
  -0.020666223,
  -0.035445705,
  -0.048847437,
  -0.060307798,
  -0.069388411,
  -0.075650902,
  -0.078907397,
  -0.079032649,
  -0.076026652,
  -0.070014659,
  -0.061184546,
   -0.05003731,
  -0.037011328,
  -0.022482347,
 -0.0072644907,
  0.0082038641,
    0.02317122,
   0.037073951,
   0.049348437,
   0.059493673,
   0.067071289,
   0.071830783,
   0.073584279,
   0.072269157,
   0.067885414,
   0.060683547,
   0.050914059,
   0.039077951,
   0.025613591,
   0.010959361,
  -0.004133245,
  -0.019037975,
  -0.033253832,
  -0.046154566,
  -0.057176551,
  -0.066006664,
  -0.072143907,
  -0.075400403,
  -0.075650902,
  -0.072958032,
  -0.067259163,
  -0.059055299,
  -0.048471686,
  -0.036009328,
  -0.022231846,
 -0.0076402402,
  0.0071392409,
   0.021480347,
   0.034819454,
   0.046655566,
   0.056487676,
   0.063877419,
   0.068574287,
   0.070390409,
    0.06926316,
   0.065192541,
   0.058429049,
   0.049223186,
   0.038013326,
   0.025112593,
    0.01120986,
 -0.0031938707,
  -0.017534977,
  -0.031124584,
  -0.043524319,
  -0.054233181,
  -0.062750168,
  -0.068762161,
  -0.072018657,
  -0.072394406,
   -0.06988941,
  -0.064691542,
  -0.056863427,
  -0.046843438,
  -0.035069956,
  -0.021918721,
 -0.0080159898,
  0.0061372421,
   0.019852099,
   0.032752832,
   0.044087943,
   0.053606931,
   0.060808796,
   0.065443041,
   0.067321787,
   0.066382415,
   0.062624919,
   0.056299803,
   0.047594937,
   0.036886078,
   0.024674218,
    0.01146036,
 -0.0023797466,
  -0.016031979,
  -0.029120587,
  -0.041081946,
  -0.051352434,
  -0.059618922,
  -0.065505667,
  -0.068699536,
   -0.06926316,
  -0.067008664,
  -0.062123921,
  -0.054796804,
  -0.045340443,
  -0.034067955,
  -0.021542972,
 -0.0083291144,
  0.0051978682,
   0.018411726,
   0.030686209,
   0.041708196,
   0.050851434,
   0.057865425,
   0.062437044,
   0.064315793,
   0.063564293,
   0.060119923,
   0.054170555,
    0.04596669,
   0.035884078,
   0.024235845,
    0.01158561,
 -0.0015656231,
  -0.014654231,
  -0.027241839,
  -0.038702199,
  -0.048596939,
  -0.056612928,
  -0.062311794,
   -0.06556829,
  -0.066194539,
  -0.064127917,
  -0.059618922,
  -0.052730182,
  -0.043712195,
  -0.033065957,
  -0.021229848,
 -0.0085169892,
  0.0043837442,
   0.016971353,
   0.028870089,
   0.039391075,
   0.048221188,
   0.055047304,
   0.059493673,
   0.061435046,
   0.060871421,
    0.05767755,
   0.052103933,
   0.044401068,
   0.034819454,
   0.023734844,
    0.01171086,
-0.00081412401,
  -0.013401733,
  -0.025363092,
  -0.036447702,
   -0.04596669,
  -0.053732181,
  -0.059305798,
  -0.062499669,
  -0.063188543,
  -0.061435046,
  -0.057176551,
  -0.050663561,
  -0.042209196,
  -0.032126585,
  -0.020791473,
  -0.008704864,
  0.0035696202,
   0.015718855,
   0.027053966,
   0.037199201,
   0.045716191,
   0.052354432,
   0.056675552,
   0.058742173,
   0.058241176,
   0.055360429,
    0.05016256,
   0.042835444,
   0.033754833,
    0.02329647,
   0.011773485,
-0.00018787477,
  -0.012149234,
   -0.02367222,
   -0.03425583,
  -0.043461694,
  -0.050976685,
  -0.056362426,
  -0.059556298,
  -0.060370421,
  -0.058742173,
  -0.054796804,
  -0.048722187,
  -0.040768822,
   -0.03118721,
  -0.020415724,
 -0.0088927387,
  0.0028807465,
   0.014403732,
   0.025300468,
   0.035069956,
   0.043273818,
   0.049724186,
    0.05398268,
   0.055986678,
   0.055673553,
   0.053043307,
   0.048158564,
   0.041269822,
   0.032690208,
   0.022732846,
    0.01183611,
 0.00043837447,
  -0.011021986,
  -0.022043973,
  -0.032189209,
  -0.041081946,
  -0.048283814,
  -0.053606931,
  -0.056738177,
  -0.057614926,
  -0.056174553,
  -0.052542307,
  -0.046843438,
  -0.039265824,
  -0.030247835,
  -0.019977349,
 -0.0090179881,
  0.0021918723,
   0.013276483,
    0.02367222,
   0.033065957,
   0.041019323,
   0.047219189,
   0.051352434,
   0.053419056,
   0.053231181,
    0.05078881,
   0.046279815,
   0.039766824,
   0.031625584,
   0.022231846,
    0.01183611,
 0.00093937386,
 -0.0099573624,
  -0.020540975,
  -0.030247835,
  -0.038764825,
  -0.045778817,
  -0.050914059,
  -0.054045305,
   -0.05498468,
  -0.053732181,
  -0.050350435,
  -0.044964692,
  -0.037888077,
  -0.029245838,
    -0.0196016,
 -0.0091432384,
  0.0015656231,
   0.012149234,
   0.022106596,
   0.031124584,
   0.038764825,
   0.044776816,
   0.048847437,
   0.050914059,
    0.05078881,
   0.048596939,
   0.044338442,
   0.038263825,
   0.030623586,
   0.021668222,
   0.011773485,
  0.0014403732,
 -0.0090179881,
    -0.0191006,
  -0.028431713,
  -0.036635578,
  -0.043336444,
  -0.048346437,
   -0.05141506,
  -0.052417058,
  -0.051289808,
  -0.048221188,
  -0.043211194,
  -0.036447702,
  -0.028369088,
  -0.019163225,
 -0.0092058633,
  0.0010019988,
   0.011084611,
   0.020603599,
   0.029245838,
   0.036635578,
   0.042459695,
   0.046405064,
   0.048471686,
   0.048471686,
    0.04646769,
   0.042522321,
   0.036823452,
   0.029558962,
   0.021104598,
   0.011773485,
  0.0018787477,
 -0.0080786147,
  -0.017722852,
  -0.026678215,
  -0.034506331,
  -0.041019323,
  -0.045841441,
  -0.048847437,
  -0.049912062,
  -0.048972687,
  -0.046091942,
  -0.041395071,
  -0.035069956,
  -0.027429715,
  -0.018662226,
 -0.0092684883,
 0.00043837447,
   0.010082612,
    0.01922585,
   0.027492339,
   0.034568956,
   0.040205198,
   0.044087943,
   0.046154566,
   0.046217191,
   0.044401068,
   0.040768822,
   0.035383081,
   0.028556964,
   0.020540975,
   0.011648235,
  0.0022544973,
 -0.0072018658,
  -0.016407729,
  -0.024987344,
  -0.032502333,
  -0.038764825,
  -0.043461694,
  -0.046405064,
  -0.047532314,
  -0.046718189,
  -0.044087943,
    -0.0397042,
  -0.033692206,
  -0.026490342,
  -0.018223851,
 -0.0092684883,
             0,
  0.0091432384,
   0.017910727,
   0.025801467,
   0.032627583,
   0.038013326,
   0.041833446,
   0.043837444,
   0.044087943,
   0.042397069,
   0.039015325,
   0.034005331,
   0.027554963,
   0.019914724,
   0.011522985,
  0.0026302468,
 -0.0063877418,
   -0.01515523,
  -0.023359096,
  -0.030623586,
  -0.036572954,
  -0.041144572,
  -0.044025317,
  -0.045152567,
  -0.044526318,
  -0.042083945,
    -0.0379507,
  -0.032377083,
  -0.025550967,
  -0.017722852,
 -0.0092058633,
-0.00043837447,
  0.0083291144,
   0.016595603,
   0.024173219,
   0.030748835,
   0.035946704,
   0.039641574,
    0.04164557,
   0.041958695,
   0.040455697,
   0.037324453,
   0.032564959,
   0.026490342,
     0.0193511,
   0.011397735,
  0.0029433714,
 -0.0056362427,
  -0.014027982,
  -0.021793472,
  -0.028744837,
  -0.034506331,
  -0.038952701,
  -0.041770822,
   -0.04289807,
  -0.042334445,
  -0.040142574,
  -0.036322452,
  -0.031061961,
  -0.024611593,
  -0.017221853,
 -0.0091432384,
-0.00081412401,
  0.0075149904,
    0.01540573,
    0.02267022,
   0.028932713,
   0.033942705,
   0.037512326,
   0.039516324,
    0.03982945,
   0.038514326,
   0.035633579,
    0.03118721,
   0.025488341,
   0.018724851,
    0.01120986,
  0.0031938707,
 -0.0049473685,
  -0.012900733,
  -0.020353099,
   -0.02699134,
  -0.032502333,
  -0.036760827,
  -0.039516324,
  -0.040706197,
  -0.040267824,
  -0.038201202,
  -0.034631582,
  -0.029746837,
   -0.02367222,
  -0.016658228,
 -0.0090806135,
 -0.0011898736,
  0.0067634913,
   0.014278482,
   0.021167222,
   0.027179215,
   0.032001333,
   0.035445705,
   0.037449703,
   0.037825451,
   0.036635578,
   0.033942705,
   0.029872087,
   0.024486343,
   0.018098602,
   0.011021986,
  0.0034443708,
 -0.0043211193,
   -0.01183611,
  -0.018975351,
  -0.025300468,
  -0.030560961,
  -0.034694205,
  -0.037324453,
  -0.038514326,
  -0.038201202,
  -0.036322452,
  -0.033003333,
  -0.028431713,
   -0.02267022,
  -0.016094605,
 -0.0089553632,
 -0.0014403732,
  0.0060119922,
   0.013213858,
   0.019789475,
   0.025550967,
   0.030122586,
   0.033504331,
   0.035445705,
   0.035884078,
   0.034819454,
   0.032314457,
   0.028494339,
   0.023484345,
   0.017472352,
   0.010771486,
  0.0036322451,
   -0.00369487,
  -0.010896736,
  -0.017597602,
   -0.02367222,
  -0.028744837,
  -0.032627583,
  -0.035257828,
  -0.036447702,
  -0.036197204,
  -0.034506331,
  -0.031437709,
  -0.027116589,
  -0.021730848,
  -0.015593605,
 -0.0087674889,
 -0.0016908729,
   0.005385743,
   0.012211859,
   0.018474351,
   0.023922719,
   0.028369088,
   0.031562958,
   0.033441708,
   0.033942705,
   0.033003333,
   0.030748835,
   0.027179215,
   0.022482347,
   0.016846103,
   0.010520986,
  0.0037574954,
 -0.0031312457,
 -0.0099573624,
  -0.016345104,
  -0.022106596,
  -0.026928716,
  -0.030686209,
  -0.033253832,
  -0.034381079,
   -0.03425583,
  -0.032690208,
  -0.029872087,
  -0.025864093,
  -0.020791473,
  -0.014967356,
  -0.008642239,
 -0.0019413726,
  0.0047594937,
    0.01120986,
   0.017159228,
   0.022357095,
   0.026552966,
   0.029684212,
   0.031562958,
   0.032063959,
   0.031249834,
   0.029183211,
   0.025801467,
   0.021480347,
   0.016157229,
   0.010207862,
  0.0038827448,
 -0.0026302468,
 -0.0090806135,
   -0.01515523,
  -0.020603599,
  -0.025237842,
  -0.028807463,
  -0.031249834,
  -0.032439707,
  -0.032314457,
  -0.030936711,
  -0.028306462,
  -0.024548969,
  -0.019852099,
  -0.014403732,
 -0.0084543643,
 -0.0021292474,
  0.0041958694,
   0.010270487,
   0.015906729,
   0.020854099,
   0.024862094,
   0.027868088,
   0.029684212,
   0.030247835,
   0.029496336,
    0.02761759,
   0.024548969,
   0.020415724,
   0.015468355,
  0.0099573624,
  0.0039453697,
 -0.0021918723,
 -0.0082664895,
  -0.013965357,
  -0.019163225,
  -0.023546969,
   -0.02699134,
  -0.029371087,
  -0.030498337,
  -0.030498337,
  -0.029245838,
  -0.026803465,
   -0.02329647,
  -0.018975351,
  -0.013840107,
 -0.0082038641,
 -0.0023171222,
  0.0036322451,
  0.0093937377,
   0.014716856,
   0.019413725,
   0.023233844,
   0.026051966,
   0.027868088,
   0.028431713,
   0.027805465,
   0.026051966,
   0.023233844,
   0.019413725,
   0.014842106,
  0.0095816129,
  0.0040079947,
 -0.0017534979,
 -0.0075149904,
  -0.012900733,
  -0.017785477,
  -0.021918721,
  -0.025237842,
  -0.027492339,
  -0.028619588,
  -0.028619588,
  -0.027492339,
  -0.025300468,
  -0.022106596,
  -0.017973352,
  -0.013213858,
 -0.0080159898,
 -0.0024423716,
  0.0031312457,
  0.0085796136,
   0.013589608,
   0.017973352,
   0.021668222,
   0.024361094,
   0.026051966,
   0.026678215,
   0.026177217,
   0.024548969,
   0.021918721,
   0.018411726,
   0.014090607,
  0.0092684883,
  0.0040079947,
 -0.0013777483,
 -0.0067634913,
   -0.01183611,
  -0.016407729,
  -0.020353099,
  -0.023484345,
  -0.025676217,
  -0.026803465,
   -0.02686609,
  -0.025864093,
   -0.02379747,
  -0.020854099,
  -0.017033978,
  -0.012650234,
 -0.0077028652,
 -0.0025676219,
  0.0026928717,
  0.0077654901,
   0.012524984,
   0.016658228,
   0.020102599,
   0.022732846,
   0.024361094,
   0.024924718,
   0.024486343,
   0.023045972,
   0.020666223,
   0.017409727,
   0.013401733,
  0.0088927387,
  0.0040079947,
 -0.0010646237,
 -0.0060746172,
  -0.010834111,
   -0.01515523,
  -0.018850101,
  -0.021793472,
  -0.023860093,
  -0.024987344,
  -0.025112593,
  -0.024173219,
  -0.022357095,
    -0.0196016,
  -0.016094605,
   -0.01196136,
 -0.0074523655,
 -0.0026302468,
  0.0023171222,
   0.007013991,
    0.01146036,
    0.01540573,
   0.018599601,
   0.021104598,
    0.02267022,
   0.023233844,
   0.022920721,
   0.021605596,
   0.019413725,
   0.016407729,
   0.012712859,
  0.0085169892,
  0.0039453697,
-0.00075149909,
 -0.0054483679,
 -0.0098947375,
  -0.013902732,
  -0.017409727,
  -0.020165224,
  -0.022169222,
  -0.023233844,
  -0.023359096,
  -0.022544971,
  -0.020916723,
  -0.018349101,
   -0.01515523,
   -0.01133511,
 -0.0071392409,
 -0.0026302468,
  0.0019413726,
  0.0063251168,
   0.010458361,
   0.014153232,
   0.017221853,
   0.019538975,
   0.020979349,
   0.021605596,
   0.021355097,
   0.020165224,
   0.018161227,
    0.01540573,
    0.01196136,
  0.0081412396,
  0.0038827448,
-0.00043837447,
 -0.0048221187,
 -0.0089553632,
  -0.012712859,
  -0.015969354,
  -0.018599601,
  -0.020478349,
  -0.021480347,
  -0.021668222,
  -0.020979349,
   -0.01947635,
  -0.017159228,
  -0.014215857,
  -0.010708862,
 -0.0067634913,
 -0.0026302468,
  0.0015656231,
  0.0056988676,
   0.009518988,
   0.012963358,
    0.01578148,
   0.017973352,
   0.019413725,
   0.019977349,
   0.019789475,
   0.018724851,
   0.016908729,
   0.014341107,
   0.011272485,
  0.0077028652,
  0.0038201204,
 -0.0002504997,
 -0.0042584944,
 -0.0080786147,
   -0.01158561,
  -0.014654231,
  -0.017096603,
  -0.018850101,
  -0.019852099,
  -0.020039974,
  -0.019413725,
  -0.018035977,
  -0.015969354,
  -0.013213858,
  -0.010019987,
 -0.0064503667,
 -0.0026302468,
  0.0012524985,
  0.0050726184,
   0.008642239,
   0.011773485,
   0.014466356,
   0.016470354,
   0.017848102,
   0.018411726,
   0.018223851,
   0.017284478,
    0.01565623,
   0.013339108,
   0.010520986,
  0.0072644907,
    0.00369487,
             0,
   -0.00369487,
 -0.0072644907,
  -0.010520986,
  -0.013339108,
  -0.015593605,
  -0.017221853,
  -0.018161227,
  -0.018411726,
  -0.017848102,
  -0.016658228,
  -0.014716856,
  -0.012274484,
 -0.0093311127,
 -0.0060746172,
 -0.0025676219,
  0.0010019988,
  0.0045089941,
  0.0077654901,
   0.010708862,
   0.013151233,
   0.015029981,
   0.016282479,
   0.016846103,
   0.016720853,
   0.015906729,
   0.014403732,
   0.012337109,
  0.0097694872,
  0.0067634913,
  0.0035069953,
 0.00012524985,
 -0.0032564956,
 -0.0065129916,
 -0.0094563626,
  -0.012086609,
  -0.014153232,
   -0.01565623,
  -0.016532979,
  -0.016783478,
  -0.016345104,
  -0.015217855,
  -0.013526983,
   -0.01133511,
  -0.008642239,
 -0.0056988676,
  -0.002504997,
 0.00075149909,
  0.0039453697,
  0.0069513661,
  0.0095816129,
    0.01183611,
   0.013589608,
   0.014779481,
   0.015343105,
   0.015217855,
   0.014528981,
   0.013151233,
    0.01133511,
  0.0090179881,
  0.0063251168,
  0.0033817459,
 0.00031312462,
 -0.0028181211,
 -0.0057614925,
 -0.0084543643,
  -0.010834111,
  -0.012775484,
  -0.014153232,
  -0.014967356,
  -0.015217855,
  -0.014842106,
  -0.013840107,
  -0.012337109,
  -0.010333112,
 -0.0079533649,
 -0.0052604931,
 -0.0023797466,
 0.00056362431,
  0.0034443708,
  0.0061372421,
  0.0085796136,
   0.010646236,
   0.012211859,
   0.013276483,
   0.013840107,
   0.013777482,
   0.013151233,
    0.01196136,
   0.010270487,
  0.0082038641,
  0.0058241175,
  0.0031312457,
 0.00037574954,
 -0.0023797466,
 -0.0050726184,
 -0.0075149904,
 -0.0096442373,
  -0.011397735,
  -0.012650234,
  -0.013401733,
  -0.013652232,
  -0.013339108,
  -0.012462359,
  -0.011147236,
 -0.0093937377,
 -0.0072644907,
 -0.0048221187,
 -0.0022544973,
 0.00037574954,
  0.0029433714,
   0.005385743,
  0.0075776153,
  0.0094563626,
   0.010896736,
    0.01183611,
   0.012337109,
   0.012337109,
   0.011773485,
   0.010708862,
  0.0092684883,
  0.0074523655,
  0.0052604931,
  0.0029433714,
 0.00050099939,
 -0.0020039971,
 -0.0043837442,
 -0.0065756165,
 -0.0085169892,
  -0.010082612,
   -0.01120986,
  -0.011898735,
  -0.012149234,
   -0.01183611,
  -0.011147236,
 -0.0099573624,
 -0.0083917393,
 -0.0065129916,
 -0.0043837442,
 -0.0021292474,
 0.00018787477,
   0.002504997,
  0.0046342439,
  0.0066382415,
  0.0082664895,
  0.0095816129,
   0.010458361,
   0.010896736,
   0.010896736,
   0.010395736,
   0.009518988,
  0.0082038641,
  0.0066382415,
  0.0047594937,
  0.0026928717,
 0.00050099939,
  -0.001628248,
 -0.0037574954,
 -0.0056988676,
 -0.0073897406,
 -0.0087674889,
 -0.0097694872,
  -0.010395736,
  -0.010646236,
  -0.010395736,
 -0.0097694872,
 -0.0087674889,
 -0.0073897406,
 -0.0057614925,
 -0.0039453697,
 -0.0019413726,
 6.2624924e-05,
  0.0020666225,
  0.0039453697,
  0.0056988676,
  0.0071392409,
  0.0082664895,
  0.0090179881,
  0.0094563626,
  0.0094563626,
  0.0090806135,
  0.0082664895,
  0.0072018658,
  0.0058241175,
  0.0041958694,
  0.0023797466,
 0.00056362431,
 -0.0013151234,
 -0.0031312457,
 -0.0048221187,
 -0.0062624919,
 -0.0075149904,
 -0.0083917393,
 -0.0089553632,
 -0.0091432384,
 -0.0089553632,
 -0.0083917393,
 -0.0075776153,
 -0.0063877418,
 -0.0050099934,
 -0.0034443708,
 -0.0017534979,
             0,
  0.0016908729,
   0.003319121,
  0.0047594937,
  0.0060119922,
   0.007013991,
  0.0077028652,
  0.0080159898,
  0.0080159898,
  0.0077028652,
  0.0070766159,
  0.0061372421,
  0.0050099934,
  0.0036322451,
  0.0021292474,
 0.00056362431,
 -0.0010646237,
 -0.0025676219,
 -0.0040079947,
 -0.0052604931,
 -0.0062624919,
  -0.007013991,
 -0.0075149904,
 -0.0076402402,
 -0.0075149904,
 -0.0070766159,
 -0.0063877418,
  -0.005385743,
 -0.0042584944,
 -0.0029433714,
 -0.0015029982,
-6.2624924e-05,
  0.0013777483,
  0.0026928717,
  0.0039453697,
  0.0049473685,
  0.0057614925,
  0.0063251168,
  0.0066382415,
  0.0066382415,
  0.0063877418,
  0.0058867424,
  0.0051352433,
   0.004133245,
  0.0030059963,
  0.0018161228,
 0.00050099939,
-0.00081412401,
 -0.0020666225,
 -0.0031938707,
 -0.0041958694,
 -0.0050726184,
 -0.0056988676,
 -0.0060746172,
  -0.006199867,
 -0.0060746172,
 -0.0057614925,
 -0.0051352433,
 -0.0043837442,
 -0.0034443708,
 -0.0023797466,
 -0.0012524985,
-0.00012524985,
  0.0010019988,
  0.0021292474,
  0.0030686213,
  0.0038827448,
   0.004571619,
  0.0050099934,
  0.0052604931,
  0.0052604931,
  0.0050726184,
  0.0046342439,
  0.0040706196,
   0.003319121,
  0.0024423716,
  0.0014403732,
 0.00043837447,
-0.00056362431,
 -0.0015656231,
 -0.0024423716,
 -0.0031938707,
 -0.0038827448,
 -0.0043211193,
 -0.0046342439,
 -0.0047594937,
 -0.0046342439,
 -0.0043837442,
 -0.0039453697,
 -0.0033817459,
 -0.0026302468,
 -0.0018787477,
 -0.0010019988,
-0.00012524985,
 0.00075149909,
  0.0015656231,
  0.0022544973,
  0.0028807465,
  0.0033817459,
    0.00369487,
  0.0038827448,
  0.0038827448,
    0.00369487,
  0.0033817459,
  0.0029433714,
  0.0024423716,
  0.0017534979,
  0.0010646237,
 0.00037574954,
-0.00037574954,
 -0.0010646237,
 -0.0016908729,
 -0.0022544973,
 -0.0026928717,
 -0.0030686213,
 -0.0032564956,
  -0.003319121,
 -0.0032564956,
 -0.0030686213,
 -0.0027554962,
 -0.0023171222,
 -0.0018161228,
 -0.0013151234,
-0.00068887416,
-0.00012524985,
 0.00043837447,
  0.0010019988,
  0.0015029982,
  0.0018787477,
  0.0021918723,
  0.0023797466,
   0.002504997,
   0.002504997,
  0.0023797466,
  0.0021918723,
  0.0018787477,
  0.0015029982,
  0.0011272486,
 0.00068887416,
  0.0002504997,
-0.00018787477,
-0.00062624924,
 -0.0010019988,
 -0.0013151234,
 -0.0015656231,
 -0.0017534979,
 -0.0018787477,
 -0.0018787477,
 -0.0018161228,
 -0.0016908729,
 -0.0015029982,
 -0.0012524985,
 -0.0010019988,
-0.00068887416,
-0.00037574954,
-6.2624924e-05,
  0.0002504997,
 0.00050099939,
 0.00068887416,
 0.00087674893,
  0.0010019988,
  0.0011272486,
  0.0011272486,
  0.0011272486,
  0.0010646237,
 0.00093937386,
 0.00081412401,
 0.00062624924,
 0.00043837447,
  0.0002504997,
 0.00012524985,
-6.2624924e-05,
-0.00018787477,
-0.00031312462,
-0.00037574954,
-0.00043837447,
-0.00050099939,
-0.00050099939,
-0.00043837447,
-0.00043837447,
-0.00037574954,
 -0.0002504997,
-0.00018787477,
-0.00012524985,
-6.2624924e-05,
             0,
             0,
             0,
             0,
             0,
             0,
             0,
             0,
             0,
             0,
             0,
             0,
             0,

};

const framecnt_t Session::default_click_emphasis_length = sizeof (default_click_emphasis) / sizeof (default_click_emphasis[0]);

const Sample Session::default_click[] = {

              0,
   -0.029544597,
   -0.068916394,
    0.039560782,
    0.087814858,
     0.18545692,
     0.17052713,
     0.28713064,
     0.35579506,
      0.3971197,
     0.43529459,
     0.45904366,
      0.4771232,
     0.48140684,
     0.47643024,
     0.45872868,
     0.43233384,
     0.39522986,
     0.35018852,
      0.2962649,
     0.23635677,
     0.17027515,
     0.10179972,
    0.029040639,
   -0.042332556,
     -0.1155326,
    -0.18419702,
    -0.25015265,
    -0.31037576,
    -0.36411038,
    -0.41041162,
    -0.44795657,
    -0.47605229,
    -0.49369085,
    -0.50118723,
    -0.49835247,
    -0.48474557,
    -0.46150047,
    -0.42823918,
    -0.38603261,
    -0.33664462,
    -0.27988624,
    -0.21802527,
    -0.15181765,
   -0.082775268,
   -0.012724965,
    0.057010363,
     0.12466686,
     0.18948859,
     0.24920773,
     0.30313135,
     0.34987355,
     0.38817444,
       0.417908,
      0.4378774,
     0.44783057,
     0.44776759,
     0.43743642,
     0.41727807,
     0.38779646,
     0.34974755,
     0.30357231,
     0.25071961,
     0.19226036,
     0.12926549,
    0.063624825,
  -0.0037796926,
   -0.071310199,
    -0.13720284,
     -0.2003867,
    -0.25934991,
    -0.31283255,
    -0.35963774,
    -0.39894655,
    -0.42962505,
     -0.4512953,
     -0.4635793,
    -0.46584711,
     -0.4584767,
    -0.44159408,
    -0.41532521,
    -0.38061505,
     -0.3381565,
    -0.28870552,
      -0.233585,
    -0.17399185,
    -0.11099697,
   -0.046301234,
    0.018772473,
    0.083090243,
     0.14488822,
      0.2029065,
     0.25613716,
     0.30313135,
      0.3430071,
     0.37507149,
     0.39844259,
     0.41255345,
     0.41759305,
      0.4129944,
     0.39900955,
     0.37633139,
     0.34495995,
     0.30590312,
     0.26016884,
     0.20838705,
     0.15194364,
    0.092161504,
    0.030174545,
   -0.032631345,
   -0.094681299,
     -0.1549674,
    -0.21204076,
    -0.26445249,
    -0.31138368,
     -0.3517634,
    -0.38452073,
    -0.40927772,
    -0.42527841,
    -0.43227084,
    -0.43031801,
     -0.4192939,
    -0.39938753,
    -0.37135479,
    -0.33563671,
    -0.29292618,
    -0.24454611,
    -0.19125244,
    -0.13417909,
   -0.074900907,
   -0.014425827,
    0.045923264,
      0.1045715,
     0.16051095,
     0.21254472,
     0.25928691,
     0.29998161,
     0.33380986,
     0.35976374,
      0.3775283,
     0.38678854,
     0.38716652,
     0.37885118,
     0.36209455,
     0.33708558,
     0.30458023,
     0.26533442,
      0.2199781,
     0.16977119,
     0.11578458,
      0.0590262,
  0.00094492314,
   -0.057199348,
     -0.1143987,
    -0.16907825,
     -0.2201671,
    -0.26678329,
    -0.30760397,
     -0.3418732,
    -0.36902398,
    -0.38830042,
    -0.39926153,
    -0.40197031,
    -0.39611178,
    -0.38200092,
    -0.36001572,
    -0.33047111,
    -0.29406007,
     -0.2519165,
    -0.20460736,
    -0.15320354,
   -0.099153935,
   -0.043214486,
    0.013165929,
    0.068601421,
     0.12227305,
     0.17279495,
     0.21897019,
     0.26010584,
     0.29506801,
     0.32316372,
     0.34395203,
     0.35686597,
     0.36159059,
     0.35825187,
      0.3468498,
     0.32751037,
     0.30098952,
     0.26766523,
     0.22829343,
     0.18388205,
     0.13531299,
    0.083531207,
    0.030048557,
   -0.024316022,
   -0.078365626,
    -0.13065137,
    -0.18029134,
    -0.22621459,
    -0.26716127,
     -0.3025014,
    -0.33154203,
    -0.35333827,
    -0.36776409,
    -0.37456754,
    -0.37324464,
    -0.36417338,
    -0.34754274,
    -0.32354168,
    -0.29298918,
    -0.25651514,
    -0.21468655,
    -0.16863729,
    -0.11950128,
   -0.067971472,
    -0.01549674,
    0.036726013,
    0.087940848,
     0.13663589,
      0.1819292,
     0.22300187,
     0.25865697,
     0.28832756,
     0.31144668,
     0.32738436,
     0.33576269,
     0.33670763,
     0.32990417,
     0.31573032,
     0.29462703,
     0.26672032,
     0.23289207,
     0.19396122,
     0.15062075,
     0.10387855,
    0.054868538,
   0.0044726362,
   -0.046175245,
   -0.095689217,
    -0.14337634,
    -0.18803971,
     -0.2285454,
    -0.26438951,
    -0.29456405,
    -0.31831311,
    -0.33551071,
    -0.34558988,
    -0.34817267,
    -0.34363705,
    -0.33185701,
    -0.31302155,
    -0.28788658,
    -0.25676712,
    -0.22035608,
    -0.17966139,
    -0.13537599,
     -0.0885078,
   -0.040253725,
   0.0085043083,
    0.056758384,
     0.10312261,
     0.14703004,
     0.18734676,
     0.22300187,
     0.25355437,
     0.27831136,
     0.29651688,
     0.30804495,
     0.31264357,
     0.30999778,
     0.30048557,
     0.28429588,
     0.26161772,
     0.23314404,
     0.19956777,
     0.16132988,
     0.11962727,
    0.075341871,
    0.029103633,
   -0.017638566,
   -0.064128785,
    -0.10935911,
    -0.15219562,
     -0.1917564,
    -0.22734851,
    -0.25802701,
    -0.28316196,
    -0.30237542,
    -0.31510038,
    -0.32114787,
    -0.32051794,
    -0.31302155,
    -0.29903667,
    -0.27887832,
    -0.25292444,
    -0.22174198,
    -0.18627585,
    -0.14696705,
    -0.10482347,
   -0.060916046,
   -0.016000698,
    0.028914647,
    0.072633093,
     0.11452469,
     0.15358151,
     0.18873265,
     0.21960014,
     0.24523905,
     0.26520842,
      0.2791933,
     0.28675269,
      0.2877606,
     0.28240603,
     0.27068898,
     0.25279844,
     0.22942734,
     0.20089066,
     0.16775536,
     0.13109234,
    0.091405566,
    0.049576968,
   0.0068034464,
   -0.036285049,
   -0.078680601,
     -0.1192493,
     -0.1573612,
    -0.19219737,
    -0.22274989,
    -0.24864078,
     -0.2693031,
     -0.2841069,
    -0.29292618,
    -0.29563495,
    -0.29191826,
    -0.28228005,
    -0.26672032,
    -0.24555403,
    -0.21941114,
    -0.18885864,
    -0.15440044,
    -0.11704448,
   -0.077483698,
   -0.036537027,
   0.0047246157,
      0.0454823,
    0.085043082,
     0.12227305,
     0.15647927,
     0.18703179,
     0.21311167,
     0.23421496,
     0.25002667,
     0.25997984,
     0.26413753,
     0.26237365,
     0.25462529,
     0.24114439,
     0.22237191,
     0.19855985,
     0.17033814,
     0.13846274,
     0.10337459,
     0.06601863,
    0.027339777,
   -0.012158011,
    -0.05140382,
   -0.089452724,
    -0.12567478,
    -0.15925105,
    -0.18923661,
    -0.21531648,
    -0.23679775,
    -0.25311342,
    -0.26420051,
    -0.26961806,
     -0.2692401,
    -0.26338157,
     -0.2519165,
    -0.23515988,
    -0.21367861,
    -0.18778773,
    -0.15805415,
    -0.12529681,
   -0.090082674,
   -0.053230672,
   -0.015622729,
    0.021985213,
    0.058837214,
    0.093988357,
     0.12680869,
     0.15654227,
     0.18249616,
     0.20429238,
       0.221301,
     0.23320702,
     0.23988449,
     0.24114439,
     0.23679775,
     0.22728551,
     0.21273369,
     0.19333127,
      0.1697082,
     0.14236842,
     0.11175291,
    0.078743597,
    0.044033418,
   0.0082523287,
   -0.027654751,
   -0.062994876,
   -0.097075104,
    -0.12895051,
    -0.15805415,
    -0.18388205,
    -0.20561528,
    -0.22300187,
    -0.23572683,
     -0.2433492,
    -0.24580601,
    -0.24316022,
    -0.23528585,
    -0.22256089,
     -0.2053003,
    -0.18375605,
    -0.15843211,
    -0.13008442,
   -0.099027946,
   -0.066207616,
   -0.032316373,
   0.0020788312,
     0.03603307,
      0.0688534,
    0.099972868,
     0.12857254,
     0.15402247,
     0.17594469,
     0.19377224,
     0.20706416,
     0.21569446,
     0.21941114,
     0.21808827,
     0.21204076,
     0.20114264,
     0.18577189,
     0.16630647,
     0.14318735,
      0.1167925,
    0.088003844,
    0.057136352,
    0.025008967,
  -0.0076223798,
   -0.040064742,
   -0.071751163,
    -0.10179972,
    -0.12970645,
    -0.15484141,
    -0.17651164,
    -0.19452818,
    -0.20838705,
    -0.21764729,
    -0.22243491,
    -0.22249791,
    -0.21783629,
    -0.20863903,
    -0.19509513,
    -0.17745657,
    -0.15629029,
    -0.13197427,
    -0.10494946,
   -0.076034816,
   -0.045671286,
   -0.014614811,
    0.016441663,
    0.046868188,
     0.07609781,
      0.1032486,
     0.12794259,
     0.14961283,
     0.16775536,
      0.1819922,
     0.19219737,
     0.19786691,
      0.1991268,
     0.19597706,
     0.18835468,
     0.17651164,
     0.16082592,
     0.14148649,
     0.11906032,
    0.094114346,
    0.066963554,
     0.03836388,
   0.0090082674,
    -0.02066232,
   -0.049891942,
   -0.077924662,
    -0.10438251,
    -0.12857254,
    -0.14992781,
    -0.16813332,
    -0.18268514,
    -0.19333127,
    -0.19994574,
    -0.20221355,
    -0.20026071,
    -0.19408721,
    -0.18388205,
    -0.16983419,
    -0.15232161,
    -0.13172229,
    -0.10841418,
   -0.083090243,
   -0.056128435,
   -0.028158709,
              0,
    0.028032719,
    0.055183511,
    0.080822427,
      0.1045085,
     0.12573777,
      0.1438803,
     0.15881008,
     0.17002317,
     0.17733058,
     0.18066931,
     0.17991337,
     0.17506276,
     0.16643246,
     0.15402247,
     0.13814776,
      0.1193123,
    0.097831043,
    0.074081975,
    0.048821029,
     0.02248917,
  -0.0044096415,
   -0.031182464,
   -0.057262343,
   -0.082208313,
    -0.10526444,
    -0.12611574,
    -0.14425827,
    -0.15925105,
     -0.1708421,
    -0.17890545,
    -0.18306311,
    -0.18331509,
    -0.17978738,
    -0.17241698,
    -0.16151886,
    -0.14728202,
    -0.12995843,
    -0.11005205,
   -0.088003844,
   -0.064128785,
   -0.039182814,
   -0.013606893,
    0.012032021,
    0.037229973,
    0.061294015,
    0.083909175,
      0.1045085,
     0.12252503,
     0.13776979,
     0.14980182,
     0.15836912,
     0.16340871,
     0.16466861,
      0.1622748,
     0.15629029,
     0.14677806,
     0.13392711,
     0.11824138,
    0.099909874,
    0.079310549,
    0.057010363,
    0.033450279,
   0.0090712621,
   -0.015433745,
   -0.039623778,
   -0.063057872,
   -0.084980088,
    -0.10520144,
    -0.12315498,
    -0.13839974,
    -0.15068374,
      -0.159881,
    -0.16548754,
    -0.16769236,
    -0.16636947,
    -0.16145587,
    -0.15326654,
    -0.14186446,
    -0.12750163,
    -0.11055601,
   -0.091405566,
   -0.070365278,
   -0.048065091,
   -0.024945971,
  -0.0013858872,
    0.021985213,
    0.044600371,
    0.066144621,
    0.086051002,
     0.10381556,
      0.1192493,
     0.13191127,
     0.14148649,
     0.14791197,
     0.15093572,
     0.15055776,
     0.14690405,
     0.13984862,
     0.12970645,
      0.1167295,
     0.10110678,
    0.083216233,
    0.063561829,
    0.042458548,
    0.020347345,
  -0.0021418259,
   -0.024630997,
   -0.046679202,
   -0.067593501,
   -0.087184909,
    -0.10488647,
    -0.12032021,
    -0.13323416,
    -0.14325035,
    -0.15024278,
    -0.15408547,
    -0.15458943,
    -0.15181765,
    -0.14595913,
    -0.13701385,
    -0.12517082,
    -0.11080799,
   -0.094114346,
   -0.075530857,
   -0.055561481,
   -0.034458197,
    -0.01278796,
   0.0089452728,
    0.030363531,
    0.050962856,
    0.070239288,
    0.087877851,
     0.10343759,
     0.11654052,
     0.12706067,
     0.13468305,
     0.13915568,
     0.14060456,
     0.13884071,
     0.13392711,
     0.12605275,
     0.11540661,
     0.10211469,
    0.086617955,
    0.069168374,
    0.050143922,
    0.030048557,
    0.009260247,
   -0.011780042,
   -0.032568351,
   -0.052663716,
   -0.071751163,
   -0.089200746,
    -0.10476048,
    -0.11817839,
    -0.12895051,
    -0.13701385,
    -0.14224243,
    -0.14432126,
    -0.14343933,
    -0.13953365,
    -0.13260421,
    -0.12302899,
    -0.11087098,
   -0.096382162,
   -0.079940499,
   -0.061923963,
   -0.042710526,
   -0.022741151,
  -0.0023938054,
     0.01782755,
    0.037544948,
    0.056254424,
    0.073641011,
     0.08926374,
     0.10274464,
     0.11389474,
     0.12246204,
     0.12819457,
     0.13115533,
     0.13102934,
     0.12800559,
     0.12214707,
     0.11351677,
     0.10236667,
     0.08901176,
    0.073641011,
    0.056569399,
    0.038300886,
    0.019087447,
 -0.00050395913,
   -0.020095366,
   -0.039308804,
   -0.057703308,
   -0.074837913,
   -0.090397649,
    -0.10406754,
    -0.11546961,
    -0.12441488,
    -0.13071437,
    -0.13424208,
    -0.13493502,
     -0.1327302,
    -0.12775361,
    -0.12013123,
    -0.10998905,
   -0.097516069,
   -0.083153237,
   -0.067026549,
   -0.049576968,
    -0.03124546,
   -0.012346996,
   0.0067404518,
    0.025449931,
    0.043529459,
    0.060538077,
    0.076034816,
    0.089767699,
     0.10142175,
     0.11074499,
     0.11754844,
      0.1217061,
     0.12309199,
      0.1217691,
     0.11767443,
     0.11093398,
     0.10179972,
    0.090334652,
    0.076853748,
    0.061671984,
    0.045167327,
    0.027591756,
   0.0093862368,
  -0.0090082674,
    -0.02727678,
   -0.044915347,
   -0.061671984,
    -0.07710573,
   -0.090838613,
    -0.10268165,
    -0.11231986,
    -0.11956427,
     -0.1242259,
    -0.12630473,
    -0.12573777,
    -0.12239904,
    -0.11660352,
    -0.10828819,
   -0.097768047,
   -0.085232068,
   -0.070932231,
   -0.055183511,
   -0.038426876,
   -0.020914299,
   -0.003086749,
    0.014614811,
    0.032001398,
    0.048506055,
    0.063750815,
    0.077609687,
     0.08964171,
    0.099531904,
     0.10721728,
     0.11244585,
     0.11515463,
     0.11528062,
     0.11282382,
     0.10778423,
     0.10041383,
    0.090775617,
    0.079121565,
    0.065703656,
    0.050836866,
    0.034773172,
    0.018016535,
  0.00081893336,
   -0.016441663,
    -0.03332429,
   -0.049576968,
   -0.064758732,
   -0.078491615,
   -0.090649627,
     -0.1007918,
    -0.10879215,
    -0.11452469,
    -0.11780042,
    -0.11855636,
     -0.1167925,
    -0.11263484,
    -0.10602038,
    -0.09726409,
   -0.086491966,
    -0.07389299,
   -0.059782139,
   -0.044537378,
    -0.02841069,
   -0.011780042,
   0.0049136002,
    0.021481253,
    0.037418955,
    0.052411737,
    0.066207616,
    0.078428622,
    0.088822776,
    0.097201094,
      0.1033116,
     0.10715428,
     0.10854017,
     0.10753225,
     0.10406754,
    0.098335001,
    0.090397649,
    0.080381463,
    0.068664415,
    0.055372497,
    0.040820681,
    0.025449931,
   0.0094492314,
  -0.0068034464,
   -0.022930134,
   -0.038552864,
   -0.053419654,
   -0.067089544,
   -0.079310549,
   -0.089893688,
   -0.098523987,
    -0.10507545,
     -0.1094221,
    -0.11137494,
    -0.11099697,
    -0.10828819,
     -0.1032486,
   -0.096067187,
   -0.086932929,
   -0.075908827,
    -0.06343584,
   -0.049639964,
   -0.034836167,
   -0.019465417,
  -0.0037166979,
    0.012032021,
    0.027339777,
    0.041954588,
    0.055561481,
    0.067845483,
    0.078554611,
    0.087499883,
    0.094429321,
    0.099153935,
     0.10173673,
      0.1019887,
    0.099909874,
    0.095689217,
     0.08926374,
    0.080885421,
    0.070680252,
    0.058900211,
     0.04586027,
    0.031749417,
    0.016945622,
   0.0017008614,
   -0.013543898,
   -0.028536679,
   -0.042962505,
   -0.056443409,
   -0.068727411,
   -0.079562529,
    -0.08863379,
   -0.095941196,
    -0.10110678,
    -0.10413053,
    -0.10494946,
    -0.10356358,
   -0.099972868,
   -0.094303329,
   -0.086680951,
   -0.077168724,
   -0.066207616,
   -0.053797625,
   -0.040316721,
   -0.026079878,
   -0.011402072,
   0.0034647183,
    0.018142524,
    0.032316373,
    0.045671286,
    0.057955286,
      0.0688534,
    0.078239636,
    0.085736027,
     0.09134257,
    0.094870285,
     0.09625617,
    0.095500232,
    0.092602468,
    0.087562879,
    0.080696438,
    0.071940149,
    0.061608988,
    0.049954936,
    0.037166977,
     0.02349709,
   0.0093232417,
  -0.0051025851,
   -0.019402422,
    -0.03332429,
    -0.04649022,
   -0.058774218,
   -0.069672332,
   -0.079184561,
   -0.086995923,
   -0.092917444,
    -0.09688612,
   -0.098775965,
   -0.098586983,
    -0.09625617,
    -0.09197252,
   -0.085736027,
   -0.077672683,
   -0.068097461,
   -0.057010363,
   -0.044852353,
   -0.031812413,
    -0.01807953,
  -0.0041576619,
   0.0098272008,
     0.02349709,
    0.036537027,
    0.048695039,
    0.059719143,
    0.069294364,
    0.077357708,
    0.083657197,
    0.088003844,
    0.090397649,
    0.090775617,
    0.089074754,
    0.085421052,
    0.079877503,
    0.072507102,
    0.063561829,
    0.053167676,
    0.041639613,
    0.029103633,
    0.016000698,
   0.0024568001,
   -0.011087098,
   -0.024442011,
   -0.037292966,
   -0.049387982,
   -0.060349091,
   -0.070113297,
   -0.078365626,
   -0.084854099,
    -0.08964171,
    -0.09247648,
   -0.093295412,
   -0.092224498,
    -0.08913775,
    -0.08422415,
   -0.077546694,
   -0.069231368,
   -0.059467164,
   -0.048506055,
   -0.036600023,
   -0.023938054,
   -0.010898114,
   0.0023308103,
    0.015433745,
    0.028032719,
    0.040001746,
    0.051025849,
     0.06085305,
    0.069231368,
     0.07609781,
    0.081137402,
    0.084413135,
    0.085799021,
    0.085232068,
    0.082775268,
    0.078491615,
    0.072381112,
    0.064695739,
    0.055624475,
    0.045293317,
    0.033891243,
    0.021859223,
   0.0091972519,
  -0.0035907081,
   -0.016378668,
   -0.028788658,
   -0.040631695,
   -0.051529809,
   -0.061420005,
   -0.069987306,
   -0.076979738,
   -0.082397298,
   -0.086051002,
   -0.087877851,
   -0.087814858,
   -0.085925012,
   -0.082145319,
   -0.076727759,
   -0.069672332,
   -0.061168024,
    -0.05140382,
   -0.040631695,
   -0.028977643,
   -0.016882627,
  -0.0044096415,
   0.0080633443,
    0.020221355,
    0.031938402,
    0.042836516,
    0.052663716,
     0.06135701,
    0.068601421,
    0.074333954,
    0.078365626,
    0.080570446,
     0.08101141,
    0.079625525,
     0.07647578,
    0.071625174,
    0.065199696,
    0.057262343,
    0.048128087,
    0.037859919,
    0.026772824,
     0.01511877,
    0.003086749,
  -0.0090082674,
   -0.020977295,
   -0.032442362,
    -0.04327748,
   -0.053167676,
   -0.061860969,
   -0.069294364,
   -0.075278877,
   -0.079562529,
   -0.082208313,
   -0.083153237,
   -0.082208313,
   -0.079625525,
   -0.075341871,
   -0.069420354,
   -0.062112948,
   -0.053545644,
   -0.043844433,
   -0.033261294,
   -0.022048206,
   -0.010394155,
   0.0013858872,
     0.01303994,
    0.024379018,
    0.035088146,
    0.044915347,
    0.053734629,
     0.06135701,
    0.067467513,
    0.072129134,
    0.075152888,
     0.07647578,
     0.07609781,
    0.074018979,
    0.070239288,
    0.064947717,
    0.058207266,
    0.050143922,
    0.041009664,
    0.030930484,
    0.020221355,
   0.0090082674,
  -0.0024568001,
   -0.013795878,
   -0.024882975,
   -0.035466115,
   -0.045293317,
     -0.0541126,
   -0.061797974,
   -0.068160457,
   -0.073074058,
   -0.076412784,
   -0.078113647,
   -0.078176641,
    -0.07660177,
   -0.073389032,
   -0.068601421,
   -0.062427922,
   -0.054931532,
   -0.046301234,
   -0.036726013,
   -0.026457848,
   -0.015622729,
  -0.0045986259,
   0.0064884722,
    0.017386586,
    0.027780741,
    0.037544948,
    0.046427224,
    0.054175593,
     0.06072706,
    0.065892642,
    0.069546342,
    0.071688169,
    0.072192129,
    0.071058221,
     0.06834944,
    0.064128785,
    0.058459244,
    0.051466813,
    0.043403469,
    0.034332208,
    0.024505007,
    0.014173847,
   0.0034647183,
  -0.0073074056,
   -0.017890545,
   -0.028158709,
   -0.037796926,
   -0.046679202,
   -0.054553564,
   -0.061168024,
   -0.066522588,
   -0.070491267,
   -0.072948066,
   -0.073829996,
   -0.073137051,
   -0.070932231,
   -0.067152537,
   -0.062049952,
   -0.055624475,
   -0.048065091,
   -0.039497787,
    -0.03011155,
   -0.020158361,
  -0.0098901954,
  0.00062994892,
    0.011024103,
    0.021040289,
     0.03061551,
    0.039434792,
    0.047309152,
      0.0541126,
    0.059719143,
    0.063876805,
    0.066711573,
    0.067971472,
    0.067719491,
    0.065955635,
    0.062742897,
    0.058081276,
    0.052159759,
    0.045104332,
    0.037040987,
    0.028158709,
    0.018646483,
   0.0086932927,
  -0.0014488823,
   -0.011591057,
   -0.021481253,
   -0.030867489,
   -0.039623778,
    -0.04756113,
   -0.054427574,
   -0.060160107,
   -0.064569749,
   -0.067656497,
   -0.069231368,
   -0.069420354,
   -0.068034465,
   -0.065325688,
   -0.061168024,
   -0.055750466,
   -0.049136003,
   -0.041576619,
   -0.033135305,
   -0.024001047,
   -0.014488821,
  -0.0046616206,
   0.0051655797,
    0.014866791,
    0.024127037,
     0.03282033,
    0.040757685,
    0.047750116,
     0.05360864,
    0.058270262,
    0.061608988,
    0.063561829,
    0.064065789,
    0.063183861,
     0.06085305,
    0.057136352,
    0.052222752,
     0.04611225,
    0.038993828,
    0.031056474,
     0.02236318,
    0.013165929,
   0.0037166979,
  -0.0058585238,
    -0.01524476,
   -0.024379018,
   -0.033009315,
   -0.040883675,
   -0.047876105,
   -0.053860618,
   -0.058711225,
   -0.062301934,
   -0.064569749,
   -0.065388682,
   -0.064884722,
   -0.062994876,
   -0.059782139,
   -0.055309502,
   -0.049702957,
   -0.043025501,
   -0.035466115,
   -0.027213788,
   -0.018457499,
  -0.0093232417,
 -6.2958337e-05,
   0.0091972519,
    0.018142524,
    0.026646834,
    0.034521192,
    0.041576619,
    0.047624127,
    0.052663716,
    0.056443409,
    0.058963204,
    0.060223103,
    0.060097113,
    0.058585236,
    0.055813461,
    0.051781788,
    0.046616209,
    0.040379717,
     0.03332429,
    0.025449931,
    0.017071612,
   0.0083153234,
 -0.00069294358,
  -0.0096382163,
   -0.018394504,
   -0.026772824,
   -0.034584187,
   -0.041639613,
   -0.047813111,
   -0.052915697,
   -0.056884374,
   -0.059719143,
    -0.06123102,
   -0.061420005,
   -0.060349091,
   -0.057955286,
   -0.054364578,
   -0.049639964,
   -0.043844433,
   -0.037166977,
   -0.029796576,
   -0.021733231,
   -0.013291919,
  -0.0046616206,
   0.0040946668,
     0.01266197,
    0.020851303,
    0.028599673,
      0.0356551,
    0.041891592,
    0.047183163,
    0.051340824,
    0.054364578,
    0.056191431,
    0.056758384,
    0.056002445,
    0.054049604,
     0.05089986,
    0.046553213,
    0.041261645,
    0.035025151,
    0.027969726,
    0.020347345,
    0.012284001,
   0.0039056824,
  -0.0045356308,
    -0.01291395,
   -0.020977295,
   -0.028599673,
     -0.0356551,
   -0.041891592,
   -0.047246158,
   -0.051592803,
   -0.054805542,
   -0.056884374,
   -0.057703308,
   -0.057325338,
   -0.055750466,
   -0.052978691,
   -0.049073008,
   -0.044159407,
    -0.03836388,
   -0.031749417,
   -0.024442011,
   -0.016693642,
  -0.0086932927,
 -0.00044096401,
   0.0076853749,
    0.015559734,
    0.023119119,
     0.03011155,
    0.036411039,
    0.041828598,
    0.046301234,
    0.049765953,
    0.052096763,
    0.053167676,
    0.053167676,
    0.051907777,
    0.049513972,
    0.046049255,
    0.041576619,
    0.036096063,
    0.029922567,
    0.023056126,
    0.015622729,
   0.0078743594,
              0,
  -0.0079373545,
   -0.015685724,
   -0.023056126,
   -0.029985561,
   -0.036285049,
   -0.041765602,
    -0.04636423,
   -0.049954936,
   -0.052474733,
   -0.053923614,
   -0.054175593,
   -0.053230672,
   -0.051214834,
   -0.048128087,
   -0.044033418,
   -0.038993828,
   -0.033135305,
   -0.026646834,
   -0.019591406,
   -0.012158011,
  -0.0045356308,
   0.0031497437,
    0.010709129,
    0.018016535,
    0.024882975,
     0.03111947,
    0.036663017,
    0.041324638,
    0.045104332,
    0.047876105,
    0.049513972,
    0.050080928,
    0.049513972,
    0.047813111,
    0.045104332,
    0.041387634,
    0.036726013,
     0.03124546,
    0.025134956,
    0.018394504,
    0.011339078,
    0.003968677,
  -0.0034647183,
   -0.010835119,
   -0.018016535,
   -0.024756987,
   -0.030930484,
   -0.036537027,
   -0.041261645,
   -0.045167327,
   -0.048065091,
   -0.049954936,
    -0.05077387,
   -0.050521892,
      -0.049199,
   -0.046805194,
   -0.043403469,
   -0.039182814,
   -0.034080229,
   -0.028284701,
   -0.021922217,
    -0.01511877,
  -0.0080633443,
 -0.00088192802,
   0.0062994878,
    0.013291919,
    0.019969376,
    0.026142874,
    0.031686423,
    0.036537027,
    0.040505706,
    0.043592454,
    0.045671286,
    0.046742198,
    0.046805194,
    0.045734281,
    0.043718444,
    0.040694689,
    0.036789009,
    0.032127387,
    0.026646834,
     0.02066232,
    0.014173847,
   0.0074333954,
  0.00044096401,
  -0.0064884722,
   -0.013354914,
   -0.019843386,
   -0.025953889,
   -0.031497438,
   -0.036411039,
   -0.040442711,
    -0.04365545,
    -0.04598626,
   -0.047246158,
    -0.04756113,
   -0.046805194,
   -0.045104332,
   -0.042458548,
    -0.03886784,
   -0.034521192,
   -0.029418607,
   -0.023749068,
    -0.01757557,
   -0.011087098,
  -0.0044096415,
   0.0023938054,
   0.0090082674,
    0.015433745,
    0.021481253,
    0.026961806,
    0.031875408,
     0.03603307,
    0.039371797,
    0.041828598,
    0.043340476,
    0.043907429,
    0.043466465,
    0.042080577,
    0.039686772,
    0.036474034,
    0.032505355,
    0.027717745,
     0.02236318,
    0.016567653,
     0.01033116,
   0.0039056824,
  -0.0025827899,
  -0.0090712621,
    -0.01537075,
   -0.021292267,
   -0.026772824,
   -0.031686423,
    -0.03590708,
   -0.039371797,
   -0.041954588,
    -0.04365545,
   -0.044411389,
   -0.044222403,
   -0.043088494,
    -0.04107266,
   -0.038174894,
   -0.034521192,
    -0.03011155,
   -0.025071961,
   -0.019528412,
   -0.013606893,
  -0.0074333954,
  -0.0011339076,
   0.0051655797,
    0.011276083,
    0.017134606,
    0.022552166,
    0.027465766,
    0.031749417,
    0.035277132,
    0.037985912,
    0.039875756,
    0.040883675,
    0.040946669,
    0.040127735,
     0.03836388,
    0.035781089,
    0.032442362,
    0.028347694,
    0.023623079,
    0.018394504,
     0.01278796,
   0.0068664416,
  0.00081893336,
  -0.0052915695,
   -0.011213088,
   -0.016945622,
   -0.022300187,
   -0.027213788,
   -0.031497438,
   -0.035088146,
   -0.037922916,
   -0.040001746,
   -0.041198649,
   -0.041450628,
   -0.040883675,
   -0.039434792,
   -0.037166977,
   -0.034080229,
   -0.030363531,
   -0.025953889,
   -0.020977295,
   -0.015685724,
   -0.010016185,
  -0.0041576619,
   0.0017008614,
   0.0074963905,
    0.013102934,
    0.018394504,
    0.023245108,
    0.027528762,
    0.031182464,
    0.034206218,
    0.036348044,
     0.03773393,
     0.03823789,
    0.037922916,
    0.036726013,
    0.034773172,
    0.032001398,
    0.028536679,
    0.024442011,
    0.019843386,
    0.014740801,
   0.0093862368,
   0.0037796926,
  -0.0018898463,
  -0.0074963905,
   -0.012976944,
   -0.018142524,
   -0.022930134,
    -0.02727678,
   -0.030993478,
   -0.034017233,
   -0.036285049,
   -0.037859919,
   -0.038552864,
   -0.038426876,
   -0.037544948,
   -0.035781089,
    -0.03332429,
   -0.030174545,
   -0.026394852,
   -0.022048206,
   -0.017260596,
   -0.012095016,
  -0.0068034464,
  -0.0013228925,
   0.0041576619,
   0.0094492314,
    0.014551817,
    0.019276432,
    0.023560084,
     0.02727678,
    0.030426524,
     0.03282033,
    0.034521192,
     0.03540312,
     0.03552911,
    0.034836167,
    0.033387283,
    0.031182464,
    0.028347694,
    0.024819981,
    0.020788309,
    0.016252678,
    0.011402072,
   0.0062994878,
   0.0010709129,
  -0.0042206566,
  -0.0093862368,
   -0.014362832,
   -0.019024453,
   -0.023245108,
   -0.026961806,
    -0.03011155,
   -0.032631345,
   -0.034458197,
    -0.03552911,
   -0.035844085,
    -0.03540312,
   -0.034143222,
   -0.032253377,
   -0.029607593,
   -0.026394852,
   -0.022615161,
   -0.018394504,
   -0.013795878,
  -0.0089452728,
  -0.0039056824,
   0.0011969027,
    0.006173498,
    0.011024103,
    0.015622729,
    0.019843386,
    0.023560084,
    0.026772824,
    0.029355611,
    0.031308453,
    0.032505355,
    0.033009315,
    0.032757337,
    0.031812413,
     0.03011155,
    0.027780741,
    0.024819981,
    0.021355263,
    0.017386586,
     0.01303994,
   0.0083783185,
   0.0035907081,
  -0.0012598974,
  -0.0061105029,
   -0.010835119,
   -0.015307755,
   -0.019465417,
   -0.023182116,
   -0.026394852,
   -0.029040639,
   -0.031056474,
   -0.032442362,
   -0.033072311,
   -0.033009315,
   -0.032316373,
   -0.030867489,
   -0.028788658,
   -0.026079878,
    -0.02286714,
   -0.019150442,
   -0.015055775,
   -0.010646134,
  -0.0061105029,
  -0.0013858872,
   0.0032757334,
   0.0078743594,
    0.012221006,
    0.016315673,
    0.020032371,
    0.023245108,
    0.025953889,
    0.028095715,
    0.029544597,
    0.030363531,
     0.03048952,
    0.029922567,
    0.028725665,
    0.026898813,
    0.024442011,
    0.021481253,
     0.01807953,
    0.014236842,
     0.01007918,
    0.005732534,
   0.0012598974,
  -0.0032757334,
  -0.0076853749,
   -0.011969027,
   -0.016000698,
   -0.019591406,
    -0.02286714,
   -0.025575921,
   -0.027717745,
   -0.029355611,
   -0.030300535,
   -0.030552514,
   -0.030237542,
   -0.029229622,
   -0.027591756,
   -0.025449931,
   -0.022678155,
   -0.019528412,
   -0.015937704,
   -0.012032021,
  -0.0078743594,
  -0.0035907081,
  0.00075593824,
   0.0050395899,
   0.0091342572,
    0.013102934,
    0.016693642,
    0.019906381,
    0.022678155,
    0.024882975,
    0.026520842,
    0.027654751,
    0.028095715,
     0.02790673,
    0.027150792,
    0.025764904,
    0.023749068,
    0.021292267,
    0.018331509,
    0.014992781,
    0.011339078,
   0.0074333954,
   0.0033387286,
 -0.00081893336,
  -0.0049136002,
  -0.0089452728,
   -0.012724965,
   -0.016315673,
   -0.019465417,
   -0.022237191,
   -0.024505007,
   -0.026268864,
    -0.02740277,
   -0.028032719,
   -0.028032719,
    -0.02740277,
   -0.026205868,
   -0.024505007,
   -0.022237191,
   -0.019528412,
   -0.016441663,
   -0.012976944,
   -0.009260247,
  -0.0054175593,
  -0.0014488823,
   0.0025197952,
   0.0064254776,
    0.010142175,
    0.013606893,
    0.016693642,
    0.019465417,
    0.021796227,
    0.023560084,
    0.024882975,
    0.025575921,
    0.025701909,
     0.02532394,
    0.024316022,
    0.022804144,
    0.020788309,
    0.018268514,
    0.015433745,
    0.012221006,
   0.0086932927,
   0.0050395899,
   0.0012598974,
  -0.0025197952,
  -0.0062364927,
  -0.0098272008,
   -0.013228924,
   -0.016315673,
   -0.019024453,
   -0.021355263,
   -0.023245108,
   -0.024568001,
   -0.025386935,
   -0.025701909,
   -0.025386935,
   -0.024568001,
   -0.023245108,
   -0.021481253,
   -0.019213437,
   -0.016567653,
   -0.013543898,
   -0.010268165,
  -0.0068034464,
  -0.0032127388,
  0.00037796935,
    0.003968677,
   0.0074333954,
    0.010772124,
    0.013795878,
    0.016504658,
    0.018835468,
    0.020725315,
    0.022111202,
    0.023056126,
    0.023434094,
    0.023371098,
    0.022678155,
    0.021544249,
    0.019969376,
    0.017890545,
     0.01549674,
    0.012724965,
   0.0096382163,
   0.0064254776,
   0.0030237539,
 -0.00044096401,
  -0.0039056824,
  -0.0072444109,
   -0.010394155,
   -0.013354914,
   -0.016000698,
   -0.018331509,
    -0.02028435,
   -0.021733231,
   -0.022741151,
   -0.023245108,
   -0.023245108,
   -0.022804144,
   -0.021859223,
    -0.02041034,
   -0.018583489,
   -0.016315673,
   -0.013795878,
   -0.010898114,
  -0.0078743594,
  -0.0046616206,
  -0.0013858872,
   0.0018898463,
   0.0051025851,
   0.0081893341,
    0.011087098,
    0.013669888,
    0.016000698,
    0.017890545,
    0.019402422,
    0.020473335,
    0.021103284,
    0.021292267,
    0.020914299,
    0.020158361,
    0.018898463,
    0.017260596,
     0.01524476,
    0.012850955,
     0.01020517,
   0.0073704007,
   0.0043466464,
   0.0012598974,
  -0.0018268516,
  -0.0049136002,
  -0.0078743594,
   -0.010646134,
   -0.013228924,
    -0.01549674,
   -0.017386586,
   -0.018961458,
   -0.020095366,
   -0.020788309,
   -0.021040289,
   -0.020851303,
   -0.020221355,
   -0.019150442,
   -0.017638566,
   -0.015811714,
   -0.013669888,
   -0.011213088,
   -0.008567303,
   -0.005732534,
  -0.0028347694,
  0.00012591761,
    0.003086749,
   0.0059215184,
   0.0086302981,
    0.011087098,
    0.013291919,
     0.01524476,
    0.016819632,
     0.01795354,
    0.018772473,
    0.019087447,
    0.019024453,
    0.018520494,
    0.017638566,
    0.016315673,
    0.014677806,
    0.012724965,
     0.01045715,
   0.0080003492,
   0.0053545642,
    0.002645785,
  -0.0001890827,
  -0.0029607592,
  -0.0056695389,
  -0.0082523287,
   -0.010646134,
   -0.012850955,
   -0.014677806,
   -0.016252678,
   -0.017449581,
   -0.018331509,
   -0.018709478,
   -0.018772473,
   -0.018394504,
   -0.017638566,
   -0.016504658,
   -0.015055775,
   -0.013291919,
   -0.011213088,
  -0.0089452728,
  -0.0064884722,
  -0.0039056824,
  -0.0012598974,
   0.0013858872,
    0.003968677,
   0.0064254776,
   0.0087562879,
    0.010835119,
    0.012724965,
    0.014299837,
     0.01549674,
    0.016378668,
    0.016882627,
    0.017008617,
    0.016756637,
    0.016126689,
    0.015181765,
    0.013858873,
    0.012284001,
    0.010394155,
   0.0083153234,
   0.0060475082,
   0.0036537028,
   0.0011969027,
  -0.0013228925,
  -0.0037796926,
  -0.0061105029,
  -0.0083153234,
   -0.010394155,
   -0.012158011,
   -0.013732883,
   -0.014929786,
   -0.015874709,
   -0.016441663,
   -0.016630647,
   -0.016504658,
   -0.016000698,
   -0.015181765,
   -0.014047857,
   -0.012598976,
   -0.010898114,
  -0.0089452728,
  -0.0068664416,
  -0.0046616206,
  -0.0023308103,
              0,
   0.0022678156,
   0.0045356308,
   0.0066774571,
   0.0086302981,
    0.010394155,
    0.011906032,
    0.013102934,
    0.014047857,
    0.014677806,
    0.014929786,
    0.014929786,
    0.014551817,
    0.013858873,
    0.012850955,
    0.011591057,
    0.010016185,
   0.0083153234,
   0.0063624824,
   0.0043466464,
    0.002204821,
              0,
  -0.0021418259,
  -0.0042836517,
  -0.0062994878,
  -0.0081263389,
  -0.0098272008,
   -0.011276083,
    -0.01253598,
   -0.013480904,
   -0.014110852,
   -0.014488821,
   -0.014488821,
   -0.014236842,
   -0.013669888,
    -0.01278796,
   -0.011654052,
   -0.010268165,
  -0.0086932927,
  -0.0069924314,
  -0.0051025851,
   -0.003086749,
  -0.0010709129,
  0.00094492314,
   0.0028977646,
   0.0047876104,
    0.006614462,
   0.0081893341,
   0.0096382163,
    0.010835119,
    0.011780042,
    0.012472985,
    0.012850955,
    0.012976944,
     0.01278796,
    0.012346996,
    0.011591057,
    0.010583139,
   0.0093862368,
   0.0080003492,
   0.0064254776,
   0.0047246157,
   0.0028977646,
   0.0010079178,
 -0.00088192802,
  -0.0027087796,
  -0.0044726362,
   -0.006173498,
  -0.0076853749,
  -0.0090712621,
    -0.01020517,
   -0.011150093,
   -0.011843037,
   -0.012284001,
   -0.012472985,
   -0.012346996,
   -0.011969027,
   -0.011339078,
   -0.010520144,
  -0.0094492314,
  -0.0081893341,
  -0.0067404518,
  -0.0052285749,
  -0.0035907081,
  -0.0018268516,
 -0.00012591761,
   0.0015748716,
   0.0032757334,
   0.0048506055,
   0.0062994878,
   0.0075593852,
   0.0086932927,
   0.0095752212,
     0.01033116,
    0.010772124,
    0.010961108,
    0.010961108,
    0.010709129,
    0.010142175,
   0.0094492314,
   0.0085043083,
   0.0074333954,
   0.0061105029,
   0.0047246157,
   0.0032757334,
   0.0017008614,
  0.00012591761,
  -0.0014488823,
  -0.0029607592,
  -0.0044726362,
  -0.0057955286,
  -0.0069924314,
  -0.0080633443,
  -0.0089452728,
  -0.0096382163,
   -0.010142175,
   -0.010394155,
   -0.010394155,
    -0.01020517,
  -0.0097642061,
  -0.0091972519,
  -0.0083783185,
  -0.0073704007,
  -0.0062994878,
  -0.0050395899,
  -0.0037166979,
  -0.0022678156,
 -0.00088192802,
  0.00056695379,
   0.0019528414,
   0.0033387286,
   0.0045986259,
    0.005732534,
   0.0067404518,
   0.0075593852,
   0.0082523287,
   0.0086932927,
   0.0089452728,
   0.0090712621,
   0.0089452728,
   0.0086302981,
   0.0081263389,
   0.0074333954,
   0.0065514673,
   0.0056065442,
   0.0044726362,
   0.0033387286,
   0.0020788312,
  0.00081893336,
 -0.00050395913,
  -0.0017638565,
  -0.0029607592,
  -0.0041576619,
  -0.0051655797,
  -0.0061105029,
  -0.0069294362,
  -0.0075593852,
  -0.0080003492,
  -0.0083153234,
  -0.0083783185,
  -0.0083153234,
  -0.0080633443,
  -0.0076853749,
  -0.0071184211,
  -0.0063624824,
  -0.0055435491,
  -0.0045986259,
   -0.003527713,
  -0.0024568001,
  -0.0013228925,
 -0.00012591761,
   0.0010079178,
   0.0020788312,
    0.003086749,
   0.0040946668,
   0.0049136002,
   0.0056695389,
   0.0062364927,
   0.0066774571,
   0.0069924314,
   0.0071184211,
   0.0071184211,
   0.0069294362,
    0.006614462,
   0.0061105029,
   0.0055435491,
   0.0047876104,
    0.003968677,
    0.003086749,
   0.0021418259,
   0.0011339076,
  0.00012591761,
 -0.00081893336,
  -0.0018268516,
  -0.0027087796,
  -0.0035907081,
  -0.0043466464,
  -0.0049765953,
  -0.0055435491,
  -0.0059845136,
  -0.0062364927,
  -0.0064254776,
  -0.0064254776,
  -0.0062994878,
  -0.0060475082,
  -0.0056065442,
  -0.0051655797,
  -0.0045356308,
  -0.0038426872,
   -0.003086749,
  -0.0022678156,
  -0.0014488823,
 -0.00056695379,
  0.00031497423,
   0.0011339076,
   0.0019528414,
    0.002645785,
   0.0033387286,
   0.0039056824,
   0.0044096415,
   0.0047876104,
   0.0050395899,
   0.0052285749,
   0.0052285749,
   0.0051655797,
   0.0049765953,
   0.0046616206,
   0.0042836517,
   0.0037796926,
   0.0032127388,
   0.0025827899,
   0.0018898463,
   0.0011969027,
  0.00050395913,
 -0.00025197957,
 -0.00094492314,
  -0.0015748716,
   -0.002204821,
  -0.0027717748,
  -0.0032757334,
  -0.0037166979,
  -0.0040316721,
  -0.0042836517,
  -0.0044096415,
  -0.0044726362,
  -0.0044096415,
  -0.0042836517,
  -0.0040316721,
  -0.0037166979,
  -0.0033387286,
  -0.0028977646,
  -0.0023938054,
  -0.0018268516,
  -0.0012598974,
 -0.00069294358,
 -0.00012591761,
  0.00044096401,
   0.0010079178,
   0.0015118769,
   0.0019528414,
   0.0023938054,
   0.0027087796,
   0.0030237539,
   0.0032127388,
   0.0033387286,
   0.0034017232,
   0.0033387286,
   0.0032127388,
    0.003086749,
   0.0028347694,
   0.0025197952,
    0.002204821,
   0.0018268516,
   0.0013858872,
  0.00094492314,
  0.00056695379,
  0.00012591761,
 -0.00031497423,
 -0.00075593824,
  -0.0011339076,
  -0.0014488823,
  -0.0017638565,
  -0.0020158361,
  -0.0022678156,
  -0.0023938054,
  -0.0025197952,
  -0.0025197952,
  -0.0025197952,
  -0.0024568001,
  -0.0023308103,
  -0.0021418259,
  -0.0019528414,
  -0.0017008614,
  -0.0013858872,
  -0.0011339076,
 -0.00081893336,
 -0.00050395913,
  -0.0001890827,
  6.2958337e-05,
  0.00037796935,
  0.00062994892,
  0.00088192802,
   0.0010709129,
   0.0011969027,
   0.0013228925,
   0.0014488823,
   0.0015118769,
   0.0015118769,
   0.0015118769,
   0.0014488823,
   0.0013858872,
   0.0012598974,
   0.0011339076,
  0.00094492314,
  0.00081893336,
  0.00062994892,
  0.00044096401,
  0.00031497423,
  0.00012591761,
 -6.2958337e-05,
  -0.0001890827,
 -0.00031497423,
 -0.00044096401,
 -0.00050395913,
 -0.00056695379,
 -0.00062994892,
 -0.00062994892,
 -0.00062994892,
 -0.00062994892,
 -0.00056695379,
 -0.00056695379,
 -0.00050395913,
 -0.00044096401,
 -0.00037796935,
 -0.00031497423,
  -0.0001890827,
  -0.0001890827,
 -0.00012591761,
 -6.2958337e-05,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,
              0,

};

const framecnt_t Session::default_click_length = sizeof (default_click) / sizeof (default_click[0]);
