#!/bin/sh -e
#
# Removes unwanted content from the upstream sources.
# Called by uscan with '--upstream-version' <version> <file>
#

VERSION=$2
TAR=../apache-log4j-extras1.2_$VERSION.orig.tar.xz
DIR=apache-log4j-extras1.2-$VERSION
TAG=$(echo "apache-log4j-extras-$VERSION" | sed -re's/~(alpha|beta|rc)/-\1-/')

svn export http://svn.apache.org/repos/asf/logging/log4j/companions/extras/tags/${TAG}/ $DIR
XZ_OPT=--best tar -c -J -f $TAR --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
