[![PyPI version](https://badge.fury.io/py/ansible.png)](http://badge.fury.io/py/ansible) [![PyPI downloads](https://pypip.in/d/ansible/badge.png)](https://pypi.python.org/pypi/ansible)


Ansible
=======

Ansible is a radically simple configuration-management, application deployment, task-execution, and multinode orchestration engine.

Read the documentation and more at http://ansible.com/

Many users run straight from the development branch (it's generally fine to do so), but you might also wish to consume a release.  You can find 
instructions [here](http://docs.ansible.com/intro_getting_started.html) for a variety of platforms.  If you want a tarball of the last release, go to [releases.ansible.com](http://releases.ansible.com/ansible) and you can also install with pip.

Design Principles
=================

   * Have a dead simple setup process and a minimal learning curve
   * Be super fast & parallel by default
   * Require no server or client daemons; use existing SSHd
   * Use a language that is both machine and human friendly
   * Focus on security and easy auditability/review/rewriting of content
   * Manage remote machines instantly, without bootstrapping
   * Allow module development in any dynamic language, not just Python
   * Be usable as non-root
   * Be the easiest IT automation system to use, ever.
  
Get Involved
============

   * Read [Contributing.md](https://github.com/ansible/ansible/blob/devel/CONTRIBUTING.md) for all kinds of ways to contribute to and interact with the project, including mailing list information and how to submit bug reports and code to Ansible.  
   * All code submissions are done through pull requests.  Take care to make sure no merge commits are in the submission, and use "git rebase" vs "git merge" for this reason.  If submitting a large code change (other than modules), it's probably a good idea to join ansible-devel and talk about what you would like to do or add first and to avoid duplicate efforts.  This not only helps everyone know what's going on, it also helps save time and effort if we decide some changes are needed.
   * irc.freenode.net: #ansible

Branch Info
===========

   * Releases are named after Van Halen songs.
   * The devel branch corresponds to the release actively under development.
   * Various release-X.Y branches exist for previous releases
   * We'd love to have your contributions, read "CONTRIBUTING.md" for process notes.

Author
======

Ansible was created by Michael DeHaan (michael@ansible.com) and has contributions from over
700 users (and growing).  Thanks everyone!

[Ansible, Inc](http://ansible.com)

