# I.1 Isn't libertarian socialism an oxymoron?

In a word, no. This question is often asked by those who have come across the
so-called "libertarian" right. As discussed in [section
A.1.3](secA1.md#seca13) , the word libertarian has been used by anarchists
for far longer than the pro-free market right have been using it. In fact,
anarchists have been using it as a synonym for anarchist for over 150 years,
since 1858. In comparison, widespread use of the term by the so-called
"libertarian" right dates from the 1970s in America (with, from the 1940s
onwards, limited use by a few individuals). Indeed, outside of North America
libertarian is still essentially used as an equivalent of anarchist and as a
shortened version of libertarian socialist. As Noam Chomsky notes:

> _"Let me just say regarding the terminology, since we happen to be in the
United States, we have to be rather careful. Libertarian in the United States
has a meaning which is almost the opposite of what it has in the rest of the
world traditionally. Here, libertarian means ultra right-wing capitalist. In
the European tradition, libertarian meant socialist. So, anarchism was
sometimes called libertarian socialism, a large wing of anarchism, so we have
to be a little careful about terminology."_ [**Reluctant Icon**]

This in itself does not prove that the term libertarian socialist is free of
contradiction. However, as we will show below, the claim that the term is
self-contradictory rests on the assumption that socialism requires the state
in order to exist and that socialism is incompatible with liberty (and the
equally fallacious claim that capitalism is libertarian and does not need the
state). This assumption, as is often true of many objections to socialism, is
based on a misconception of what socialism is, a misconception that many
authoritarian socialists and the state capitalism of Soviet Russia have helped
to foster. In reality it is the term "state socialism" which is the true
oxymoron.

Sadly many people take for granted the assertion of many on the right and left
that socialism equals Leninism or Marxism and ignore the rich and diverse
history of socialist ideas, ideas that spread from communist and
individualist-anarchism to Leninism. As Benjamin Tucker once noted, _"the fact
that State Socialism . . . has overshadowed other forms of Socialism gives it
no right to a monopoly of the Socialistic idea."_ [**Instead of a Book**, pp.
363-4] Unfortunately, many on the left combine with the right to do exactly
that. Indeed, the right (and, of course, many on the left) consider that, by
definition, "socialism" **is** state ownership and control of the means of
production, along with centrally planned determination of the national economy
(and so social life).

Yet even a quick glance at the history of the socialist movement indicates
that the identification of socialism with state ownership and control is not
common. For example, Anarchists, many Guild Socialists, council communists
(and other libertarian Marxists), as well as followers of Robert Owen, all
rejected state ownership. Indeed, anarchists recognised that the means of
production did not change their form as capital when the state took over their
ownership nor did wage-labour change its nature when it is the state employing
labour (for example, see [section H.3.13](secH3.md#sech313) ). For
anarchists state ownership of capital is not socialistic in the slightest.
Indeed, as Tucker was well aware, state ownership turned **everyone** into a
proletarian (bar the state bureaucracy) -- hardly a desirable thing for a
political theory aiming for the end of wage slavery!

So what **does** socialism mean? Is it compatible with libertarian ideals?
What do the words libertarian and socialism actually mean? It is temping to
use dictionary definitions as a starting point, although we should stress that
such a method holds problems as different dictionaries have different
definitions and the fact that dictionaries are rarely politically
sophisticated. Use one definition, and someone else will counter with one more
to their liking. For example, socialism is often defined as _"state ownership
of wealth"_ and anarchy as _"disorder."_ Neither of these definitions are
useful when discussing political ideas, particularly anarchism as, obviously,
no form of anarchism would be socialist by such a definition nor do anarchists
seek disorder. Therefore, the use of dictionaries is not the end of a
discussion and often misleading when applied to politics.

Libertarian, though, is generally defined to mean someone who upholds the
principles of liberty, especially individual liberty of thought and action.
Such a situation cannot but be encouraged by socialism, by free access to the
means of life. This is because in such a situation people associate as equals
and so, as John Most and Emma Goldman once argued, the _"system of communism
logically excludes any and every relation between master and servant, and
means really Anarchism."_ [_"Talking about Anarchy"_, p. 28, **Black Flag**,
no. 228, p. 28] In other words, by basing itself on free association and self-
management in every aspect of life the anarchist form of socialism cannot but
be libertarian.

In other words, there is a reason why anarchists have used the term
libertarian for over 150 years! More to the point, why assume that the right's
recent appropriation of the word be considered the base point? That implies
that private property defends individual liberty rather than suppresses it.
Such an assumption, as anarchists have argued from the start of anarchism as a
distinct socio-political theory, is wrong. As we discussed earlier (see
[section B.4](secB4.md), for example), capitalism denies liberty of thought
and action within the workplace (unless one is the boss, of course). As one
staunch defender of capitalism (and a classical liberal often listed as a
forefather of right-wing "libertarianism") glibly noted, the capitalist _"of
course exercises power over the workers"_, although _"he cannot exercise it
arbitrarily"_ thanks to the market but within this limit _"the entrepreneur is
free to give full rein to his whims"_ and _"to dismiss workers offhand."_
[Ludwig von Mises, **Socialism**, p. 443 and p. 444] Right-wing "libertarians"
are utterly blind to the liberty-destroying hierarchies associated with
private property, perhaps unsurprisingly as they are fundamentally pro-
capitalist and anti-socialist (equally unsurprisingly, genuine libertarians
tend to call them "propertarians"). As left-wing economist Geoffrey M. Hodgson
correctly notes:

> _"By their own logic, [such] market individualists are forced to disregard
the organisational structure of the firm, or to falsely imagine that markets
exist inside it. To do otherwise would be to admit that a system as dynamic as
capitalism depends upon a mode of organisation from which markets are excluded
. . . This . . . allows market individualists to ignore the reality of non-
market organisations in the private sector . . . They can thus ignore the
reality of control and authority within the private capitalist corporation but
remain critical of public sector bureaucracy and state planning."_
[**Economics and Utopia**, pp. 85-6]

The propertarian perspective inevitably generates massive contradictions, such
as admitting that both the state and private property share a common monopoly
of decision making over a given area yet opposing only the former (see
[section F.1](secF1.md)). As anarchists have long pointed out, the
hierarchical social relations associated with private property have nothing to
do with individual liberty. Removing the state but keeping private property
would, therefore, not be a step forward: _"A fine business we would make if we
destroyed the State and replaced it with a mass of little States! killing a
monster with one head and keeping a monster with a thousand heads!"_ [Carlo
Cafiero, _"Anarchy and Communism"_, pp. 179-86, **The Raven**, No. 6, p. 181]

This is why we argue that anarchism is more than just a stateless society, for
while a society without a state is a necessary condition for anarchy it is not
sufficient -- private hierarchies also limit freedom. Hence Chomsky:

> _"It's all generally based on the idea that hierarchic and authoritarian
structures are not self-justifying. They have to have a justification . . .
For example, your workplace is one point of contact and association. So,
workplaces ought to be democratically controlled by participants . . . there
are all kinds of ways in which people interact with one another. The forms of
organisation and association that grow out of those should be, to the extent
possible, non-authoritarian, non-hierarchic, managed and directed by the
participants."_ [**Reluctant Icon**]

Therefore, anarchists argue, **real** libertarian ideas **must** be based on
workers self-management, i.e. workers must control and manage the work they
do, determining where and how they do it and what happens to the fruit of
their labour, which in turn means the elimination of wage labour. Or, to use
Proudhon's words, the _"abolition of the proletariat."_ [**Selected Writings
of Pierre-Joseph Proudhon**, p. 179] Unless this is done then the majority of
people will become subject to the authoritarian social relationships the likes
of Mises and other right-wing "libertarians" support. As one communist-
anarchist put it:

> _"It is because the individual does not own himself, and is not permitted to
be his true self. He has become a mere market commodity, an instrument for the
accumulation of property -- for others . . . Individuality is stretched on the
Procrustes bed of business . . . If our individuality were to be made the
price of breathing, what ado there would be about the violence done to the
personality! And yet our very right to food, drink and shelter is only too
often conditioned upon our loss of individuality. These things are granted to
the propertyless millions (and how scantily!) only in exchange for their
individuality -- they become the mere instruments of industry."_ [Max
Baginski, _"Stirner: The Ego and His Own"_, pp. 142-151, **Mother Earth**,
Vol. II, No. 3, p. 150]

Socialism, anarchists argue, can only mean a classless and anti-authoritarian
(i.e. libertarian) society in which people manage their own affairs, either as
individuals or as part of a group (depending on the situation). In other
words, it implies self-management in all aspects of life -- including work. It
has always struck anarchists as somewhat strange and paradoxical (to say the
least) that a system of _"natural"_ liberty (Adam Smith's term,
misappropriated by supporters of capitalism) involves the vast majority having
to sell that liberty in order to survive. Thus to be consistently libertarian
is, logically, to advocate self-management, and so socialism (see [section
G.4.2](secG4.md#secg42)). This explains the long standing anarchist
opposition to the phoney "individualism" associated with classical liberalism
(so-called right-wing "libertarian" ideology, although better termed
"propertarian" to avoid confusion). Thus we find Emma Goldman dismissing
_"this kind of individualism"_ in _"whose name . . . social oppression are
defended and held up as virtues."_ [**Red Emma Speaks**, p. 112]

As we will discuss in [section I.3.3](secI3.md#seci33), socialisation is
advocated to ensure the elimination of wage labour and is a common theme of
all genuine forms of socialism. Anarchists argue that state socialism does not
eliminate wage labour, rather it universalises it. In fact, state socialism
shows that socialism is **necessarily** libertarian, not statist. For if the
state owns the workplace, then the producers do not, and so they will not be
at liberty to manage their own work but will instead be subject to the state
as the boss. Moreover, replacing the capitalist owning class by state
officials in no way eliminates wage labour; in fact it makes it worse in many
cases. Therefore "socialists" who argue for nationalisation of the means of
production are **not** socialists (which means that the Soviet Union and the
other so-called "socialist" countries were/are **not** socialist nor are
parties which advocate nationalisation socialist).

Indeed, attempts to associate socialism with the state misunderstands the
nature of socialism. It is an essential principle of socialism that (social)
inequalities between individuals must be abolished to ensure liberty for all
(**natural** inequalities cannot be abolished, nor do anarchists desire to do
so). Socialism, as Proudhon put it, _"is egalitarian above all else."_ [**No
Gods, No Masters**, vol. 1, p. 57] This applies to inequalities of power as
well, especially to **political** power. And any hierarchical system
(particularly the state) is marked by inequalities of power -- those at the
top (elected or not) have more power than those at the bottom. Hence the
following comments provoked by the expulsion of anarchists from the social
democratic Second International:

> _"It could be argued with much more reason that we are the most logical and
most complete socialists, since we demand for every person not just his [or
her] entire measure of the wealth of society but also his [or her] portion of
social power, which is to say, the real ability to make his [or her] influence
felt, along with that of everybody else, in the administration of public
affairs."_ [Malatesta and Hamon, **Op. Cit.**, vol. 2, p. 20]

The election of someone to administer public affairs **for you** is not having
a portion of social power. It is, to use the words of leading French anarcho-
syndicalist Emile Pouget, _"an act of abdication,"_ the delegating of power
into the hands of a few. [**Op. Cit.**, p. 67] This means that _"**[a]ll
political power inevitably creates a privileged situation** for the men who
exercise it. Thus it violates, from the beginning, the equalitarian
principle."_ [Voline, **The Unknown Revolution**, p. 249]

From this short discussion we see the links between libertarian and socialism.
To be a true libertarian requires you to support workers' control otherwise
you support authoritarian social relationships. To support workers' control,
by necessity, means that you must ensure that the producers own (and so
control) the means of producing and distributing the goods they create.
Without ownership, they cannot truly control their own activity or the product
of their labour. The situation where workers possess the means of producing
and distributing goods is socialism. Thus to be a true libertarian requires
you to be a socialist.

Similarly, a true socialist must also support individual liberty of thought
and action, otherwise the producers "possess" the means of production and
distribution in name only. If the state owns the means of life, then the
producers do not and so are in no position to manage their own activity. As
the experience of Russia under Lenin shows, state ownership soon produces
state control and the creation of a bureaucratic class which exploits and
oppresses the workers even more so than their old bosses. Since it is an
essential principle of socialism that inequalities between people must be
abolished in order to ensure liberty, it makes no sense for a genuine
socialist to support any institution based on inequalities of power (and as we
discussed in [section B.2](secB2.md), the state is just such an
institution). To oppose inequality and not extend that opposition to
inequalities in power, especially **political** power, suggests a lack of
clear thinking. Thus to be a true socialist requires you to be a libertarian,
to be for individual liberty and opposed to inequalities of power which
restrict that liberty.

Therefore, rather than being an oxymoron, libertarian socialism indicates that
true socialism must be libertarian and that a libertarian who is not a
socialist is a phoney. As true socialists oppose wage labour, they must also
oppose the state for the same reasons. Similarly, consistent libertarians must
oppose wage labour for the same reasons they must oppose the state. So,
libertarian socialism rejects the idea of state ownership and control of the
economy, along with the state as such. Through workers' self-management it
proposes to bring an end to authority, exploitation, and hierarchy in
production. This in itself will increase, not reduce, liberty. Those who argue
otherwise rarely claim that political democracy results in less freedom than
political dictatorship.

One last point. It could be argued that many social anarchists smuggle the
state back in via communal ownership of the means of life. This, however, is
not the case. To argue so confuses society with the state. The communal
ownership advocated by collectivist and communist anarchists is not the same
as state ownership. This is because it is based on horizontal relationships
between the actual workers and the "owners" of social capital (i.e. the
federated communities as a whole, which includes the workers themselves we
must stress), not vertical ones as in nationalisation (which are between state
bureaucracies and its "citizens"). Also, such communal ownership is based upon
letting workers manage their own work and workplaces. This means that it is
based upon, and does not replace, workers' self-management. In addition, all
the members of an anarchist community fall into one of three categories:

(1) producers (i.e. members of a collective or self-employed artisans);  
(2) those unable to work (i.e. the old, sick and so on, who **were**
producers); or  
(3) the young (i.e. those who **will be** producers).

Therefore, workers' self-management within a framework of communal ownership
is entirely compatible with libertarian and socialist ideas concerning the
possession of the means of producing and distributing goods by the producers
themselves. Far from there being any contradiction between libertarianism and
socialism, libertarian ideals imply socialist ones, and vice versa. As Bakunin
put it in 1867:

> _"We are convinced that freedom without Socialism is privilege and
injustice, and that Socialism without freedom is slavery and brutality."_
[**Bakunin on Anarchism**, p. 127]

History has proven him correct. Rather than libertarian socialism being the
oxymoron, it is state socialism and libertarian capitalism that are. Both
historically (in terms of who first used the word) and logically (in terms of
opposing all hierarchical organisations) it is anarchists who should be called
libertarians, **not** the propertarian right.

## I.1.1 Is socialism impossible?

In 1920, the right-wing economist Ludwig von Mises declared socialism to be
impossible. A leading member of the "Austrian" school of economics, he argued
this on the grounds that without private ownership of the means of production,
there cannot be a competitive market for production goods and without a market
for production goods, it is impossible to determine their values. Without
knowing their values, economic rationality is impossible and so a socialist
economy would simply be chaos: _"the absurd output of a senseless apparatus."_
For Mises, socialism meant central planning with the economy _"subject to the
control of a supreme authority."_ [_"Economic Calculation in the Socialist
Commonwealth"_, pp. 87-130, **Collectivist Economic Planning**, F.A von Hayek
(ed.), p. 104 and p. 106] While applying his _"economic calculation argument"_
to Marxist ideas of a future socialist society, his argument, it is claimed,
is applicable to **all** schools of socialist thought, including libertarian
ones. It is on the basis of his arguments that many right-wingers claim that
libertarian (or any other kind of) socialism is impossible in principle.

Yet as David Schweickart observes it _"has long been recognised that Mises's
argument is logically defective. Even without a market in production goods,
their monetary values can be determined."_ [**Against Capitalism**, p. 88] In
other words, economic calculation based on prices is perfectly possible in a
libertarian socialist system. After all, to build a workplace requires so many
tonnes of steel, so many bricks, so many hours of work and so on. If we assume
a mutualist society, then the prices of these goods can be easily found as the
co-operatives in question would be offering their services on the market.
These commodities would be the inputs for the construction of production goods
and so the latter's monetary values can be found.

Ironically enough, Mises **did** mention the idea of such a mutualist system
in his initial essay. _"Exchange relations between production-goods can only
be established on the basis of private ownership of the means of production"_
he asserted. _"When the 'coal syndicate' provides the 'iron syndicate' with
coal, no price can be formed, except when both syndicates are the owners of
the means of production employed in their business. This would not be
socialisation but workers' capitalism and syndicalism."_ [**Op. Cit.**, p.
112] However, his argument is flawed for numerous reasons.

First, and most obvious, socialisation (as we discuss in [section
I.3.3](secI3.md#seci33)) simply means free access to the means of life. As
long as those who join a workplace have the same rights and liberties as
existing members then there is socialisation. A market system of co-
operatives, in other words, is **not** capitalist as there is no wage labour
involved as a new workers become full members of the syndicate, with the same
rights and freedoms as existing members. Thus there are no hierarchical
relationships between owners and wage slaves (even if these owners also happen
to work there). As all workers' control the means of production they use, it
is not capitalism.

Second, nor is such a system usually called, as Mises suggests,
_"syndicalism"_ but rather mutualism and he obviously considered its most
famous advocate, Proudhon and his _"fantastic dreams"_ of a mutual bank, as a
socialist. [**Op. Cit.**, p. 88] Significantly, Mises subsequently admitted
that it was _"misleading"_ to call syndicalism workers' capitalism, although
_"the workers are the owners of the means of production"_ it was _"not genuine
socialism, that is, centralised socialism"_, as it _"must withdraw productive
goods from the market. Individual citizens must not dispose of the shares in
the means of production which are allotted to them."_ Syndicalism, i.e.,
having those who do the work control it, was _"the ideal of plundering
hordes"_! [**Socialism**, p. 274fn, p. 270, p. 273 and p. 275]

His followers, likewise, concluded that "syndicalism" was not capitalism with
Hayek stating that there were _"many types of socialism"_ including
_"communism, syndicalism, guild socialism"_. Significantly, he indicated that
Mises argument was aimed at systems based on the _"central direction of all
economic activity"_ and so _"earlier systems of more decentralised socialism,
like guild-socialism or syndicalism, need not concern us here since it seems
now to be fairly generally admitted that they provide no mechanism whatever
for a rational direction of economic activity."_ [_"The Nature and History of
the Problem"_, pp. 1-40, **Collectivist Economic Planning**, F.A von Hayek
(ed.),p. 17, p. 36 and p. 19] Sadly he failed to indicate who _"generally
admitted"_ such a conclusion. More recently, Murray Rothbard urged the state
to impose private shares onto the workers in the former Stalinist regimes of
Eastern Europe as ownership was _"not to be granted to collectives or co-
operatives or workers or peasants holistically, which would only bring back
the ills of socialism in a decentralised and chaotic syndicalist form."_
[**The Logic of Action II**, p. 210]

Third, syndicalism usually refers to a strategy (revolutionary unionism) used
to achieve (libertarian) socialism rather than the goal itself (as Mises
himself noted in a tirade against unions, _"Syndicalism is nothing else but
the French word for trade unionism"_ [**Socialism**, p. 480]). It could be
argued that such a mutualist system could be an aim for some syndicalists,
although most were and still are in favour of libertarian communism (a simple
fact apparently unknown to Mises). Indeed, Mises ignorance of syndicalist
thought is striking, asserting that the _"market is a consumers' democracy.
The syndicalists want to transform it into a producers' democracy."_ [**Human
Action**, p. 809] Most syndicalists, however, aim to **abolish** the market
and **all** aim for workers' control of production to **complement** (not
replace) consumer choice. Syndicalists, like other anarchists, do not aim for
workers' control of consumption as Mises asserts. Given that Mises asserts
that the market, in which one person can have a thousand votes and another
one, is a _"democracy"_ his ignorance of syndicalist ideas is perhaps only one
aspect of a general ignorance of reality.

More importantly, the whole premise of his critique of mutualism is flawed.
_"Exchange relations in productive goods"_ he asserted, _"can only be
established on the basis of private property in the means of production. If
the Coal Syndicate delivers coal to the Iron Syndicate a price can be fixed
only if both syndicates own the means of production in industry."_
[**Socialism**, p. 132] This may come as a surprise to the many companies
whose different workplaces sell each other their products! In other words,
capitalism itself shows that workplaces owned by the same body (in this case,
a large company) can exchange goods via the market. That Mises makes such a
statement indicates well the firm basis of his argument in reality. Thus a
socialist society can have extensive autonomy for its co-operatives, just as a
large capitalist firm can:

> _"the entrepreneur is in a position to separate the calculation of each part
of his total enterprise in such a way that he can determine the role it plays
within his whole enterprise. Thus he can look at each section as if it were a
separate entity and can appraise it according to the share it contributes to
the success of the total enterprise. Within this system of business
calculation each section of a firm represents an integral entity, a
hypothetical independent business, as it were. It is assumed that this section
'owns' a definite part of the whole capital employed in the enterprise, that
it buys from other sections and sells to them, that it has its own expenses
and its own revenues, that its dealings result either in a profit or in a loss
which is imputed to its own conduct of affairs as distinguished from the
result of the other sections. Thus the entrepreneur can assign to each
section's management a great deal of independence . . . Every manager and
submanager is responsible for the working of his section or subsection. It is
to his credit if the accounts show a profit, and it is to his disadvantage if
they show a loss. His own interests impel him toward the utmost care and
exertion in the conduct of his section's affairs."_ [**Human Action**, pp.
301-2]

So much, then, for the notion that common ownership makes it impossible for
market socialism to work. After all, the libertarian community can just as
easily separate the calculation of each part of its enterprise in such a way
as to determine the role each co-operative plays in its economy. It can look
at each section as if it were a separate entity and appraise it according to
the share it contributes as it is assumed that each section "owns" (i.e., has
use rights over) its definite part. It can then buy from, and sell to, other
co-operatives and a profit or loss can be imputed to evaluate the independent
action of each co-operative and so their own interests impel the co-operative
workers toward the utmost care and exertion in the conduct of their co-
operative's affairs.

So to refute Mises, we need only repeat what he himself argued about large
corporations! Thus there can be extensive autonomy for workplaces under
socialism and this does not in any way contradict the fact that _"all the
means of production are the property of the community."_ [_"Economic
Calculation in the Socialist Commonwealth"_, **Op. Cit.**, p. 89]
Socialisation, in other words, does **not** imply central planning but rather
free access and free association. In summary, then, Mises confused property
rights with use rights, possession with property, and failed to see now a
mutualist system of socialised co-operatives exchanging products can be a
viable alternative to the current exploitative and oppressive economic regime.

Such a mutualist economy also strikes at the heart of Mises' claims that
socialism was _"impossible."_ Given that he accepted that there may be
markets, and hence market prices, for consumer goods in a socialist economy
his claims of the impossibility of socialism seems unfounded. For Mises, the
problem for socialism was that _"because no production-good will ever become
the object of exchange, it will be impossible to determine its monetary
value."_ [**Op. Cit.**, p. 92] The flaw in his argument is clear. Taking, for
example, coal, we find that it is both a means of production and of
consumption. If a market in consumer goods is possible for a socialist system,
then competitive prices for production goods is also possible as syndicates
producing production-goods would also sell the product of their labour to
other syndicates or communes. As Mises admitted when discussing one scheme of
guild socialism, _"associations and sub-associations maintain a mutual
exchange-relationship; they receive and give as if they were owners. Thus a
market and market-prices are formed."_ Thus, when deciding upon a new
workplace, railway or house, the designers in question do have access to
competitive prices with which to make their decisions. Nor does Mises'
argument work against communal ownership in such a system as the commune would
be buying products from syndicates in the same way as one part of a company
can buy products from another part of the same company under capitalism. That
goods produced by self-managed syndicates have market-prices does not imply
capitalism for, as they abolish wage labour and are based on free-access
(socialisation), it is a form of socialism (as socialists define it, Mises'
protestations that _"this is incompatible with socialism"_ not-with-
standing!). [**Socialism**, p. 518]

Murray Rothbard suggested that a self-managed system would fail, and a system
_"composed exclusively of self-managed enterprises is impossible, and would
lead . . . to calculative chaos and complete breakdown."_ When _"each firm is
owned jointly by all factor-owners"_ then _"there is no separation at all
between workers, landowners, capitalists, and entrepreneurs. There would be no
way, then, of separating the wage incomes received from the interest or rent
incomes or profits received. And now we finally arrive at the real reason why
the economy cannot consist completely of such firms (called 'producers' co-
operatives'). For, without an external market for wage rates, rents, and
interest, there would be no rational way for entrepreneurs to allocate factors
in accordance with the wishes of the consumers. No one would know where he
could allocate his land or his labour to provide the maximum monetary gains.
No entrepreneur would know how to arrange factors in their most value-
productive combination to earn greatest profit. There could be no efficiency
in production because the requisite knowledge would be lacking."_ [quoted by
David L. Prychitko, **Markets, Planning and Democracy**, p. 135 and p. 136]

It is hard to take this argument seriously. Consider, for example, a pre-
capitalist society of farmers and artisans. Both groups of people own their
own means of production (the land and the tools they use). The farmers grow
crops for the artisans who, in turn, provide the farmers with the tools they
use. According to Rothbard, the farmers would have no idea what to grow nor
would the artisans know which tools to buy to meet the demand of the farmers
nor which to use to reduce their working time. Presumably, both the farmers
and artisans would stay awake at night worrying what to produce, wishing they
had a landlord and boss to tell them how best to use their labour and
resources.

Let us add the landlord class to this society. Now the landlord can tell the
farmer what to grow as their rent income indicates how to allocate the land to
its most productive use. Except, of course, it is still the farmers who decide
what to produce. Knowing that they will need to pay rent (for access to the
land) they will decide to devote their (rented) land to the most profitable
use in order to both pay the rent and have enough to live on. Why they do not
seek the most profitable use without the need for rent is not explored by
Rothbard. Much the same can be said of artisans subject to a boss, for the
worker can evaluate whether an investment in a specific new tool will result
in more income or reduced time labouring or whether a new product will likely
meet the needs of consumers. Moving from a pre-capitalist society to a post-
capitalist one, it is clear that a system of self-managed co-operatives can
make the same decisions without requiring economic masters. This is
unsurprising, given that Mises' asserted that the boss _"of course exercises
power over the workers"_ but that the _"lord of production is the consumer."_
[**Socialism**, p. 443] In which case, the boss need not be an intermediary
between the real "lord" and those who do the production!

All in all, Rothbard confirms Kropotkin's comments that economics (_"that
pseudo-science of the bourgeoisie"_) _"does not cease to give praise in every
way to the benefits of individual property"_ yet _"the economists do not
conclude, 'The land to him who cultivates it.' On the contrary, they hasten to
deduce from the situation, 'The land to the lord who will get it cultivated by
wage earners!'"_ [**Words of a Rebel**, pp. 209-10] In addition, Rothbard
implicitly places "efficiency" above liberty, preferring dubious "efficiency"
gains to the actual gains in freedom which the abolition of workplace
autocracy would create. Given a choice between liberty and "efficiency", the
genuine anarchist would prefer liberty. Luckily, though, workplace liberty
increases efficiency so Rothbard's decision is a wrong one. It should also be
noted that Rothbard's position (as is usually the case) is directly opposite
that of Proudhon, who considered it _"inevitable"_ that in a free society
_"the two functions of **Wage-Worker** on the one hand, and of **Proprietor-
Capitalist-Entrepreneur** on the other, become equal and inseparable in the
person of every worker"_. This was the _"first principle of the new economy, a
principle full of hope and of consolation for the worker without capital, but
a principle full of terror for the parasite and for the tools of parasitism,
who see reduced to naught their celebrated formula: **Capital, labour,
talent**!"_ [**Property is Theft!**, p. 535 and p. 289]

And it does seem a strange co-incidence that someone born into a capitalist
economy, ideologically supporting it with a passion and seeking to justify its
class system just happens to deduce from a given set of axioms that landlords
and capitalists happen to play a vital role in the economy! It would not take
too much time to determine if someone in a society without landlords or
capitalists would also logically deduce from the same axioms the pressing
economic necessity for such classes. Nor would it take long to ponder why
Greek philosophers, like Aristotle, concluded that slavery was natural. And it
does seem strange that centuries of coercion, authority, statism, classes and
hierarchies all had absolutely no impact on how society evolved, as the end
product of real history (the capitalist economy) just happens to be the same
as Rothbard's deductions from a few assumptions predict. Little wonder, then,
that "Austrian" economics seems more like rationalisations for some
ideologically desired result than a serious economic analysis.

Even some dissident "Austrian" economists recognise the weakness of Rothbard's
position. Thus _"Rothbard clearly misunderstands the general principle behind
producer co-operatives and self-management in general."_ In reality, _"[a]s a
democratic method of enterprise organisation, workers' self-management is, in
principle, fully compatible with a market system"_ and so _"a market economy
comprised of self-managed enterprises is consistent with Austrian School
theory . . . It is fundamentally a **market-based system** . . . that doesn't
seem to face the epistemological hurdles . . . that prohibit rational economic
calculation"_ under state socialism. Sadly, socialism is still equated with
central planning, for such a system _"is certainly not socialism. Nor,
however, is it capitalism in the conventional sense of the term."_ In fact, it
is not capitalism at all and if we assume that free access to resources such
as workplaces and credit, then it most definitely **is** socialism (_"Legal
ownership is not the chief issue in defining workers' self-management --
management is. Worker-managers, though not necessarily the legal owners of all
the factors of production collected within the firm, are free to experiment
and establish enterprise policy as they see fit."_). [David L. Prychitko,
**Op. Cit.**, p. 136, p. 135, pp. 4-5, p. 4 and p. 135] This suggests that
non-labour factors can be purchased from other co-operatives, credit provided
by mutual banks (credit co-operatives) at cost and so forth. As such, a
mutualist system is perfectly feasible.

Thus economic calculation based on competitive market prices is possible under
a socialist system. Indeed, we see examples of this even under capitalism. For
example, the Mondragon co-operative complex in the Basque Country indicate
that a libertarian socialist economy can exist and flourish. Perhaps it will
be suggested that an economy needs stock markets to price companies, as Mises
did. Thus investment is _"not a matter for the mangers of joint stock
companies, it is essentially a matter of the capitalists"_ in the _"stock
exchanges"_. Investment, he asserted, was _"not a matter of wages"_ of
managers but of _"the capitalist who buys and sell stocks and shares, who make
loans and recover them, who make deposits in the banks."_ [**Socialism**, p.
139]

It would be churlish to note that the members of co-operatives under
capitalism, like most working class people, are more than able to make
deposits in banks and arrange loans. In a mutualist economy, workers will not
loose this ability just because the banks are themselves co-operatives.
Similarly, it would be equally churlish but essential to note that the stock
market is hardly the means by which capital is actually raised within
capitalism. As David Engler points out, _"[s]upporters of the system . . .
claim that stock exchanges mobilise funds for business. Do they? When people
buy and sell shares, 'no investment goes into company treasuries . . . Shares
simply change hands for cash in endless repetition.' Company treasuries get
funds only from new equity issues. These accounted for an average of a mere
0.5 per cent of shares trading in the US during the 1980s."_ [**Apostles of
Greed**, pp. 157-158] This is echoed by David Ellerman:

> _"In spite of the stock market's large symbolic value, it is notorious that
it has relatively little to do with the production of goods and services in
the economy (the gambling industry aside). The overwhelming bulk of stock
transactions are in second-hand shares so that the capital paid for shares
usually goes to other stock traders, not to productive enterprises issuing new
shares."_ [**The Democratic Worker-Owned Firm**, p. 199]

This suggests that the _"efficient allocation of capital in production does
not require a stock market (witness the small business sector [under
capitalism])."_ _"Socialist firms,"_ he notes, _"are routinely attacked as
being inherently inefficient because they have no equity shares exposed to
market valuation. If this argument had any merit, it would imply that the
whole sector of unquoted closely-held small and medium-sized firms in the West
was 'inherently inefficient' -- a conclusion that must be viewed with some
scepticism. Indeed, in the comparison to large corporations with publicly-
traded shares, the closely-held firms are probably **more** efficient users of
capital."_ [**Op. Cit.**, p. 200 and p. 199]

In terms of the impact of the stock market on the economy there is good reason
to think that this **hinders** economic efficiency by generating a perverse
set of incentives and misleading information flows and so their abolition
would actually **aid** production and productive efficiency).

Taking the first issue, the existence of a stock market has serious (negative)
effects on investment. As Doug Henwood notes, there _"are serious
communication problems between managers and shareholders."_ This is because
_"[e]ven if participants are aware of an upward bias to earnings estimates [of
companies], and even if they correct for it, managers would still have an
incentive to try to fool the market. If you tell the truth, your accurate
estimate will be marked down by a sceptical market. So, it's entirely rational
for managers to boost profits in the short term, either through accounting
gimmickry or by making only investments with quick paybacks."_ So, managers
_"facing a market [the stock market] that is famous for its preference for
quick profits today rather than patient long-term growth have little choice
but to do its bidding. Otherwise, their stock will be marked down, and the
firm ripe for take-over."_ While _"[f]irms and economies can't get richer by
starving themselves"_ stock market investors _"can get richer when the
companies they own go hungry -- at least in the short term. As for the long
term, well, that's someone else's problem the week after next."_ [**Wall
Street**, p. 171]

Ironically, this situation has a parallel with Stalinist central planning.
Under that system the managers of State workplaces had an incentive to lie
about their capacity to the planning bureaucracy. The planner would, in turn,
assume higher capacity, so harming honest managers and encouraging them to
lie. This, of course, had a seriously bad impact on the economy.
Unsurprisingly, the similar effects caused by capital markets on economies
subject to them are as bad as well as downplaying long term issues and
investment. In addition, it should be noted that stock-markets regularly
experiences bubbles and subsequent bursts. Stock markets may reflect the
collective judgements of investors, but it says little about the quality of
those judgements. What use are stock prices if they simply reflect herd
mentality, the delusions of people ignorant of the real economy or who fail to
see a bubble? Particularly when the real-world impact when such bubbles burst
can be devastating to those uninvolved with the stock market?

In summary, then, firms are _"over-whelmingly self-financing -- that is, most
of their investment expenditures are funded through profits (about 90%, on
longer-term averages)"_ The stock markets provide _"only a sliver of
investment funds."_ There are, of course, some _"periods like the 1990s,
during which the stock market serves as a conduit for shovelling huge amounts
of cash into speculative venues, most of which have evaporated . . . Much,
maybe most, of what was financed in the 1990s didn't deserve the money."_ Such
booms do not last forever and are _"no advertisement for the efficiency of our
capital markets."_ [Henwood, **After the New Economy**, p. 187 and p. 188]

Thus there is substantial reason to question the suggestion that a stock
market is necessary for the efficient allocation of capital. There is no need
for capital markets in a system based on mutual banks and networks of co-
operatives. As Henwood concludes, _"the signals emitted by the stock market
are either irrelevant or harmful to real economic activity, and that the stock
market itself counts little or nothing as a source of finance. Shareholders .
. . have no useful role."_ [**Wall Street**, p. 292]

Then there is also the ironic nature of Rothbard's assertion that self-
management would ensure there _"could be no efficiency in production because
the requisite knowledge would be lacking."_ This is because capitalist firms
are hierarchies, based on top-down central planning, and this hinders the free
flow of knowledge and information. As with Stalinism, within the capitalist
firm information passes up the organisational hierarchy and becomes
increasingly simplified and important local knowledge and details lost (when
not deliberately falsified to ensure continual employment by suppressing bad
news). The top-management takes decisions based on highly aggregated data, the
quality of which is hard to know. The management, then, suffers from
information and knowledge deficiencies while the workers below lack sufficient
autonomy to act to correct inefficiencies as well as incentive to communicate
accurate information and act to improve the production process. As Cornelius
Castoriadis correctly noted:

> _"Bureaucratic planning is nothing but the extension to the economy as a
whole of the methods created and applied by capitalism in the 'rational'
direction of large production units. If we consider the most profound feature
of the economy, the concrete situation in which people are placed, we see that
bureaucratic planning is the most highly perfected realisation of the spirit
of capitalism; it pushes to the limit its most significant tendencies. Just as
in the management of a large capitalist production unit, this type of planning
is carried out by a separate stratum of managers . . . Its essence, like that
of capitalist production, lies in an effort to reduce the direct producers to
the role of pure and simple executants of received orders, orders formulated
by a particular stratum that pursues its own interests. This stratum cannot
run things well, just as the management apparatus . . . [in capitalist]
factories cannot run things well. The myth of capitalism's productive
efficiency at the level of the individual factory, a myth shared by bourgeois
and Stalinist ideologues alike, cannot stand up to the most elemental
examination of the facts, and any industrial worker could draw up a
devastating indictment against capitalist 'rationalisation' **judged on its
own terms.**_

> _"First of all, the managerial bureaucracy does not **know** what it is
supposed to be managing. The reality of production escapes it, for this
reality is nothing but the activity of the producers, and the producers do not
inform the managers . . . about what is really taking place. Quite often they
organise themselves in such a way that the managers won't be informed (in
order to avoid increased exploitation, because they feel antagonistic, or
quite simply because they have no interest: It isn't **their** business). _

> _"In the second place, the way in which production is organised is set up
entirely against the workers. They always are being asked, one way or another,
to do more work without getting paid for it. Management's orders, therefore,
inevitably meet with fierce resistance on the part of those who have to carry
them out."_ [**Political and Social Writings**, vol. 2, pp. 62-3]

This is _"the same objection as that Hayek raises against the possibility of a
planned economy. Indeed, the epistemological problems that Hayek raised
against centralised planned economies have been echoed within the socialist
tradition as a problem within the capitalist firm."_ There is _"a real
conflict within the firm that parallels that which Hayek makes about any
centralised economy."_ [John O'Neill, **The Market**, p. 142] This is because
workers have knowledge about their work and workplace that their bosses lack
and a self-managed co-operative workplace would motivate workers to use such
information to improve the firm's performance. In a capitalist workplace, as
in a Stalinist economy, the workers have no incentive to communicate this
information as _"improvements in the organisation and methods of production
initiated by workers essentially profit capital, which often then seizes hold
of them and turns them against the workers. The workers know it and
consequently they restrict their participation in production . . . They
restrict their output; they keep their ideas to themselves . . . They organise
among themselves to carry out their work, all the while keeping up a facade of
respect for the official way they are supposed to organise their work."_
[Castoriadis, **Op. Cit.**, pp. 181-2] An obvious example would be concerns
that management would seek to monopolise the workers' knowledge in order to
accumulate more profits, better control the workforce or replace them (using
the higher productivity as an excuse). Thus self-management rather than
hierarchy enhances the flow and use of information in complex organisations
and so improves efficiency.

This conclusion, it should be stressed, is not idle speculation and Mises was
utterly wrong in his assertions related to self-management. People, he stated,
_"err"_ in thinking that profit-sharing _"would spur the worker on to a more
zealous fulfilment of his duties"_ (indeed, it _"must lead straight to
Syndicalism"_) and it was _"nonsensical to give 'labour' . . . a share in
management. The realisation of such a postulate would result in syndicalism."_
[**Socialism**, p. 268, p. 269 and p. 305] Yet, as we note in [section
I.3.2](secI3.md#seci32), the empirical evidence is overwhelmingly against
Mises (which suggests why "Austrians" are so dismissive of empirical evidence,
as it exposes flaws in the great chains of deductive reasoning they so love).
In fact, workers' participation in management and profit sharing enhance
productivity. In one sense, though, Mises is right, in that capitalist firms
will tend not to encourage participation or even profit sharing as it shows to
workers the awkward fact that while the bosses may need them, they do not need
the bosses. As discussed in [section J.5.12](secJ5.md#secj512), bosses are
fearful that such schemes **will** lead to "syndicalism" and so quickly stop
them in order to remain in power -- in spite (or, more accurately, because) of
the efficiency and productivity gains they result in.

_"Both capitalism and state socialism,"_ summarises Ellerman, _"suffer from
the motivational inefficiency of the employment relation."_ **Op. Cit.**, pp.
210-1] Mutualism would be **more** efficient as well as freer for, once the
stock market and workplace hierarchies are removed, serious blocks and
distortions to information flow will be eliminated.

Unfortunately, the state socialists who replied to Mises in the 1920s and
1930s did not have such a libertarian economy in mind. In response to Mises
initial challenge, a number of economists pointed out that Pareto's disciple,
Enrico Barone, had already, 13 years earlier, demonstrated the theoretical
possibility of a _"market-simulated socialism."_ However, the principal attack
on Mises's argument came from Fred Taylor and Oscar Lange (for a collection of
their main papers, see **On the Economic Theory of Socialism**). In light of
their work, Hayek shifted the question from theoretical impossibility to
whether the theoretical solution could be approximated in practice. Which
raises an interesting question, for if (state) socialism is _"impossible"_ (as
Mises assured us) then what **did** collapse in Eastern Europe? If the
"Austrians" claim it **was** "socialism" then they are in the somewhat awkward
position that something they assure us is _"impossible"_ existed for decades.
Moreover, it should be noted that both sides of the argument accepted the idea
of central planning of some kind or another. This means that most of the
arguments of Mises and Hayek did not apply to libertarian socialism, which
rejects central planning along with every other form of centralisation.

Nor was the response by Taylor and Lange particularly convincing in the first
place. This was because it was based far more on neo-classical capitalist
economic theory than on an appreciation of reality. In place of the Walrasian
_"Auctioneer"_ (the "god in the machine" of general equilibrium theory which
ensures that all markets clear) Taylor and Lange presented the _"Central
Planning Board"_ whose job it was to adjust prices so that all markets
cleared. Neo-classical economists who are inclined to accept Walrasian theory
as an adequate account of a working capitalist economy will be forced to
accept the validity of their model of "socialism." Little wonder Taylor and
Lange were considered, at the time, the victors in the "socialist calculation"
debate by most of the economics profession (with the collapse of the Soviet
Union, this decision has been revised somewhat -- although we must point out
that Taylor and Lange's model was not the same as the Soviet system, a fact
conveniently ignored by commentators).

Unfortunately, given that Walrasian theory has little bearing to reality, we
must also come to the conclusion that the Taylor-Lange "solution" has about
the same relevance (even ignoring its non-libertarian aspects, such as its
basis in state-ownership, its centralisation, its lack of workers' self-
management and so on). Many people consider Taylor and Lange as fore-runners
of _"market socialism."_ This is incorrect -- rather than being market
socialists, they are in fact "neo-classical" socialists, building a
"socialist" system which mimics capitalist economic **theory** rather than its
**reality**. Replacing Walrus's mythical creation of the _"Auctioneer"_ with a
planning board does not really get to the heart of the problem! Nor does their
vision of "socialism" have much appeal -- a re-production of capitalism with a
planning board and a more equal distribution of money income. Anarchists
reject such "socialism" as little more than a nicer version of capitalism, if
that.

With the collapse of the Soviet Union, it has been fashionable to assert that
_"Mises was right"_ and that socialism is impossible (of course, **during**
the cold war such claims were ignored as the Soviet threat had to boosted and
used as a means of social control and to justify state aid to capitalist
industry). Nothing could be further from the truth as these countries were not
socialist at all and did not even approximate the (libertarian) socialist idea
(the only true form of socialism). The Stalinist countries had authoritarian
_"command economies"_ with bureaucratic central planning, and so their failure
cannot be taken as proof that a decentralised, libertarian socialism cannot
work. Nor can Mises' and Hayek's arguments against Taylor and Lange be used
against a libertarian mutualist or collectivist system as such a system is
decentralised and dynamic (unlike the "neo-classical" socialist model).
Libertarian socialism of this kind did, in fact, work remarkably well during
the Spanish Revolution in the face of amazing difficulties, with increased
productivity and output in many workplaces as well as increased equality and
liberty (see [section I.8](secI8.md)).

Thus the _"calculation argument"_ does not prove that socialism is impossible.
Mises was wrong in asserting that _"a socialist system with a market and
market prices is as self-contradictory as is the notion of a triangular
square."_ [**Human Action**, p. 706] This is because capitalism is not defined
by markets as such but rather by wage labour, a situation where working class
people do not have free access to the means of production and so have to sell
their labour (and so liberty) to those who do. If quoting Engels is not
**too** out of place, the _"object of production -- to produce commodities --
**does not import** to the instrument the character of capital"_ as the
_"production of commodities is one of the preconditions for the existence of
capital . . . as long as the producer sells only **what he himself** produces,
he is not a capitalist; he becomes so only from the moment he makes use of his
instrument **to exploit the wage labour of others**."_ [**Collected Works**,
Vol. 47, pp. 179-80] In this, as noted in [section C.2.1](secC2.md#secc21),
Engels was merely echoing Marx (who, in turn, was simply repeating Proudhon's
distinction between property and possession). As mutualism eliminates wage
labour by self-management and free access to the means of production, its use
of markets and prices (both of which pre-date capitalism) does not mean it is
not socialist (and as we note in [section G.1.1](secG1.md#secg11) Marx,
Engels, Bakunin and Kropotkin, like Mises, acknowledged Proudhon as being a
socialist). This focus on the market, as David Schweickart suggests, is no
accident:

> _"The identification of capitalism with the market is a pernicious error of
both conservative defenders of **laissez-faire** [capitalism] and most left
opponents . . . If one looks at the works of the major apologists for
capitalism . . . one finds the focus of the apology always on the virtues of
the market and on the vices of central planning. Rhetorically this is an
effective strategy, for it is much easier to defend the market than to defend
the other two defining institutions of capitalism. Proponents of capitalism
know well that it is better to keep attention toward the market and away from
wage labour or private ownership of the means of production."_ [_"Market
Socialism: A Defense"_, pp. 7-22, **Market Socialism: the debate among
socialists**, Bertell Ollman (ed.), p. 11]

The theoretical work of such socialists as David Schweickart (see his books
**Against Capitalism** and **After Capitalism**) present an extensive
discussion of a dynamic, decentralised market socialist system which has
obvious similarities with mutualism -- a link which some Leninists recognise
and stress in order to discredit market socialism via guilt-by-association
(Proudhon _"the anarchist and inveterate foe of Karl Marx . . . put forward a
conception of society, which is probably the first detailed exposition of a
'socialist market.'"_ [Hillel Ticktin, _"The Problem is Market Socialism"_,
pp. 55-80, **Op. Cit.**, p. 56]). So far, most models of market socialism have
not been fully libertarian, but instead involve the idea of workers' control
within a framework of state ownership of capital (Engler in **Apostles of
Greed** is an exception to this, supporting community ownership). Ironically,
while these Leninists reject the idea of market socialism as contradictory
and, basically, not socialist they usually acknowledge that the transition to
Marxist-communism under their workers' state would utilise the market.

So, as anarchist Robert Graham points out, _"Market socialism is but one of
the ideas defended by Proudhon which is both timely and controversial . . .
Proudhon's market socialism is indissolubly linked with his notions of
industrial democracy and workers' self-management."_ [_"Introduction"_, P-J
Proudhon, **General Idea of the Revolution**, p. xxxii] As we discuss in
[section I.3.5](secI3.md#seci35) Proudhon's system of agro-industrial
federations can be seen as a non-statist way of protecting self-management,
liberty and equality in the face of market forces (Proudhon, unlike
individualist anarchists, was well aware of the negative aspects of markets
and the way market forces can disrupt society). Dissident economist Geoffrey
M. Hodgson is right to suggest that Proudhon's system, in which _"each co-
operative association would be able to enter into contractual relations with
others"_, could be _"described as an early form of 'market socialism'"_. In
fact, _"instead of Lange-type models, the term 'market socialism' is more
appropriately used to refer to such systems. Market socialism, in this more
appropriate and meaningful sense, involves producer co-operatives that are
owned by the workers within them. Such co-operatives sell their products on
markets, with genuine exchanges of property rights"_ (somewhat annoyingly,
Hodgson incorrectly asserts that _"Proudhon described himself as an anarchist,
not a socialist"_ when, in reality, the French anarchist repeatedly referred
to himself and his mutualist system as socialist). [**Economics and Utopia**,
p. 20, p. 37 and p. 20]

Thus it is possible for a socialist economy to allocate resources using
markets. By suppressing capital markets and workplace hierarchies, a mutualist
system will improve upon capitalism by removing an important source of
perverse incentives which hinder efficient use of resources as well as long
term investment and social responsibility in addition to reducing inequalities
and increasing freedom. As David Ellerman once noted, many _"still look at the
world in bipolar terms: capitalism or (state) socialism."_ Yet there _"are two
broad traditions of socialism: **state socialism** and **self-management
socialism**. State socialism is based on government ownership of major
industry, while self-management socialism envisions firms being worker self-
managed and not owned or managed by the government."_ [**Op. Cit.**, p. 147]
Mutualism is a version of the second vision and anarchists reject the cosy
agreement between mainstream Marxists and their ideological opponents on the
propertarian right that only state socialism is "real" socialism.

Finally, it should be noted that most anarchists are not mutualists but rather
aim for (libertarian) communism, the abolition of money. Many do see a
mutualist-like system as an inevitable stage in a social revolution, the
transitional form imposed by the objective conditions facing a transformation
of a society marked by thousands of years of oppression and exploitation
(collectivist-anarchism contains elements of both mutualism and communism,
with most of its supporters seeing it as a transitional system). This is
discussed in [section I.2.2](secI2.md#seci22), while [section
I.1.3](secI1.md#seci13) indicates why most anarchists reject even non-
capitalist markets. So does Mises's argument mean that a socialism that
abolishes the market (such as libertarian communism) is impossible? Given that
the vast majority of anarchists seek a libertarian communist society, this is
an important question. We address it in the [next section](secI1.md#seci12).

## I.1.2 Is libertarian communism impossible?

In a word, no. While the _"calculation argument"_ (see [last
section](secI1.md#seci11)) is often used by propertarians (so-called right-
wing "libertarians") as **the** basis for the argument that communism (a
moneyless society) is impossible, it is based on certain false ideas of what
prices do, the nature of the market and how a communist-anarchist society
would function. This is hardly surprising, as Mises based his theory on a
variation of neo-classical economics and the Marxist social-democratic (and so
Leninist) ideas of what a "socialist" economy would look like. So there has
been little discussion of what a true (i.e. libertarian) communist society
would be like, one that utterly transformed the existing conditions of
production by workers' self-management and the abolition of both wage-labour
**and** money. However, it is useful here to indicate exactly why communism
would work and why the _"calculation argument"_ is flawed as an objection to
it.

Mises argued that without money there was no way a socialist economy would
make "rational" production decisions. Not even Mises denied that a moneyless
society could estimate what is likely to be needed over a given period of time
(as expressed as physical quantities of definite types and sorts of objects).
As he argued, _"calculation **in natura** in an economy without exchange can
embrace consumption-goods only."_ His argument was that the next step, working
out which productive methods to employ, would not be possible, or at least
would not be able to be done "rationally," i.e. avoiding waste and
inefficiency. The evaluation of producer goods _"can only be done with some
kind of economic calculation. The human mind cannot orient itself properly
among the bewildering mass of intermediate products and potentialities without
such aid. It would simply stand perplexed before the problems of management
and location."_ Thus we would quickly see _"the spectacle of a socialist
economic order floundering in the ocean of possible and conceivable economic
combinations without the compass of economic calculation."_ [_"Economic
Calculation in the Socialist Commonwealth"_, pp. 87-130, **Collectivist
Economic Planning**, F.A. von Hayek (ed.), p. 104, p. 103 and p. 110] Hence
the claim that monetary calculation based on market prices is the only
solution.

This argument is not without its force. How can a producer be expected to know
if tin is a better use of resources than iron when creating a product if all
they know is that iron and tin are available and suitable for their purpose?
Or, if we have a consumer good which can be made with A + 2B or 2A + B (where
A and B are both input factors such as steel, oil electricity, etc.) how can
we tell which method is more efficient (i.e. which one used least resources
and so left the most over for other uses)? With market prices, Mises' argued,
it is simple. If A cost $10 and B $5, then clearly method one would be the
most efficient ($20 versus $25). Without the market, Mises argued, such a
decision would be impossible and so every decision would be _"groping in the
dark."_ [**Op. Cit.**, p. 110]

Mises' argument rests on three flawed assumptions, two against communism and
one for capitalism. The first two negative assumptions are that communism
entails central planning and that it is impossible to make investment
decisions without money values. We discuss why each is wrong in this section.
Mises' positive assumption for capitalism, namely that markets allow exact and
efficient allocation of resources, is discussed in [section
I.1.5](secI1.md#seci15) .

Firstly, Mises assumes a centralised planned economy. As Hayek summarised, the
crux of the matter was _"the impossibility of a rational calculation in a
centrally directed economy from which prices are necessarily absent"_, one
which _"involves planning on a most extensive scale -- minute direction of
practically all productive activity by one central authority"_. Thus the _"one
central authority has to solve the economic problem of distributing a limited
amount of resources between a practically infinite number of competing
purposes"_ with _"a reasonable degree of accuracy, with a degree of success
equally or approaching the results of competitive capitalism"_ is what
_"constitutes the problem of socialism as a method."_ [_"The Nature and
History of the Problem"_, pp. 1-40, **Op. Cit.**, p. 35, p. 19 and pp. 16-7]

While this was a common idea in Marxian social democracy (and the Leninism
that came from it), centralised organisations are rejected by anarchism. As
Bakunin argued, _"where are the intellects powerful enough to embrace the
infinite multiplicity and diversity of real interests, aspirations, wishes,
and needs which sum up the collective will of the people? And to invent a
social organisation that will not be a Procrustean bed upon which the violence
of the State will more or less overtly force unhappy society to stretch out?"_
Moreover, a socialist government, _"unless it were endowed with omniscience,
omnipresence, and the omnipotence which the theologians attribute to God,
could not possibly know and foresee the needs of its people, or satisfy with
an even justice those interests which are most legitimate and pressing."_
[**Bakunin on Anarchism**, pp. 268-9 and p. 318] For Malatesta, such a system
would require _"immense centralisation"_ and would either be _"an impossible
thing to achieve, or, if possible, would end up as a colossal and very complex
tyranny."_ [**At the Café**, p. 65]

Kropotkin, likewise, dismissed the notion of central planning as the
_"economic changes that will result from the social revolution will be so
immense and so profound . . . that it will be impossible for one or even a
number of individuals to elaborate the social forms to which a further society
must give birth. The elaboration of new social forms can only be the
collective work of the masses."_ [**Words of a Rebel**, p. 175] The notion
that a _"strongly centralised Government"_ could _"**command** that a
prescribed quantity"_ of a good _"be sent to such a place on such a day"_ and
be _"received on a given day by a specified official and stored in particular
warehouses"_ was not only _"undesirable"_ but also _"wildly Utopian."_ During
his discussion of the benefits of free agreement against state tutelage,
Kropotkin noted that only the former allowed the utilisation of _"the co-
operation, the enthusiasm, the local knowledge"_ of the people. [**The
Conquest of Bread**, pp. 82-3 and p. 137]

Kropotkin's own experience had shown how the _"high functionaries"_ of the
Tsarist bureaucracy _"were simply charming in their innocent ignorance"_ of
the areas they were meant to be administrating and how, thanks to Marxism, the
socialist ideal had _"lost the character of something that had to be worked
out by the labour organisations themselves, and became state management of
industries -- in fact, state socialism; that is, state capitalism."_ As an
anarchist, he knew that governments become _"isolated from the masses"_ and so
_"the very success of socialism"_ required _"the ideas of no-government, of
self-reliance, of free initiative of the individual"_ to be _"preached side by
side with those of socialised ownership and production."_ Thus it was
essential that socialism was decentralised, federal and participatory, that
the _"structure of the society which we longed for"_ was _"worked out, in
theory and practice, from beneath"_ in by _"all labour unions"_ with _"a full
knowledge of local needs of each trade and each locality."_ [**Memoirs of a
Revolutionist**, p. 184, p. 360, p. 374-5 and p. 376] He reiterated this as
the Bolsheviks confirmed his warnings:

> _"The immense constructive work demanded by a social revolution cannot be
accomplished by a central government . . . It has need of knowledge, of brains
and of the voluntary collaboration of a host of local and specialised forces
which alone can attack the diversity of economic problems in their local
aspects . . . Socialism will certainly make considerable progress, and new
forms of more independent life will be created based on local autonomy and
free initiative . . . But the success of this reconstruction will depend in
great part on the possibility of direct cooperation between the different
peoples. To achieve that, it is necessary that . . . there should be a union
of all the workers' organisations of the world, federated to deliver world
production from its present subjection to capitalism."_ [**Anarchism**, pp.
255-6]

So anarchists can agree with Mises that central planning cannot work in
practice as its advocates hope. Or, more correctly, Mises agreed with the
anarchists, as we had opposed central planning first. We have long recognised
that no small body of people can be expected to know what happens in society
and plan accordingly (_"No single brain nor any bureau of brains can see to
this organisation."_ [Issac Puente, **Libertarian Communism**, p. 29]).
Moreover, there is the pressing question of freedom as well, for _"the
despotism of [the 'socialist'] State would be equal to the despotism of the
present state, increased by the economic despotism of all the capital which
would pass into the hands of the State, and the whole would be multiplied by
all the centralisation necessary for this new State. And it is for this reason
that we, the Anarchists, friends of liberty, we intend to fight them to the
end."_ [Carlo Cafiero, _"Anarchy and Communism"_, pp. 179-86, **The Raven**,
No. 6, p. 179]

As John O'Neill summarises, the _"argument against centralised planning is one
that has been articulated within the history of socialist planning as an
argument for democratic and decentralised decision making."_ [**The Market**,
p. 132] So, for good economic and political reasons, anarchists reject central
planning. This central libertarian socialist position feeds directly into
refuting Mises' argument, for while a **centralised** system would need to
compare a large (_"infinite"_) number of possible alternatives to a large
number of possible needs, this is not the case in a **decentralised** system.
Rather than a vast multitude of alternatives which would swamp a centralised
planning agency, one workplace comparing different alternatives to meet a
specific need faces a much lower number of possibilities as the objective
technical requirements (use-values) of a project are known and so local
knowledge will eliminate most of the options available to a small number which
can be directly compared.

As such, removing the assumption of a central planning body automatically
drains Mises' critique of much of its force -- rather than an _"the ocean of
possible and conceivable economic combinations"_ faced by a central body, a
specific workplace or community has a more limited number of possible
solutions for a limited number of requirements. Moreover, any complex machine
is a product of less complex goods, meaning that the workplace is a consumer
of other workplace's goods. If, as Mises admitted, a customer can decide
between consumption goods without the need for money then the user and
producer of a _"higher order"_ good can decide between consumption goods
required to meet their needs.

In terms of decision making, it is true that a centralised planning agency
would be swamped by the multiple options available to it. However, in a
decentralised socialist system individual workplaces and communes would be
deciding between a much smaller number of alternatives. Moreover, unlike a
centralised system, the individual firm or commune knows exactly what is
required to meet its needs, and so the number of possible alternatives is
reduced as well (for example, certain materials are simply technically
unsuitable for certain tasks).

Mises' other assumption is equally flawed. This is that without the market, no
information is passed between producers beyond the final outcome of
production. In other words, he assumed that the final product is all that
counts in evaluating its use. Needless to say, it is true that without more
information than the name of a given product it is impossible to determine
whether using it would be an efficient utilisation of resources. Yet more
information can be provided which can be used to inform decision making. As
socialists Adam Buick and John Crump point out, _"at the level of the
individual production unit or industry, the only calculations that would be
necessary in socialism would be calculations in kind. On the one side would be
recorded the resources (materials, energy, equipment, labour) used up in
production and on the other the amount of good produced, together with any by-
products. . . . Socialist production is simply the production of use values
from use values, and nothing more."_ [**State Capitalism: The Wages System
Under New Management**, p. 137] Thus any good used as an input into a
production process would require the communication of this kind of
information.

The generation and communication of such information implies a decentralised,
horizontal network between producers and consumers. This is because what
counts as a use-value can only be determined by those directly using it. Thus
the production of use-values from use-values cannot be achieved via central
planning, as the central planners have no notion of the use-value of the goods
being used or produced. Such knowledge lies in many hands, dispersed
throughout society, and so socialist production implies decentralisation.
Capitalist ideologues claim that the market allows the utilisation of such
dispersed knowledge, but as John O'Neill notes, _"the market may be one way in
which dispersed knowledge can be put to good effect. It is not . . . the only
way"_. _"The strength of the epistemological argument for the market depends
in part on the implausibility of assuming that all knowledge could be
centralised upon some particular planning agency"_ he stresses, but Mises'
_"argument ignores, however, the existence of the decentralised but
predominantly non-market institutions for the distribution of knowledge . . .
The assumption that only the market can co-ordinate dispersed non-vocalisable
knowledge is false."_ [**Op. Cit.**, p. 118 and p. 132]

So, in order to determine if a specific good is useful to a person, that
person needs to know its "cost." Under capitalism, the notion of cost has been
so associated with **price** that we have to put the word "cost" in quotation
marks. However, the real cost of, say, writing a book, is not a sum of money
but so much paper, so much energy, so much ink, so much human labour. In order
to make a rational decision on whether a given good is better for meeting a
given need than another, the would-be consumer requires this information.
However, under capitalism this information is **hidden** by the price.

Somewhat ironically, given how "Austrian" economics tends to stress that the
informational limitations are at the root of its _"impossibility"_ of
socialism, the fact is that the market hides a significant amount of essential
information required to make a sensible investment decision. This can be seen
from an analysis of Mises' discussion on why labour-time cannot replace money
as a decision-making tool. Using labour, he argued, _"leaves the employment of
material factors of production out of account"_ and presents an example of two
goods, P and Q, which take 10 hours to produce. P takes 8 hours of labour,
plus 2 units of raw material A (which is produced by an hour's socially
necessary labour). Q takes 9 hours of labour and one unit of A. He asserts
that in terms of labour P and Q _"are equivalent, but in value terms P is more
valuable than Q. The former is false, and only the later corresponds to the
nature and purpose of calculation."_ [_"Economic Calculation in the Socialist
Commonwealth"_, **Op. Cit.**, p. 113]

The flaw in his argument is clear. Assuming that an hour of socially necessary
labour is £10 then, in price terms, P would have £80 of direct labour costs,
with £20 of raw material A while Q would have £90 of direct labour and £10 of
A. Both cost £100 so it hard to see how this _"corresponds to the nature and
purpose of calculation"_! Using less of raw material A is a judgement made
**in addition** to _"calculation"_ in this example. The question of whether to
economise on the use of A simply cannot be made using prices. If P, for
example, can only be produced via a more ecologically destructive process than
Q or if the work process by which P is created is marked by dull, mindless
work but Q's is more satisfying for the people involved than Q may be
considered a better decision. Sadly, that kind of information is **not**
communicated by the price mechanism.

As John O'Neill points out, _"Mises' earlier arguments against socialist
planning turned on an assumption about commensurability. His central argument
was that rational economic decision-making required a single measure on the
basis of which the worth of alternative states of affairs could be calculated
and compared."_ [**Ecology, Policy and Politics**, p. 115] This central
assumption was unchallenged by Taylor and Lange in their defence of
"socialism", meaning that from the start the debate against Mises was
defensive and based on the argument that socialist planning could mimic the
market and produce results which were efficient from a capitalist point of
view.

Anarchists question whether using prices means basing all decision making on
one criterion and ignoring all others is a rational thing to do. As O'Neill
suggests, _"the relative scarcity of items . . . hardly exhaust the full gamut
of information that is distributed throughout society which might be relevant
to the co-ordination of economic activities and plans."_ [**The Market**, p.
196] Saying that a good costs £10 does not tell you much about the amount of
pollution its production or use generates, under what conditions of labour it
was produced, whether its price is affected by the market power of the firm
producing it, whether it is produced in an ecologically sustainable way, and
so forth. Similarly, saying that another, similar, good costs £9 does not tell
you whether than £1 difference is due to a more efficient use of inputs or
whether it is caused by imposing pollution onto the planet.

And do prices **actually** reflect costs? The question of profit, the reward
for owning capital and allowing others to use it, is hardly a cost in the same
way as labour, resources and so on (attempts to explain profits as an
equivalent sacrifice as labour have always been ridiculous and quickly
dropped). When looking at prices to evaluate efficient use for goods, you
cannot actually tell by the price if this is so. Two goods may have the same
price, but profit levels (perhaps under the influence of market power) may be
such that one has a higher cost price than another. The price mechanism fails
to indicate which uses least resources as it is influenced by market power.
Indeed, as Takis Fotopoulos notes, _"[i]f . . . both central planning and the
market economy inevitably lead to concentrations of power, then neither the
former nor the latter can produce the sort of information flows and incentives
which are necessary for the best functioning of any economic system."_
[**Towards an Inclusive Democracy**, p. 252] Moreover, a good produced under a
authoritarian state which represses its workforce could have a lower price
than one produced in a country which allowed unions to organise and has basic
human rights. The repression would force down the cost of labour, so making
the good in question appear as a more "efficient" use of resources. In other
words, the market can mask inhumanity as "efficiency" and actually reward that
behaviour by market share.

In other words, market prices can be horribly distorted in that they ignore
quality issues. Exchanges therefore occur in light of false information and,
moreover, with anti-social motivations -- to maximise short-term surplus for
the capitalists regardless of losses to others. Thus they distort valuations
and impose a crass, narrow and ultimately self-defeating individualism. Prices
are shaped by more than costs, with, for example, market power increasing
market prices far higher than actual costs. Market prices also fail to take
into account public goods and so bias allocation choices against them not to
mention ignoring the effects on the wider society, i.e. beyond the direct
buyers and sellers. Similarly, in order to make rational decisions relating to
using a good, you need to know **why** the price has changed for if a change
is permanent or transient implies different responses. Thus the current price
is not enough in itself. Has the good become more expensive temporarily, due,
say, to a strike? Or is it because the supply of the resource has been
exhausted? Actions that are sensible in the former situation will be wrong in
the other. As O'Neill suggests, _"the information [in the market] is passed
back without dialogue. The market informs by 'exit' -- some products find a
market, others do not. 'Voice' is not exercised. This failure of dialogue . .
. represents an informational failure of the market, not a virtue . . . The
market . . . does distribute information . . . it also blocks a great deal."_
[**Op. Cit.**, p. 99]

So a purely market-based system leaves out information on which to base
rational resource allocations (or, at the very least, hides it). The reason
for this is that a market system measures, at best, preferences of
**individual** buyers among the **available** options. This assumes that all
the pertinent use-values that are to be outcomes of production are things that
are to be consumed by the individual, rather than use-values that are
collectively enjoyed (like clean air). Prices in the market do not measure
social costs or externalities, meaning that such costs are not reflected in
the price and so you cannot have a rational price system. Similarly, if the
market measures only preferences amongst things that can be monopolised and
sold to individuals, as distinguished from values that are enjoyed
collectively, then it follows that information necessary for rational
decision-making in production is not provided by the market. In other words,
capitalist "calculation" fails because private firms are oblivious to the
social cost of their labour and raw materials inputs.

Indeed, prices often **mis**-value goods as companies can gain a competitive
advantage by passing costs onto society (in the form of pollution, for
example, or de-skilling workers, increasing job insecurity, and so on). This
externalisation of costs is actually rewarded in the market as consumers seek
the lowest prices, unaware of the reasons **why** it is lower (such
information cannot be gathered from looking at the price). Even if we assume
that such activity is penalised by fines later, the damage is still done and
cannot be undone. Indeed, the company may be able to weather the fines due to
the profits it originally made by externalising costs (see [section
E.3](secE3.md)). Thus the market creates a perverse incentive to subsidise
their input costs through off-the-book social and environmental externalities.
As Chomsky suggests:

> _"it is by now widely realised that the economist's 'externalities can no
longer be consigned to footnotes. No one who gives a moment's thought to the
problems of contemporary society can fail to be aware of the social costs of
consumption and production, the progressive destruction of the environment,
the utter irrationality of the utilisation of contemporary technology, the
inability of a system based on profit or growth-maximisation to deal with
needs that can only be expressed collectively, and the enormous bias this
system imposes towards maximisation of commodities for personal use in place
of the general improvement of the quality of life."_ [**Radical Priorities**,
pp. 190-1]

Prices hide the actual costs that production involved for the individual,
society, and the environment, and instead boils everything down into **one**
factor, namely price. There is a lack of dialogue and information between
producer and consumer.

Moreover, without using another means of cost accounting instead of prices how
can supporters of capitalism know there is a correlation between actual and
price costs? One can determine whether such a correlation exists by measuring
one against the other. If this cannot be done, then the claim that prices
measure costs is a tautology (in that a price represents a cost and we know
that it is a cost because it has a price). If it can be done, then we can
calculate costs in some other sense than in market prices and so the argument
that only market prices represent costs falls. Equally, there may be costs (in
terms of quality of life issues) which **cannot** be reflected in price terms.

Simply put, the market fails to distribute all relevant information and,
particularly when prices are at disequilibrium, can communicate distinctly
**misleading** information. In the words of two South African anarchists,
_"prices in capitalism provided at best incomplete and partial information
that obscured the workings of capitalism, and would generate and reproduce
economic and social inequalities. Ignoring the social character of the economy
with their methodological individualism, economic liberals also ignored the
social costs of particular choices and the question of externalities."_
[Michael Schmidt and Lucien van der Walt, **Black Flame**, p. 92] This
suggests that prices cannot be taken to reflect real costs any more that they
can reflect the social expression of the valuation of goods. They are the
result of a conflict waged over these goods and those that acted as their
inputs (including, of course, labour). Market and social power, much more than
need or resource usage, decides the issue. The inequality in the means of
purchasers, in the market power of firms and in the bargaining position of
labour and capital all play their part, so distorting any relationship a price
may have to its costs in terms of resource use. Prices are misshapen.

Little wonder Kropotkin asked whether _"are we not yet bound to analyse that
compound result we call price rather than to accept it as a supreme and blind
ruler of our actions?"_ [**Fields, Factories and Workshops Tomorrow**, p. 71]
It is precisely these **real** costs, hidden by price, which need to be
communicated to producers and consumers for them to make informed and rational
decisions concerning their economic activity.

It is useful to remember that Mises argued that it is the **complexity** of a
modern economy that ensures money is required: _"Within the narrow confines of
household economy, for instance, where the father can supervise the entire
economic management, it is possible to determine the significance of changes
in the processes of production, without such aids to the mind [as monetary
calculation], and yet with more or less of accuracy."_ However, _"the mind of
one man alone -- be it ever so cunning, is too weak to grasp the importance of
any single one among the countlessly many goods of higher order. No single man
can ever master all the possibilities of production, innumerable as they are,
as to be in a position to make straightway evident judgements of value without
the aid of some system of computation."_ [**Op. Cit.**, p. 102]

A libertarian communist society would, it must be stressed, use various _"aids
to the mind"_ to help individuals and groups to make economic decisions. This
would reduce the complexity of economic decision making, by allowing different
options and resources to be compared to each other. Hence the complexity of
economic decision making in an economy with a multitude of goods can be
reduced by the use of rational algorithmic procedures and methods to aid the
process. Such tools would aid decision making, not dominate it as these
decisions affect humans and the planet and should never be made automatically.

That being the case, a libertarian communist society would quickly develop the
means of comparing the real impact of specific _"higher order"_ goods in terms
of their real costs (i.e. the amount of labour, energy and raw materials used
plus any social and ecological costs). Moreover, it should be remembered that
production goods are made up on inputs of other goods, that is, higher goods
are made up of consumption goods of a lower order. If, as Mises admits,
calculation without money is possible for consumption goods then the creation
of _"higher order"_ goods can be also achieved and a record of its costs made
and communicated to those who seek to use it.

While the specific _"aids to the mind"_ as well as "costs" and their relative
weight would be determined by the people of a free society, we can speculate
that it would include direct and indirect labour, externalities (such as
pollution), energy use and materials, and so forth. As such, it must be
stressed that a libertarian communist society would seek to communicate the
"costs" associated with any specific product as well as its relative scarcity.
In other words, it needs a means of determining the objective or absolute
costs associated with different alternatives as well as an indication of how
much of a given good is available at a given it (i.e., its scarcity). Both of
these can be determined without the use of money and markets.

[Section I.4](secI4.md) discusses possible frameworks for an anarchist
economy, including suggestions for libertarian communist economic decision-
making processes. In terms of _"aids to the mind"_, these include methods to
compare goods for resource allocation by indicating the absolute costs
involved in producing a good and the relative scarcity of a specific good,
among other things. Such a framework is necessary because _"an appeal to a
necessary role for practical judgements in decision making is **not** to deny
any role to general principles. Neither . . . does it deny any place for the
use of technical rules and algorithmic procedures . . . Moreover, there is a
necessary role for rules of thumb, standard procedures, the default procedures
and institutional arrangements that can be followed unreflectively and which
**reduce** the scope for **explicit** judgements comparing different states of
affairs. There are limits in time, efficient use of resources and the
dispersal of knowledge which require rules and institutions. Such rules and
institutions can free us for space and time for reflective judgements where
they matter most."_ [John O'Neill, **Ecology, Policy and Politics**, pp.
117-8] It is these _"rules and institutions need themselves to be open to
critical and reflective appraisal."_ [O'Neill, **The Market**, p. 118]

Economic decisions, in other words, cannot be reduced down to one factor yet
Mises argued that anyone _"who wished to make calculations in regard to a
complicated process of production will immediately notice whether he has
worked more economically than others or not; if he finds, from reference to
the exchange values obtaining in the market, that he will not be able to
produce profitably, this shows that others understand how to make better use
of the higher-order goods in question."_ [**Op. Cit.**, pp. 97-8] However,
this only shows whether someone has worked more **profitably** than others,
not whether it is more economical. Market power automatically muddles this
issue, as does the possibility of reducing the monetary cost of production by
recklessly exploiting natural resources and labour, polluting, or otherwise
passing costs onto others. Similarly, the issue of wealth inequality is
important, for if the production of luxury goods proves more profitable than
basic essentials for the poor does this show that producing the former is a
better use of resources? And, of course, the key issue of the relative
strength of market power between workers and capitalists plays a key role in
determining "profitably."

Basing your economic decision making on a single criteria, namely
profitability, can, and does, lead to perverse results. Most obviously, the
tendency for capitalists to save money by not introducing safety equipment
(_"To save a dollar the capitalist build their railroads poorly, and along
comes a train, and loads of people are killed. What are their lives to him, if
by their sacrifice he has saved money?"_ [Emma Goldman, **A Documentary
History of the American Years**, vol. 1, p. 157]). Similarly, it is considered
a more "efficient" use of resources to condemn workers to deskilling and
degrading work than "waste" resources in developing machines to eliminate or
reduce it (_"How many machines remain unused solely because they do not return
an immediate profit to the capitalist! . . . How many discoveries, how many
applications of science remain a dead letter solely because they don't bring
the capitalist enough!"_ [Carlo Cafiero, _"Anarchy and Communism"_, pp.
179-86, **The Raven**, No. 6, p. 182]). Similarly, those investments which
have a higher initial cost but which, in the long run, would have, say, a
smaller environmental impact would not be selected in a profit-driven system.

This has seriously irrational effects, because the managers of capitalist
enterprises are obliged to choose technical means of production which produce
the cheapest results. All other considerations are subordinate, in particular
the health and welfare of the producers and the effects on the environment.
The harmful effects resulting from "rational" capitalist production methods
have long been pointed out. For example, speed-ups, pain, stress, accidents,
boredom, overwork, long hours and so on all harm the physical and mental
health of those involved, while pollution, the destruction of the environment,
and the exhaustion of non-renewable resources all have serious effects on both
the planet and those who live on it. As green economist E. F. Schumacher
argued:

> _"But what does it **mean** when we say that something is uneconomic? . . .
[S]omething is uneconomic when it fails to earn an adequate profit in terms of
money. The method of economics does not, and cannot, produce any other meaning
. . . The judgement of economics . . . is an extremely **fragmentary**
judgement; out of the large number of aspects which in real life have to be
seen and judged together before a decision can be taken, economics supplies
only one -- whether a money profit accrues **to those who undertake it** or
not."_ [**Small is Beautiful**, pp. 27-8]

Schumacher stressed that _"about the **fragmentary** nature of the judgements
of economics there can be no doubt whatever. Even with the narrow compass of
the economic calculus, these judgements are necessarily and **methodically**
narrow. For one thing, they give vastly more weight to the short than to the
long term. . . [S]econd, they are based on a definition of cost which excludes
all 'free goods' . . . [such as the] environment, except for those parts that
have been privately appropriated. This means that an activity can be economic
although it plays hell with the environment, and that a competing activity, if
at some cost it protects and conserves the environment, will be uneconomic."_
Moreover, _"[d]o not overlook the words 'to those who undertake it.' It is a
great error to assume, for instance, that the methodology of economics is
normally applied to determine whether an activity carried out by a group
within society yields a profit to society as a whole."_ [**Op. Cit.**, p. 29]

To claim that prices include all these "externalities" is nonsense. If they
did, we would not see capital moving to third-world countries with few or no
anti-pollution or labour laws. At best, the "cost" of pollution would only be
included in a price if the company was sued successfully in court for damages
-- in other words, once the damage is done. Ultimately, companies have a
strong interest in buying inputs with the lowest prices, regardless of **how**
they are produced. In fact, the market rewards such behaviour as a company
which was socially responsible would be penalised by higher costs, and so
market prices. It is reductionist accounting and its accompanying _"ethics of
mathematics"_ that produces the _"irrationality of rationality"_ which plagues
capitalism's exclusive reliance on prices (i.e. profits) to measure
"efficiency."

Ironically enough, Mises also pointed to the irrational nature of the price
mechanism. He stated (correctly) that there are _"extra-economic"_ elements
which _"monetary calculation cannot embrace"_ because of _"its very nature."_
He acknowledged that these _"considerations themselves can scarcely be termed
irrational"_ and, as examples, listed _"[i]n any place where men regard as
significant the beauty of a neighbourhood or a building, the health, happiness
and contentment of mankind, the honour of individuals or nations."_ He also
noted that _"they are just as much motive forces of rational conduct as are
economic factors"_ but they _"do not enter into exchange relationships."_ How
rational is an economic system which ignores the _"health, happiness and
contentment"_ of people? Or the beauty of their surroundings? Which, moreover,
penalises those who take these factors into consideration? For anarchists,
Mises comments indicate well the inverted logic of capitalism. That Mises can
support a system which ignores the needs of individuals, their happiness,
health, surroundings, environment and so on by _"its very nature"_ says a lot.
His suggestion that we assign monetary values to such dimensions begs the
question and has plausibility only if it assumes what it is supposed to prove.
[**Op. Cit.**, p. 99-100] Indeed, the person who would put a price on
friendship would have no friends as they simply do not understand what
friendship is and are thereby excluded from much which is best in human life.
Likewise for other _"extra-economic"_ goods that individuals value, such as
beautiful places, happiness, the environment and so on.

So essential information required for sensible decision making would have to
be recorded and communicated in a communist society and used to evaluate
different options using agreed methods of comparison. This differs drastically
from the price mechanism as it recognises that mindless, automatic calculation
is impossible in social choices. Such choices have an unavoidable ethical and
social dimension simply because they involve other human beings and the
environment. As Mises himself acknowledged, monetary calculation does not
capture such dimensions.

We, therefore, need to employ practical judgement in making choices aided by a
full understanding of the **real** social and ecological costs involved using,
of course, the appropriate _"aids to the mind."_ Given that an anarchist
society would be complex and integrated, such aids would be essential but, due
to its decentralised nature, it need not embrace the price mechanism. It can
evaluate the efficiency of its decisions by looking at the **real** costs
involved to society rather than embrace the distorted system of costing
explicit in the price mechanism (as Kropotkin once put it, _"if we analyse
**price**"_ we must _"make a distinction between its different elements"_.
[**Op. Cit.**, p. 72]).

In summary, then, Mises considered only central planning as genuine socialism,
meaning that a decentralised communism was not addressed. Weighting up the
pros and cons of how to use millions of different goods in the millions of
potential situations they could be used would be impossible in a centralised
system, yet in decentralised communism this is not an issue. Each individual
commune and syndicate would be choosing from the few alternatives required to
meet their needs. With the needs known, the alternatives can be compared --
particularly if agreed criteria (_"aids to the mind"_) are utilised and the
appropriate agreed information communicated.

Efficient economic decision making in a moneyless "economy" is possible,
assuming that sufficient information is passed between syndicates and communes
to evaluate the relative and absolute costs of a good. Thus, decisions can be
reached which aimed to reduce the use of goods in short supply or which take
large amounts of resources to produce (or which produce large externalities to
create). While a **centralised** system would be swamped by the large number
of different uses and combinations of goods, a **decentralised** communist
system would not be.

Thus, anarchists argue that Mises was wrong. Communism **is** viable, but only
if it is **libertarian** communism. Ultimately, though, the real charge is not
that socialism is _"impossible"_ but rather that it would be inefficient,
i.e., it would allocate resources such that too much is used to achieve
specified goals and that there would be no way to check that the allocated
resources were valued sufficiently to warrant their use in the first place.
While some may portray this as a case of planning against markets (no-
planning), this is false. Planning occurs in capitalism (as can be seen from
any business), it is a question of whether capitalism ensures that more plans
can be co-ordinated and needs meet by means of relative prices and profit-loss
accounting than by communism (free access and distribution according to need).
As such, the question is does the capitalist system add additional problems to
the efficient co-ordination of plans? Libertarian communists argue, yes, it
does (as we discuss at length in [section I.1.5](secI1.md#seci15) ).

All choices involve lost possibilities, so the efficient use of resources is
required to increase the possibilities for creating other goods. At best, all
you can say is that by picking options which cost the least a market economy
will make more resources available for other activities. Yet this assumption
crucially depends equating "efficient" with profitable, a situation which
cannot be predicted beforehand and which easily leads to inefficient
allocation of resources (particularly if we are looking at meeting human
needs). Then there are the costs of using money for if we are talking of
opportunity costs, of the freeing up of resources for other uses, then the
labour and other resources used to process money related activities should be
included. While these activities (banking, advertising, defending property,
and so forth) are essential to a capitalist economy, they are not needed and
unproductive from the standpoint of producing use values or meeting human
need. This would suggest that a libertarian communist economy would have a
productive advantage over a capitalist economy as the elimination of this
structural waste intrinsic to capitalism will free up a vast amount of labour
and materials for socially useful production. This is not to mention the so-
called "costs" which are no such thing, but relate to capitalist property
rights. Thus "rent" may be considered a cost under capitalism, but would
disappear if those who used a resource controlled it rather than pay a tribute
to gain access to it. As Kropotkin argued, _"the capitalist system makes us
pay for everything three or four times its labour value"_ thanks to rent,
profit, interest and the actions of middle men. Such system specific "costs"
hide the actual costs (in terms of labour and resource use) by increasing the
price compared to if we _"reckon our expenses in labour"_. [**Op. Cit.**, p.
68]

Moreover, somewhat ironically, this "economising" of resources which the
market claims to achieve is not to conserve resources for future generations
or to ensure environmental stability. Rather, it is to allow **more** goods to
be produced in order to accumulate more capital. It could be argued that the
market forces producers to minimise costs on the assumption that lower costs
will be more likely to result in higher profits. However, this leaves the
social impact of such cost-cutting out of the equation. For example, imposing
externalities on others does reduce a firm's prices and, as a result, is
rewarded by the market however alienating and exhausting work or rising
pollution levels does not seem like a wise thing to do. So, yes, it is true
that a capitalist firm will seek to minimise costs in order to maximise
profits. This, at first glance, could be seen as leading to an efficient use
of resources until such time as the results of this become clear. Thus goods
could be created which do not last as long as they could, which need constant
repairing, etc. So a house produced "efficiently" under capitalism could be a
worse place to live simply because costs were reduced by cutting corners (less
insulation, thinner walls, less robust materials, etc.). In addition, the
collective outcome of all these "efficient" decisions could be socially
inefficient as they reduce the quality of life of those subject to them as
well as leading to over-investment, over-production, falling profits and
economic crisis. As such, it could be argued that Mises' argument exposes more
difficulties for capitalism rather than for anarchism.

Finally, it should be noted that most anarchists would question the criteria
Hayek and Mises used to judge the relative merits of communism and capitalism.
As the former put it, the issue was _"a distribution of income independent of
private property in the means of production and a volume of output which was
at least approximately the same or even greater than that procured under free
competition."_ [_"The Nature and History of the Problem"_, **Op. Cit.**, p.
37] Thus the issue is reduced to that of output (quantity), not issues of
freedom (quality). If slavery or Stalinism **had** produced more output than
free market capitalism, that would not make either system desirable This was,
in fact, a common argument against Stalinism during the 1950s and 1960s when
it **did** appear that central planning was producing more goods (and,
ironically, by the propertarian right against the welfare state for, it should
be remembered, that volume of output, like profitability and so "efficiency",
in the market depends on income distribution and a redistribution from rich to
poor could easily result in more output becoming profitable). Similarly, that
capitalism produces more alcohol and Prozac to meet the higher demand for
dulling the minds of those trying to survive under it would **not** be an
argument against libertarian communism! As we discuss in [section
I.4](secI4.md), while anarchists seek to meet material human needs we do not
aim, as under capitalism, to sacrifice all other goals to that aim as
capitalism does. Thus, to state the obvious, the aim for maximum volume of
output only makes sense under capitalism as the maximum of human happiness and
liberty may occur with a lower volume of output in a free society. The people
of a society without oppression, exploitation and alienation will hardly act
in identical ways, nor seek the same volume of output, as those in one, like
capitalism, marked by those traits!

Moreover, the volume of output is a somewhat misleading criteria as it totally
ignores its distribution. If the bulk of that volume goes to a few, then that
is hardly a good use of resources. This is hardly an academic concern as can
be seen from the Hayek influenced neo-liberalism of the 1980s onwards. As
economist Paul Krugman notes, the value of the output of an average worker
_"has risen almost 50 percent since 1973. Yet the growing concentration of
income in the hands of a small minority had proceeded so rapidly that we're
not sure whether the typical American has gained anything from rising
productivity."_ This means that wealth has flooded upwards, and _"the lion's
share of economic growth in America over the past thirty years has gone to a
small, wealthy minority."_ [**The Conscience of a Liberal**, p. 124 and p.
244]

To conclude. Capitalist "efficiency" is hardly rational and for a fully human
and ecological efficiency libertarian communism is required. As Buick and
Crump point out, _"socialist society still has to be concerned with using
resources efficiently and rationally, but the criteria of 'efficiency' and
'rationality' are not the same as they are under capitalism."_ [**Op. Cit.**,
p. 137] Under communist-anarchism, the decision-making system used to
determine the best use of resources is not more or less "efficient" than
market allocation, because it goes beyond the market-based concept of
"efficiency." It does not seek to mimic the market but to do what the market
fails to do. This is important, because the market is not the rational system
its defenders often claim. While reducing all decisions to one common factor
is, without a doubt, an easy method of decision making, it also has serious
side-effects **because** of its reductionistic basis. The market makes
decision making simplistic and generates a host of irrationalities and
dehumanising effects as a result. So, to claim that communism will be "more"
efficient than capitalism or vice versa misses the point. Libertarian
communism will be "efficient" in a totally different way and people will act
in ways considered "irrational" only under the narrow logic of capitalism.

For another critique of Mises, see Robin Cox's _"The 'Economic Calculation'
controversy: unravelling of a myth"_ [**Common Voice**, Issue 3]

## I.1.3 What is wrong with markets anyway?

A lot. Markets soon result in what are termed _"market forces,"_ impersonal
forces which ensure that the people in the economy do what is required of them
in order for the economy to function. The market system, in capitalist
apologetics, is presented to appear as a regime of freedom where no one forces
anyone to do anything, where we "freely" exchange with others as we see fit.
However, the facts of the matter are somewhat different, since the market
often ensures that people act in ways **opposite** to what they desire or
forces them to accept "free agreements" which they may not actually desire.
Wage labour is the most obvious example of this, for, as we indicated in
[section B.4](secB4.md), most people have little option but to agree to work
for others.

We must stress here that not all anarchists are opposed to the market.
Individualist anarchists favour it while Proudhon wanted to modify it while
retaining competition. For many, the market equals capitalism but this is not
the case as it ignores the fundamental issue of (economic) class, namely who
owns the means of production. Capitalism is unique in that it is based on wage
labour, i.e. a market for labour as workers do not own their own means of
production and have to sell themselves to those who do. Thus it is entirely
possible for a market to exist within a society and for that society **not**
to be capitalist. For example, a society of independent artisans and peasants
selling their product on the market would not be capitalist as workers would
own and control their means of production. Similarly, Proudhon's competitive
system of self-managed co-operatives and mutual banks would be non-capitalist
(and socialist) for the same reason. Anarchists object to capitalism due to
the quality of the social relationships it generates between people (i.e. it
generates authoritarian ones). If these relationships are eliminated then the
kinds of ownership which do so are anarchistic. Thus the issue of ownership
matters only in-so-far it generates relationships of the desired kind (i.e.
those based on liberty, equality and solidarity). To concentrate purely on
"markets" or "property" means to ignore social relationships and the key
aspect of capitalism, namely wage labour. That right-wingers do this is
understandable (to hide the authoritarian core of capitalism) but why
(libertarian or other) socialists should do so is less clear.

In this section of the FAQ we discuss anarchist objections to the market **as
such** rather than the capitalist market. The workings of the market do have
problems with them which are independent of, or made worse by, the existence
of wage-labour. It is these problems which make most anarchists hostile to the
market and so desire a (libertarian) communist society. So, even if we assume
a mutualist (a libertarian market-socialist) system of competing self-managed
workplaces, then communist anarchists would argue that market forces would
soon result in many irrationalities occurring.

Most obviously, operating in a market means submitting to the profit
criterion. This means that however much workers might want to employ social
criteria in their decision making, they cannot. To ignore profitability would
cause their firm to go bankrupt. Markets, therefore, create conditions that
compel producers to decide things which are not be in their, or others,
interest, such as introducing deskilling or polluting technology, working
longer hours, and so on, in order to survive on the market. For example, a
self-managed workplace will be more likely to invest in safe equipment and
working practices, this would still be dependent on finding the money to do so
and may still increase the price of their finished product. So we could point
to the numerous industrial deaths and accidents which are due to market forces
making it unprofitable to introduce adequate safety equipment or working
conditions, (conservative estimates for industrial deaths in the USA are
between 14,000 and 25,000 per year plus over 2 million disabled), or to
increased pollution and stress levels which shorten life spans.

This tendency for self-managed firms to adjust to market forces by increasing
hours, working more intensely, allocating resources to accumulating equipment
rather than leisure time or consumption can be seen in co-operatives under
capitalism. While lacking bosses may reduce this tendency in a post-capitalist
economy, it will not eliminate it. This is why many socialists, including
anarchists, call the way markets force unwilling members of co-operatives to
make such unpleasant decisions a form of "self-exploitation" (although this is
somewhat misleading, as there no exploitation in the capitalist sense of
owners appropriating unpaid labour). For communist-anarchists, a market system
of co-operatives _"has serious limitations"_ as _"a collective enterprise is
not necessarily a commune -- nor is it necessarily communistic in its
outlook."_ This is because it can end up _"competing with like concerns for
resources, customers, privileges, and even profits"_ as they _"become a
particularistic interest"_ and _"are subjected to the same social pressures by
the market in which they must function."_ This _"tends increasingly to
encroach on their higher ethical goals -- generally, in the name of
'efficiency', and the need to 'grow' if they are to survive, and the
overwhelming temptation to acquire larger earnings."_ [Murray Bookchin,
**Remaking Society**, pp. 193-4]

Similarly, a market of self-managed firms would still suffer from booms and
slumps as the co-operatives response to changes in prices would still result
in over-production (see [section C.7.2](secC7.md#secc72) ) and over-
investment (see [section C.7.3](secC7.md#secc73)). While the lack of non-
labour income would help reduce the severity of the business cycle, it seems
unlikely to eliminate it totally. Equally, many of the problems of market-
increased uncertainty and the destabilising aspects of price signals discussed
in [section I.1.5](secI1.md#seci15) are just as applicable to all markets,
including post-capitalist ones.

This is related to the issue of the _"tyranny of small decisions"_ we
highlighted in [section B.6](secB6.md). This suggests that the aggregate
effect of individual decisions produces social circumstances which are
irrational and against the interests of those subject to them. This is the
case with markets, where competition results in economic pressures which force
its participants to act in certain ways, ways they would prefer not to do but,
as isolated individuals or workplaces, end up doing due to market forces. In
markets, it is rational for people try to buy cheap and sell dear. Each tries
to maximise their income by either minimising their costs or maximising their
prices, not because they particularly want to but because they need to as
taking into account other priorities is difficult as there is no means of
finding them out and deeply inadvisable as it is competitively suicidal as it
places burdens on firms which their competitors need not face.

As we noted in [section E.3](secE3.md), markets tend to reward those who act
in anti-social ways and externalise costs (in terms of pollution and so on).
In a market economy, it is impossible to determine whether a low cost reflects
actual efficiency or a willingness to externalise, i.e., impose costs on
others. Markets rarely internalise external costs. Two economic agents who
strike a market-rational bargain between themselves need not consider the
consequences of their bargain for other people outside their bargain, nor the
consequences for the earth. In reality, then, market exchanges are never
bilateral agreements as their effects impact on the wider society (in terms
of, say, pollution, inequality and so on). This awkward fact is ignored in the
market. As the left-wing economist Joan Robinson put it: _"In what industry,
in what line of business, are the true social costs of the activity registered
in its accounts? Where is the pricing system that offers the consumer a fair
choice between air to breath and motor cars to drive about in?"_
[**Contribution to Modern Economics**, p. 10]

While, to be fair, there will be a reduced likelihood for a workplace of self-
employed workers to pollute their own neighbourhoods in a free society, the
competitive pressures and rewards would still be there and it seems unlikely
that they will be ignored, particularly if survival on the market is at stake
so communist-anarchists fear that while not having bosses, capitalists and
landlords would mitigate some of the irrationalities associated with markets
under capitalism, it will not totally remove them. While the market may be
free, people would not be.

Even if we assume that self-managed firms resist the temptations and pressures
of the market, any market system is also marked by a continuing need to expand
production and consumption. In terms of environmental impact, a self-managed
firm must still make profits in order to survive and so the economy must grow.
As such, every market system will tend to expand into an environment which is
of fixed size. As well as placing pressure on the planet's ecology, this need
to grow impacts on human activity as it also means that market forces ensure
that work continually has to expand. Competition means that we can never take
it easy, for as Max Stirner argued, _"[r]estless acquisition does not let us
take breath, take a calm **enjoyment**. We do not get the comfort of our
possessions . . . Hence it is at any rate helpful that we come to an agreement
about **human** labours that they may not, as under competition, claim all our
time and toil."_ [**The Ego and Its Own**, p. 268] Value needs to be created,
and that can only be done by labour and so even a non-capitalist market system
will see work dominate people's lives. Thus the need to survive on the market
can impact on broader (non-monetary) measures of welfare, with quality of life
falling as a higher GDP is created as the result of longer working hours with
fewer holidays. Such a regime may, perhaps, be good for material wealth but it
is not great for people.

The market can also block the efficient use of resources. For example, for a
long time energy efficient light-bulbs were much more expensive than normal
ones. Over the long period, however, they used far less energy than normal
ones, meaning less need to produce more energy (and so burn coal and oil, for
example). However, the high initial price ensured that most people continued
to use the less efficient bulbs and so waste resources. Much the same can be
said of alternative forms of energy, with investment in (say) wind energy
ignored in favour of one-use and polluting energy sources. A purely market
system would not allow decisions which benefit the long-term interests of
people to be made (for example, by distributing energy-efficient light-bulbs
freely or at a reduced cost) as these would harm the profits of those co-
operatives which tried to do so.

Also, markets do not reflect the values of things we do not put a price upon
(as we argued in [section B.5](secB5.md)). It cannot protect wilderness, for
example, simply because it requires people to turn it into property and sell
it as a commodity. If you cannot afford to visit the new commodity, the market
turns it into something else, no matter how much you value it. The market also
ignores the needs of future generations as they always discount the value of
the long term future. A payment to be made 1,000 years from now (a mere speck
in geological time) has a market value of virtually zero according to any
commonly used discount rate. Even 50 years in the future cannot be adequately
considered as competitive pressures force a short term perspective on people
harmful to present and future generations, plus the ecology of the planet.

Then there are corrosive effects of the market on human personalities. As we
have argued elsewhere (see [section B.1.3](secB1.md#secb13) ), competition
in a free market creates numerous problems -- for example, the creation of an
_"ethics of mathematics"_ and the strange inversion of values in which things
(property/money) become more important than people. This can have a de-
humanising effect, with people becoming cold-hearted calculators who put
profits before people. This can be seen in capitalism, where economic
decisions are far more important than ethical ones -- particularly as such an
inhuman mentality can be rewarded on the market. Merit does not necessarily
breed success, and the successful do not necessarily have merit. The truth is
that, in the words of Noam Chomsky, _"wealth and power tend to accrue to those
who are ruthless, cunning, avaricious, self-seeking, lacking in sympathy and
compassion, subservient to authority and willing to abandon principle for
material gain, and so on . . . Such qualities might be just the valuable ones
for a war of all against all."_ [**For Reasons of State**, pp. 139-140]

Needless to be said, if the market does reward such people with success it can
hardly be considered as a **good** thing. A system which elevates making money
to the position of the most important individual activity will obviously
result in the degrading of human values and an increase in neurotic and
psychotic behaviour. Little wonder, as Alfie Kohn has argued, competition can
have serious negative effects on us outside of work, with it damaging both our
personal psychology and our interpersonal relationships. Thus competition
_"itself is responsible for the development of a lower moral standard"_ which
places winning at any cost above fairness and justice. Kohn quotes Nathan
Ackerman, the father of family therapy, who noted that the _"strife of
competition reduces empathic sympathy, distorts communication, impairs the
mutuality of support and sharing, and decreases the satisfaction of personal
need."_ [**No Contest**, p. 163 and pp. 142-3] Thus, the market can impoverish
us as individuals, sabotaging self-esteem, promoting conformity, ruining
relationships and making us less than what we could be. This is a problem of
markets as such, not only capitalist ones and so non-capitalist markets could
make us less human and more a robot.

All market decisions are crucially conditioned by the purchasing power of
those income groups that can back their demands with money. Not everyone can
work (the sick, the very old, children and so forth) and for those who can,
personal circumstances may impact on their income. Moreover, production has
become so interwoven that it _"is utterly impossible to draw a distinction
between the work of each"_ and so we should _"put the **needs** above the
**works**, and first of all to recognise **the right to live**, and later on
**the right to well-being** for all those who took their share in
production."_ This is particularly the case as _"the needs of the individual,
do not always correspond to his **works**"_ \-- for example, _"a man of forty,
father of three children, has other needs than a young man of twenty"_ and
_"the woman who suckles her infant and spends sleepless nights at its bedside,
cannot do as much **work** as the man who has slept peacefully."_ [Kropotkin,
**Conquest of Bread**, p. 170 and p. 171] This was why communist-anarchists
like Kropotkin stressed the need not only to abolish wage-labour but also
money, the wages system.

So it goes without saying that purchasing power (demand) and need are not
related, with people often suffering simply because they do not have the money
required to purchase, say, health care, housing or food for themselves or
their families. While economic distress may be less in a non-capitalist market
system, it still would exist as would the fear of it. The market is a
continuous bidding for goods, resources, and services, with those who have the
most purchasing power the winners. This means that the market system is the
worst one for allocating resources when purchasing power is unequally
distributed (this is why orthodox economists make the convenient assumption of
a _"given distribution of income"_ when they try to show that a capitalist
allocation of resources is the best one via _"Pareto optimality"_). While a
mutualist system should reduce inequality drastically, it cannot be assumed
that inequalities will not increase over time. This is because inequalities in
resources leads to inequalities of power on the market and, assuming self-
interest, any trade or contract will benefit the powerful more than the
powerless, so re-enforcing and potentially increasing the inequalities and
power between the parties. Similarly, while an anarchist society would be
created with people driven by a sense of solidarity and desire for equality,
markets tend to erode those feelings and syndicates or communes which, thanks
to the resources they control (such as rare raw materials or simply the size
of their investments reducing competitive pressures) have an advantage on the
market may be tempted to use their monopoly power vis-à-vis other groups in
society to accrue more income for themselves at the expense of less fortunate
syndicates and communes. This could degenerate back into capitalism as any
inequalities that exist between co-operatives would be increased by
competition, forcing weaker co-operatives to fail and so creating a pool of
workers with nothing to sell but their labour. The successful co-operatives
could then hire those workers and so re-introduce wage labour. So these
possibilities could, over time, return a post-capitalist market system to
capitalism if the inequalities become so great that the new rich become so
alienated from the rest of society they recreate wage-labour and, by
necessity, a state to enforce a desire for property in land and the means of
production against public opinion.

All this ensures that the market cannot really provide the information
necessary for rational-decision making in terms of ecological impact as well
as human activity and so resources are inefficiently allocated. We all suffer
from the consequences of that, with market forces impoverishing our
environment and quality of life. Thus are plenty of reasons for concluding
that efficiency and the market not only do not necessarily coincide, but,
indeed, necessarily do not coincide. Indeed, rather than respond to individual
needs, the market responds to money (more correctly, profit), which by its
very nature provides a distorted indication of individual preferences (and
does not take into account values which are enjoyed collectively, such as
clean air, or **potentially** enjoyed, such as the wilderness a person may
never visit but desires to see exist and protected).

This does not mean that social anarchists propose to "ban" the market -- far
from it. This would be impossible. What we do propose is to convince people
that a profit-based market system has distinctly **bad** effects on
individuals, society and the planet's ecology, and that we can organise our
common activity to replace it with libertarian communism. As Max Stirner
argued, competition _"has a continued existence"_ because _"all do not attend
to **their** **affair** and come to an **understanding** with each other about
it . . . . Abolishing competition is not equivalent to favouring the guild.
The difference is this: In the **guild** baking, etc., is the affair of the
guild-brothers; in **competition**, the affair of chance competitors; in the
**union**, of those who require baked goods, and therefore my affair, yours,
the affair of neither guildic nor the concessionary baker, but the affair of
the **united.**"_ [**Op. Cit.**, p. 275]

Therefore, social anarchists do not appeal purely to altruism in their
struggle against the de-humanising effects of the market, but also to egoism:
the simple fact that co-operation and mutual aid is in our best interests as
individuals. By co-operating and controlling _"the affairs of the united,"_ we
can ensure a free society which is worth living in, one in which the
individual is not crushed by market forces and has time to fully develop his
or her individuality and uniqueness:

> _"Solidarity is therefore the state of being in which Man attains the
greatest degree of security and wellbeing; and therefore egoism itself, that
is the exclusive consideration of one's own interests, impels Man and human
society towards solidarity."_ [Errico Malatesta, **Anarchy**, p. 30]

In conclusion then, communist-anarchists argue that even non-capitalist
markets would result in everyone being so busy competing to further their
"self-interest" that they would loose sight of what makes life worth living
and so harm their **actual** interests. Ultimately, what counts as self-
interest is shaped by the surrounding social system. The pressures of
competing may easily result in short-term and narrow interests taking
precedence over richer, deeper needs and aspirations which a communal system
could allow to flourish by providing the social institutions by which
individuals can discuss their joint interests, formulate them and act to
achieve them. That is, even non-capitalist markets would result in people
simply working long and hard to survive on the market rather than **living**.
If one paradox of authoritarian socialism is that it makes everyone miserable
by forcing them to altruistically look out for the happiness of others,
market-based libertarian socialism could produce the potential paradox of
making everyone miserable by the market forcing them to pursue a limited
notion of self-interest which ensures that they do not have the time or
opportunity to really be happy and at one with themselves and others.

In other words, bosses act as they do under capitalism in part because markets
force them to. Getting rid of bosses need not eliminate all the economic
pressures which influence the bosses' decisions and, in turn, could force
groups of workers to act in similar ways. Thus a competitive system would
undermine many of the benefits which people sought when they ended capitalism.
This is why some socialists inaccurately call socialist schemes of competing
co-operatives "self-managed capitalism" or "self-exploitation" -- they are
simply drawing attention to the negative aspects of markets which getting rid
of the boss cannot solve. Significantly, Proudhon was well aware of the
negative aspect of market forces and suggested various institutional
structures, such as the agricultural-industrial federation, to combat them (so
while in favour of competition he was, unlike the individualist anarchists,
against the free market). Communist anarchists, unsurprisingly, argue that
individualist anarchists tend to stress the positive aspects of competition
while ignoring or downplaying its negative sides. While, undoubtedly,
capitalism makes the negative side of competition worse than it could be it
does not automatically follow that a non-capitalist market would not have
similar, if smaller, negative aspects to it.

## I.1.4 If capitalism is exploitative, then isn't socialism as well?

Some libertarian Marxists (as well as Leninists) claim that non-communist
forms of socialism are just "self-managed" capitalism. Strangely,
propertarians (the so-called "libertarian" right) also say yes to this
question, arguing that socialist opposition to exploitation does not imply
socialism but what they also call "self-managed" capitalism. Thus some on the
left proclaim anything short of communism is a form of capitalism while, on
the right, some proclaim that communism is exploitative and only a market
system (which they erroneously equate to capitalism) is non-exploitative.

Both are wrong. First, and most obviously, socialism does not equal communism
(and vice versa). While there is a tendency on both right and left to equate
socialism with communism (particularly Marxism), in reality, as Proudhon once
noted, socialism _"was not founded as a sect or church; it has seen a number
of different schools."_ [**Property is Theft!**, p. 23] Only a few of these
schools are communist, just as only a few of them are libertarian. Second, not
all socialist schools aim to abolish the market and payment by deed. Proudhon,
for example, opposed communism and state socialism just as much as he opposed
capitalism. Third, capitalism does not equal the market. The market predates
capitalism and, for some libertarian socialists, will survive it. Even from a
Marxist position, a noted in [section I.1.1](secI.md#seci11) , the defining
feature of capitalism is **wage labour**, not the market.

Why some socialists desire to reduce the choices facing humanity to either
communism or some form of capitalism is frankly strange, but also
understandable because of the potential dehumanising effects of market systems
(as shown under capitalism). Why the propertarian right wishes to do so is
more clear, as it aims to discredit all forms of socialism by equating them to
communism (which, in turn, it equates to central planning and Stalinism).

Yet this is not a valid inference to make. Opposition to capitalism can imply
both socialism (distribution according to deed, or selling the product of ones
labour) and communism (distribution according to need, or a moneyless
economy). The theory is a critique of capitalism, based on an analysis of that
system as being rooted in the exploitation of labour (as we discussed in
[section C.2](secC2.md)), i.e., it is marked by workers not being paid the
full-value of the goods they create. This analysis, however, is not
necessarily the basis of a socialist economy although it **can** be considered
this as well. As noted, Proudhon used his critique of capitalism as an
exploitative system as the foundation of his proposals for mutual banking and
co-operatives. Marx, on the other hand, used a similar analysis as Proudhon's
purely as a critique of capitalism while hoping for communism. Robert Owen
used it as the basis of his system of labour notes while Kropotkin argued that
such a system was just the wages-system under another form and a free society
_"having taken possession of all social wealth, having boldly proclaimed the
right of all to this wealth . . . will be compelled to abandon any system of
wages, whether in currency or labour-notes."_ [**The Conquest of Bread**, p.
167]

In other words, though a system of co-operative selling on the market (what is
mistakenly termed "self-managed" capitalism by some) or exchanging labour-time
values would not be communism, it is **not** capitalism. This is because the
workers are not separated from the means of production. Therefore, the
attempts by propertarians to claim that it is capitalism are false, an example
of misinformed insistence that virtually **every** economic system, bar state
socialism and feudalism, is capitalist. However, it could be argued that
communism (based on free access and communal ownership of all resources
including the product of labour) would mean that workers are exploited by non-
workers (the young, the sick, the elderly and so on). As communism abolishes
the link between performance and payment, it could be argued that the workers
under communism would be just as exploited as under capitalism, although (of
course) not by a class of capitalists and landlords but by the community. As
Proudhon put it, while the _"members of a community, it is true, have no
private property"_ the community itself _"is proprietor"_ and so communism
_"is inequality, but not as property is. Property is the exploitation of the
weak by the strong. Communism is the exploitation of the strong by the weak."_
[**What is Property?**, p. 250]

Needless to say, subsequent anarchists rejected Proudhon's blanket opposition
to all forms of communism, rejecting this position as only applicable to
authoritarian, not libertarian, communism. Which, it must be remembered, was
the only kind around when this was written in 1840 (as we noted in [section
H.1](secH1.md) , what was known as communism in Proudhon's time was
authoritarian). Suffice to say, Proudhon's opposition to communism shares
little with that of the Propertarian-right, which reflects the sad lack of
personal empathy (and so ethics) of the typical defender of capitalism.
However, the notion that communism (distribution according to need) rather
than socialism (distribution according to deed) is exploitative misses the
point as far as communist anarchism goes. This is because of two reasons.

Firstly, _"Anarchist Communism . . . means voluntary Communism, Communism from
free choice."_ [Alexander Berkman, **What is Anarchism**, p. 148] This means
it is not imposed on anyone but is created and practised only by those who
believe in it.

Therefore it would be up to the communities and syndicates to decide how they
wish to distribute the products of their labour and individuals to join, or
create, those that meet their ideas of right and wrong. Some may decide on
equal pay, others on payment in terms of labour time, yet others on
communistic associations. The important thing to realise is that individuals
and the co-operatives they join will decide what to do with their output,
whether to exchange it or to distribute it freely. Hence, because it is based
on free agreement, communist-anarchism cannot be exploitative. Members of a
commune or co-operative which is communistic are free to leave, after all.
Needless to say, the co-operatives will usually distribute their product to
others within their confederation and exchange with the non-communist ones in
a different manner. We say "usually" for in the case of emergencies like
earthquakes and so forth the situation would call for, and produce, mutual aid
just as it does today to a large degree, even under capitalism.

The reason why capitalism is exploitative is that workers **have** to agree to
give the product of their labour to another (the boss, the landlord) in order
to be employed in the first place (see [section B.4](secB4.md) ). While they
can choose who to be exploited by (and, to varying degrees, pick the best of
the limited options available to them) they cannot avoid selling their liberty
to property owners (a handful do become self-employed and some manage to join
the exploiting class, but not enough to make either a meaningful option for
the bulk of the working class). In libertarian communism, by contrast, the
workers themselves agree to distribute part of their product to others (i.e.
society as a whole, their neighbours, friends, and so forth). It is based on
free agreement, while capitalism is marked by power, authority, and the firm
(invisible) hand of market forces (supplemented, as necessary, by the visible
fist of the state). As resources are held in common under anarchism, people
always have the option of working alone if they so desire (see [section
I.3.7](secI3.md#seci37)).

Secondly, unlike under capitalism, there is no separate class which is
appropriating the goods produced. The so-called "non-workers" in a libertarian
communist society have been, or will be, workers. As the noted Spanish
anarchist De Santillan pointed out, _"[n]aturally, children, the aged and the
sick are not considered parasites. The children will be productive when they
grow up. The aged have already made their contribution to social wealth and
the sick are only temporarily unproductive."_ [**After the Revolution**, p.
20] In other words, over their life time, everyone contributes to society and
so using the "account book" mentality of capitalism misses the point. As
Kropotkin put it:

> _"Services rendered to society, be they work in factory or field, or mental
services, **cannot be** valued in money. There can be no exact measure of
value (of what has been wrongly-termed exchange value), nor of use value, with
regard to production. If two individuals work for the community five hours a
day, year in year out, at different work which is equally agreeable to them,
we may say that on the whole their labour is equivalent. But we cannot divide
their work, and say that the result of any particular day, hour, or minute of
work of the one is worth the result of a minute or hour of the other."_
[**Conquest of Bread**, p. 168]

So it is difficult to evaluate how much an individual worker or group of
workers actually contribute to society. This can be seen whenever workers
strike, particularly so-called "key" areas like transport. Then the media is
full of accounts of how much the strike is costing "the economy" and it is
always far more than that of the wages lost in strike action. Yet, according
to capitalist economics, the wages of a worker are equal to their contribution
to production -- no more, no less. Striking workers, in other words, should
only harm the economy to the value of their wages yet, of course, this is
obviously not the case. This is because of the interconnected nature of any
advanced economy, where contributions of individuals are so bound together.

Needless to say, this does not imply that a free people would tolerate the
able-bodied simply taking without contributing towards the mass of products
and services society. As we discuss in [section I.4.14](secI4.md#seci414) ,
such people will be asked to leave the community and be in the same situation
as those who do not wish to be communists.

Ultimately, the focus on calculating exact amounts and on the evaluation of
contributions down to the last penny is exactly the kind of narrow-minded
account-book mentality which makes most people socialists in the first place.
It would be ironic if, in the name of non-exploitation, a similar accounting
mentality to that which records how much surplus value is extracted from
workers under capitalism is continued into a free society. It makes life
easier not to have to worry whether you can afford to visit the doctors or
dentists, not to have to pay for use of roads and bridges, know that you can
visit a public library for a book and so forth. For those who wish to spend
their time calculating such activities and seeking to pay the community for
them simply because they hate the idea of being "exploited" by the "less"
productive, the ill, the young or the old then we are sure that a libertarian
communist society will accommodate them (although we are sure that emergencies
will be an exception and they will be given free access to communal hospitals,
fire services and so forth).

Thus the notion that communism would be exploitative like capitalism misses
the point. While all socialists accuse capitalism for failing to live up to
its own standards, of not paying workers the full product of their labour,
most do not think that a socialist society should seek to make that full
payment a reality. Life, for libertarian communists, is just too complex and
fleeting to waste time and energy calculating exactly the contribution of each
to society. As Malatesta put it:

> _"I say that **the worker has the right to the entire product of his work**:
but I recognise that this right is only a formula of abstract justice; and
means, in practice, that there should be no exploitation, that everyone must
work and enjoy the fruits of their labour, according to the custom agreed
among them._

> _"Workers are not isolated beings that live for themselves and for
themselves, but social beings . . . Moreover, it is impossible, the more so
with modern production methods, to determine the exact labour that each worker
contributed, just as it is impossible to determine the differences in
productivity of each worker or each group of workers, how much is due to the
fertility of the soil, the quality of the implements used, the advantages or
difficulties flowing from the geographical situation or the social
environment. Hence, the solution cannot be found in respect to the strict
rights of each person, but must be sought in fraternal agreement, in
solidarity."_ [**At the Café**, pp. 56-7]

All in all, most anarchists reject the notion that people sharing the world
(which is all communism really means) equates to them being exploited by
others. Rather than waste time trying to record the minutiae of who
contributed exactly what to society, most anarchists are happy if people
contribute to society roughly equal amounts of time and energy and take what
they need in return. To consider such a situation of free co-operation as
exploitative is simply ridiculous (just as well consider the family as the
exploitation of its working members by their non-working partners and
children). Those who do are free to leave such an association and pay their
own way in everything (a task which would soon drive home the simplicity and
utility of communism, most anarchists would suggest).

## I.1.5 Does capitalism efficiently allocate resources?

We have discussed, in [section I.1.1](secI1.md#seci11) , the negative
effects of workplace hierarchy and stock markets and, in [section
I.1.2](secI1.md#seci12) , the informational problems of prices and the
limitations in using profit as the sole criteria for decision making for the
efficient allocation of resources. As such, anarchists have reason to doubt
the arguments of the "Austrian" school of economics that (libertarian)
socialism is impossible, as first suggested by Ludwig Von Mises in 1920.
[_"Economic Calculation in the Socialist Commonwealth"_, **Collectivist
Economic Planning**, F.A von Hayek (ed.), pp. 87-130] Here, we discuss why
anarchists also have strong reason to question the underlying assumption that
capitalism efficiently allocates resources and how this impacts on claims that
"socialism" is impossible. This is based on an awareness of the flaws in any
(implicit) assumption that all prices are at equilibrium, the issue of
uncertainty, the assumption that human well-being is best served by market
forces and, lastly, the problem of periodic economic crisis under capitalism.

The first issue is that prices only provide adequate knowledge for rational
decision making only if they are at their equilibrium values as this equates
supply and demand. Sadly, for the "Austrian" school and its arguments against
socialism, it rejects the notion that prices could be at equilibrium. While
modern "Austrian" economics is keen to stress its (somewhat underdeveloped)
disequilibrium analysis of capitalism, this was not always the case. When
Mises wrote his 1920 essay on socialism his school of economics was considered
a branch of the neo-classicalism and this can be seen from Mises' critique of
central planning. In fact, it would be fair to say that the neo-"Austrian"
focus of prices as information and (lip-service to) disequilibrium flowed from
the Economic Calculation debate, specifically the awkward fact that their more
orthodox neo-classical peers viewed Lange's "solution" as answering Mises and
Hayek.

Thus there is a fundamental inconsistency in Mises' argument, namely that
while Austrian economics reject the notion of equilibrium and the perfect
competition of neo-classical economics he nonetheless maintains that market
prices are the correct prices and can be used to make rational decisions. Yet,
in any real market, these correct prices must be ever changing so making the
possibility that _"precise"_ economic decisions by price can go wrong on a
large scale (i.e., in slumps). In other words, Mises effectively assumed away
uncertainty and, moreover, failed to mention that this uncertainty is
increased dramatically within capitalism.

This can be seen from modern "Austrian" economics which, after the Economic
Calculation debates of the 1920s and 1930s, moved increasingly away from neo-
classical equilibrium theory. However, this opened up a whole new can of worms
which, ironically, weakened the "Austrian" case against socialism. For the
modern "Austrian" economist, the economy is considered not to be in
equilibrium, with the entrepreneur being seen as the means by which it is
brought towards it. Thus _"this approach postulates a tendency for profit
opportunities to be **discovered** and **grasped** by routine-resisting
entrepreneurial market participants"_, with this _"tending to nudge the market
in the equilibrative direction."_ Lip-service is paid to the obvious fact that
entrepreneurs can make errors but _"**there is no tendency for entrepreneurial
errors to be made.** The tendency which the market generates toward greater
mutual awareness, is not offset by any equal but opposite tendency in the
direction of diminishing awareness"_ and so the _"entrepreneurial market
process may indeed reflect a systematically equilibrative **tendency**, but
this by no means constitutes a **guaranteed** unidirectional, flawlessly
converging trajectory."_ All this results on the _"speculative actions of
entrepreneurs who see opportunities for pure profit in the conditions of
disequilibrium."_ [Israel M. Kirzner, _"Entrepreneurial Discovery and the
Competitive Market Process: An Austrian Approach"_, pp. 60-85, **Journal of
Economic Literature**, Vol. 35, No. 1, p. 71, p. 73, p. 82, p. 72 and p. 68]

When evaluating this argument, it is useful to remember that _"postulate"_
means **"to assume without proof to be true"** or **"to take as self-
evident."** At its most simple, this argument ignores how entrepreneurial
activity pushes an economy **away** from equilibrium (unlike radical
economists, only a few "Austrian" economists, such as those who follow Ludwig
Lachmann, recognise that market forces have both equilibrating **and**
disequilibrium effects, acknowledged in passing by Kirzner: _"In a world of
incessant change, they argue, it is precisely those acts of entrepreneurial
boldness which must frustrate any discovery efforts made by fellow
entrepreneurs."_ [**Op. Cit.**, p. 79]). In other words, market activity can
lead to economic crisis and inefficient allocation decisions. A successful
entrepreneur will, by their actions, frustrate the plans of others, most
obviously those of his competitors but also those who require the goods they
used to produce their commodities and those whose incomes are reduced by the
new products being available. It staggers belief to think that **every**
action by a firm will be step towards equilibrium or a better co-ordination of
plans, particularly if you include **unsuccessful** entrepreneurs into the
process. In other words, the market can be as discoordinating as it can be co-
ordinating and it cannot be "postulated" beforehand which will predominate at
any given time.

There is an obvious example of entrepreneurial activity which leads to
increasing disequilibrium, one (ironically) drawn straight from "Austrian"
economics itself. This is the actions of bankers extending credit and so
deviating from the "natural" (equilibrium) rate of interest. As one post-
Keynesian economist notes, this, the "Austrian" theory of the business cycle,
_"not only proved to be vulnerable to the Cambridge capital critique . . . ,
but also appeared to reply upon concepts of equilibrium (the 'natural rate of
interest', for example) that were inconsistent with the broader principles of
Austrian economic theory."_ [J.E. King, **A history of post Keynesian
economics since 1936**, p. 230] As we discussed in [section C.8](secC8.md),
this kind of activity is to be expected of entrepreneurs seeking to make money
from meeting market demand. The net result of this activity is a tendency
**away** from equilibrium. This can be generalised for all markets, with the
profit seeking activities of some businesses frustrating the plans of others.
Ultimately, the implication that all entrepreneurial activity is stabilising,
virtuous arbitrage that removes disequilibria is as unconvincing as is the
suggestion that the misinformation conveyed by disequilibrium prices can cause
very substantial macroeconomic distortions for only one good (credit). Surely,
the argument as regards interest rates can apply to other disequilibrium
prices, with responses to unsustainable prices for other goods being equally
capable of generating mal-investment (which only becomes apparent when the
prices adjust towards their "natural" levels). After all, any single price
distortion leads to all other prices becoming distorted because of the
ramifications for exchange ratios throughout the economy.

One of the reasons why neo-classical economists stress equilibrium is that
prices provide the basis for rational calculation only in that state, for
disequilibrium prices can convey extremely misleading information. When people
trade at disequilibrium prices, it has serious impacts on the economy (which
is why neo-classical economics abstracts from it). As one economist notes, if
people _"were to buy and sell at prices which did not clear the market"_ then
once _"such trading has taken place, there can be no guarantee that, even if
an equilibrium exists, the economy will ever converge to it. In fact, it is
likely to move in cycles around the equilibrium."_ This _"is more than a mere
supposition. It is an accurate description of what does happen in the real
world."_ [Paul Ormerod, **The Death of Economics**, pp. 87-8] Once we dismiss
the ideologically driven _"postulate"_ of "Austrian" economics, we can see how
these opportunities for "pure profit" (and, of course, a corresponding pure
loss for the buyer) impacts on the economy and how the market system adds to
uncertainty. As dissident economist Steve Keen puts it:

> _"However, a change in prices in one market will affect consumer demand in
all other markets. This implies that a move towards equilibrium by one market
could cause some or all others to move away from equilibrium. Clearly it is
possible that this . . . might never settle down to equilibrium._

> _"This will be especially so if trades actually occur at disequilibrium --
as in practice they must . . . A disequilibrium trade will mean that the
people on the winning side of the bargain -- sellers if the price is higher
than equilibrium -- will gain real income at the expense of the losers,
compared to the alleged standard of equilibrium. This shift in income
distribution will then affect all other markets, making the dance of many
markets even more chaotic."_ [**Debunking Economics**, p. 169]

That prices can, and do, convey extremely misleading information is something
which "Austrians" have a tendency to downplay. Yet in economies closer to
their ideal (for example, nineteenth century America) there were many more
recessions (usually triggered by financial crises arising from the collapse of
speculative bubbles) than in the twentieth and so the economy was
fundamentally more unstable, resulting in the market "precisely" investing in
the "wrong" areas. Of course, it could be argued that there was not really
free market capitalism then (e.g., protectionism, no true free banking due to
regulation by state governments and so on) yet this would be question begging
in the extreme (particularly since the end of the 20th and dawn of the 21st
centuries saw speculative crises precisely in those areas which were regulated
least).

Thus, the notion that prices can ensure the efficient allocation of resources
is question begging. If prices are in disequilibrium, as "Austrians" suggest,
then the market does not automatically ensure that they move towards
equilibrium. Without equilibrium, we cannot say that prices provide companies
sufficient information to make rational investment decisions. They may act on
price information which is misleading, in that it reflects temporary highs or
lows in the market or which is a result of speculative bubbles. An investment
decision made on the **mis**-information implied in disequilibrium prices is
as likely to produce mal-investment and subsequent macro-economic distortions
as decisions made in light of the interest rate not being at its "natural"
(equilibrium) value. So unless it is assumed that the market is in equilibrium
when an investment decision is made then prices can reflect misinformation as
much as information. These, the obvious implications of disequilibrium, help
undermine Mises' arguments against socialism.

Even if we assume that prices are at or, at best, near equilibrium when
investment decisions are made, the awkward fact is that these prices do not
tell you prices in the future nor what will be bought when production is
finished. Rather, they tell you what was **thought** to be profitable before
**investment began**. There are always differences between the prices used to
cost various investments and the prices which prevail on the market when the
finished goods are finally sold, suggesting that the market presents
systematically misleading signals. In addition, rival companies respond to the
same price signals by undertaking long term investments at the same time, so
creating the possibility of a general crisis of over-accumulation and over-
production when they are complete. As we discussed in [section
C.7.2](secC7.md#secc72) , this is a key factor in the business cycle. Hence
the recurring possibility of over-production, when the aggregate response to a
specific market's rising price results in the market being swamped by goods,
so driving the market price down. Thus the market is marked by uncertainty,
the future is not known. So it seems ironic to read Mises asserting that _"in
the socialist commonwealth every economic change becomes an undertaking whose
success can be neither appraised in advance nor later retrospectively
determined. There is only groping in the dark."_ [**Op. Cit.**, p. 110]

In terms of _"appraised in advance"_, Mises is essentially assuming that
capitalists can see the future. In the real world, rather than in the unreal
world of capitalist economics, the future is unknown and, as a result, success
can only be guessed at. This means that any investment decision under **real**
capitalism is, equally, _"groping in the dark"_ because there is no way to
know, before hand, whether the expectations driving the investment decisions
will come to be. As Mises himself noted as part of his attack on socialism,
_"a static state is impossible in real life, as our economic data are for ever
changing"_ and so, needless to say, the success of an investment **cannot** be
appraised beforehand with any real degree of certainty. Somewhat ironically,
Mises noted that _"the static nature of economic activity is only a
theoretical assumption corresponding to no real state of affairs, however
necessary it may be for our thinking and for the perfection of our knowledge
of economics."_ [**Op. Cit.**, p. 109] Or, for that matter, our critique of
socialism! This can be seen from one of his examples against socialism:

> _"Picture the building of a new railroad. Should it be built at all, and if
so, which out of a number of conceivable roads should be built? In a
competitive and monetary economy, this question would be answered by monetary
calculation. The new road will render less expensive the transport of some
goods, and it may be possible to calculate whether this reduction of expense
transcends that involved in the building and upkeep of the next line. That can
only be calculated in money."_ [**Op. Cit.**, p. 108]

It _"may be possible"_? Not before hand. At best, an investor could
**estimate** the willingness of firms to swap to the new railroad and whether
those expected costs will result in a profit on both fixed and running costs.
The construction costs can be estimated, although unexpected price rises in
the future may make a mockery of these too, but the amount of future income
cannot. Equally, the impact of building the new railroad will change the
distribution of income as well, which in turn affects prices across the market
and people's consumption decisions which, in turn, affects the profitability
of new railroad investment. Yet all this is ignored in order to attack
socialism.

In other words, Mises assumes that the future can be accurately predicted in
order to attack socialism. Thus he asserts that a socialist society _"would
issue an edict and decide for or against the projected building. Yet this
decision would depend at best upon vague estimates; it would never be based
upon the foundation of an exact calculation of value."_ [**Op. Cit.**, p. 109]
Yet any investment decision in a **real** capitalist economy depends _"at best
upon vague estimates"_ of future market conditions and expected returns on the
investment. This is because accounting is backward looking, while investment
depends on the unknowable future.

In other words, _"people recognise that their economic future is uncertain
(nonergodic) and cannot be reliably predicted from existing market
information. Consequently, investment expenditures on production facilities
and people's desire to save are typically based on differing expectations of
an unknowable, uncertain future."_ This means that in an uncertain world
future profits _"can neither be reliably forecasted from existing market
information, nor endogenously determined via today's planned saving propensity
of income earners . . . Thus, unless one assumes that entrepreneurs can
accurately predict the future from here to eternity, current expectations of
prospective yield must depend on the animal optimism or pessimism of
entrepreneurs."_ [Paul Davidson, **John Maynard Keynes**, pp. 62-3] So, yes,
under capitalism you can determine the money cost (price) of a building but
the decision to build is based on estimates and guesses of the future, to use
Mises' words _"vague estimates."_ A change in the market can mean that even a
building which is constructed exactly to expected costs does not produce a
profit and so sits empty. Even in terms of _"exact calculation"_ of inputs
these can change, so undermining the projected final cost and so its profit
margin.

For a good explanation of the problems of uncertainty, we must turn to Keynes
who placed it at the heart of his analysis of capitalism. _"The actual results
of an investment over a long term of years,"_ argued Keynes, _"very seldom
agree with the initial expectation"_ since _"our existing knowledge does not
provide a sufficient basis for a calculated mathematical expectation. In point
of fact, all sorts of considerations enter into the market valuation which are
in no way relevant to the prospective yield."_ He stressed that _"human
decisions affecting the future, whether personal or political or economic,
cannot depend on strict mathematical expectation, since the basis for making
such calculations does not exist."_ He also suggested that the _"chief
result"_ of wage flexibility _"would be to cause a great instability of
prices, so violent perhaps as to make business calculations futile."_ [**The
General Theory**, p. 152, pp. 162-3 and p. 269]

Much the same can be said of other prices as well. As Proudhon argued decades
before Mises proclaimed socialism impossible, profit is ultimately an unknown
value. Under capitalism wages are the _"least that can be given"_ to a worker:
_"that is, we do not know."_ The _"price of the merchandise put upon the
market"_ by the capitalist will be the _"highest that he can obtain; that is,
again, we do not know."_ Economics _"admits"_ that _"the prices of merchandise
and labour . . . can be **estimated**"_ and _"that estimation is essentially
an arbitrary operation, which never can lead to sure and certain
conclusions."_ Thus capitalism is based on _"the relation between two
unknowns"_ which _"cannot be determined."_ [**Property is Theft!**, p. 172]

So under capitalism **all** decisions are _"groping in the dark"_. Which can,
and does, lead to inefficient allocations of resources:

> _"It leads, that is to say, to **misdirected** investment. But over and
above this it is an essential characteristic of the boom that investments
which will in fact yield, say, 2 per cent. in conditions of full employment
are made in the expectation of a yield of, say, 6 per cent., and are valued
accordingly. When the disillusion comes, this expectation is replaced by a
contrary 'error of pessimism', with the result that the investments, which
would in fact yield 2 per cent. in conditions of full employment, are expected
to yield less than nothing; and the resulting collapse of new investment then
leads to a state of unemployment in which the investments, which would have
yielded 2 per cent. in conditions of full employment, in fact yield less than
nothing. We reach a condition where there is a shortage of houses, but where
nevertheless no one can afford to live in the houses that there are."_
[Keynes, **Op. Cit.**, pp. 321-2]

Thus uncertainty and expectations of profit can lead to massive allocation
inefficiencies and waste. Of course Mises pays lip-service to this uncertainty
of markets. He noted that there are _"ceaseless alternations in other economic
data"_ and that exchange relations are _"subject to constant . . .
fluctuations"_ but those _"fluctuations disturb value calculations only in the
slightest degree"_! He admitted that _"some mistakes are inevitable in such a
calculation"_ but rest assured _"[w]hat remains of uncertainty comes into the
calculation of the uncertainty of future conditions, which is an inevitable
concomitant of the dynamic nature of economic life."_ [**Op. Cit.**, p. 98, p.
110 and p. 111] So, somewhat ironically, Mises assumed that, when attacking
socialism, that prices are so fluid that no central planning agency could ever
compute their correct price and so allocated resources inefficiently yet, when
it comes to capitalism, prices are not so fluid that they make investment
decisions difficult!

The question is, does capitalism reduce or increase these uncertainties? We
can suggest that capitalism adds two extra layers of uncertainty. As with any
economy, there is the uncertainty that produced goods will meet an actual need
of others (i.e., that it has a use-value). The market adds another layer of
uncertainty by adding the need for its price to exceed costs. Finally,
capitalism adds another level of uncertainty in that the capitalist class must
make sufficient profits as well. Thus, regardless of how much people need a
specific good if capitalists cannot make a profit from it then it will not be
produced.

Uncertainty will, of course, afflict a communist-anarchist society. Mistakes
in resource allocation will happen, with some goods over produced at times and
under-produced at others. However, a communist society removes the added
uncertainty associated with a capitalist economy as such mistakes do **not**
lead to general slumps as losses result in the failure of firms and rising
unemployment. In other words, without Mises' precise economic calculation
society will no longer be afflicted by the uncertainty associated with the
profit system.

Significantly, there are developments within capitalism which point to the
benefits of communism in reducing uncertainty. This is the rise of the large-
scale corporation. In fact, many capitalist firms expand precisely to reduce
the uncertainties associated with market prices and their (negative) impact on
the plans they make. Thus companies integrate horizontally by take-over to
gain more control over investment and supply decisions as well as vertically
to stabilise costs and secure demand for necessary inputs.

As economist John Kenneth Galbraith noted, when investment is large, _"[n]o
form of market uncertainty is so serious as that involving the terms and
conditions on which capital is obtained."_ As a result internal funds are used
as _"the firm has a secure source of capital"_ and _"no longer faces the risks
of the market."_ This applies to other inputs, for a _"firm cannot
satisfactorily foresee and schedule future action or prepare for contingencies
if it does not know what its prices will be, what its sales will be, what its
costs, including labour and capital costs, will be and what will be available
at these costs. If the market is uncontrolled, it will not know these things .
. . Much of what the firm regards as planning consists in minimising
uncontrolled market influences."_ This partly explains why firms grow (the
other reason is to dominate the market and reap oligopolistic profits). The
_"market is superseded by vertical integration"_ as the firm _"takes over the
source of supply or the outlet"_. This _"does not eliminate market
uncertainty"_ but rather replaces _"the large and unmanageable uncertainty as
to the price"_ of inputs with _"smaller, more diffuse and more manageable
uncertainties"_ such as the costs of labour. A large firm can only control the
market, by _"reducing or eliminating the independence of action"_ of those it
sells to or buys from. This means the behaviour of others can be controlled,
so that _"uncertainty as to that behaviour is reduced."_ Finally, advertising
is used to influence the amount sold. Firms also _"eliminate market
uncertainty"_ by _"entering into contracts specifying prices and amounts to be
provided or bought for substantial periods of time."_ Thus _"one of the
strategies of eliminating market uncertainty is to eliminate the market."_
[**The New Industrial State** p. 47, pp. 30-6 and p. 47]

Of course, such attempts to reduce uncertainty within capitalism are
incomplete and subject to breakdown. Such planning systems can come into
conflict with others (for example, the rise of Japanese corporations in the
1970s and 1980s and subsequent decline of American industrial power). They are
centralised, hierarchically structured and based on top-down central planning
(and so subject to the informational problems we highlighted in [section
I.1.2](secI1.md#seci12)). Market forces can reassert themselves, making a
mockery of even the best organised plans. However, these attempts at
transcending the market within capitalism, as incomplete as they are, show a
major problem with relying on markets and market prices to allocate resources.
They add an extra layer of uncertainty which ensure that investors and firms
are as much in the dark about their decisions as Mises argued central planners
would be. As such, to state as Mises does that production in socialism can
_"never be based upon the foundation of an exact calculation of value"_ is
somewhat begging the question. [**Op. Cit.**, p. 109] This is because knowing
the _"exact"_ price of an investment is meaningless as the key question is
whether it makes a profit or not -- and that is unknown when it is made and if
it makes a loss, it is still a waste of resources! So it does not follow that
a knowledge of current prices allows efficient allocation of resources
(assuming, of course, that profitability equates to social usefulness).

In summary, Mises totally ignored the issues of uncertainty (we do not, and
cannot, know the future) and the collective impact of individual decisions.
Production and investment decisions are made based on expectations about
future profits, yet these (expected) profits depend (in part) on what other
decisions are being, and will be, made. This is because they will affect the
future aggregate supply of a good and so market price, the price of inputs and
the distribution of effective demand. In the market-based (and so fragmented
and atomistic) decision-making Mises assumes, any production and investment
decisions are made on the basis on unavoidable ignorance of the actions of
others and the results of those actions. Of course there is uncertainty which
would affect every social system (such as the weather, discovery of new
sources of energy, raw materials and technology, changing customer needs, and
so forth). However, market based systems add extra levels of uncertainty by
the lack of communication between decision-makers as well as making profit the
be-all-and-end-all of economic rationalism.

So in terms of Mises' claim that only capitalism ensures that success can be
_"appraised in advance"_, it is clear that in reality that system is as marked
by _"groping in the dark"_ as any other. What of the claim that only markets
can ensure that a project's success is _"later retrospectively determined"_?
By this, Mises makes a flawed assumption -- namely the dubious notion that
what is profitable is right. Thus economically is identified with profitably.
So even if we assume prices provide enough information for rational decision
making, that the economy jumps from one state of equilibrium to another and
that capitalists can predict the future, the awkward fact is that maximising
profit does not equal maximising human well-being.

Neither well-being nor efficiency equals profitability as the latter does not
take into account **need**. Meeting needs is not _"retrospectively
determined"_ under capitalism, only profit and loss. An investment may fail
not because it is not needed but because there is no effective demand for it
due to income inequalities. So it is important to remember that the
distribution of income determines whether something is an "efficient" use of
resources or not. As Thomas Balogh noted, real income _"is measured in terms
of a certain set of prices ruling in a given period and that these prices will
reflect the prevailing distribution of income. (With no Texan oil millionaires
there would be little chance of selling a baby blue Roll-Royce . . . at a
price ten times the yearly income of a small farmer or sharecropper)."_ [**The
Irrelevance of Conventional Economics**, pp. 98-9] The market demand for
commodities, which allocates resources between uses, is based not on the
tastes of consumers but on the distribution of purchasing power between them.
This, ironically, was mentioned by Mises as part of his attack on socialism,
arguing that the central planners could not use current prices for _"the
transition to socialism must, as a consequence of the levelling out of the
differences in income and the resultant re-adjustments in consumption, and
therefore production, change all economic data."_ [**Op. Cit.**, p. 109] He
did not mention the impact this has in terms of "efficiency" or profitability!
After all, what is and is not profitable ("efficient") depends on effective
demand, which in turn depends of a specific income distribution. Identical
production processes become efficient and inefficient simply by a
redistribution of income from the rich to the poor, and vice versa. Similarly,
changes in market prices may make once profitably investments unprofitable,
without affecting the needs they were satisfying. And this, needless to say,
can have serious impacts on human well-being.

As discussed in [section C.1.5](secC1.md#secc15) , this becomes most obvious
during famines. As Allan Engler points out, _"[w]hen people are denied access
to the means of livelihood, the invisible hand of market forces does not
intervene on their behalf. Equilibrium between supply and demand has no
necessary connection with human need. For example, assume a country of one
million people in which 900,000 are without means of livelihood. One million
bushels of wheat are produced. The entire crop is sold to 100,000 people at
$10 a bushel. Supply and demand are in equilibrium, yet 900 000 people will
face starvation."_ [**Apostles of Greed**, pp. 50-51] In case anyone thinks
that this just happens in theory, the example of numerous famines (from the
Irish famine of the 1840s to those in African countries in 1980s) gives a
classic example of this occurring in practice, with rich landowners exporting
food to the other nations while millions starve in their own.

So the distributional consequences of the market system play havoc with any
attempt to define what is and is not an "efficient" use of resources. As
markets inform by 'exit' only -- some products find a market, others do not --
'voice' is absent. The operation of 'exit' rather than 'voice' leaves behind
those without power in the marketplace. For example, the wealthy do not buy
food poisoned with additives, the poor consume it. This means a division grows
between two environments: one inhabited by those with wealth and one inhabited
by those without it. As can be seen from the current capitalist practice of
"exporting pollution" to developing countries, this problem can have serious
ecological and social effects. So, far from the market being a _"democracy"_
based on _"one dollar, one vote,"_ it is an oligarchy in which, for example,
the _"79,000 Americans who earned the minimum wage in 1987 have the same
influence [or "vote"] as Michael Milken, who 'earned' as much as all of them
combined."_ [Michael Albert and Robin Hahnel, **The Political Economy of
Participatory Economics**, p. 21] One dissident economist states the
blindingly obvious, namely that the _"market and democracy clash at a
fundamental level. Democracy runs on the principle of 'one man (one person),
one vote.' The market runs on the principle of 'one dollar, one vote.'
Naturally, the former gives equal weight to each person, regardless of the
money she/he has. The latter gives greater weight to richer people."_ This
means that the market is automatically skewed in favour of the wealthy and so
_"[l]eaving everything to the market means that the rich may be able to
realise even the most frivolous element of their desires, while the poor may
not be able even to survive -- thus the world spends twenty times more
research money on slimming drugs than on malaria, which claims more than a
million lives and debilitates millions more in developing countries every
year."_ [Ha-Joon Chang, **Bad Samaritans**, p. 172 and p. 174]

In other words, markets are always biased in favour of effective demand, i.e.
in favour of the demands of people with money, and so can never (except in the
imaginary abstractions of neo-classical economics) allocate the necessities of
life to those who need them the most. Thus a simple redistribution of wealth
(via militant unions or the welfare state, for example) could make previously
"bad" investments good simply because the new income allows those who had
previously needed, but could not afford, the good or service in question to
purchase it. So just because something makes a loss under one distribution of
income does not mean that it is an inefficient use of resources in the sense
of meeting human needs (and could make a profit under another, more equal,
distribution of wealth). So the "efficient" allocation of resources in terms
of price (i.e., profit) is often no such thing as the wealthy few skew market
decisions in their favour.

It is important to remember that, for the "Austrians", preferences are
demonstrated through action in the market and they are not interested in
opinions, thus any preference which is not expressed by action is irrelevant
to them. So any attempt to collectively prioritise, say, building decent
housing for all, provide health care for everyone, and so forth are all
considered "inefficient" uses of resources as those who receive them would
not, normally, be able to afford them and, consequently, do not really desire
them anyway (as they, needless to say, do not express that desire by market
exchanges!). Yet this ignores the awkward fact that in the market, people can
only act if they have money to make their preferences known. Thus those who
have a need but no money do not count when determining if the market is
efficient or not. There is simply no room for the real people who can be
harmed by real markets. As economist Amartya Sen argues, the workings of a
"pure" capitalist market, as desired by "Austrians" economists and other
propertarians, _"can be problematic since the actual consequences of the
operation of these entitlements can, quite possibly, include rather terrible
results. It can, in particular, lead to the violation of the substantive
freedom of individuals to achieve those things to which they have reason to
attach great importance, including escaping avoidable mortality, being well
nourished and healthy, being able to read, write and count and so on."_ In
fact, _"even gigantic famines can result without anyone's [right] libertarian
rights (including property rights) being violated. The destitutes such as the
unemployed or the impoverished may starve precisely because their
'entitlements' . . . do not give them enough food."_ Similarly,
_"deprivation"_ such as _"regular undernourishment"_, the _"lack of medical
care for curable illnesses"_ can _"coexist with all [right] libertarian rights
(including rights of property ownership) being fully satisfied."_
[**Development as Freedom**, p. 66]

All of which, it must be stressed, is ignored in the "Austrian" case against
socialism. Ultimately, if providing food to a rich person's pets makes a
profit then it becomes a more economical and efficient use of the resource
than providing food to famine victims who cannot purchase food on the market.
So it should never be forgotten that the "Austrians" insist that only
preferences demonstrated in action are real. So if you cannot act on the
market (i.e., buy something) then your need for it is not real. In other
words, if a person loses their job and, as a consequence, loses their home
then, according to this logic, they do not "need" a home as their
"demonstrated preference" (i.e., their actual choices in action) shows that
they genuinely value living under a bridge (assuming they gain the bridge
owners agreement, of course).

As an aside, this obvious fact shows that the "Austrian" assertion that
intervention in the market **always** reduces social utility cannot be
supported. The argument that the market maximises utility is based on assuming
a given allocation of resources before the process of free exchange begins. If
someone does not have sufficient income to, say, buy food or essential medical
treatment then this is not reflected in the market. If wealth is redistributed
and they then they get access to the goods in question, then (obviously) their
utility has increased and it is a moot point whether social utility has
decreased as the disutility of the millionaire who was taxed to achieve it
cannot be compared to it. Significantly, those "Austrians" who have sought to
prove that all intervention in the market reduces social utility have failed.
For example, as one dissident "Austrian" economist notes, while Murray
Rothbard _"claimed he offered a purely deductive"_ argument that state
intervention always reduced social utility _"his case [was] logically
flawed."_ He simply assumed that social utility was reduced although he gave
no reason for such an assumption as he admitted that interpersonal comparisons
of utility were impossible. For someone _"who asks that his claims be tested
only by their logic"_, his ultimate conclusions about state intervention _"do
not follow"_ and exhibit _"a careless self-contradiction"_ [David L.
Prychitko, **Markets, Planning and Democracy**, p. 189, p. 111 and p. 110]

In summary, then, in terms of feedback saying that if something made a profit
then it was efficiently produced confuses efficiency and need with
profitability and effective demand. Something can make a profit by imposing
costs via externalities and lowering quality. Equally, a good may not make a
profit in spite of there being a need for it simply because people cannot
afford to pay for it.

As such, Mises was wrong to assert that _"[b]etween production for profit and
production for need, there is no contrast."_ [**Socialism**, p. 143] In fact,
it seems incredible that anyone claiming to be an economist could make such a
comment. As Proudhon and Marx (like Smith and Ricardo before them) made clear,
a commodity in order to be exchanged must first have a use-value (utility) to
others. Thus production for profit, by definition, means production for "use"
-- otherwise exchange would not happen. What socialists were highlighting by
contrasting production for profit to need was, firstly, that need comes after
profit and so without profit a good will not be produced no matter how many
people need it. Secondly, it highlights the fact that during crises capitalism
is marked by an over-production of goods reducing profits, so stopping
production, while people who need those goods go without them. Thus capitalism
is marked by homeless people living next to empty housing and hungry people
seeing food exported or destroyed in order to maximise profit. Ultimately, if
the capitalist does not make a profit then it is a bad investment --
regardless of whether it could be used to meet people's needs and so make
their lives better. In other words, Mises ignores the very basis of capitalism
(production for profit) and depicts it as production aiming at the direct
satisfaction of consumers.

Equally, that something makes a profit does not mean that it is an efficient
use of resources. If, for example, that profit is achieved by imposing
pollution externalities or by market power then it cannot be said that society
as a whole, rather than the capitalist, has benefited. Similarly, non-market
based systems can be seen to be more efficient than market based ones in terms
of outcome. For example, making health care available to all who need it
rather than those who can afford it is economically "inefficient" in
"Austrian" eyes but only an ideologue would claim that we should not do so
because of this particularly as we can point to the awkward fact that the more
privatised health care systems in the USA and Chile are more inefficient than
the nationalised systems elsewhere in the world. Administration costs are
higher and the societies in question pay far more for an equivalent level of
treatment. Of course, it could be argued that the privatised systems are not
truly private but the awkward fact remains -- the more market based system is
worse, in terms of coverage of the population, cost for treatment, bureaucracy
and health outcomes per pound spent.

In addition, in a highly unequal society costs are externalised to those at
the bottom of the social hierarchy. The consequences are harmful, as suggested
by the newspeak used to disguise this reality. For example, there is what is
called "increasing flexibility of the labour market." "Flexibility" sounds
great: rigid structures are unappealing and hardly suitable for human growth.
In reality, as Noam Chomsky points out _"[f]lexibility means insecurity. It
means you go to bed at night and don't know if you have a job tomorrow
morning. That's called flexibility of the labour market, and any economist can
explain that's a good thing for the economy, where by 'the economy' now we
understand profit-making. We don't mean by 'the economy' the way people live.
That's good for the economy, and temporary jobs increase flexibility. Low
wages also increase job insecurity. They keep inflation low. That's good for
people who have money, say, bondholders. So these all contribute to what's
called a 'healthy economy,' meaning one with very high profits. Profits are
doing fine. Corporate profits are zooming. But for most of the population,
very grim circumstances. And grim circumstances, without much prospect of a
future, may lead to constructive social action, but where that's lacking they
express themselves in violence."_ [**Keeping the Rabble in Line**, pp. 283-4]
So it simply cannot be assumed that what is good for the economy (profits)
equates to what is good for people (at least the working class).

Thus the "Austrians" prize profitability above all and this assumption is at
the root of the "Calculation Argument" against socialism, but this makes sense
only insofar as efficiency is confused with profit. The market will invest in
coal if profits are higher and, in so doing, contribute to global warming. It
will deny medical care to the sick (no profits and so it is inefficient) while
contributing to, say, a housing bubble because it makes short-term profits by
providing loans to people who really cannot afford them. It will support all
kinds of economic activity, regardless of the wider impact, and so
"efficiency" (i.e., profits) can, and does, contradict both wisdom and ethics
and so, ultimately, an efficient allocation of resources to meet people's
needs.

Lastly, our critique has so far ignored the periodic crises that hit
capitalist economies which produce massive unemployment and social disruption
-- crises that are due to subjective and objective pressures on the operation
of the price mechanism (see [section C.7](secC7.md) for details). In the
upswing, when expectations are buoyant, firms will invest and produce a
mutually reinforcing expansion. However, the net effect of such decisions
eventually leads to over-investment, excess capacity and over-production --
mal-investment and the waste of the embodied resources. This leads to lower
than expected profits, expectations change for the worse and the boom turns
into bust, capital equipment is scrapped, workers are unemployed and resources
are either wasted or left idle.

In a crisis we see the contradiction between use value and exchange value come
to a head. Workers are no less productive than when the crisis started, the
goods and services they create are no less needed than before. The means of
production are just as productive as they were. Both are just as capable as
before of affording for everyone a decent standard of living. Even though
people are homeless, housing stands empty. Even though people need goods,
production is stopped. Even though people want jobs, workplaces are closed.
Yet, according to the logic of _"exact"_ "economic calculation", production is
now "inefficient" and should be closed-down, workers made unemployed and
expected to find work by forcing down the wages of those lucky enough to
remain employed in the hope that the owners of the means of life will find it
profitable to exploit them as much as before (for when hard times arrive it is
never long until somebody suggests that the return of prosperity requires
sacrifices at the bottom of the heap and, needless to say, the "Austrian"
economists are usually the first to do so).

This suggests that the efficient allocation of resources becomes meaningless
if its reality is a cycle where consumers go without essential goods due to
scarcity and high prices followed by businesses going bust because of over-
production and low prices. This process ruins large numbers of people's lives,
not to mention wasting vast stocks of productive equipment and goods. There
are always people who need the over-produced goods and so the market adds to
uncertainty as there is a difference between the over-production of goods and
the over-production of commodities. If more goods were produced in a communist
society this may signify a waste of resources but it would not, as under
capitalism, produce a crisis situation as well!

So in a real capitalist economy, there are numerous reasons for apparently
rational investment decisions going wrong. Not that these investments produce
goods which people do not need, simply that _"exact"_ "economic calculation"
indicates that they are not making a profit and so are an "inefficient" use of
resources. However, it is question begging in the extreme to argue that if
(thanks to a recession) workers can no longer buy food then is it an
"efficient" allocation of resources that they starve. Similarly, during the
Great Depression, the American government (under the New Deal) hired about 60%
of the unemployed in public works and conservation projects. These saw a
billion trees planted, the whooping crane saved, the modernisation of rural
America, and the building of (among others) the Cathedral of Learning in
Pittsburgh, the Montana state capitol, New York's Lincoln Tunnel and
Triborough Bridge complex, the Tennessee Valley Authority as well as building
or renovating 2,500 hospitals, 45,000 schools, 13,000 parks and playgrounds,
7,800 bridges, 700,000 miles of roads, 1,000 airfields as well as employing
50,000 teachers and rebuilding the country's entire rural school system. Can
all these schemes really be considered a waste of resources simply because
they would never have made a capitalist a profit?

Of course, our discussion is affected by the fact that "actually existing"
capitalism has various forms of state-intervention. Some of these "socialise"
costs and risks, such as publicly funded creation of an infrastructure and
Research and Development (R&amp;D). Given that much R&amp;D is conducted via
state funding (via universities, military procurements, and so on) and (of
course!) the profits of such research are then privatised, question arises
would the initial research have gone ahead if the costs had not been
"socialised"? Would Mises' _"exact"_ calculation have resulted in, say, the
internet being developed? If, as seems likely, not, does it not mean our
current use of the World Wide Web is an inefficient use of resources? Then
there are the numerous state interventions which exist to ensure that certain
activities become "efficient" (i.e., profitable) such as specifying and
defending intellectual property rights, the limited liability of corporations
and enforcing capitalist property rights (in land, for example). While we take
this activity for granted when evaluating capitalism, they are serious
imperfections in the market and so what counts as an "efficient" use of
resources. Other state interventions aim to reduce uncertainty and stabilise
the market, such as welfare maintaining aggregate demand.

Removing these "imperfections" in the market would substantially affect the
persuasiveness of Mises' case. _"What data we do have,"_ notes Doug Henwood,
_"don't lend any support to the notion that the nineteenth century was more
'stable' than the twentieth . . . the price level bounced all over the place,
with periods of inflation alternating with periods of deflation, and GDP
growth in the last three decades . . . was similarly volatile. The busts were
savage, resulting in massive bank failures and very lean times for workers and
farmers."_ [**After the New Economy**, p. 242] Looking at business cycle data
for America, what becomes clear is that some of those regular nineteenth
century slumps were extremely long: the Panic of 1873, for example, was
followed by a recession that lasted 5 1/2 years. The New York Stock Exchange
closed for ten days and 89 of the country's 364 railroads went bankrupt. A
total of 18,000 businesses failed between 1873 and 1875. Unemployment reached
14% by 1876, during a time which became known as the Long Depression.
Construction work lagged, wages were cut, real estate values fell and
corporate profits vanished.

Given this, given the tendency of capitalism to crisis and to ignore real
needs in favour of effective demand, it is far better to be roughly right than
precisely wrong. In other words, the economic calculation that Mises
celebrates regularly leads to situations where people suffer because it
precisely shows that workplaces should shut because, although nothing had
changed in their productivity and the need of their products, they can no
longer make a profit. Saying, in the middle of a crisis, that people should be
without work, be homeless and go hungry because economic calculation proves
they have no need for employment, homes and food shows the irrationality of
glorifying "economic calculation" as the be all and end all of resource
allocation.

In summary, then, not only is libertarian communism possible, capitalism
itself makes economic calculation problematic and resource allocation
inefficient. Given the systematic uncertainty which market dynamics imply and
the tendencies to crisis inherent in the system, "economic calculation"
ensures that resources are wasted. Using the profit criteria as the measure of
"efficiency" is also problematic as it ensures that real needs are ignored and
places society in frequent situations (crises) where "economic calculation"
ensures that industries close, so ensuring that goods and services people need
are no longer produced. As Proudhon put it, under capitalism there is _"a
miserable oscillation between usury and bankruptcy."_ [**Op. Cit.**, p. 285]
For anarchists, these drawbacks to capitalist allocation are obvious. Equally
obvious is the reason why Mises failed to discuss them: ultimately, like neo-
classical economics, the "Austrian" school seeks to eulogise capitalism rather
than to understand it.

[‹ I.0 Section I Introduction](secIint.md "Go to previous page" )
[up](secIcon.md "Go to parent page" ) [I.2 Is this a blueprint for an
anarchist society? ›](secI2.md "Go to next page" )

