!{\src2tex{textfont=tt}}
!!****f* ABINIT/outfan
!! NAME
!! outfan
!!
!! FUNCTION
!! output fan file for one perturbation (used for elphon calculations in anaddb)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2014 ABINIT group (XG, DRH, MB)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.
!!
!! INPUTS
!!  bdeigrf=number of bands for which the derivatives of the eigenvalues have been computed
!!  dtset = dataset variable for run flags
!!  eig2nkq= second ordre eigenvalue (or electron lifetime) that must be printed out 
!!  mpert= maximum number of perturbations
!!  nkpt_rbz= number of k-points for perturbation
!!  unitout= writting unit of file
!!
!! OUTPUTS
!!  to file
!!
!! PARENTS
!!      eig2tot
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine outfan(bdeigrf,dtset,fan,nkpt_rbz,unitout)

 use defs_basis
 use m_profiling
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'outfan'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: bdeigrf,nkpt_rbz,unitout
 type(dataset_type),intent(in) :: dtset
!arrays
 real(dp),intent(in) :: fan(2,dtset%mband*dtset%nsppol,nkpt_rbz,&
&                       dtset%mband*dtset%nsppol,3*dtset%natom)

!Local variables -------------------------
!scalars
 integer :: bandtot_index,iband,ikpt,imode,isppol,jband

! *********************************************************************

!output information in this file
 write(unitout,*)
 write(unitout,'(a,i8)') ' 2nd eigenvalue derivatives   - # elements :', 9*dtset%natom**2
 write(unitout,'(a,3es16.8,a)') ' qpt', dtset%qptn(:), ' 1.0'

!output RF eigenvalues

 do ikpt=1,nkpt_rbz
!  bandtot_index differs from zero only in the spin-polarized case
   bandtot_index=0
   write (unitout,'(a,3es16.8)') ' K-point:', dtset%kptns(:,ikpt)
   do isppol=1,dtset%nsppol
     do iband=1,bdeigrf
       write (unitout,'(a,i5)') ' Band:', iband+bandtot_index
       do imode=1,3*dtset%natom
         do jband=1,dtset%mband         
           write (unitout,'(2i4,2d22.14)') imode,jband,&
&           fan(1,iband+bandtot_index,ikpt,jband,imode),&
&           fan(2,iband+bandtot_index,ikpt,jband,imode)
         end do !jband
       end do !imode
     end do !iband
     bandtot_index = bandtot_index + dtset%mband
   end do !isppol
 end do !ikpt

!close fan file
 close (unitout)

end subroutine outfan
!!***
