!{\src2tex{textfont=tt}}
!!****f* ABINIT/cprj_utils
!! NAME
!! cprj_utils
!!
!! FUNCTION
!! This module contains functions used to manipulate
!! variables of structured datatype cprj_type.
!! cprj_type variables are <p_lmn|Cnk> projected
!! quantities where |p_lmn> are non-local projectors
!!                  |Cnk> are wave functions
!!
!! COPYRIGHT
!! Copyright (C) 2007-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

! *************************************************************************

subroutine cprj1_alloc(cprj,ncpgr,nlmn)

 use defs_basis
 use defs_datatypes

 implicit none
!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ncpgr
!arrays
 integer,intent(in) :: nlmn(:)
 type(cprj_type),intent(inout) :: cprj(:)
!Local variables-------------------------------
 integer :: ii,nn,n1dim
!----------------------------------------------
 n1dim=size(cprj);nn=size(nlmn)
 if (nn/=n1dim) stop "Error in cprj1_alloc: wrong sizes ! "
 do ii=1,n1dim
  nn=nlmn(ii)
  cprj(ii)%nlmn=nn
  cprj(ii)%ncpgr=ncpgr
  allocate(cprj(ii)%cp(2,nn))
  if (ncpgr>0) allocate(cprj(ii)%dcp(2,ncpgr,nn))
 end do
end subroutine cprj1_alloc

!==============================================

subroutine cprj2_alloc(cprj,ncpgr,nlmn)

 use defs_basis
 use defs_datatypes

 implicit none
!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ncpgr
!arrays
 integer,intent(in) :: nlmn(:)
 type(cprj_type),intent(inout) :: cprj(:,:)
!Local variables-------------------------------
 integer :: ii,jj,n1dim,n2dim,nn
!----------------------------------------------
 n1dim=size(cprj,dim=1);n2dim=size(cprj,dim=2);nn=size(nlmn,dim=1)
 if (nn/=n1dim) stop "Error in cprj2_alloc: wrong sizes !"
 do jj=1,n2dim
  do ii=1,n1dim
   nn=nlmn(ii)
   cprj(ii,jj)%nlmn=nn
   cprj(ii,jj)%ncpgr=ncpgr
   allocate(cprj(ii,jj)%cp(2,nn))
   if (ncpgr>0) allocate(cprj(ii,jj)%dcp(2,ncpgr,nn))
  end do
 end do
end subroutine cprj2_alloc

!==============================================

subroutine cprj1_free(cprj)

 use defs_basis
 use defs_datatypes

 implicit none
!Arguments ------------------------------------
!scalars
!arrays
 type(cprj_type),intent(inout) :: cprj(:)
!Local variables-------------------------------
 integer :: ii,n1dim
!----------------------------------------------
 n1dim=size(cprj)
 do ii=1,n1dim
  deallocate(cprj(ii)%cp)
  if (cprj(ii)%ncpgr>0) deallocate(cprj(ii)%dcp)
 end do
end subroutine cprj1_free

!==============================================

subroutine cprj2_free(cprj)

 use defs_basis
 use defs_datatypes

 implicit none
!Arguments ------------------------------------
!scalars
!arrays
 type(cprj_type),intent(inout) :: cprj(:,:)
!Local variables-------------------------------
 integer :: ii,jj,n1dim,n2dim
!----------------------------------------------
 n1dim=size(cprj,dim=1);n2dim=size(cprj,dim=2)
 do jj=1,n2dim
  do ii=1,n1dim
   deallocate(cprj(ii,jj)%cp)
   if (cprj(ii,jj)%ncpgr>0) deallocate(cprj(ii,jj)%dcp)
  end do
 end do
end subroutine cprj2_free

!==============================================

subroutine cprj1_nullify(cprj)

 use defs_basis
 use defs_datatypes

 implicit none
!Arguments ------------------------------------
!scalars
!arrays
 type(cprj_type),intent(inout) :: cprj(:)
!Local variables-------------------------------
 integer :: ii,n1dim
!----------------------------------------------
 n1dim=size(cprj)
 do ii=1,n1dim
  cprj(ii)%cp(:,:)=zero
  if (cprj(ii)%ncpgr>0) cprj(ii)%dcp(:,:,:)=zero
 end do
end subroutine cprj1_nullify

!==============================================

subroutine cprj2_nullify(cprj)

 use defs_basis
 use defs_datatypes

 implicit none
!Arguments ------------------------------------
!scalars
!arrays
 type(cprj_type),intent(inout) :: cprj(:,:)
!Local variables-------------------------------
 integer :: ii,jj,n1dim,n2dim
!----------------------------------------------
 n1dim=size(cprj,dim=1);n2dim=size(cprj,dim=2)
 do jj=1,n2dim
  do ii=1,n1dim
   cprj(ii,jj)%cp(:,:)=zero
   if (cprj(ii,jj)%ncpgr>0) cprj(ii,jj)%dcp(:,:,:)=zero
  end do
 end do
end subroutine cprj2_nullify

!!***
