; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine --instcombine-max-iterations=0 -S | FileCheck %s --check-prefix=ZERO
; RUN: opt < %s -instcombine --instcombine-max-iterations=1 -S | FileCheck %s --check-prefix=ONE
; RUN: opt < %s -instcombine -S | FileCheck %s --check-prefix=FIXPOINT
; RUN: not opt < %s -instcombine -S --instcombine-infinite-loop-threshold=3 2>&1 | FileCheck %s --check-prefix=LOOP

; Based on xor-of-icmps-with-extra-uses.ll. This requires multiple iterations of
; InstCombine to reach a fixpoint.

define i1 @v0_select_of_consts(i32 %X, i32* %selected) {
; ZERO-LABEL: @v0_select_of_consts(
; ZERO-NEXT:    [[COND0:%.*]] = icmp sgt i32 [[X:%.*]], 32767
; ZERO-NEXT:    [[COND1:%.*]] = icmp sgt i32 [[X]], -32768
; ZERO-NEXT:    [[SELECT:%.*]] = select i1 [[COND0]], i32 32767, i32 -32768
; ZERO-NEXT:    store i32 [[SELECT]], i32* [[SELECTED:%.*]]
; ZERO-NEXT:    [[RES:%.*]] = xor i1 [[COND0]], [[COND1]]
; ZERO-NEXT:    ret i1 [[RES]]

; ONE-LABEL: @v0_select_of_consts(
; ONE-NEXT:    [[COND0:%.*]] = icmp sle i32 [[X:%.*]], 32767
; ONE-NEXT:    [[COND0_NOT:%.*]] = xor i1 [[COND0]], true
; ONE-NEXT:    [[COND1:%.*]] = icmp sgt i32 [[X]], -32768
; ONE-NEXT:    [[SELECT:%.*]] = select i1 [[COND0_NOT]], i32 32767, i32 -32768
; ONE-NEXT:    store i32 [[SELECT]], i32* [[SELECTED:%.*]], align 4
; ONE-NEXT:    [[TMP1:%.*]] = and i1 [[COND0]], [[COND1]]
; ONE-NEXT:    ret i1 [[TMP1]]

; FIXPOINT-LABEL: @v0_select_of_consts(
; FIXPOINT-NEXT:    [[COND0_INV:%.*]] = icmp sgt i32 [[X:%.*]], 32767
; FIXPOINT-NEXT:    [[SELECT:%.*]] = select i1 [[COND0_INV]], i32 32767, i32 -32768
; FIXPOINT-NEXT:    store i32 [[SELECT]], i32* [[SELECTED:%.*]], align 4
; FIXPOINT-NEXT:    [[X_OFF:%.*]] = add i32 [[X]], 32767
; FIXPOINT-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[X_OFF]], 65535
; FIXPOINT-NEXT:    ret i1 [[TMP1]]

; LOOP: LLVM ERROR: Instruction Combining seems stuck in an infinite loop after 3 iterations.

  %cond0 = icmp sgt i32 %X, 32767
  %cond1 = icmp sgt i32 %X, -32768
  %select = select i1 %cond0, i32 32767, i32 -32768
  store i32 %select, i32* %selected
  %res = xor i1 %cond0, %cond1
  ret i1 %res
}
