//Original:/testcases/core/c_dsp32shift_ahalf_rp_s/c_dsp32shift_ahalf_rp_s.dsp
// Spec Reference: dsp32shift ashift
# mach: bfin

.include "testutils.inc"
	start



// Ashift : positive data, count (+)=left (half reg)
// d_lo = ashft (d_lo BY d_lo)
// RLx by RLx
imm32 r0, 0x00000000;
R0.L = -1;
imm32 r1, 0x00000001;
imm32 r2, 0x00000002;
imm32 r3, 0x00000003;
imm32 r4, 0x00000004;
imm32 r5, 0x00000005;
imm32 r6, 0x00000006;
imm32 r7, 0x00000007;
//rl0 = ashift (rl0 by rl0);
R1.L = ASHIFT R1.L BY R0.L (S);
R2.L = ASHIFT R2.L BY R0.L (S);
R3.L = ASHIFT R3.L BY R0.L (S);
R4.L = ASHIFT R4.L BY R0.L (S);
R5.L = ASHIFT R5.L BY R0.L (S);
R6.L = ASHIFT R6.L BY R0.L (S);
R7.L = ASHIFT R7.L BY R0.L (S);
//CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00000000;
CHECKREG r2, 0x00000001;
CHECKREG r3, 0x00000001;
CHECKREG r4, 0x00000002;
CHECKREG r5, 0x00000002;
CHECKREG r6, 0x00000003;
CHECKREG r7, 0x00000003;

imm32 r0, 0x00001001;
R1.L = -1;
imm32 r2, 0x00002002;
imm32 r3, 0x00003003;
imm32 r4, 0x00004004;
imm32 r5, 0x00005005;
imm32 r6, 0x00006006;
imm32 r7, 0x00007007;
R0.L = ASHIFT R0.L BY R1.L (S);
//rl1 = ashift (rl1 by rl1);
R2.L = ASHIFT R2.L BY R1.L (S);
R3.L = ASHIFT R3.L BY R1.L (S);
R4.L = ASHIFT R4.L BY R1.L (S);
R5.L = ASHIFT R5.L BY R1.L (S);
R6.L = ASHIFT R6.L BY R1.L (S);
R7.L = ASHIFT R7.L BY R1.L (S);
CHECKREG r0, 0x00000800;
//CHECKREG r1, 0x00000001;
CHECKREG r2, 0x00001001;
CHECKREG r3, 0x00001801;
CHECKREG r4, 0x00002002;
CHECKREG r5, 0x00002802;
CHECKREG r6, 0x00003003;
CHECKREG r7, 0x00003803;


imm32 r0, 0x00001001;
imm32 r1, 0x00001001;
R2.L = -15;
imm32 r3, 0x00003003;
imm32 r4, 0x00004004;
imm32 r5, 0x00005005;
imm32 r6, 0x00006006;
imm32 r7, 0x00007007;
R0.L = ASHIFT R0.L BY R2.L (S);
R1.L = ASHIFT R1.L BY R2.L (S);
//rl2 = ashift (rl2 by rl2);
R3.L = ASHIFT R3.L BY R2.L (S);
R4.L = ASHIFT R4.L BY R2.L (S);
R5.L = ASHIFT R5.L BY R2.L (S);
R6.L = ASHIFT R6.L BY R2.L (S);
R7.L = ASHIFT R7.L BY R2.L (S);
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00000000;
//CHECKREG r2, 0x0000000f;
CHECKREG r3, 0x00000000;
CHECKREG r4, 0x00000000;
CHECKREG r5, 0x00000000;
CHECKREG r6, 0x00000000;
CHECKREG r7, 0x00000000;

imm32 r0, 0x00001001;
imm32 r1, 0x00001001;
imm32 r2, 0x00002002;
R3.L = -16;
imm32 r4, 0x00004004;
imm32 r5, 0x00005005;
imm32 r6, 0x00006006;
imm32 r7, 0x00007007;
R0.L = ASHIFT R0.L BY R3.L (S);
R1.L = ASHIFT R1.L BY R3.L (S);
R2.L = ASHIFT R2.L BY R3.L (S);
//rl3 = ashift (rl3 by rl3);
R4.L = ASHIFT R4.L BY R3.L (S);
R5.L = ASHIFT R5.L BY R3.L (S);
R6.L = ASHIFT R6.L BY R3.L (S);
R7.L = ASHIFT R7.L BY R3.L (S);
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00000000;
CHECKREG r2, 0x00000000;
//CHECKREG r3, 0x00000010;
CHECKREG r4, 0x00000000;
CHECKREG r5, 0x00000000;
CHECKREG r6, 0x00000000;
CHECKREG r7, 0x00000000;

// d_lo = ashft (d_hi BY d_lo)
// RHx by RLx
imm32 r0, 0x00000000;
imm32 r1, 0x00010000;
imm32 r2, 0x00020000;
imm32 r3, 0x00030000;
imm32 r4, 0x00040000;
imm32 r5, 0x00050000;
imm32 r6, 0x00060000;
imm32 r7, 0x00070000;
R0.L = ASHIFT R0.H BY R0.L (S);
R1.L = ASHIFT R1.H BY R0.L (S);
R2.L = ASHIFT R2.H BY R0.L (S);
R3.L = ASHIFT R3.H BY R0.L (S);
R4.L = ASHIFT R4.H BY R0.L (S);
R5.L = ASHIFT R5.H BY R0.L (S);
R6.L = ASHIFT R6.H BY R0.L (S);
R7.L = ASHIFT R7.H BY R0.L (S);
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00010001;
CHECKREG r2, 0x00020002;
CHECKREG r3, 0x00030003;
CHECKREG r4, 0x00040004;
CHECKREG r5, 0x00050005;
CHECKREG r6, 0x00060006;
CHECKREG r7, 0x00070007;

imm32 r0, 0x10010000;
R1.L = -1;
imm32 r2, 0x20020000;
imm32 r3, 0x30030000;
imm32 r4, 0x40040000;
imm32 r5, 0x50050000;
imm32 r6, 0x60060000;
imm32 r7, 0x70070000;
R0.L = ASHIFT R0.H BY R1.L (S);
//rl1 = ashift (rh1 by rl1);
R2.L = ASHIFT R2.H BY R1.L (S);
R3.L = ASHIFT R3.H BY R1.L (S);
R4.L = ASHIFT R4.H BY R1.L (S);
R5.L = ASHIFT R5.H BY R1.L (S);
R6.L = ASHIFT R6.H BY R1.L (S);
R7.L = ASHIFT R7.H BY R1.L (S);
CHECKREG r0, 0x10010800;
//CHECKREG r1, 0x00010001;
CHECKREG r2, 0x20021001;
CHECKREG r3, 0x30031801;
CHECKREG r4, 0x40042002;
CHECKREG r5, 0x50052802;
CHECKREG r6, 0x60063003;
CHECKREG r7, 0x70073803;


imm32 r0, 0x10010000;
imm32 r1, 0x10010000;
R2.L = -15;
imm32 r3, 0x30030000;
imm32 r4, 0x40040000;
imm32 r5, 0x50050000;
imm32 r6, 0x60060000;
imm32 r7, 0x70070000;
R0.L = ASHIFT R0.H BY R2.L (S);
R1.L = ASHIFT R1.H BY R2.L (S);
//rl2 = ashift (rh2 by rl2);
R3.L = ASHIFT R3.H BY R2.L (S);
R4.L = ASHIFT R4.H BY R2.L (S);
R5.L = ASHIFT R5.H BY R2.L (S);
R6.L = ASHIFT R6.H BY R2.L (S);
R7.L = ASHIFT R7.H BY R2.L (S);
CHECKREG r0, 0x10010000;
CHECKREG r1, 0x10010000;
//CHECKREG r2, 0x2002000f;
CHECKREG r3, 0x30030000;
CHECKREG r4, 0x40040000;
CHECKREG r5, 0x50050000;
CHECKREG r6, 0x60060000;
CHECKREG r7, 0x70070000;

imm32 r0, 0x10010001;
imm32 r1, 0x10010001;
imm32 r2, 0x20020002;
R3.L = -16;
imm32 r4, 0x40040004;
imm32 r5, 0x50050005;
imm32 r6, 0x60060006;
imm32 r7, 0x70070007;
R0.L = ASHIFT R0.H BY R3.L (S);
R1.L = ASHIFT R1.H BY R3.L (S);
R2.L = ASHIFT R2.H BY R3.L (S);
//rl3 = ashift (rh3 by rl3);
R4.L = ASHIFT R4.H BY R3.L (S);
R5.L = ASHIFT R5.H BY R3.L (S);
R6.L = ASHIFT R6.H BY R3.L (S);
R7.L = ASHIFT R7.H BY R3.L (S);
CHECKREG r0, 0x10010000;
CHECKREG r1, 0x10010000;
CHECKREG r2, 0x20020000;
//CHECKREG r3, 0x30030010;
CHECKREG r4, 0x40040000;
CHECKREG r5, 0x50050000;
CHECKREG r6, 0x60060000;
CHECKREG r7, 0x70070000;

// d_hi = ashift (d_lo BY d_lo)
// RLx by RLx
imm32 r0, 0x00000001;
imm32 r1, 0x00000001;
imm32 r2, 0x00000002;
imm32 r3, 0x00000003;
imm32 r4, 0x00000000;
imm32 r5, 0x00000005;
imm32 r6, 0x00000006;
imm32 r7, 0x00000007;
R0.H = ASHIFT R0.L BY R4.L (S);
R1.H = ASHIFT R1.L BY R4.L (S);
R2.H = ASHIFT R2.L BY R4.L (S);
R3.H = ASHIFT R3.L BY R4.L (S);
//rh4 = ashift (rl4 by rl4);
R5.H = ASHIFT R5.L BY R4.L (S);
R6.H = ASHIFT R6.L BY R4.L (S);
R7.H = ASHIFT R7.L BY R4.L (S);
CHECKREG r0, 0x00010001;
CHECKREG r1, 0x00010001;
CHECKREG r2, 0x00020002;
CHECKREG r3, 0x00030003;
//CHECKREG r4, 0x00040004;
CHECKREG r5, 0x00050005;
CHECKREG r6, 0x00060006;
CHECKREG r7, 0x00070007;

imm32 r0, 0x00000001;
imm32 r1, 0x00000001;
imm32 r2, 0x00000002;
imm32 r3, 0x00000003;
imm32 r4, 0x00000004;
R5.L = -1;
imm32 r6, 0x00000006;
imm32 r7, 0x00000007;
R0.H = ASHIFT R0.L BY R5.L (S);
R1.H = ASHIFT R1.L BY R5.L (S);
R2.H = ASHIFT R2.L BY R5.L (S);
R3.H = ASHIFT R3.L BY R5.L (S);
R4.H = ASHIFT R4.L BY R5.L (S);
//rh5 = ashift (rl5 by rl5);
R6.H = ASHIFT R6.L BY R5.L (S);
R7.H = ASHIFT R7.L BY R5.L (S);
CHECKREG r0, 0x00000001;
CHECKREG r1, 0x00000001;
CHECKREG r2, 0x00010002;
CHECKREG r3, 0x00010003;
CHECKREG r4, 0x00020004;
//CHECKREG r5, 0x00020005;
CHECKREG r6, 0x00030006;
CHECKREG r7, 0x00030007;


imm32 r0, 0x00001001;
imm32 r1, 0x00001001;
imm32 r1, 0x00002002;
imm32 r3, 0x00003003;
imm32 r4, 0x00004004;
imm32 r5, 0x00005005;
R6.L = -15;
imm32 r7, 0x00007007;
R0.H = ASHIFT R0.L BY R6.L (S);
R1.H = ASHIFT R1.L BY R6.L (S);
R2.H = ASHIFT R2.L BY R6.L (S);
R3.H = ASHIFT R3.L BY R6.L (S);
R4.H = ASHIFT R4.L BY R6.L (S);
R5.H = ASHIFT R5.L BY R6.L (S);
//rh6 = ashift (rl6 by rl6);
R7.H = ASHIFT R7.L BY R6.L;
CHECKREG r0, 0x00001001;
CHECKREG r1, 0x00002002;
CHECKREG r2, 0x00000002;
CHECKREG r3, 0x00003003;
CHECKREG r4, 0x00004004;
CHECKREG r5, 0x00005005;
//CHECKREG r6, 0x00006006;
CHECKREG r7, 0x00007007;

imm32 r0, 0x00001001;
imm32 r1, 0x00002001;
imm32 r2, 0x00002002;
imm32 r3, 0x00003003;
imm32 r4, 0x00004004;
imm32 r5, 0x00005005;
imm32 r6, 0x00006006;
R7.L = -16;
R0.H = ASHIFT R0.L BY R7.L (S);
R1.H = ASHIFT R1.L BY R7.L (S);
R2.H = ASHIFT R2.L BY R7.L (S);
R3.H = ASHIFT R3.L BY R7.L (S);
R4.H = ASHIFT R4.L BY R7.L (S);
R5.H = ASHIFT R5.L BY R7.L (S);
R6.H = ASHIFT R6.L BY R7.L (S);
R7.H = ASHIFT R7.L BY R7.L (S);
CHECKREG r0, 0x00001001;
CHECKREG r1, 0x00002001;
CHECKREG r2, 0x00002002;
CHECKREG r3, 0x00003003;
CHECKREG r4, 0x00004004;
CHECKREG r5, 0x00005005;
CHECKREG r6, 0x00006006;
//CHECKREG r7, 0x00007007;

// d_lo = ashft (d_hi BY d_lo)
// RHx by RLx
imm32 r0, 0x00010000;
imm32 r1, 0x00010000;
imm32 r2, 0x00020000;
imm32 r3, 0x00030000;
R4.L = -1;
imm32 r5, 0x00050000;
imm32 r6, 0x00060000;
imm32 r7, 0x00070000;
R0.H = ASHIFT R0.H BY R4.L (S);
R1.H = ASHIFT R1.H BY R4.L (S);
R2.H = ASHIFT R2.H BY R4.L (S);
R3.H = ASHIFT R3.H BY R4.L (S);
//rh4 = ashift (rh4 by rl4);
R5.H = ASHIFT R5.H BY R4.L (S);
R6.H = ASHIFT R6.H BY R4.L (S);
R7.H = ASHIFT R7.H BY R4.L (S);
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00000000;
CHECKREG r2, 0x00010000;
CHECKREG r3, 0x00010000;
//CHECKREG r4, 0x00020000;
CHECKREG r5, 0x00020000;
CHECKREG r6, 0x00030000;
CHECKREG r7, 0x00030000;

imm32 r0, 0x10010000;
imm32 r1, 0x10010000;
imm32 r2, 0x20020000;
imm32 r3, 0x30030000;
imm32 r4, 0x40040000;
R5.L = -1;
imm32 r6, 0x60060000;
imm32 r7, 0x70070000;
R0.H = ASHIFT R0.H BY R5.L (S);
R1.H = ASHIFT R1.H BY R5.L (S);
R2.H = ASHIFT R2.H BY R5.L (S);
R3.H = ASHIFT R3.H BY R5.L (S);
R4.H = ASHIFT R4.H BY R5.L (S);
//rh5 = ashift (rh5 by rl5);
R6.H = ASHIFT R6.H BY R5.L (S);
R7.H = ASHIFT R7.H BY R5.L (S);
CHECKREG r0, 0x08000000;
CHECKREG r1, 0x08000000;
CHECKREG r2, 0x10010000;
CHECKREG r3, 0x18010000;
CHECKREG r4, 0x20020000;
//CHECKREG r5, 0x28020000;
CHECKREG r6, 0x30030000;
CHECKREG r7, 0x38030000;


imm32 r0, 0x10010000;
imm32 r1, 0x10010000;
imm32 r2, 0x20020000;
imm32 r3, 0x30030000;
imm32 r4, 0x40040000;
imm32 r5, 0x50050000;
R6.L = -15;
imm32 r7, 0x70070000;
R0.L = ASHIFT R0.H BY R6.L (S);
R1.L = ASHIFT R1.H BY R6.L (S);
R2.L = ASHIFT R2.H BY R6.L (S);
R3.L = ASHIFT R3.H BY R6.L (S);
R4.L = ASHIFT R4.H BY R6.L (S);
R5.L = ASHIFT R5.H BY R6.L (S);
//rl6 = ashift (rh6 by rl6);
R7.L = ASHIFT R7.H BY R6.L;
CHECKREG r0, 0x10010000;
CHECKREG r1, 0x10010000;
CHECKREG r2, 0x20020000;
CHECKREG r3, 0x30030000;
CHECKREG r4, 0x40040000;
CHECKREG r5, 0x50050000;
//CHECKREG r6, 0x60060000;
CHECKREG r7, 0x70070000;

imm32 r0, 0x10010000;
imm32 r1, 0x10010000;
imm32 r2, 0x20020000;
imm32 r2, 0x30030000;
imm32 r4, 0x40040000;
imm32 r5, 0x50050000;
imm32 r6, 0x60060000;
R7.L = -16;
R0.H = ASHIFT R0.H BY R7.L (S);
R1.H = ASHIFT R1.H BY R7.L (S);
R2.H = ASHIFT R2.H BY R7.L (S);
R3.H = ASHIFT R3.H BY R7.L (S);
R4.H = ASHIFT R4.H BY R7.L (S);
R5.H = ASHIFT R5.H BY R7.L (S);
R6.H = ASHIFT R6.H BY R7.L (S);
//rh7 = ashift (rh7 by rl7);
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00000000;
CHECKREG r2, 0x00000000;
CHECKREG r3, 0x00000000;
CHECKREG r4, 0x00000000;
CHECKREG r5, 0x00000000;
CHECKREG r6, 0x00000000;
//CHECKREG r7, -16;
pass
