// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 4>, 512> hypergeometric_1F1_small_random = {{
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3120496888848085298500150407682059028781e-07) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.6514289704448319804813725126456961678164e-07) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4251648118650251187396410170163027341567e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9329883887952291363912923641903252697671e+05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.6022834664829109580559513943614433234837e+05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1202798760022712181196496058323664735578e+07) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5173092391411281539208311318861329133408e+07) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3965802816047186826219234476118783495661e+08) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-6.0578133795338771807914542394423097784312e+05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-4.2629221827214476289450605410767463229413e+05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.1420600673577551684343184889890782039808e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.6549360518646681912216258020249589194284e+05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.0265493171455343234400728774614777155838e+06) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3967144700010162771560607627370644163103e+07) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8250794750569058416086979379365475589740e+07) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2309523541272620250099190622367582626138e+08) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(5.2855614987939496930875473152426286733340e+10) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.8669459997258647094663831763157735745831e+10) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.0514246519661881369608735922752109633659e+09) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1172705179905930516504576753453180135315e+07) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1832887320858921363869110588116464085771e+07) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(7.3320112927934212101555413508931525023065e+08) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.0268975553354738854637567365813196985563e+09) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.6874573394773905777796041306114389147700e+09) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.1989539219190365351299833491996336922842e+04) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8894176498265838967612097238992226655969e+04) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.6521349860645664571395498516248737801550e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.9965351801351068182544390352654527597974e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.3443955361690253710359920766938221868510e-04) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6715801850599329113888396268349420290184e-04) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8189420343349571525478843028876274491794e-04) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1658763232911819859902138099116413203592e-04) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.5670145172858639910784798616014438326848e+04) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3505676338816138948159832359173370818393e+04) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.7054704087396405833672214515503944931885e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8011535892784451992487023483324227105376e-06) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.1644358626415491804864782440440637597976e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.4000329115595817714545552969885615119490e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.1410919180653436669585849183246001717522e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(3.2186884192070860308578815852209554773358e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(5.6449628347049920034132752188153310983823e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.9137084156912851306010547587449555596374e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.1040396786489372945099179347243447381418e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9970206644090035762195506703568019902269e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.7559440609855314028372435364328560462573e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-3.4216478343038136772422729854406626419965e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-3.4221101490033313848022866474309421464624e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4263596968144243123015049822712650844623e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(5.1243680862823312928567175014433964551909e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.4649900741995189687740863907774694642193e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.0147796609043424793300235109905125644633e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.1060599705789567218314411207527577397969e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.4907480420480231769767676618398510232266e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.9041621925172190961303555771795657906625e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-3.1116641567529802374902389587400950237174e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.4422835478933816738535662804601488032637e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.6821761835815310418326149340607662295557e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.3532606320759611042488323726715012095548e+03) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(5.7901024588453629014694171480502272966594e+02) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.4415328976051365725092911216704515173059e-05) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.3140285596123391966881705133801611200206e-06) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(7.8373068873386762880729094337970488531995e-06) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.2399279041930723747120018704848547261193e-06) },
      { SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4844493347101439224683098657410390361681e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.5295363119981548432477817961911347884918e+05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.0760474608915101604896460036340644439742e+05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.7847284175382149640209289575093299662281e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.5797295124645983704336977220361885928953e+05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.4686361335340117787094919491783865467739e+05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6923902705266714606977231482224281502211e+07) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.3949613253296433952920990672285022624418e+07) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.9133807144107665152166675735396934343908e+08) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3120496888848085298500150407682059028781e-07) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.6514289704448319804813725126456961678164e-07) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4251648118650251187396410170163027341567e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9329883887952291363912923641903252697671e+05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.6022834664829109580559513943614433234837e+05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1202798760022712181196496058323664735578e+07) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5173092391411281539208311318861329133408e+07) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3965802816047186826219234476118783495661e+08) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4121986020116719336513101403429615978892e+10) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.7715650262931614083807558987859641104350e+10) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(5.0211976874414691093822916494094145202953e+08) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2333324824661804044106129536125493288080e+07) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-3.5926009120090977437980402660995802836312e+07) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.3569360443733178479863749801886215845067e+08) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(5.2945502077251844191270359032333436225263e+08) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(5.8080657175636251990970364230737566272893e+09) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8032861699573921010497549726710535169614e+04) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.5539346291698192484388303421884155066598e+04) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.0992397958104072841964166291852590818105e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.6657128625670909382146485720636985017468e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4244637172729459235660019830675754869061e-04) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6038775570381389054355291619438299504651e-04) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.9206133001365324570672240973002365030018e-04) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-4.0618022150514502766061815052822647043731e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2919324453314579430047435480793068153285e+04) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.1166631089157724072844278861328009481401e+04) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.3070228265205118790840531660519069705255e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9225490626809122686275086732093761562576e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.9071870674695635989227274421173156558038e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.7793170501274042996879065069268285480609e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(7.3074907077505893178554978092885731150731e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.8625846891186062843573315700777672115430e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.7325037281235987294867482851471960717058e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.1306640772743857791126008068155340646964e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.5569628542161936547123448651296867117085e+02) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.5459910752829485928645325356444029276549e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.2487681498811089485450818009692278785407e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-3.5868048952167815070501794230675453357197e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-3.9003852945505494601871914805926600426929e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.5772591525086872957548133557766797994708e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.3030870931925586276148634058309649044776e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.7595411130078445799294402559409293324058e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.7971133105217078279603933337999321607462e+02) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.4679120650755861743256474936730645634113e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.7280462171115517884364224162541156241774e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.8232073906336698578410743256808745606408e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-3.3200115296602167801297845957412184332101e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(5.0165345973751404414187511504890132101417e-06) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.2775802946119446714257345546659536682749e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0034909656560749865301888236897975662240e+03) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(5.0693721541955714898186221013724917594001e+02) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-3.0413326555306784328534475843594525690694e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1851166954007668464033423961302543580978e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3004957705654620200871882745872201683724e-05) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.3793238996635548923553310853906771366475e-06) },
      { SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.7835234591882636803322110054196929502919e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-3.0451243913624449617830211259151047977990e+01) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2326478880476154231630584606198873393421e+01) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.7599440498844765932841954169935337188657e-01) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-3.1489751851849973806482594898393887926630e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-8.8598996718608615225404267426411709258865e+03) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1299490018915043306622785884403740653413e+06) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.7790670219748349540571253569653750009920e+06) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-4.3050876657728837401617922435186453081542e+07) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1598172373398533151601135239567212348641e+01) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.5901405005513945167095160825542043467064e+01) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-4.3218045988885433385140658643050112706871e-01) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.6130132990770915076454393915327119729078e+03) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.1337897504181756653757022896637704895566e+03) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-3.4270206979760145514384924253753372183752e+05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.4174359704933205736501374925920142077558e+05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.2705512884780301195733337956490050084263e+07) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3120496888848085298500150407682059028781e-07) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.6514289704448319804813725126456961678164e-07) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4251648118650251187396410170163027341567e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9329883887952291363912923641903252697671e+05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.6022834664829109580559513943614433234837e+05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1202798760022712181196496058323664735578e+07) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5173092391411281539208311318861329133408e+07) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3965802816047186826219234476118783495661e+08) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.3019404580540436591443744371693647629277e+03) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0445428425756686250290179750930680327446e+03) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(5.6578921595041916021057436233245855709638e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.3550513273681563966998651832867416081713e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.6318004123894090188596930710900286163370e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-4.9505519073054219769033510997973126389556e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.8868682159987405461925506924210757798619e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4353100731301451704712474875762291055953e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.7475700744510918018419663821696356996005e+03) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.5561707335333164814476820945002464913735e+03) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.4377951247546863001865356866552576287863e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(7.1927801518685284693992291514349212112735e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8819418699540550505457634873587221199281e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.3965611726932542577922666652202374416053e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.4167667636515312343920607802499274021060e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-4.0770909051054036833428883164321086286703e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(7.6671818126069086591753665574088996609269e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.8841732267904837549980387416579779368351e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.1604754883160634632112619249174307970883e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.7423182141088438336624155394652156856188e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.5196914533349479797448111229921512401343e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.5081051649079121920763227801871331081759e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5391500588457422378828345347164807108574e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.1818344560367944350641211218770916238701e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(7.0948634093766988400578512772392759919177e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.3755566497821506375963981937652889664783e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0199319096786776690204829680704636943638e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.5086896931911123252114792352246014370288e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.5528421510314406979361628592140281802811e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2985670343024574772365816180915865141287e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.4000098370292025954015792360610659400296e-04) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.3473871829616656751687497639678208009936e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.2312510976788754549453851971914034707446e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.8240178294341960718380507055642213065785e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2934059192933983712251141094639498418020e+02) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7043697777843857061866426709413942964674e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-3.1754190635890216298904267647419258502137e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-3.1577441286369241844453896986544393242930e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.0172623225776644183927274043691289719817e-05) },
      { SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.0517534494272832768181027751639267683978e-05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(5.9018671048291382632236323496181689162022e+03) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8674940733628850191480655165899247282664e+04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.7461018265207334901047996919962103685069e+04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-8.8917119123277862517019489613860759401694e+21) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.1397889473361454876320978480588360999447e+22) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-6.3753572230076668633735950291283559628146e+25) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.2724587566093616836274698800391926493189e+26) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6757374181178062034481018018799106545618e+28) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.3194815175946097953211508258852935196589e+03) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.6678775774031319317037063124451867117327e+03) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4528629890075419626805805840732244983440e+03) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1864548274917455574903942850799795198619e+21) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.7231248964072985592368390097585343094834e+22) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4528806491452938667923267541806321562641e+25) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.8837930701119822847532010343450253449282e+25) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-3.6573269375901574436927072154992530675117e+27) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.5367096501778559308642601922205409580530e+03) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.1796835340040542119669759574236320890460e+02) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.3176836858995374340579272875068840307922e+03) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8268317544810350736543526047273141584104e+21) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.1952659861002386162233726797831781564887e+22) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(5.6943697730702966245136356980294300047723e+24) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.0696041350948222661809673787432502604290e+25) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3187883425176201213377821394428384276335e+26) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3120496888848085298500150407682059028781e-07) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.6514289704448319804813725126456961678164e-07) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4251648118650251187396410170163027341567e-05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9329883887952291363912923641903252697671e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.6022834664829109580559513943614433234837e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1202798760022712181196496058323664735578e+07) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5173092391411281539208311318861329133408e+07) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3965802816047186826219234476118783495661e+08) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0332724015507928034818792441559777265077e-06) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.6417658957723157471538764732475635911842e-06) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.2354500185269017497456454410561139636145e-05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6911830164806445624467690641440268503946e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.7098531346020710588451834914961541501568e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(5.7855466392193200972758001309998343719825e+06) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(7.7691964027275262135651452508090600527306e+06) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7341100608963667983403174723208115454247e+07) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.0223342297463067748666840238196963958093e-05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.8768585683703140450349488425310087921697e-05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.7732195014452360490589155897483942151856e-04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.2509281923595721234566849200767271235236e+04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.5602690436140735035415800993818376983369e+04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(7.7689817687853847867075337605311448124097e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.0143434795465473114159850755855088541444e+06) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(7.2102343199969028571365111583452798996298e+06) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.9811571327087777339359663877058856908770e-05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.0143288253838480997642813535097315087139e-05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(4.4477104949149809486486945402852556197156e-04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.7843013597834737129893394534342194152923e+04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(5.5719824142506883767777974733082538260729e+04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.4181622683247715042880857260273315083754e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.3559065824961770364388980209336043210761e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(5.8208423588894476926910724149663085084606e+06) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.7808519205544928224646419065229518178041e-04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0994688806017777240444172295674663499122e-04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.1971101747236666318864291827942970828092e-03) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.9655390999726991054193408096805681023555e+03) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8828065633665836389458154056348815017061e+04) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.7887742431650131661453007173083236072620e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.2829332195244531470323938067475417885630e+05) },
      { SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3804306524155016858113356982323885038172e+06) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-3.0154400338339732784237759012362621220086e+04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.2215288273975793251460075671656661720919e+04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.5948977373568832897940930102605968288528e+03) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.5299795502720373089339921202191857914137e+22) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.0664430146709159815701332729670633902312e+23) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.9514242813828713319755529054138525319194e+26) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-3.9171313261850816376568884267208876753587e+26) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.3703137459481754717079187371166521541773e+28) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.0354304171461768488238212910306645009486e+03) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(7.9605205067065023132842124099593598448468e+03) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.9508582506638021376955350809247639642191e+03) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-6.1877706978928118683986341075259508041579e+21) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-4.9609777727991916409071230675379176744327e+22) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-4.4253203969404219505476798436542157343741e+25) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-8.8342789860575027535132010422818214158620e+25) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1666538626332430721001445259122699632906e+28) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.9681009792568430770373302335516123768037e+03) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-4.6491188500375156642925418664586923258438e+03) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.2881779456505952235984237079801473499213e+03) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.8905012260155990276850670238374439751683e+21) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.2591748910165150948037029603560514215581e+22) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6488616333400832031262785007370893137803e+25) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.1160987410761943828892861288471846458473e+25) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8339151489416033146187529829336400349667e+27) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.0356436200218190188305844554200222470273e-08) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.4488375041910521370194277851982457545724e-08) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8009302244985416636019012443932537514914e-06) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(5.1547091172610548447426076597333280519887e+05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.1907106657232138523143880618896203230668e+06) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.1979186267120677639759236287714512029729e+07) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.0023573631459876305805089353170870138419e+07) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.9337986612516399435613927270160054940116e+08) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3120496888848085298500150407682059028781e-07) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.6514289704448319804813725126456961678164e-07) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4251648118650251187396410170163027341567e-05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9329883887952291363912923641903252697671e+05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.6022834664829109580559513943614433234837e+05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1202798760022712181196496058323664735578e+07) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5173092391411281539208311318861329133408e+07) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3965802816047186826219234476118783495661e+08) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6523014457451224750458614231537123090873e-05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0459350525188605814092814750495566861752e-05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.9654541519306088828791404725728035001895e-04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(5.3931998033249823317571459403797229653858e+04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.1165601340406612660299140985684849371246e+05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.4386160874777444978934572880296675941693e+06) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8945287801299103250579885883657682802421e+06) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.4308232335702328476030187072607425130773e+07) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.1160770766201238173445619439373029730128e-05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.6065248950003583640649686312292691183896e-05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.3679280615931795088038110521844740176169e-04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.5980666343479844303267283046473116318220e+04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.4399875123834299143908646518696125456906e+04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1829462473858973571830808577026052570020e+06) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5533989900304739586449907257452285539821e+06) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.1497560654022251493405084285405227278532e+07) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.9744434491290418294054849111400685321682e-05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.0740630580695761013309973837806154353590e-04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(7.1583245621041471882118264672890566254498e-04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.5937082693539157265300465846164821373378e+04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(3.0877015953959067081672213134625709757652e+04) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(3.1888508743700531577544846314872533368378e+05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(4.1047979819747060601787274735960691076845e+05) },
      { SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.6371043742148350681900119825488979534840e+06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-6.6744887308837553878597692412935934640335e+04) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1400244139561081083537177270443060475309e+05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.1489683995626448978707748759461207397190e+05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.6903064235667896057913197105766031089569e+23) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-6.6545497218122144911365694912665115209897e+24) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.5946490273107176607996888150236166197718e+27) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.5541972983409731606552688384257487211224e+28) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.4414461947801187874467212744106925287631e+30) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-3.5225889717704026404321021222405697522244e+04) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-3.7451463363766780202572217432219490150916e+04) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.2508860630175281069818839089882478066698e+04) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.8480653363451303608216346531127518298704e+23) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.5702880715971884746882266216074065925178e+24) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6947702962605472739919748289598861257577e+27) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-3.4495856463195519390563360992755473262203e+27) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.2236183147422620934531472780612224802319e+29) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.0346570770079095745367309280428735233761e+03) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6016243893509556084967836596505748170656e+03) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3140572608817271717660207777379288507970e+04) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2186282418234649425362796424637575322424e+23) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.6403901742786347207144171531866423515671e+23) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(5.3519970916100177420913364995756379211077e+26) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.0324513502887174749515981414700148590528e+27) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.0850590408191999400914102111962814013023e+29) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(7.3139783010068609531909577919541248845558e-09) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3257184633107102394298143876469602883632e-09) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.0488597992006679519107943446062575841957e-07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.3639654858363443528150487580578783993881e+06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.4540818116493890711254007438303326382247e+06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0543228769682352724942842593442619347725e+08) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8854625701275756743822863172776422415572e+08) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(3.4283350239143550331092154761156912455834e+09) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4607019616650192499727344930703111284640e-09) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-4.5979364361046539168786518964599059884463e-09) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-4.5921441133771238599432747296936489475217e-07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8354473275487467851514466661187105909167e+06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.4951049322330278225648350502741932608680e+06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.0045738351445305609876891113952935952685e+08) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3991436629239611289054395158053768873213e+08) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.5670329315511096633964131231368868939332e+09) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3120496888848085298500150407682059028781e-07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.6514289704448319804813725126456961678164e-07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4251648118650251187396410170163027341567e-05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9329883887952291363912923641903252697671e+05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.6022834664829109580559513943614433234837e+05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1202798760022712181196496058323664735578e+07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5173092391411281539208311318861329133408e+07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3965802816047186826219234476118783495661e+08) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(5.5271233496735913564666794620976400511392e-07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(7.5914916875703889215127783566202970743133e-07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.9425944380251898469834630926606379962461e-05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4646872462090840687547900369449044813665e+05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(5.5011523380058445473536536035985754139481e+05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.0769681087934851825413019564915419602253e+06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2258850254993147756640669136391179577673e+07) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.1058851011724460813508898145919256110348e+08) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.3817438718426232490497583028623962661928e-06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1428128934749626262788131073217355001697e-06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.0381372920384592584041187699461962861841e-04) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(7.7136544228044400104161607474064462314293e+04) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6228119603961207702567701328894177333716e+05) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.2019055171728270205693047343258003838015e+06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.9147810604362358599300806889760716510127e+06) },
      { SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.2821684388639910529006686926322794069655e+07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-3.3786079759797590808984317911346624764556e+04) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-9.3496276405284069848304049533908658234902e+04) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2043859497297950638445966984004238033467e+05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.0877937444528210925385252698750559878425e+24) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-9.4697931077481438583474801850408242563782e+24) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1023556537956931992939450353131993919660e+28) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2604537009556897907009761290112361841241e+28) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-3.6017221446436074864415013900794700226409e+30) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-3.4552958111509998320369768946486277175235e+04) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-4.0229935833466176954590444380133860746786e+04) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.7793632758420047857985908211839700752955e+04) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.6094234180836962969189567103992887956120e+23) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2307010339808698506343423994566630766059e+24) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.4559186671973560887774129925100573729749e+27) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.0089908065749251570707751452533995009651e+27) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.6941462390059997083934850865397787822688e+29) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.3724130641241442652847058915530068310060e+03) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.6512042410322615705555043339367432888966e+03) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.0776104989641034604456144302183811125192e+04) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6894126341671740531844476083468131593230e+23) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2055858812516013909907287893665786434040e+24) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(7.6265749929705910160260543897540953414616e+26) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.4743901857670335656805665456291057812936e+27) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.5730213263177715060310924096508751646960e+29) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.0479590890543261035394514374958922929689e-09) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2652449272719880368870124747795369785683e-09) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1064559935354473537980215056659598063894e-07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(4.0818301633679359998427884619860583966506e+06) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.0346410502831595827467543636379549636993e+07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.5853860934250200248299752753002723893872e+08) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.6416807336104312273471458693818702387924e+08) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(4.4137211379887037658847087870521013565668e+09) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4364946530206824705485643664305197571609e-09) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2277293593510569589864987280341736437617e-09) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-3.9357633946467930200971264459220347901393e-07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.2179206160542887726873326541723881945331e+06) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(5.4785305218397806570953573896432394356562e+06) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2590979345663378175578931305876915698388e+08) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.7586243854916542285373548034935690233542e+08) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0093427015157143156735493458231518515419e+09) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8332985142472296459731404801528852269803e-07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.6570180266612295383316931831408894144740e-07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.0223725478184394721619417738524829029976e-05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(3.4952742386149593194033742515638262718149e+05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(7.9352710393860533543120925832175954409484e+05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3846692583903654390436924097706149695126e+07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8807551705608587620432081966071776462096e+07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.7662520399340415891458468375888704674135e+08) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3120496888848085298500150407682059028781e-07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.6514289704448319804813725126456961678164e-07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4251648118650251187396410170163027341567e-05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9329883887952291363912923641903252697671e+05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.6022834664829109580559513943614433234837e+05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1202798760022712181196496058323664735578e+07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5173092391411281539208311318861329133408e+07) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3965802816047186826219234476118783495661e+08) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(4.6581681892540383501478463118031412407911e-06) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(5.9944964382553332016037230723583573912894e-06) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.3100476907705210866349942374893753829258e-05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.0866681814566423528323424814838797136482e+04) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.9277829175167031485297770612953135856474e+05) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.6893527446534422557422269885320253938161e+06) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(3.5701797159668420975853064757255682241214e+06) },
      { SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8520795431827307371738207162585312072388e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.6563873368760511780521246628968760518053e+05) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.2098167750912612219990003991858411954497e+05) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-3.8908628844436806317171077160345616521658e+04) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.2498942558963726704736448459318175966619e+25) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1362308317886897460574894612469296432753e+26) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.5244662912388707524398686005845858062142e+29) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-3.1715735819334722137610503263462022822917e+29) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5962565715895689699140826040540333778677e+31) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(5.0603525369281782588975927469610608099251e+04) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.2978518998050318788244669773353218887864e+04) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.6369098104251351740069691222185843330287e+04) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.9608884179355564156899104922331169699996e+24) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.6437963655523371751425133052900104651680e+25) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-3.3574389064262330038378199688383381750013e+28) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-6.9480041328906163760339265546050379723919e+28) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1824973584595516457063617922549320910745e+31) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.3734796935740764732237397432081801561638e+04) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(3.0251743280848807874354556946097139230236e+04) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.9754307744638005837815481352590101108479e+04) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6856649880274742071497736362202772609001e+24) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2597403666720717146576510741149742483034e+25) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.2664178436164317665277902918954034538230e+27) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8190615678713277684864915572574398896348e+28) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.1616631109398825886200779976466403808998e+30) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.4139881435092200947670874172981153369396e-09) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6714153765383299037375128990008313257288e-09) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(5.8961219114157176009203753643741401272383e-08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6170735637748533369011241074730568849583e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(4.3538757721347850395141280798132441423945e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3247117778591164816461171410454867687330e+09) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.9035594447417219646912897871397447981090e+09) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.6543560716040885951347022286983486927033e+10) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(5.2641356488262031155151336633004067475305e-10) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.2610346648539095125131840493711504523632e-09) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8681828984038410005572396715146464266342e-08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.5387686758153553359516348505834386130386e+06) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.2404112697061464627834364767519114509809e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2714163706058565731054540761376631007250e+08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.9365593665353087599545649419662464718217e+08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.1752710297767515765591266019206780271583e+10) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.1492896571744523966974190971761814891321e-08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.5650206266819267073855727677151521184391e-08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(3.1255936611185462320692055413437162854227e-07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.2224150652257202079653653002301168169908e+06) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.9468837164738657077909646958494664127708e+06) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2630946752114898730425989148728917021982e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.6796693509628163998328813105234762826280e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3914114153622278068435254456419222813017e+08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.2436646885496169830438464415251725982313e-08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.5544087033210144463951641400055154118599e-08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(7.7183950873317155964308966865051892388579e-07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.0156389799403500669478284838514371698044e+06) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4274842558080851917896568397129443739949e+06) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(5.0163489606219798790064747772030434421459e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.9320762490630180220354517542992633577637e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(7.3516047749839877587097845911430358353540e+08) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(3.3120496888848085298500150407682059028781e-07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(4.6514289704448319804813725126456961678164e-07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.4251648118650251187396410170163027341567e-05) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.9329883887952291363912923641903252697671e+05) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.6022834664829109580559513943614433234837e+05) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.1202798760022712181196496058323664735578e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.5173092391411281539208311318861329133408e+07) },
      { SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.3965802816047186826219234476118783495661e+08) }
   }};
//#undef SC_
