# ---------------------------------
# Finds OpenAL, ALUT, OGGVORBIS
# Adds library to target
# Adds include path
# ---------------------------------

IF(WIN32)
	FIND_PATH(PATH_OPENAL include/al.h PATHS $ENV{OV_DEP_OPENAL} $ENV{OpenViBE_dependencies} NO_DEFAULT_PATH)
	FIND_PATH(PATH_ALUT include/AL/alut.h PATHS $ENV{OV_DEP_ALUT} $ENV{OpenViBE_dependencies})
	FIND_PATH(PATH_OGG include/ogg/ogg.h PATHS $ENV{OV_DEP_OGG} $ENV{OpenViBE_dependencies})
	FIND_PATH(PATH_VORBIS include/vorbis/vorbisfile.h PATHS $ENV{OV_DEP_VORBIS} $ENV{OpenViBE_dependencies})
	
	IF(CMAKE_BUILD_TYPE STREQUAL "Debug")
		SET(BUILDTYPE_PATH "debug")
	ELSE(CMAKE_BUILD_TYPE STREQUAL "Debug")
		SET(BUILDTYPE_PATH "release")
	ENDIF(CMAKE_BUILD_TYPE STREQUAL "Debug")
		
	IF(PATH_OPENAL)

		MESSAGE(STATUS "  Found OpenAL...")
		IF(PATH_ALUT)
			MESSAGE(STATUS "  & Found ALUT...")
			IF(PATH_OGG)
				MESSAGE(STATUS "  & Found OGG...")
				IF(PATH_VORBIS)
					MESSAGE(STATUS "  & Found VORBIS...")
					INCLUDE_DIRECTORIES(${PATH_OPENAL}/include ${PATH_ALUT}/include ${PATH_OGG}/include ${PATH_VORBIS}/include)
										
					FIND_LIBRARY(LIB_OPENAL OpenAL32 PATHS ${PATH_OPENAL}/libs/Win32 NO_DEFAULT_PATH)
					IF(LIB_OPENAL)
						MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENAL}")
						TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENAL})
					ELSE(LIB_OPENAL)
						MESSAGE(STATUS "    [FAILED] lib OpenAL32")
					ENDIF(LIB_OPENAL)
					
					FIND_LIBRARY(LIB_ALUT alut PATHS ${PATH_ALUT}/lib NO_DEFAULT_PATH)
					IF(LIB_ALUT)
						MESSAGE(STATUS "    [  OK  ] lib ${LIB_ALUT}")
						TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_ALUT})
					ELSE(LIB_ALUT)
						MESSAGE(STATUS "    [FAILED] lib alut")
					ENDIF(LIB_ALUT)
					
					FIND_LIBRARY(LIB_OGG libogg PATHS $ENV{OV_DEP_OGG}/win32/lib/${BUILDTYPE_PATH} NO_DEFAULT_PATH)
					IF(LIB_OGG)
						MESSAGE(STATUS "    [  OK  ] lib ${LIB_OGG}")
						TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OGG})
					ELSE(LIB_OGG)
						MESSAGE(STATUS "    [FAILED] lib ogg")
					ENDIF(LIB_OGG)
					
					FIND_LIBRARY(LIB_VORBIS libvorbis PATHS $ENV{OV_DEP_VORBIS}/win32/lib/${BUILDTYPE_PATH} NO_DEFAULT_PATH)
					IF(LIB_VORBIS)
						MESSAGE(STATUS "    [  OK  ] lib ${LIB_VORBIS}")
						TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_VORBIS})
					ELSE(LIB_VORBIS)
						MESSAGE(STATUS "    [FAILED] lib vorbis")
					ENDIF(LIB_VORBIS)
					
					FIND_LIBRARY(LIB_VORBISFILE libvorbisfile PATHS $ENV{OV_DEP_VORBIS}/win32/lib/${BUILDTYPE_PATH} NO_DEFAULT_PATH)
					IF(LIB_VORBISFILE)
						MESSAGE(STATUS "    [  OK  ] lib ${LIB_VORBISFILE}")
						TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_VORBISFILE})
					ELSE(LIB_VORBISFILE)
						MESSAGE(STATUS "    [FAILED] lib vorbisfile")
					ENDIF(LIB_VORBISFILE)
					
					ADD_DEFINITIONS(-DTARGET_HAS_ThirdPartyOpenAL)
				ELSE(PATH_VORBIS)
					MESSAGE(STATUS "  -- FAILED to find VORBIS")
				ENDIF(PATH_VORBIS)
			ELSE(PATH_OGG)
				MESSAGE(STATUS "  -- FAILED to find OGG")
			ENDIF(PATH_OGG)
		ELSE(PATH_ALUT)
			MESSAGE(STATUS "  -- FAILED to find ALUT")
		ENDIF(PATH_ALUT)
	ELSE(PATH_OPENAL)
		MESSAGE(STATUS "  FAILED to find OpenAL")
	ENDIF(PATH_OPENAL)
ENDIF(WIN32)

IF(UNIX)
	INCLUDE("FindThirdPartyPkgConfig")
	pkg_check_modules(ALUT freealut)

	IF(ALUT_FOUND)
		MESSAGE(STATUS "  Found ALUT...")
		INCLUDE_DIRECTORIES(${ALUT_INCLUDE_DIRS})
		ADD_DEFINITIONS(${ALUT_CFLAGS})
		ADD_DEFINITIONS(${ALUT_CFLAGS_OTHERS})
		LINK_DIRECTORIES(${ALUT_LIBRARY_DIRS})
		FOREACH(ALUT_LIB ${ALUT_LIBRARIES})
			SET(ALUT_LIB1 "ALUT_LIB1-NOTFOUND")
			FIND_LIBRARY(ALUT_LIB1 NAMES ${ALUT_LIB} PATHS ${ALUT_LIBRARY_DIRS} ${ALUT_LIBDIR} NO_DEFAULT_PATH)
			FIND_LIBRARY(ALUT_LIB1 NAMES ${ALUT_LIB})
			IF(ALUT_LIB1)
				MESSAGE(STATUS "    [  OK  ] Third party lib ${ALUT_LIB1}")
				TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${ALUT_LIB1})
			ELSE(ALUT_LIB1)
				MESSAGE(STATUS "    [FAILED] Third party lib ${ALUT_LIB}")
			ENDIF(ALUT_LIB1)
		ENDFOREACH(ALUT_LIB)
	ELSE(ALUT_FOUND)
		MESSAGE(STATUS "  FAILED to find ALUT...")
	ENDIF(ALUT_FOUND)
	
	pkg_check_modules(VORBIS vorbisfile)

	IF(VORBIS_FOUND)
		MESSAGE(STATUS "  Found VORBIS...")
		INCLUDE_DIRECTORIES(${VORBIS_INCLUDE_DIRS})
		ADD_DEFINITIONS(${VORBIS_CFLAGS})
		ADD_DEFINITIONS(${VORBIS_CFLAGS_OTHERS})
		LINK_DIRECTORIES(${VORBIS_LIBRARY_DIRS})
		FOREACH(VORBIS_LIB ${VORBIS_LIBRARIES})
			SET(VORBIS_LIB1 "VORBIS_LIB1-NOTFOUND")
			FIND_LIBRARY(VORBIS_LIB1 NAMES ${VORBIS_LIB} PATHS ${VORBIS_LIBRARY_DIRS} ${VORBIS_LIBDIR} NO_DEFAULT_PATH)
			FIND_LIBRARY(VORBIS_LIB1 NAMES ${VORBIS_LIB})
			IF(VORBIS_LIB1)
				MESSAGE(STATUS "    [  OK  ] Third party lib ${VORBIS_LIB1}")
				TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${VORBIS_LIB1})
			ELSE(VORBIS_LIB1)
				MESSAGE(STATUS "    [FAILED] Third party lib ${VORBIS_LIB}")
			ENDIF(VORBIS_LIB1)
		ENDFOREACH(VORBIS_LIB)
		ADD_DEFINITIONS(-DTARGET_HAS_ThirdPartyOpenAL)
	ELSE(VORBIS_FOUND)
		MESSAGE(STATUS "  FAILED to find VORBIS...")
	ENDIF(VORBIS_FOUND)
	
ENDIF(UNIX)


