# ---------------------------------
# Finds GSL toolkit
#
# Sets GSL_FOUND
# Sets GSL_LIBRARIES
# Sets GSL_LIBRARY_DIRS
# Sets GSL_LDFLAGS
# Sets GSL_LDFLAGS_OTHERS
# Sets GSL_INCLUDE_DIRS
# Sets GSL_CFLAGS
# Sets GSL_CFLAGS_OTHERS
#
# Adds library to target
# Adds include path
# ---------------------------------

INCLUDE("FindThirdPartyPkgConfig")
pkg_check_modules(GSL gsl)

IF(GSL_FOUND)
	MESSAGE(STATUS "  Found gsl...")
	INCLUDE_DIRECTORIES(${GSL_INCLUDE_DIRS})
	ADD_DEFINITIONS(${GSL_CFLAGS})
	ADD_DEFINITIONS(${GSL_CFLAGS_OTHERS})
	LINK_DIRECTORIES(${GSL_LIBRARY_DIRS})
	FOREACH(GSL_LIB ${GSL_LIBRARIES})
		SET(GSL_LIB1 "GSL_LIB1-NOTFOUND")
		FIND_LIBRARY(GSL_LIB1 NAMES ${GSL_LIB} PATHS ${GSL_LIBRARY_DIRS} ${GSL_LIBDIR} NO_DEFAULT_PATH)
		FIND_LIBRARY(GSL_LIB1 NAMES ${GSL_LIB})
		IF(GSL_LIB1)
			MESSAGE(STATUS "    [  OK  ] Third party lib ${GSL_LIB1}")
			TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${GSL_LIB1})
		ELSE(GSL_LIB1)
			MESSAGE(STATUS "    [FAILED] Third party lib ${GSL_LIB}")
		ENDIF(GSL_LIB1)
	ENDFOREACH(GSL_LIB)

	ADD_DEFINITIONS(-DTARGET_HAS_ThirdPartyGSL)
ELSE(GSL_FOUND)
	MESSAGE(STATUS "  FAILED to find gsl...")
ENDIF(GSL_FOUND)
