# ---------------------------------
# Finds EXPAT toolkit
#
# Sets EXPAT_FOUND
# Sets EXPAT_LIBRARIES
# Sets EXPAT_LIBRARY_DIRS
# Sets EXPAT_LDFLAGS
# Sets EXPAT_LDFLAGS_OTHERS
# Sets EXPAT_INCLUDE_DIRS
# Sets EXPAT_CFLAGS
# Sets EXPAT_CFLAGS_OTHERS
# ---------------------------------
IF(UNIX)
	FIND_PATH(EXPAT_expat_INCLUDE_PATH "expat.h"
		PATHS "$ENV{OpenViBE_dependencies}/include")
	FIND_LIBRARY(EXPAT_expat_LIBRARY
		NAMES expat
		PATHS "$ENV{OpenViBE_dependencies}/lib")
ENDIF(UNIX)

IF(WIN32)
	FIND_PATH(EXPAT_expat_INCLUDE_PATH "expat.h"
		PATHS "$ENV{OV_DEP_EXPAT}/Source/lib")
	FIND_LIBRARY(EXPAT_expat_LIBRARY
		NAMES libexpat
		PATHS "$ENV{OV_DEP_EXPAT}/Libs" "$ENV{OV_DEP_EXPAT}/Bin")
ENDIF(WIN32)

IF(EXPAT_expat_INCLUDE_PATH)
IF(EXPAT_expat_LIBRARY)
	SET(EXPAT_FOUND TRUE)
	SET(EXPAT_LIBRARIES ${EXPAT_expat_LIBRARY})
	SET(EXPAT_LIBRARY_DIRS "")
	SET(EXPAT_LDFLAGS "")
	SET(EXPAT_LDFLAGS_OTHERS "")
	SET(EXPAT_INCLUDE_DIRS ${EXPAT_expat_INCLUDE_PATH})
	SET(EXPAT_CFLAGS "")
	SET(EXPAT_CFLAGS_OTHERS "")
ENDIF(EXPAT_expat_LIBRARY)
ENDIF(EXPAT_expat_INCLUDE_PATH)

MARK_AS_ADVANCED(
	EXPAT_expat_INCLUDE_PATH
	EXPAT_expat_LIBRARY

	EXPAT_FOUND
	EXPAT_LIBRARIES
	EXPAT_LIBRARY_DIRS
	EXPAT_LDFLAGS
	EXPAT_LDFLAGS_OTHERS
	EXPAT_INCLUDE_DIRS
	EXPAT_CFLAGS
	EXPAT_CFLAGS_OTHERS
)

IF(EXPAT_FOUND)
	MESSAGE(STATUS "  Found expat...")
	INCLUDE_DIRECTORIES(${EXPAT_INCLUDE_DIRS})
	ADD_DEFINITIONS(${EXPAT_CFLAGS})
	ADD_DEFINITIONS(${EXPAT_CFLAGS_OTHERS})
	LINK_DIRECTORIES(${EXPAT_LIBRARY_DIRS})
	TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${EXPAT_LIBRARIES})

	ADD_DEFINITIONS(-DTARGET_HAS_ThirdPartyExpat)
ELSE(EXPAT_FOUND)
	MESSAGE(STATUS "  FAILED to find expat...")
ENDIF(EXPAT_FOUND)

