# ---------------------------------
# Finds module Stream
# Adds library to target
# Adds include path
# ---------------------------------
OPTION(DYNAMIC_LINK_OPENVIBE_MODULE_STREAM "Dynamically link OpenViBE module Stream" ON)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_STREAM)
	ADD_DEFINITIONS(-DStream_Shared)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_STREAM)

IF(DYNAMIC_LINK_OPENVIBE_MODULE_STREAM)
	SET(OPENVIBE_MODULE_STREAM_LINKING dynamic)
ELSE(DYNAMIC_LINK_OPENVIBE_MODULE_STREAM)
	SET(OPENVIBE_MODULE_STREAM_LINKING static)
ENDIF(DYNAMIC_LINK_OPENVIBE_MODULE_STREAM)

FIND_PATH(PATH_OPENVIBE_MODULES_STREAM include/stream/defines.h PATHS $ENV{OpenViBE_modules}/stream $ENV{OpenViBE_module_stream})
IF(PATH_OPENVIBE_MODULES_STREAM)
	MESSAGE(STATUS "  Found OpenViBE module Stream...")
	INCLUDE_DIRECTORIES(${PATH_OPENVIBE_MODULES_STREAM}/include)
	FIND_LIBRARY(LIB_OPENVIBE_MODULE_STREAM OpenViBE-module-Stream-${OPENVIBE_MODULE_STREAM_LINKING} PATHS ${PATH_OPENVIBE_MODULES_STREAM}/lib)
	IF(LIB_OPENVIBE_MODULE_STREAM)
		MESSAGE(STATUS "    [  OK  ] lib ${LIB_OPENVIBE_MODULE_STREAM}")
		TARGET_LINK_LIBRARIES(${PROJECT_NAME}-dynamic ${LIB_OPENVIBE_MODULE_STREAM})
	ELSE(LIB_OPENVIBE_MODULE_STREAM)
		MESSAGE(STATUS "    [FAILED] lib OpenViBE-module-Stream-${OPENVIBE_MODULE_STREAM_LINKING}")
	ENDIF(LIB_OPENVIBE_MODULE_STREAM)

	ADD_DEFINITIONS(-DTARGET_HAS_Stream)
ELSE(PATH_OPENVIBE_MODULES_STREAM)
	MESSAGE(STATUS "  FAILED to find OpenViBE module Stream...")
ENDIF(PATH_OPENVIBE_MODULES_STREAM)
