
package edu.jhu.ece.iacl.processcontrol;



import java.lang.*;
import java.io.*;
import org.ggf.drmaa.*;

import edu.jhu.ece.iacl.pipeline.ExecutionContext;

import java.util.*;
import java.text.SimpleDateFormat;

import javax.swing.JOptionPane;
 

public class ProcessControllerDRMAA implements ProcessController {
	
	private String JobID; 
	private String JobNam;
	private JobTemplate jt; 
	private long JobSubmitTime; 
	private long JobRunningTime;
	private Integer exitCode;
	private UUID randFileName = UUID.randomUUID();
	private File tempFile = null;
	private static final String DATE_FORMAT = "yyyy-MM-dd_HH-mm-ss";
	private Session session;
	private HashMap<String, String> map;
	
	//public ProcessControllerDRMAA(String Command)
	public ProcessControllerDRMAA()
	{	
		session = DispatchController.getDRMAASession();
		map = new HashMap<String, String>(16, 1);  //create a hashmap to map env variable to Remote Env
		map.put("DISPLAY", ":99");
		JOptionPane.showMessageDialog(null, "DISPLAY SET");
	}
	
	// New Code
	public boolean Setup(List<String> CommandList) {
		System.out.println("Setup PC-DRMAA");
		System.out.println(CommandList);
		StringWriter sw = new StringWriter();
		for(String  s : CommandList)  {
			if(s.contains(" ")) {
				sw.append("\""+s+"\"");
			} else {
				sw.append(s);
			}
			sw.append(" ");
		}
		String Command = sw.toString();
		JOptionPane.showMessageDialog(null, "before Temp Set");
		System.out.println(Command);	
		//String tempFolder = System.getenv("SGE_JOBSCRIPT_TEMP"); //a better description
		String tempFolder = "/home/jie/temp";
		JOptionPane.showMessageDialog(null, "Temp Dir Set");
		System.out.println(tempFolder);
		if(tempFolder == null)
			return false;
		/*if(tempFolder.isEmpty())
			return false;*/
		tempFile = new File(tempFolder+"/Run_"+nowTime()+"_"+randFileName.toString()+".sh"); // random script Execution File
		try{
			Writer fwriter = new BufferedWriter(new FileWriter(tempFile));
			fwriter.write("#!/bin/sh");
			fwriter.write("\n");
			fwriter.write("setenv SGE_JOBSCRIPT_TEMP "+tempFolder);
			fwriter.write("\n");
			fwriter.write("setenv DISPLAY :99");
			fwriter.write("\n");
			fwriter.write("setenv LD_LIBRARY_PATH /XR1/sge/lib/lx24-x86");
			fwriter.write("\n");
			System.out.println(Command);
			fwriter.write(Command);
			fwriter.close();
			}
		catch(IOException e) {
			JOptionPane.showMessageDialog(null, "IO Error : " + e.getMessage());
			return false;
		}
		
		try{
			jt = session.createJobTemplate();
			jt.setNativeSpecification("-shell yes -b no ");
			jt.setRemoteCommand(tempFile.toString());
			jt.setJobEnvironment(map);
		}
		catch(DrmaaException e) {
			System.out.println("Exception" +e);
			return false;
		}
		return true;
	}
	
	private static String nowTime()
	{
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
		return sdf.format(cal.getTime());
	}
	
	@Override
	public Process getProcess()
	{
		return null;
	}
	
	@Override
	public long getSubmissionTime()
	{
		return JobSubmitTime;
	}
	@Override 
	public String toString()
	{
		return JobID;
	}
	
	@Override
	public ProcessStatus getStatus() {
		// TODO Auto-generated method stub
		ProcessStatus JobStatus = null;
		try{
			Session session = DispatchController.getDRMAASession();
			int status = session.getJobProgramStatus(JobID);
			switch (status) {
			case Session.UNDETERMINED:
				JobStatus = ProcessStatus.UNDETERMINE;
				break;
			case Session.QUEUED_ACTIVE:
				JobStatus = ProcessStatus.QUEUED_ACTIVE;			
				break;
			case Session.SYSTEM_ON_HOLD:
				JobStatus = ProcessStatus.SYSTEM_ON_HOLD;	
				break;
			case Session.USER_ON_HOLD:
				JobStatus = ProcessStatus.USER_ON_HOLD;		
				break;
			case Session.USER_SYSTEM_ON_HOLD:
				JobStatus = ProcessStatus.USER_SYSTEM_ON_HOLD;				
				break;
			case Session.RUNNING:
				JobStatus = ProcessStatus.RUNNING;
				break;
			case Session.SYSTEM_SUSPENDED:
				JobStatus = ProcessStatus.SYSTEM_SUSPENDED;
				break;
			case Session.USER_SUSPENDED:
				JobStatus = ProcessStatus.USER_SUSPENDED;	
				break;
			case Session.USER_SYSTEM_SUSPENDED:
				JobStatus = ProcessStatus.USER_SYSTEM_SUSPENDED;;
				break;
			case Session.DONE:
				JobStatus = ProcessStatus.DONE;
				break;
			case Session.FAILED:
				JobStatus = ProcessStatus.FAILED;;
				break;
			}
		}catch (DrmaaException e)
		{
			System.out.println("Exception:" + e);
		}
		return JobStatus;
	}

	@Override
	public InputStream getStderrFile() {
		// TODO Auto-generated method stub
		File ErrorFile = null;
		try{
			ErrorFile = new File(jt.getErrorPath());
			} catch(DrmaaException e)
			{
				System.out.println("Exception:" + e);
			}
			try {
		InputStream io = new FileInputStream(ErrorFile);
		return io;
			} catch(IOException e) {
				return null;
			}
		
	}

	@Override
	public InputStream getStdoutFile() {
		// TODO Auto-generated method stub
		File OutputFile = null;
		try{
			OutputFile = new File(jt.getOutputPath());
			System.out.println(jt.getOutputPath());
			} catch(DrmaaException e)
			{
				System.out.println("Exception:" + e);
			}
			try {
				InputStream io = new FileInputStream(OutputFile);
				return io;
					} catch(Exception e) {
						return null;
					}
	}

	@Override
	public boolean submit() {
		// TODO Auto-generated method stub
		   try{
			   	Session session = DispatchController.getDRMAASession();
		    	JobID = session.runJob(jt);	
		    	System.out.println("Job" + JobID + "is submitted");
		        JobSubmitTime = System.currentTimeMillis();
		        return true;
		    }
			 catch (DrmaaException e)
			{
				System.out.println("Exception:" + e);
				return false;
			}
		
	}

	@Override
	public boolean destroy() {
		// TODO Auto-generated method stub
		try{
		DispatchController.getDRMAASession().control(JobID, Session.TERMINATE);
		//tempFile.delete();
		}catch(DrmaaException e)
		{
			System.out.println("Exception:" + e);
		}
		return false;
	}
	@Override 
	public Integer getExitCode()
	{
		return exitCode; 
	}
	
	@Override 
	public int waitFor()
	{
		try{
		JobInfo info = DispatchController.getDRMAASession().wait(JobID, Session.TIMEOUT_WAIT_FOREVER);
		exitCode = 0;
		}catch(DrmaaException e)
		{
		exitCode = -1;	
		}
		return exitCode;
	}
	@Override
	public void controlJob(ProcessControlAction Action)
	{
		String JobStatus = "";
		Session session = DispatchController.getDRMAASession();
		
		try{		
		if(Action == Action.SUSPEND ){
			session.control(JobID, Session.SUSPEND);
				JobStatus = "suspended";
		}
		else if(Action == Action.RELEASE ){
				session.control(JobID, Session.RELEASE);
				JobStatus = "Released";
		}
		else if(Action == Action.HOLD ){
				session.control(JobID, Session.HOLD);
				JobStatus = "Put on Hold";
		}
		else if (Action == Action.RESUME ){
				session.control(JobID, Session.RESUME);
				JobStatus = "Resumed";
		}
		else if (Action == Action.TERMINATE){
				session.control(JobID, Session.TERMINATE);
				JobStatus = "KILLED";
		System.out.println(JobStatus);
		}
		}catch(DrmaaException e)
		{
			System.out.println("Exception:" + e);
		}			
	
	}

}
