/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.splines;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.splines.LinearSpline;
import JSci.maths.wavelet.splines.Spline;

public class QuadraticSpline
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = 2;
    private double[] vecteur;
    static final double[] vg = new double[]{0.25, 0.75, 0.75, 0.25};
    static final double[] v0 = new double[]{0.75, 0.25};

    public String toString() {
        return ArrayMath.toString((double[])this.vecteur);
    }

    public int getFilterType() {
        return 2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof QuadraticSpline && this.vecteur.length == ((QuadraticSpline)object).dimension()) {
            QuadraticSpline quadraticSpline = (QuadraticSpline)object;
            for (int i = 0; i < this.vecteur.length; ++i) {
                if (this.vecteur[i] == quadraticSpline.getValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(2, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 3) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 3");
        }
        double[] dArray2 = new double[2 * dArray.length - 2];
        for (int i = 1; i < dArray.length - 1; ++i) {
            int n = 2 * i - 2;
            dArray2[n] = dArray2[n] + dArray[i] * vg[0];
            int n2 = 2 * i - 1;
            dArray2[n2] = dArray2[n2] + dArray[i] * vg[1];
            int n3 = 2 * i;
            dArray2[n3] = dArray2[n3] + dArray[i] * vg[2];
            int n4 = 2 * i + 1;
            dArray2[n4] = dArray2[n4] + dArray[i] * vg[3];
        }
        dArray2[0] = dArray2[0] + v0[0] * dArray[0];
        dArray2[1] = dArray2[1] + v0[1] * dArray[0];
        int n = dArray2.length - 1;
        dArray2[n] = dArray2[n] + v0[0] * dArray[dArray.length - 1];
        int n5 = dArray2.length - 2;
        dArray2[n5] = dArray2[n5] + v0[1] * dArray[dArray.length - 1];
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        return this.lowpass(dArray);
    }

    public QuadraticSpline(double[] dArray) {
        this.vecteur = dArray;
    }

    public QuadraticSpline() {
    }

    public Object clone() {
        QuadraticSpline quadraticSpline = (QuadraticSpline)super.clone();
        if (this.vecteur != null) {
            quadraticSpline.vecteur = ArrayMath.copy((double[])this.vecteur);
        }
        return quadraticSpline;
    }

    public double getValue(int n) {
        if (n < 0 || n > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Parameter incorrect : " + n + ", " + this.vecteur.length);
        }
        return this.vecteur[n];
    }

    public void setValue(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive : " + n);
        }
        this.vecteur[n] = d;
    }

    public void setValues(double[] dArray) {
        this.vecteur = dArray;
    }

    public LinearSpline derive() {
        return this.derive(0.0, 1.0);
    }

    public LinearSpline derive(double d, double d2) {
        double[] dArray = new double[this.vecteur.length - 1];
        for (int i = 0; i < this.vecteur.length - 1; ++i) {
            dArray[i] = 2.0 * (this.vecteur[i + 1] - this.vecteur[i]) * (double)this.vecteur.length / Math.abs(d2 - d);
        }
        return new LinearSpline(dArray);
    }

    public int dimension() {
        return this.vecteur.length;
    }

    public int dimension(int n) {
        return Cascades.dimension(this.vecteur.length, n, 2);
    }

    public double[] interpolate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + n);
        }
        return Cascades.evaluation(this, n, this.vecteur);
    }

    public double[] evaluate(int n) {
        return this.interpolate(n);
    }
}

