/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.ApplicationConfigurer;
import ptolemy.actor.Initializable;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class SharedParameter
extends Parameter
implements Initializable {
    private boolean _constructionFinished = false;
    private Class _containerClass;
    private static final boolean _delayValidation = false;
    private static Collection<WeakReference<SharedParameter>> _EMPTY_LIST = new LinkedList<WeakReference<SharedParameter>>();
    private transient List<Initializable> _initializables;
    private SharedParameter _sharedParameter;
    private long _sharedParameterVersion = -1L;
    private HashSet<SharedParameter> _sharedParameterSet;
    private long _sharedParameterSetVersion = -1L;
    private static HashMap<Workspace, SharedParameterRegistry> _REGISTRY = new HashMap();
    private boolean _suppressingPropagation = false;

    public SharedParameter(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        this(container, name, null, "");
    }

    public SharedParameter(NamedObj container, String name, Class containerClass) throws IllegalActionException, NameDuplicationException {
        this(container, name, containerClass, "");
    }

    public SharedParameter(NamedObj container, String name, Class containerClass, String defaultValue) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        if (containerClass == null) {
            containerClass = container.getClass();
        }
        this._containerClass = containerClass;
        this.inferValueFromContext(defaultValue);
        this._constructionFinished = true;
    }

    @Override
    public void addInitializable(Initializable initializable) {
        if (this._initializables == null) {
            this._initializables = new LinkedList<Initializable>();
        }
        this._initializables.add(initializable);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SharedParameter newObject = (SharedParameter)super.clone(workspace);
        SharedParameterRegistry registry = SharedParameter._getSharedParameterRegistry(this.workspace());
        registry.register(newObject);
        return newObject;
    }

    @Override
    public Token getToken() throws IllegalActionException {
        return super.getToken();
    }

    public NamedObj getRoot() {
        NamedObj result = this;
        while (((NamedObj)result).getContainer() != null) {
            if (!((result = ((NamedObj)result).getContainer()) instanceof ApplicationConfigurer)) continue;
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inferValueFromContext(String defaultValue) {
        Variable candidate = null;
        NamedObj toplevel = this.getRoot();
        if (toplevel != null && toplevel != this) {
            candidate = this._getOneSharedParameter(toplevel);
        }
        if (candidate != null) {
            defaultValue = candidate.getExpression();
        }
        boolean previousSuppressing = this._suppressingPropagation;
        try {
            this._suppressingPropagation = true;
            this.setExpression(defaultValue);
            if (candidate != null && candidate.isKnown()) {
                this.setToken(((SharedParameter)candidate).getToken());
            }
        }
        catch (IllegalActionException e) {
        }
        finally {
            this._suppressingPropagation = previousSuppressing;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.initialize();
            }
        }
    }

    public boolean isFireFunctional() {
        return true;
    }

    public boolean isStrict() {
        return false;
    }

    public boolean isSuppressingPropagation() {
        return this._suppressingPropagation;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.preinitialize();
            }
        }
    }

    @Override
    public void removeInitializable(Initializable initializable) {
        if (this._initializables != null) {
            this._initializables.remove(initializable);
            if (this._initializables.size() == 0) {
                this._initializables = null;
            }
        }
    }

    @Override
    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        NamedObj previousContainer = this.getContainer();
        if (previousContainer != container) {
            if (previousContainer instanceof Initializable) {
                ((Initializable)((Object)previousContainer)).removeInitializable(this);
            }
            if (container instanceof Initializable) {
                ((Initializable)((Object)container)).addInitializable(this);
            }
        }
        super.setContainer(container);
    }

    @Override
    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        if (name != null && !name.equals(this.getName())) {
            SharedParameterRegistry registry = SharedParameter._getSharedParameterRegistry(this.workspace());
            if (this.getName() != null && !this.getName().equals("")) {
                registry.unregister(this);
            }
            super.setName(name);
            registry.register(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpression(String expression) {
        if (expression != null && expression.equals(this.getExpression())) {
            return;
        }
        super.setExpression(expression);
        if (!this._suppressingPropagation) {
            for (SharedParameter sharedParameter : this.sharedParameterSet()) {
                if (sharedParameter == this) continue;
                try {
                    sharedParameter._suppressingPropagation = true;
                    if (sharedParameter.getExpression().equals(expression)) continue;
                    sharedParameter.setExpression(expression);
                }
                finally {
                    sharedParameter._suppressingPropagation = false;
                }
            }
        }
    }

    public void setSuppressingPropagation(boolean propagation) {
        this._suppressingPropagation = propagation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setToken(Token token) throws IllegalActionException {
        super.setToken(token);
        if (!this._suppressingPropagation) {
            for (SharedParameter sharedParameter : this.sharedParameterSet()) {
                if (sharedParameter == this) continue;
                try {
                    sharedParameter._suppressingPropagation = true;
                    sharedParameter.setToken(token);
                }
                finally {
                    sharedParameter._suppressingPropagation = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection sharedParameterSet() {
        if (this.workspace().getVersion() != this._sharedParameterSetVersion) {
            try {
                this.workspace().getReadAccess();
                this._sharedParameterSet = new HashSet();
                this._sharedParameterSetVersion = this.workspace().getVersion();
                NamedObj root = this.getRoot();
                if (root != null) {
                    SharedParameterRegistry registry = SharedParameter._getSharedParameterRegistry(this.workspace());
                    for (WeakReference<SharedParameter> reference : registry.getSharedParametersWithName(this.getName())) {
                        SharedParameter parameter;
                        if (reference == null || (parameter = (SharedParameter)reference.get()) == null || parameter.getRoot() != root || parameter._containerClass != this._containerClass) continue;
                        this._sharedParameterSet.add(parameter);
                    }
                }
            }
            finally {
                this.workspace().doneReading();
            }
        }
        return this._sharedParameterSet;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.wrapup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection validate() throws IllegalActionException {
        HashSet<SharedParameter> result = super.validate();
        if (result == null) {
            result = new HashSet<SharedParameter>();
        }
        if (!this._constructionFinished) {
            return result;
        }
        if (!this._suppressingPropagation) {
            for (SharedParameter sharedParameter : this.sharedParameterSet()) {
                if (sharedParameter == this) continue;
                try {
                    sharedParameter._suppressingPropagation = true;
                    result.addAll(sharedParameter.validate());
                    result.add(sharedParameter);
                }
                finally {
                    sharedParameter._suppressingPropagation = false;
                }
            }
        }
        return result;
    }

    @Override
    protected void _propagateValue(NamedObj destination) throws IllegalActionException {
        if (!this.sharedParameterSet().contains(destination)) {
            super._propagateValue(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedParameter _getOneSharedParameter(NamedObj container) {
        block6: {
            if (this.workspace().getVersion() != this._sharedParameterVersion) {
                try {
                    this.workspace().getReadAccess();
                    this._sharedParameter = null;
                    this._sharedParameterVersion = this.workspace().getVersion();
                    NamedObj root = this.getRoot();
                    if (root == null) break block6;
                    SharedParameterRegistry registry = SharedParameter._getSharedParameterRegistry(this.workspace());
                    for (WeakReference<SharedParameter> reference : registry.getSharedParametersWithName(this.getName())) {
                        SharedParameter parameter;
                        if (reference == null || (parameter = (SharedParameter)reference.get()) == null || parameter == this || parameter.getRoot() != root || parameter._containerClass != this._containerClass) continue;
                        SharedParameter sharedParameter = this._sharedParameter = parameter;
                        return sharedParameter;
                    }
                }
                finally {
                    this.workspace().doneReading();
                }
            }
        }
        return this._sharedParameter;
    }

    private static synchronized SharedParameterRegistry _getSharedParameterRegistry(Workspace workspace) {
        SharedParameterRegistry result = _REGISTRY.get(workspace);
        if (result == null) {
            result = new SharedParameterRegistry();
            _REGISTRY.put(workspace, result);
        }
        return result;
    }

    private static class SharedParameterRegistry {
        private HashMap<String, Collection<WeakReference<SharedParameter>>> _sharedParametersByName = new HashMap();

        private SharedParameterRegistry() {
        }

        public synchronized Collection<WeakReference<SharedParameter>> getSharedParametersWithName(String name) {
            Collection<WeakReference<SharedParameter>> set = this._sharedParametersByName.get(name);
            if (set == null) {
                return _EMPTY_LIST;
            }
            return set;
        }

        public synchronized void register(SharedParameter parameter) {
            Collection<WeakReference<SharedParameter>> set = this._sharedParametersByName.get(parameter.getName());
            if (set == null) {
                set = new LinkedList<WeakReference<SharedParameter>>();
                this._sharedParametersByName.put(parameter.getName(), set);
            }
            set.add(new WeakReference<SharedParameter>(parameter));
        }

        public synchronized void unregister(SharedParameter parameter) {
            Collection<WeakReference<SharedParameter>> set = this._sharedParametersByName.get(parameter.getName());
            if (set != null) {
                set.remove(new WeakReference<SharedParameter>(parameter));
            }
        }
    }
}

