/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.media.javasound;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundReader {
    private AudioInputStream _properFormatAudioInputStream;
    private AudioInputStream _audioInputStream;
    private int _productionRate;
    private double[][] _audioInDoubleArray;
    private byte[] _data;
    private int _frameSizeInBytes;
    private int _sampleSizeInBits;
    private float _sampleRate;
    private int _channels;
    private int _bytesPerSample;
    private boolean _isAudioCaptureActive;
    private byte[] _b = new byte[1];
    private double[][] _doubleArray = new double[1][1];
    private boolean _debug = false;

    public SoundReader(String sourceURL, int getSamplesArraySize) throws IOException {
        this._productionRate = getSamplesArraySize;
        URL soundURL = new URL(sourceURL);
        this._openFileFromURL(soundURL);
        this._isAudioCaptureActive = true;
    }

    public SoundReader(URL soundURL, int getSamplesArraySize) throws IOException {
        this._productionRate = getSamplesArraySize;
        this._openFileFromURL(soundURL);
        this._isAudioCaptureActive = true;
    }

    public int getChannels() throws IllegalStateException {
        if (this._isAudioCaptureActive) {
            return this._channels;
        }
        throw new IllegalStateException("SoundReader: getChannels() was called while audio capture was inactive (openFile() was never called).");
    }

    public float getSampleRate() throws IllegalStateException {
        if (this._isAudioCaptureActive) {
            return this._sampleRate;
        }
        throw new IllegalStateException("SoundReader: getSampleRate() was called while audio capture was inactive (openFile() was never called).");
    }

    public double[][] getSamples() throws IOException, IllegalStateException {
        if (this._isAudioCaptureActive) {
            if (this._debug) {
                System.out.println("SoundReader: getSamples(): invoked");
            }
            if (this._debug) {
                System.out.println("SoundReader: getSamples(): bytes available = " + this._properFormatAudioInputStream.available());
            }
            int numBytesRead = this._properFormatAudioInputStream.read(this._data);
            if (this._debug) {
                System.out.println("SoundReader: getSamples(): numBytesRead = " + numBytesRead);
            }
            if (numBytesRead == this._data.length) {
                this._audioInDoubleArray = this._byteArrayToDoubleArray(this._data, this._bytesPerSample, this._channels);
                return this._audioInDoubleArray;
            }
            if (numBytesRead == -1) {
                if (this._debug) {
                    System.out.println("SoundReader: getSamples(): numBytesRead = -1, so returning null now...");
                }
                return null;
            }
            if (numBytesRead != this._data.length) {
                this._audioInDoubleArray = this._byteArrayToDoubleArray(this._data, this._bytesPerSample, this._channels);
                return this._audioInDoubleArray;
            }
            return null;
        }
        throw new IllegalStateException("SoundReader: getSamples() was called while audio capture was inactive (openFile() was never called or closeFile has already been called).");
    }

    public void closeFile() throws IOException {
        System.out.println("SoundReader: closeFile() invoked");
        if (this._isAudioCaptureActive) {
            if (this._audioInputStream != null) {
                this._audioInputStream.close();
            }
            if (this._properFormatAudioInputStream != null) {
                this._properFormatAudioInputStream.close();
            }
        }
        this._isAudioCaptureActive = false;
    }

    public int getBitsPerSample() throws IllegalStateException {
        if (this._isAudioCaptureActive) {
            return this._sampleSizeInBits;
        }
        throw new IllegalStateException("SoundReader: getSampleSizeInBits() was called while audio capture was inactive (openFile() was never called).");
    }

    private void _openFileFromURL(URL soundURL) throws IOException {
        if (soundURL != null) {
            try {
                this._audioInputStream = AudioSystem.getAudioInputStream(soundURL);
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException("Unsupported AudioFile :" + e);
            }
        }
        if (this._audioInputStream == null) {
            throw new IOException("No loaded audio to play back");
        }
        AudioFormat origFormat = this._audioInputStream.getFormat();
        this._sampleRate = origFormat.getSampleRate();
        if (this._debug) {
            System.out.println("SoundReader: sampling rate = " + this._sampleRate);
        }
        this._sampleSizeInBits = origFormat.getSampleSizeInBits();
        this._bytesPerSample = this._sampleSizeInBits / 8;
        if (this._debug) {
            System.out.println("SoundReader: sample size in bits = " + this._sampleSizeInBits);
        }
        this._channels = origFormat.getChannels();
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(this._sampleRate, this._sampleSizeInBits, this._channels, signed, bigEndian);
        if (this._debug) {
            System.out.println("Converted format: " + format.toString());
        }
        try {
            this._properFormatAudioInputStream = AudioSystem.getAudioInputStream(format, this._audioInputStream);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Unsupported audio file format: " + e);
        }
        this._frameSizeInBytes = format.getFrameSize();
        this._data = new byte[this._productionRate * this._frameSizeInBytes];
    }

    private double[][] _byteArrayToDoubleArray(byte[] byteArray, int bytesPerSample, int channels) {
        int lengthInSamples = byteArray.length / (bytesPerSample * channels);
        if (channels != this._doubleArray.length || lengthInSamples != this._doubleArray[0].length) {
            this._doubleArray = new double[channels][lengthInSamples];
        }
        double maxSampleReciprocal = bytesPerSample == 2 ? 3.0517578125E-5 : (bytesPerSample == 1 ? 0.0078125 : (bytesPerSample == 3 ? 1.1920928955E7 : (bytesPerSample == 4 ? 4.655661287308E-10 : 0.0)));
        if (bytesPerSample != this._b.length) {
            this._b = new byte[bytesPerSample];
        }
        for (int currSamp = 0; currSamp < lengthInSamples; ++currSamp) {
            for (int currChannel = 0; currChannel < channels; ++currChannel) {
                for (int i = 0; i < bytesPerSample; ++i) {
                    this._b[i] = byteArray[currSamp * bytesPerSample * channels + bytesPerSample * currChannel + i];
                }
                int result = this._b[0] >> 7;
                for (int i = 0; i < bytesPerSample; ++i) {
                    result = (result << 8) + (this._b[i] & 0xFF);
                }
                this._doubleArray[currChannel][currSamp] = (double)result * maxSampleReciprocal;
            }
        }
        return this._doubleArray;
    }
}

