/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.ComplexArrayMath;
import ptolemy.math.DoubleArrayMath;
import ptolemy.math.DoubleUnaryOperation;
import ptolemy.math.ExtendedMath;

public class SignalProcessing {
    public static final double EPSILON = 1.0E-9;
    public static final int DCT_TYPE_NORMALIZED = 0;
    public static final int DCT_TYPE_UNNORMALIZED = 1;
    public static final int DCT_TYPE_ORTHONORMAL = 2;
    public static final int DCT_TYPES = 3;
    public static final int WINDOW_TYPE_RECTANGULAR = 0;
    public static final int WINDOW_TYPE_BARTLETT = 1;
    public static final int WINDOW_TYPE_HANNING = 2;
    public static final int WINDOW_TYPE_HAMMING = 3;
    public static final int WINDOW_TYPE_BLACKMAN = 4;
    public static final int WINDOW_TYPE_BLACKMAN_HARRIS = 5;
    public static final int WINDOW_TYPES = 6;
    private static final double[][] _P1Table = new double[32][];
    private static final double[][] _P2Table = new double[32][];
    private static final double[][] _CTable = new double[32][];
    private static int _FFCTGenLimit = 0;
    private static final Complex[][][] _IDCTfactors = new Complex[3][32][];
    private static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    private static final double _LOG2SCALE = 1.0 / Math.log(2.0);
    private static final boolean _FORWARD_TRANSFORM = false;
    private static final boolean _INVERSE_TRANSFORM = true;

    private SignalProcessing() {
    }

    public static final boolean close(double first, double second) {
        double diff = first - second;
        return Math.abs(diff) < 1.0E-9;
    }

    public static final double[] convolve(double[] array1, double[] array2) {
        int resultSize = array1.length + array2.length - 1;
        if (resultSize < 0) {
            double[] result = new double[]{};
            return result;
        }
        double[] result = new double[resultSize];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array2.length; ++j) {
                int n = i + j;
                result[n] = result[n] + array1[i] * array2[j];
            }
        }
        return result;
    }

    public static final Complex[] convolve(Complex[] array1, Complex[] array2) {
        int i;
        int resultSize = array1.length + array2.length - 1;
        if (resultSize < 0) {
            Complex[] result = new Complex[]{};
            return result;
        }
        double[] reals = new double[resultSize];
        double[] imags = new double[resultSize];
        for (i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array2.length; ++j) {
                int n = i + j;
                reals[n] = reals[n] + (array1[i].real * array2[j].real - array1[i].imag * array2[j].imag);
                int n2 = i + j;
                imags[n2] = imags[n2] + (array1[i].imag * array2[j].real + array1[i].real * array2[j].imag);
            }
        }
        Complex[] result = new Complex[resultSize];
        for (i = 0; i < result.length; ++i) {
            result[i] = new Complex(reals[i], imags[i]);
        }
        return result;
    }

    public static final double[] DCT(double[] x) {
        return SignalProcessing.DCT(x, SignalProcessing.order(x.length), 0);
    }

    public static final double[] DCT(double[] x, int order) {
        return SignalProcessing.DCT(x, order, 0);
    }

    public static final double[] DCT(double[] x, int order, int type) {
        SignalProcessing._checkTransformArgs(x, order, false);
        if (type >= 3) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.DCT(): Unrecognized DCT type");
        }
        int size = 1 << order;
        if (order > _FFCTGenLimit) {
            SignalProcessing._FFCTTableGen(order);
        }
        double[] returnValue = SignalProcessing._DCT(x, size, order);
        switch (type) {
            case 2: {
                double factor = Math.sqrt(2.0 / (double)size);
                returnValue = DoubleArrayMath.scale(returnValue, factor);
            }
            case 0: {
                returnValue[0] = returnValue[0] * ExtendedMath.ONE_OVER_SQRT_2;
            }
        }
        return returnValue;
    }

    public static final double decibel(double value) {
        return SignalProcessing.toDecibels(value);
    }

    public static final double[] decibel(double[] values) {
        double[] result = new double[values.length];
        for (int i = values.length - 1; i >= 0; --i) {
            result[i] = SignalProcessing.toDecibels(values[i]);
        }
        return result;
    }

    public static final double[] downsample(double[] x, int n) {
        return SignalProcessing.downsample(x, n, 0);
    }

    public static final double[] downsample(double[] x, int n, int startIndex) {
        if (x.length <= 0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.downsample(): array length must be greater than 0.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.downsample(): downsampling factor must be greater than 0.");
        }
        if (startIndex < 0 || startIndex > x.length - 1) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.downsample(): startIndex must be between 0 and L - 1, where L is the size of the input array.");
        }
        int length = (x.length + 1 - startIndex) / n;
        double[] returnValue = new double[length];
        int srcIndex = startIndex;
        for (int destIndex = 0; destIndex < length; ++destIndex) {
            returnValue[destIndex] = x[srcIndex];
            srcIndex += n;
        }
        return returnValue;
    }

    public static final Complex[] FFT(Complex[] x) {
        return SignalProcessing.FFTComplexOut(x, SignalProcessing.order(x.length));
    }

    public static final Complex[] FFT(Complex[] x, int order) {
        return SignalProcessing.FFTComplexOut(x, order);
    }

    public static final Complex[] FFTComplexOut(Complex[] x) {
        return SignalProcessing.FFTComplexOut(x, SignalProcessing.order(x.length));
    }

    public static final Complex[] FFTComplexOut(Complex[] x, int order) {
        x = SignalProcessing._checkTransformArgs(x, order, false);
        double[] realx = ComplexArrayMath.realParts(x);
        double[] realrealX = SignalProcessing.FFTRealOut(realx, order);
        double[] imagrealX = SignalProcessing.FFTImagOut(realx, order);
        double[] imagx = ComplexArrayMath.imagParts(x);
        double[] realimagX = SignalProcessing.FFTRealOut(imagx, order);
        double[] imagimagX = SignalProcessing.FFTImagOut(imagx, order);
        realrealX = DoubleArrayMath.subtract(realrealX, imagimagX);
        imagrealX = DoubleArrayMath.add(imagrealX, realimagX);
        return ComplexArrayMath.formComplexArray(realrealX, imagrealX);
    }

    public static final Complex[] FFTComplexOut(double[] x) {
        return SignalProcessing.FFTComplexOut(x, SignalProcessing.order(x.length));
    }

    public static final Complex[] FFTComplexOut(double[] x, int order) {
        double[] realPart = SignalProcessing.FFTRealOut(x, order);
        double[] imagPart = SignalProcessing.FFTImagOut(x, order);
        return ComplexArrayMath.formComplexArray(realPart, imagPart);
    }

    public static final double[] FFTImagOut(Complex[] x) {
        return SignalProcessing.FFTImagOut(x, SignalProcessing.order(x.length));
    }

    public static final double[] FFTImagOut(Complex[] x, int order) {
        x = SignalProcessing._checkTransformArgs(x, order, false);
        double[] realx = ComplexArrayMath.realParts(x);
        double[] imagrealX = SignalProcessing.FFTImagOut(realx, order);
        double[] imagx = ComplexArrayMath.imagParts(x);
        double[] realimagX = SignalProcessing.FFTRealOut(imagx, order);
        return DoubleArrayMath.add(imagrealX, realimagX);
    }

    public static final double[] FFTImagOut(double[] x) {
        return SignalProcessing.FFTImagOut(x, SignalProcessing.order(x.length));
    }

    public static final double[] FFTImagOut(double[] x, int order) {
        x = SignalProcessing._checkTransformArgs(x, order, false);
        int size = 1 << order;
        int halfN = size >> 1;
        if (order - 2 > _FFCTGenLimit) {
            SignalProcessing._FFCTTableGen(order - 2);
        }
        double[] imagPart = SignalProcessing._sinDFT(x, size, order);
        double[] returnValue = new double[size];
        for (int k = 1; k < halfN; ++k) {
            returnValue[k] = -imagPart[k];
            returnValue[size - k] = imagPart[k];
        }
        return returnValue;
    }

    public static final double[] FFTRealOut(Complex[] x) {
        return SignalProcessing.FFTRealOut(x, SignalProcessing.order(x.length));
    }

    public static final double[] FFTRealOut(Complex[] x, int order) {
        x = SignalProcessing._checkTransformArgs(x, order, false);
        double[] realx = ComplexArrayMath.realParts(x);
        double[] realrealX = SignalProcessing.FFTRealOut(realx, order);
        double[] imagx = ComplexArrayMath.imagParts(x);
        double[] imagimagX = SignalProcessing.FFTImagOut(imagx, order);
        return DoubleArrayMath.subtract(realrealX, imagimagX);
    }

    public static final double[] FFTRealOut(double[] x) {
        return SignalProcessing.FFTRealOut(x, SignalProcessing.order(x.length));
    }

    public static final double[] FFTRealOut(double[] x, int order) {
        x = SignalProcessing._checkTransformArgs(x, order, false);
        int size = 1 << order;
        int halfN = size >> 1;
        if (x.length < size) {
            x = DoubleArrayMath.resize(x, size);
        }
        if (order - 2 > _FFCTGenLimit) {
            SignalProcessing._FFCTTableGen(order - 2);
        }
        double[] realPart = SignalProcessing._cosDFT(x, size, order);
        double[] returnValue = new double[size];
        System.arraycopy(realPart, 0, returnValue, 0, halfN + 1);
        for (int k = halfN + 1; k < size; ++k) {
            returnValue[k] = realPart[size - k];
        }
        return returnValue;
    }

    public static final double[] IDCT(double[] x) {
        return SignalProcessing.IDCT(x, SignalProcessing.order(x.length), 0);
    }

    public static final double[] IDCT(double[] x, int order) {
        return SignalProcessing.IDCT(x, order, 0);
    }

    public static final double[] IDCT(double[] x, int order, int type) {
        if (type >= 3) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.IDCT() : Bad DCT type");
        }
        int size = 1 << order;
        int twoSize = 2 << order;
        if (_IDCTfactors[type][order] == null) {
            SignalProcessing._IDCTfactors[type][order] = new Complex[twoSize];
            double oneOverTwoSize = 1.0 / (double)twoSize;
            double factor = 1.0;
            double oneOverE0 = 2.0;
            switch (type) {
                case 0: {
                    factor = 2.0;
                    oneOverE0 = ExtendedMath.SQRT_2;
                    break;
                }
                case 2: {
                    factor = Math.sqrt(twoSize);
                    oneOverE0 = ExtendedMath.SQRT_2;
                    break;
                }
                case 1: {
                    factor = 2.0;
                    oneOverE0 = 1.0;
                }
            }
            SignalProcessing._IDCTfactors[type][order][0] = new Complex(oneOverE0 * factor, 0.0);
            for (int k = 1; k < twoSize; ++k) {
                Complex c = new Complex(0.0, (double)k * Math.PI * oneOverTwoSize);
                SignalProcessing._IDCTfactors[type][order][k] = c.exp().scale(factor);
            }
        }
        Complex[] evenX = new Complex[twoSize];
        Complex[] myFactors = _IDCTfactors[type][order];
        evenX[0] = myFactors[0].scale(x[0]);
        for (int k = 1; k < size; ++k) {
            if (k >= x.length) {
                evenX[k] = new Complex(0.0);
                evenX[twoSize - k] = new Complex(0.0);
                continue;
            }
            evenX[k] = myFactors[k].scale(x[k]);
            evenX[twoSize - k] = myFactors[twoSize - k].scale(-x[k]);
        }
        evenX[size] = new Complex(0.0, 0.0);
        double[] longOutput = SignalProcessing.IFFTRealOut(evenX, order + 1);
        return DoubleArrayMath.resize(longOutput, size);
    }

    public static final Complex[] IFFT(Complex[] x) {
        return SignalProcessing.IFFTComplexOut(x, SignalProcessing.order(x.length));
    }

    public static final Complex[] IFFT(Complex[] x, int order) {
        return SignalProcessing.IFFTComplexOut(x, order);
    }

    public static final Complex[] IFFTComplexOut(Complex[] x) {
        return SignalProcessing.IFFTComplexOut(x, SignalProcessing.order(x.length));
    }

    public static final Complex[] IFFTComplexOut(Complex[] x, int order) {
        x = SignalProcessing._checkTransformArgs(x, order, true);
        Complex[] conjX = ComplexArrayMath.conjugate(x);
        Complex[] yConj = SignalProcessing.FFTComplexOut(conjX, order);
        Complex[] y = ComplexArrayMath.conjugate(yConj);
        double oneOverN = 1.0 / (double)(1 << order);
        return ComplexArrayMath.scale(y, oneOverN);
    }

    public static final double[] IFFTRealOut(Complex[] x) {
        return SignalProcessing.IFFTRealOut(x, SignalProcessing.order(x.length));
    }

    public static final double[] IFFTRealOut(Complex[] x, int order) {
        x = SignalProcessing._checkTransformArgs(x, order, true);
        double[] realx = ComplexArrayMath.realParts(x);
        double[] realrealX = SignalProcessing.FFTRealOut(realx, order);
        double[] imagx = ComplexArrayMath.imagParts(x);
        double[] imagimagX = SignalProcessing.FFTImagOut(imagx, order);
        realrealX = DoubleArrayMath.add(realrealX, imagimagX);
        double oneOverN = 1.0 / (double)(1 << order);
        return DoubleArrayMath.scale(realrealX, oneOverN);
    }

    public static double[] IFFTRealOut(double[] x) {
        return SignalProcessing.IFFTRealOut(x, SignalProcessing.order(x.length));
    }

    public static double[] IFFTRealOut(double[] x, int order) {
        double[] y = SignalProcessing.FFTRealOut(x, order);
        double oneOverN = 1.0 / (double)(1 << order);
        return DoubleArrayMath.scale(y, oneOverN);
    }

    public static final double[] generateBartlettWindow(int length) {
        int n;
        if (length < 1) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.generateBartlettWindow():  length of window should be greater than 0.");
        }
        int M = length - 1;
        double[] window = new double[length];
        int halfM = M / 2;
        double twoOverM = 2.0 / (double)M;
        for (n = 0; n <= halfM; ++n) {
            window[n] = (double)n * twoOverM;
        }
        for (n = halfM + 1; n < length; ++n) {
            window[n] = 2.0 - (double)n * twoOverM;
        }
        return window;
    }

    public static final double[] generateBlackmanWindow(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.generateBlackmanWindow():  length of window should be greater than 0.");
        }
        int M = length - 1;
        double[] window = new double[length];
        double twoPiOverM = Math.PI * 2 / (double)M;
        double fourPiOverM = 2.0 * twoPiOverM;
        for (int n = 0; n < length; ++n) {
            window[n] = 0.42 - 0.5 * Math.cos(twoPiOverM * (double)n) + 0.08 * Math.cos(fourPiOverM * (double)n);
        }
        return window;
    }

    public static final double[] generateBlackmanHarrisWindow(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.generateBlackmanHarrisWindow():  length of window should be greater than 0.");
        }
        int M = length - 1;
        double[] window = new double[length];
        double twoPiOverM = Math.PI * 2 / (double)M;
        double fourPiOverM = 2.0 * twoPiOverM;
        double sixPiOverM = 3.0 * twoPiOverM;
        for (int n = 0; n < length; ++n) {
            window[n] = 0.35875 - 0.48829 * Math.cos(twoPiOverM * (double)n) + 0.14128 * Math.cos(fourPiOverM * (double)n) - 0.01168 * Math.cos(sixPiOverM * (double)n);
        }
        return window;
    }

    public static final double[] generateGaussianCurve(double standardDeviation, double extent, int length) {
        GaussianSampleGenerator generator = new GaussianSampleGenerator(0.0, standardDeviation);
        return SignalProcessing.sampleWave(length, -extent * standardDeviation, 2.0 * extent * standardDeviation / (double)length, generator);
    }

    public static final double[] generateHammingWindow(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.generateHammingWindow():  length of window should be greater than 0.");
        }
        int M = length - 1;
        double[] window = new double[length];
        double twoPiOverM = Math.PI * 2 / (double)M;
        for (int n = 0; n < length; ++n) {
            window[n] = 0.54 - 0.46 * Math.cos(twoPiOverM * (double)n);
        }
        return window;
    }

    public static final double[] generateHanningWindow(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.generateHanningWindow():  length of window should be greater than 0.");
        }
        int M = length - 1;
        double[] window = new double[length];
        double twoPiOverM = Math.PI * 2 / (double)M;
        for (int n = 0; n < length; ++n) {
            window[n] = 0.5 - 0.5 * Math.cos(twoPiOverM * (double)n);
        }
        return window;
    }

    public static final double[] generatePolynomialCurve(double[] polynomial, double start, double step, int length) {
        PolynomialSampleGenerator generator = new PolynomialSampleGenerator(polynomial, 1);
        return SignalProcessing.sampleWave(length, start, step, generator);
    }

    public static final double[] generateRaisedCosinePulse(double excessBandwidth, double firstZeroCrossing, int length) {
        RaisedCosineSampleGenerator generator = new RaisedCosineSampleGenerator(firstZeroCrossing, excessBandwidth);
        return SignalProcessing.sampleWave(length, (double)(-(length - 1)) / 2.0, 1.0, generator);
    }

    public static final double[] generateRectangularWindow(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.generateRectangularWindow():  length of window should be greater than 0.");
        }
        double[] window = new double[length];
        for (int n = 0; n < length; ++n) {
            window[n] = 1.0;
        }
        return window;
    }

    public static final double[] generateSqrtRaisedCosinePulse(double excessBandwidth, double firstZeroCrossing, int length) {
        RaisedCosineSampleGenerator generator = new RaisedCosineSampleGenerator(firstZeroCrossing, excessBandwidth);
        return SignalProcessing.sampleWave(length, (double)(-(length - 1)) / 2.0, 1.0, generator);
    }

    public static final double[] generateWindow(int length, int windowType) {
        if (length < 1) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.generateWindow():  length of window should be greater than 0.");
        }
        switch (windowType) {
            case 0: {
                return SignalProcessing.generateRectangularWindow(length);
            }
            case 1: {
                return SignalProcessing.generateBartlettWindow(length);
            }
            case 2: {
                return SignalProcessing.generateHanningWindow(length);
            }
            case 3: {
                return SignalProcessing.generateHammingWindow(length);
            }
            case 4: {
                return SignalProcessing.generateBlackmanWindow(length);
            }
            case 5: {
                return SignalProcessing.generateBlackmanHarrisWindow(length);
            }
        }
        throw new IllegalArgumentException("ptolemy.math.SignalProcessing.generateWindow(): Unknown window type (" + windowType + ").");
    }

    public static final int nextPowerOfTwo(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.nextPowerOfTwo(): argument (" + x + ") is not a positive number.");
        }
        double m = Math.log(x) * _LOG2SCALE;
        int exp = (int)Math.ceil(m);
        return 1 << exp;
    }

    public static final int order(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing: size of transform must be positive.");
        }
        double m = Math.log(size) * _LOG2SCALE;
        double exp = Math.ceil(m);
        return (int)exp;
    }

    public static final Complex[] poleZeroToFrequency(Complex[] poles, Complex[] zeros, Complex gain, int numSteps) {
        double step = Math.PI * 2 / (double)numSteps;
        Complex[] freq = new Complex[numSteps];
        double angle = -Math.PI;
        for (int index = 0; index < freq.length; ++index) {
            Complex polesContribution = Complex.ONE;
            Complex zerosContribution = Complex.ONE;
            Complex ejw = new Complex(Math.cos(angle), Math.sin(angle));
            if (poles.length > 0) {
                Complex[] diffPoles = ComplexArrayMath.subtract(poles, ejw);
                polesContribution = ComplexArrayMath.product(diffPoles);
            }
            if (zeros.length > 0) {
                Complex[] diffZeros = ComplexArrayMath.subtract(zeros, ejw);
                zerosContribution = ComplexArrayMath.product(diffZeros);
            }
            freq[index] = zerosContribution.divide(polesContribution);
            freq[index] = freq[index].multiply(gain);
            angle += step;
        }
        return freq;
    }

    public static final double[] sampleWave(int length, double startTime, double interval, DoubleUnaryOperation sampleGen) {
        double time = startTime;
        double[] returnValue = new double[length];
        for (int t = 0; t < length; ++t) {
            returnValue[t] = sampleGen.operate(time);
            time += interval;
        }
        return returnValue;
    }

    public static double sawtooth(double period, double phase, double time) {
        if (period <= 0.0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.sawtooth(): period should be greater than 0.");
        }
        double point = 2.0 / period * Math.IEEEremainder(time + phase * period, period);
        point = point == -0.0 ? 0.0 : point;
        return point == 1.0 ? -1.0 : point;
    }

    public static final double sinc(double x) {
        if (x == 0.0) {
            return 1.0;
        }
        return Math.sin(x) / x;
    }

    public static double square(double period, double phase, double time) {
        if (period <= 0.0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.square(): period should be greater than 0.");
        }
        double point = 2.0 / period * Math.IEEEremainder(time + phase * period, period);
        return point >= 0.0 && point < 1.0 ? 1.0 : -1.0;
    }

    public static double triangle(double period, double phase, double time) {
        if (period <= 0.0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.triangle(): period should be greater than 0.");
        }
        double point = Math.IEEEremainder(time + phase * period, period);
        point = -period / 2.0 <= point && point < -period / 4.0 ? -(4.0 / period * point) - 2.0 : (-period / 4.0 <= point && point < period / 4.0 ? 4.0 / period * point : -(4.0 / period * point) + 2.0);
        return point;
    }

    public static final double toDecibels(double value) {
        return 20.0 * Math.log(value) * _LOG10SCALE;
    }

    public static final double[] unwrap(double[] angles) {
        double previous = 0.0;
        double[] result = new double[angles.length];
        for (int i = 0; i < angles.length; ++i) {
            result[i] = angles[i];
            while (result[i] - previous < -Math.PI) {
                int n = i;
                result[n] = result[n] + Math.PI * 2;
            }
            while (result[i] - previous > Math.PI) {
                int n = i;
                result[n] = result[n] - Math.PI * 2;
            }
            previous = result[i];
        }
        return result;
    }

    public static final double[] upsample(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing.upsample(): upsampling factor must be greater than or equal to 0.");
        }
        int length = x.length * n;
        double[] returnValue = new double[length];
        int srcIndex = 0;
        for (int destIndex = 0; destIndex < length; destIndex += n) {
            returnValue[destIndex] = x[srcIndex];
            ++srcIndex;
        }
        return returnValue;
    }

    private static void _checkTransformOrder(int order) {
        if (order < 0) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing : order of transform must be non-negative.");
        }
        if (order > 31) {
            throw new IllegalArgumentException("ptolemy.math.SignalProcessing : order of transform must be less than 32.");
        }
    }

    private static double[] _checkTransformArgs(double[] x, int order, boolean inverse) {
        SignalProcessing._checkTransformOrder(order);
        int size = 1 << order;
        if (x.length < size) {
            x = inverse ? DoubleArrayMath.padMiddle(x, size) : DoubleArrayMath.resize(x, size);
        }
        return x;
    }

    private static Complex[] _checkTransformArgs(Complex[] x, int order, boolean inverse) {
        SignalProcessing._checkTransformOrder(order);
        int size = 1 << order;
        if (x.length < size) {
            x = inverse ? ComplexArrayMath.padMiddle(x, size) : ComplexArrayMath.resize(x, size);
        }
        return x;
    }

    private static double[] _cosDFT(double[] x, int size, int order) {
        int k;
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                double[] returnValue = new double[]{x[0]};
                return returnValue;
            }
            case 2: {
                double[] returnValue = new double[]{x[0] + x[1], x[0] - x[1]};
                return returnValue;
            }
            case 4: {
                double[] returnValue = new double[]{x[0] + x[1] + x[2] + x[3], x[0] - x[2], x[0] - x[1] + x[2] - x[3]};
                return returnValue;
            }
        }
        int halfN = size >> 1;
        int quarterN = size >> 2;
        double[] x1 = new double[halfN];
        for (int k2 = 0; k2 < halfN; ++k2) {
            x1[k2] = x[k2 << 1];
        }
        double[] x2 = new double[quarterN];
        for (int k3 = 0; k3 < quarterN; ++k3) {
            int twoIp = (k3 << 1) + 1;
            x2[k3] = x[twoIp] + x[size - twoIp];
        }
        double[] halfCosDFT = SignalProcessing._cosDFT(x1, halfN, order - 1);
        double[] quarterDCT = SignalProcessing._DCT(x2, quarterN, order - 2);
        double[] returnValue = new double[halfN + 1];
        for (k = 0; k < quarterN; ++k) {
            returnValue[k] = halfCosDFT[k] + quarterDCT[k];
        }
        returnValue[quarterN] = halfCosDFT[quarterN];
        for (k = quarterN + 1; k <= halfN; ++k) {
            int idx = halfN - k;
            returnValue[k] = halfCosDFT[idx] - quarterDCT[idx];
        }
        return returnValue;
    }

    private static double[] _sinDFT(double[] x, int size, int order) {
        int k;
        switch (size) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
            case 4: {
                double[] returnValue = new double[2];
                returnValue[1] = x[1] - x[3];
                return returnValue;
            }
        }
        int halfN = size >> 1;
        int quarterN = size >> 2;
        double[] x1 = new double[halfN];
        for (int k2 = 0; k2 < halfN; ++k2) {
            x1[k2] = x[k2 << 1];
        }
        double[] x3 = new double[quarterN];
        for (int k3 = 0; k3 < quarterN; ++k3) {
            int twoIp = (k3 << 1) + 1;
            x3[k3] = (k3 & 1) == 1 ? x[size - twoIp] - x[twoIp] : x[twoIp] - x[size - twoIp];
        }
        double[] halfSinDFT = SignalProcessing._sinDFT(x1, halfN, order - 1);
        double[] quarterDCT = SignalProcessing._DCT(x3, quarterN, order - 2);
        double[] returnValue = new double[halfN];
        for (k = 1; k < quarterN; ++k) {
            returnValue[k] = halfSinDFT[k] + quarterDCT[quarterN - k];
        }
        returnValue[quarterN] = quarterDCT[0];
        for (k = quarterN + 1; k < halfN; ++k) {
            returnValue[k] = quarterDCT[k - quarterN] - halfSinDFT[halfN - k];
        }
        return returnValue;
    }

    private static double[] _DCT(double[] x, int size, int order) {
        if (size == 1) {
            double[] returnValue = new double[]{x[0]};
            return returnValue;
        }
        if (size == 2) {
            double[] returnValue = new double[]{x[0] + x[1], ExtendedMath.ONE_OVER_SQRT_2 * (x[0] - x[1])};
            return returnValue;
        }
        int halfN = size >> 1;
        double[] x4 = new double[size];
        for (int n = 0; n < halfN; ++n) {
            int twoN = n << 1;
            x4[n] = twoN >= x.length ? 0.0 : x[twoN];
            x4[size - n - 1] = twoN + 1 >= x.length ? 0.0 : x[twoN + 1];
        }
        double[] cosDFTarray = SignalProcessing._cosDFT(x4, size, order);
        double[] sinDFTarray = SignalProcessing._sinDFT(x4, size, order);
        double[] p1tab = _P1Table[order];
        double[] p2tab = _P2Table[order];
        double[] ctab = _CTable[order];
        double[] returnValue = new double[size];
        returnValue[0] = cosDFTarray[0];
        for (int k = 1; k < halfN; ++k) {
            double m1 = (cosDFTarray[k] + sinDFTarray[k]) * ctab[k];
            double m2 = sinDFTarray[k] * p1tab[k];
            double m3 = cosDFTarray[k] * p2tab[k];
            returnValue[k] = m1 - m2;
            returnValue[size - k] = m1 + m3;
        }
        returnValue[halfN] = ExtendedMath.ONE_OVER_SQRT_2 * cosDFTarray[halfN];
        return returnValue;
    }

    private static synchronized void _FFCTTableGen(int limit) {
        for (int i = _FFCTGenLimit; i <= limit; ++i) {
            int N = 1 << i;
            SignalProcessing._P1Table[i] = new double[N];
            SignalProcessing._P2Table[i] = new double[N];
            SignalProcessing._CTable[i] = new double[N];
            double[] p1t = _P1Table[i];
            double[] p2t = _P2Table[i];
            double[] ct = _CTable[i];
            for (int k = 0; k < N; ++k) {
                double arg = Math.PI * (double)k / (2.0 * (double)N);
                double c = Math.cos(arg);
                double s = Math.sin(arg);
                p1t[k] = c + s;
                p2t[k] = s - c;
                ct[k] = c;
            }
        }
        _FFCTGenLimit = Math.max(_FFCTGenLimit, limit);
    }

    public static class SqrtRaisedCosineSampleGenerator
    implements DoubleUnaryOperation {
        private final double _oneOverFZC;
        private final double _sqrtFZC;
        private final double _squareFZC;
        private final double _onePlus;
        private final double _oneMinus;
        private final double _excess;
        private final double _fourExcess;
        private final double _eightExcessPI;
        private final double _sixteenExcessSquared;
        private final double _sampleAtZero;
        private final double _fourExcessOverPISqrtFZC;
        private final double _fzcSqrtFZCOverEightExcessPI;
        private final double _fzcOverFourExcess;
        private final double _oneMinusFZCOverFourExcess;

        public SqrtRaisedCosineSampleGenerator(double firstZeroCrossing, double excess) {
            this._excess = excess;
            this._oneOverFZC = 1.0 / firstZeroCrossing;
            this._sqrtFZC = Math.sqrt(firstZeroCrossing);
            this._squareFZC = firstZeroCrossing * firstZeroCrossing;
            this._onePlus = (1.0 + this._excess) * Math.PI * this._oneOverFZC;
            this._oneMinus = (1.0 - this._excess) * Math.PI * this._oneOverFZC;
            this._fourExcess = 4.0 * this._excess;
            this._eightExcessPI = 8.0 * this._excess * Math.PI;
            this._sixteenExcessSquared = this._fourExcess * this._fourExcess;
            double fourExcessOverPI = this._fourExcess / Math.PI;
            double oneOverSqrtFZC = 1.0 / this._sqrtFZC;
            this._sampleAtZero = (fourExcessOverPI + 1.0 - this._excess) * oneOverSqrtFZC;
            this._fourExcessOverPISqrtFZC = fourExcessOverPI * oneOverSqrtFZC;
            this._fzcSqrtFZCOverEightExcessPI = firstZeroCrossing * this._sqrtFZC / this._eightExcessPI;
            this._fzcOverFourExcess = firstZeroCrossing / this._fourExcess;
            this._oneMinusFZCOverFourExcess = this._oneMinus * this._fzcOverFourExcess;
        }

        @Override
        public final double operate(double time) {
            if (time == 0.0) {
                return this._sampleAtZero;
            }
            double x = time * this._oneOverFZC;
            if (this._excess == 0.0) {
                return this._sqrtFZC * Math.sin(Math.PI * x) / (Math.PI * time);
            }
            double oneMinusTime = this._oneMinus * time;
            double onePlusTime = this._onePlus * time;
            double denominator = time * time * this._sixteenExcessSquared - this._squareFZC;
            if (SignalProcessing.close(denominator, 0.0)) {
                double oneOverTime = 1.0 / time;
                double oneOverTimeSquared = oneOverTime * oneOverTime;
                return this._fzcSqrtFZCOverEightExcessPI * oneOverTime * (this._onePlus * Math.sin(onePlusTime) - this._oneMinusFZCOverFourExcess * oneOverTime * Math.cos(oneMinusTime) + this._fzcOverFourExcess * oneOverTimeSquared * Math.sin(oneMinusTime));
            }
            return this._fourExcessOverPISqrtFZC * (Math.cos(onePlusTime) + Math.sin(oneMinusTime) / (x * this._fourExcess)) / (1.0 - this._sixteenExcessSquared * x * x);
        }
    }

    public static class SincSampleGenerator
    implements DoubleUnaryOperation {
        @Override
        public final double operate(double time) {
            return SignalProcessing.sinc(time);
        }
    }

    public static class RaisedCosineSampleGenerator
    implements DoubleUnaryOperation {
        private final double _oneOverFZC;
        private final double _excess;

        public RaisedCosineSampleGenerator(double firstZeroCrossing, double excess) {
            this._oneOverFZC = 1.0 / firstZeroCrossing;
            this._excess = excess;
        }

        @Override
        public final double operate(double time) {
            double denominator;
            if (time == 0.0) {
                return 1.0;
            }
            double x = time * this._oneOverFZC;
            double s = SignalProcessing.sinc(Math.PI * x);
            if (this._excess == 0.0) {
                return s;
            }
            if (SignalProcessing.close(denominator = 1.0 - 4.0 * (x *= this._excess) * x, 0.0)) {
                return s * 0.7853981633974483;
            }
            return s * Math.cos(Math.PI * x) / denominator;
        }
    }

    public static class SinusoidSampleGenerator
    implements DoubleUnaryOperation {
        private final double _frequency;
        private final double _phase;

        public SinusoidSampleGenerator(double frequency, double phase) {
            this._frequency = frequency;
            this._phase = phase;
        }

        @Override
        public final double operate(double time) {
            return Math.cos(this._frequency * time + this._phase);
        }
    }

    public static class SawtoothSampleGenerator
    implements DoubleUnaryOperation {
        private final double _period;
        private final double _phase;

        public SawtoothSampleGenerator(double period, double phase) {
            this._period = period;
            this._phase = phase;
        }

        @Override
        public final double operate(double time) {
            return SignalProcessing.sawtooth(this._period, this._phase, time);
        }
    }

    public static class PolynomialSampleGenerator
    implements DoubleUnaryOperation {
        private final double[] _coefficients;
        private final int _coeffLength;
        private final int _direction;

        public PolynomialSampleGenerator(double[] coefficients, int direction) {
            if (direction != 1 && direction != -1) {
                throw new IllegalArgumentException("ptolemy.math.SignalProcessing.LineSampleGenerator: direction must be either 1 or -1");
            }
            this._coeffLength = coefficients.length;
            this._coefficients = DoubleArrayMath.resize(coefficients, this._coeffLength);
            this._direction = direction;
        }

        @Override
        public final double operate(double time) {
            double sum = this._coefficients[0];
            double tn = time;
            for (int i = 1; i < this._coeffLength; ++i) {
                sum = this._direction == 1 ? (sum += this._coefficients[i] * tn) : (sum += this._coefficients[i] / tn);
                tn *= time;
            }
            return sum;
        }
    }

    public static class GaussianSampleGenerator
    implements DoubleUnaryOperation {
        private final double _mean;
        private final double _oneOverTwoVariance;
        private final double _factor;
        private static final double ONE_OVER_SQRT_TWO_PI = 1.0 / Math.sqrt(Math.PI * 2);

        public GaussianSampleGenerator(double mean, double standardDeviation) {
            this._mean = mean;
            this._oneOverTwoVariance = 1.0 / (2.0 * standardDeviation * standardDeviation);
            this._factor = ONE_OVER_SQRT_TWO_PI / standardDeviation;
        }

        @Override
        public final double operate(double time) {
            double shiftedTime = time - this._mean;
            return this._factor * Math.exp(-shiftedTime * shiftedTime * this._oneOverTwoVariance);
        }
    }
}

