/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ptolemy.math.FixPoint;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;

public abstract class Overflow
implements Cloneable,
Serializable {
    public static final Grow GROW = new Grow();
    public static final Modulo MODULO = new Modulo();
    public static final Minimize MINIMIZE = new Minimize();
    public static final Trap TRAP = new Trap();
    public static final Saturate SATURATE = new Saturate();
    public static final ToZero TO_ZERO = new ToZero();
    public static final Saturate CLIP = SATURATE;
    public static final Grow GENERAL = GROW;
    public static final Modulo WRAP = MODULO;
    public static final Trap THROW = TRAP;
    private String _name;
    private static Map _nameToOverflow;

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public static Overflow forName(String name) {
        return (Overflow)_nameToOverflow.get(name);
    }

    public static Overflow getName(String name) throws IllegalArgumentException {
        Overflow overflow = (Overflow)_nameToOverflow.get(name);
        if (overflow != null) {
            return overflow;
        }
        throw new IllegalArgumentException("Unknown overflow strategy \"" + name + "\".");
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public static boolean isOutOfRange(BigInteger bigInt, Precision precision) {
        return bigInt.compareTo(precision.getMaximumUnscaledValue()) > 0 || bigInt.compareTo(precision.getMinimumUnscaledValue()) < 0;
    }

    public static boolean isOverflow(BigInteger value, Precision precision) {
        return value.compareTo(precision.getMaximumUnscaledValue()) > 0;
    }

    public static boolean isUnderflow(BigInteger bigInt, Precision precision) {
        return bigInt.compareTo(precision.getMinimumUnscaledValue()) < 0;
    }

    public static Iterator nameIterator() {
        return _nameToOverflow.keySet().iterator();
    }

    public BigInteger minusInfinity(Quantization quant) {
        return null;
    }

    public BigInteger plusInfinity(Quantization quant) {
        return null;
    }

    public abstract FixPoint quantize(BigInteger var1, Precision var2);

    public static FixPoint quantizeGrow(BigInteger integerValue, Precision precision) {
        if (Overflow.isOutOfRange(integerValue, precision)) {
            return Overflow.quantizeMinimum(integerValue, precision);
        }
        return new FixPoint(integerValue, precision);
    }

    public static FixPoint quantizeMinimum(BigInteger bigInt, Precision p) {
        int sign = p.isSigned() ? 1 : 0;
        int int_bits = bigInt.bitLength();
        if (int_bits == 0) {
            ++int_bits;
        }
        int new_bits = int_bits + sign;
        Precision newPrecision = new Precision(sign, new_bits, p.getExponent());
        return new FixPoint(bigInt, newPrecision);
    }

    public static FixPoint quantizeModulo(BigInteger integerValue, Precision precision) {
        if (!Overflow.isOutOfRange(integerValue, precision)) {
            return new FixPoint(integerValue, precision);
        }
        BigInteger moduloInteger = null;
        if (!precision.isSigned()) {
            moduloInteger = integerValue.remainder(precision.getNumberOfLevels());
        } else {
            BigInteger minValue = precision.getMinimumUnscaledValue();
            moduloInteger = integerValue.subtract(minValue);
            BigInteger modValue = precision.getNumberOfLevels();
            moduloInteger = moduloInteger.remainder(modValue);
            if (integerValue.signum() < 0) {
                moduloInteger = moduloInteger.add(modValue);
            }
            moduloInteger = moduloInteger.add(minValue);
        }
        return new FixPoint(moduloInteger, precision);
    }

    public static FixPoint quantizeSaturate(BigInteger integerValue, Precision precision) {
        if (Overflow.isUnderflow(integerValue, precision)) {
            return new FixPoint(precision.getMinimumUnscaledValue(), precision);
        }
        if (Overflow.isOverflow(integerValue, precision)) {
            return new FixPoint(precision.getMaximumUnscaledValue(), precision);
        }
        return new FixPoint(integerValue, precision);
    }

    public static FixPoint quantizeToZero(BigInteger integerValue, Precision precision) {
        if (Overflow.isOutOfRange(integerValue, precision)) {
            return new FixPoint(BigInteger.ZERO, precision);
        }
        return new FixPoint(integerValue, precision);
    }

    public String toString() {
        return this._name;
    }

    protected Overflow(String name) {
        this._name = name;
        Overflow._addOverflow(this, name);
    }

    static void _addOverflow(Overflow type, String name) {
        if (_nameToOverflow == null) {
            _nameToOverflow = new HashMap();
        }
        _nameToOverflow.put(name, type);
    }

    public static class Trap
    extends Overflow {
        private Trap() {
            super("trap");
            Trap._addOverflow(this, "throw");
        }

        @Override
        public FixPoint quantize(BigInteger integerValue, Precision precision) {
            if (Trap.isUnderflow(integerValue, precision)) {
                throw new ArithmeticException("Minimum overflow threshold of " + precision.getMinimumUnscaledValue() + " exceeded with value " + integerValue);
            }
            if (Trap.isOverflow(integerValue, precision)) {
                throw new ArithmeticException("Maximum overflow threshold of " + precision.getMaximumUnscaledValue() + " exceeded with value " + integerValue);
            }
            return new FixPoint(integerValue, precision);
        }
    }

    public static class ToZero
    extends Overflow {
        private ToZero() {
            super("to_zero");
            ToZero._addOverflow(this, "overflow_to_zero");
        }

        @Override
        public BigInteger minusInfinity(Quantization quant) {
            return BigInteger.ZERO;
        }

        @Override
        public BigInteger plusInfinity(Quantization quant) {
            return BigInteger.ZERO;
        }

        @Override
        public FixPoint quantize(BigInteger integerValue, Precision precision) {
            return ToZero.quantizeToZero(integerValue, precision);
        }
    }

    public static class Saturate
    extends Overflow {
        private Saturate() {
            super("saturate");
            Saturate._addOverflow(this, "clip");
        }

        @Override
        public BigInteger minusInfinity(Quantization quant) {
            return quant.getMinimumUnscaledValue();
        }

        @Override
        public BigInteger plusInfinity(Quantization quant) {
            return quant.getMaximumUnscaledValue();
        }

        @Override
        public FixPoint quantize(BigInteger integerValue, Precision precision) {
            return Saturate.quantizeSaturate(integerValue, precision);
        }
    }

    public static class Modulo
    extends Overflow {
        private Modulo() {
            super("modulo");
            Modulo._addOverflow(this, "wrap");
        }

        @Override
        public FixPoint quantize(BigInteger integerValue, Precision precision) {
            return Modulo.quantizeModulo(integerValue, precision);
        }
    }

    public static class Minimize
    extends Overflow {
        private Minimize() {
            super("minimize");
            Minimize._addOverflow(this, "shrink");
        }

        @Override
        public FixPoint quantize(BigInteger integerValue, Precision precision) {
            return Minimize.quantizeMinimum(integerValue, precision);
        }
    }

    public static class Grow
    extends Overflow {
        private Grow() {
            super("grow");
        }

        @Override
        public FixPoint quantize(BigInteger integerValue, Precision precision) {
            return Grow.quantizeGrow(integerValue, precision);
        }
    }
}

