/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.DoubleMatrixMath;

public class Interpolation {
    private int[] _indexes = new int[]{0, 1};
    private double[] _values = new double[]{1.0, 0.0};
    private int _period = 2;
    private int _order = 0;

    public int[] getIndexes() {
        return this._indexes;
    }

    public int getOrder() {
        return this._order;
    }

    public int getPeriod() {
        return this._period;
    }

    public double[] getValues() {
        return this._values;
    }

    public double interpolate(int index) {
        double vAfterEnd;
        int iAfterEnd;
        double vBeforeStart;
        int iBeforeStart;
        double vEnd;
        int iEnd;
        double vStart;
        int iStart;
        int numRefPoints = this._indexes.length;
        if (numRefPoints != this._values.length) {
            throw new IllegalStateException("Interpolation.interpolate(): The index and value arrays do not have the same length.");
        }
        int largestIndex = this._indexes[numRefPoints - 1];
        if (this._period != 0 && this._period <= largestIndex) {
            throw new IllegalStateException("Interpolation.interpolate(): The period is not 0 and not greater than the largest index.");
        }
        if (index < 0 || index > largestIndex) {
            if (this._period == 0) {
                return 0.0;
            }
            if (index < 0) {
                index += (-index / this._period + 1) * this._period;
            }
            index %= this._period;
        }
        if (numRefPoints == 1) {
            return this._values[0];
        }
        int indexIndexStart = -1;
        int i = 0;
        while (i < numRefPoints) {
            if (this._indexes[i] == index) {
                return this._values[i];
            }
            if (this._indexes[i] >= index) break;
            indexIndexStart = i++;
        }
        if (this._order == 0) {
            if (indexIndexStart != -1) {
                return this._values[indexIndexStart];
            }
            return this._values[numRefPoints - 1];
        }
        if (indexIndexStart == -1) {
            iStart = this._indexes[numRefPoints - 1] - this._period;
            vStart = this._values[numRefPoints - 1];
        } else {
            iStart = this._indexes[indexIndexStart];
            vStart = this._values[indexIndexStart];
        }
        if (indexIndexStart == numRefPoints - 1) {
            iEnd = this._indexes[0] + this._period;
            vEnd = this._values[0];
        } else {
            iEnd = this._indexes[indexIndexStart + 1];
            vEnd = this._values[indexIndexStart + 1];
        }
        if (this._order == 1) {
            return vStart + (double)(index - iStart) * (vEnd - vStart) / (double)(iEnd - iStart);
        }
        if (indexIndexStart == -1) {
            iBeforeStart = this._indexes[numRefPoints - 2] - this._period;
            vBeforeStart = this._values[numRefPoints - 2];
        } else if (indexIndexStart == 0) {
            if (this._period > 0) {
                iBeforeStart = this._indexes[numRefPoints - 1] - this._period;
                vBeforeStart = this._values[numRefPoints - 1];
            } else {
                iBeforeStart = this._indexes[0] - 1;
                vBeforeStart = 0.0;
            }
        } else {
            iBeforeStart = this._indexes[indexIndexStart - 1];
            vBeforeStart = this._values[indexIndexStart - 1];
        }
        if (indexIndexStart == numRefPoints - 1) {
            iAfterEnd = this._indexes[1] + this._period;
            vAfterEnd = this._values[1];
        } else if (indexIndexStart == numRefPoints - 2) {
            if (this._period > 0) {
                iAfterEnd = this._indexes[0] + this._period;
                vAfterEnd = this._values[0];
            } else {
                iAfterEnd = this._indexes[numRefPoints - 1] + 1;
                vAfterEnd = 0.0;
            }
        } else {
            iAfterEnd = this._indexes[indexIndexStart + 2];
            vAfterEnd = this._values[indexIndexStart + 2];
        }
        double tanBefore2Start = (vStart - vBeforeStart) / (double)(iStart - iBeforeStart);
        double tanStart2End = (vEnd - vStart) / (double)(iEnd - iStart);
        double tanEnd2After = (vAfterEnd - vEnd) / (double)(iAfterEnd - iEnd);
        double tanStart = 0.5 * (tanBefore2Start + tanStart2End);
        double tanEnd = 0.5 * (tanStart2End + tanEnd2After);
        return this._hermite(index, iStart, vStart, tanStart, iEnd, vEnd, tanEnd);
    }

    public void setIndexes(int[] indexes) {
        int prev = -1;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] <= prev) {
                throw new IllegalArgumentException("Interpolation.setIndexes index array is not increasing and non-negative.");
            }
            prev = indexes[i];
        }
        this._indexes = indexes;
    }

    public void setOrder(int order) {
        if (order != 0 && order != 1 && order != 3) {
            throw new IllegalArgumentException("Interpolation.setOrder: The order " + order + " is not valid.");
        }
        this._order = order;
    }

    public void setPeriod(int period) {
        if (period < 0) {
            throw new IllegalArgumentException("Interpolation.setPeriod: The period is negative.");
        }
        this._period = period;
    }

    public void setValues(double[] values) {
        this._values = values;
    }

    private double _hermite(int index, int iStart, double vStart, double tanStart, int iEnd, double vEnd, double tanEnd) {
        double[][] M = new double[4][4];
        double iStartSqr = iStart * iStart;
        double iEndSqr = iEnd * iEnd;
        M[0][0] = iStartSqr * (double)iStart;
        M[0][1] = iStartSqr;
        M[0][2] = iStart;
        M[0][3] = 1.0;
        M[1][0] = iEndSqr * (double)iEnd;
        M[1][1] = iEndSqr;
        M[1][2] = iEnd;
        M[1][3] = 1.0;
        M[2][0] = 3.0 * iStartSqr;
        M[2][1] = 2 * iStart;
        M[2][2] = 1.0;
        M[2][3] = 0.0;
        M[3][0] = 3.0 * iEndSqr;
        M[3][1] = 2 * iEnd;
        M[3][2] = 1.0;
        M[3][3] = 0.0;
        double[][] MInverse = DoubleMatrixMath.inverse(M);
        double[] Gh = new double[]{vStart, vEnd, tanStart, tanEnd};
        double[] coef = DoubleMatrixMath.multiply(Gh, MInverse);
        double indexSqr = index * index;
        return coef[0] * indexSqr * (double)index + coef[1] * indexSqr + coef[2] * (double)index + coef[3];
    }
}

