/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.IntegerBinaryOperation;
import ptolemy.math.IntegerUnaryOperation;

public class IntegerMatrixMath {
    private IntegerMatrixMath() {
    }

    public static final int[][] add(int[][] matrix, int z) {
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix)][IntegerMatrixMath._columns(matrix)];
        for (int i = 0; i < IntegerMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < IntegerMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] + z;
            }
        }
        return returnValue;
    }

    public static final int[][] add(int[][] matrix1, int[][] matrix2) {
        IntegerMatrixMath._checkSameDimension("add", matrix1, matrix2);
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix1)][IntegerMatrixMath._columns(matrix1)];
        for (int i = 0; i < IntegerMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < IntegerMatrixMath._columns(matrix1); ++j) {
                returnValue[i][j] = matrix1[i][j] + matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] allocCopy(int[][] matrix) {
        return IntegerMatrixMath.crop(matrix, 0, 0, IntegerMatrixMath._rows(matrix), IntegerMatrixMath._columns(matrix));
    }

    public static final int[][] applyBinaryOperation(IntegerBinaryOperation op, int z, int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(z, matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final int[][] applyBinaryOperation(IntegerBinaryOperation op, int[][] matrix, int z) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j], z);
            }
        }
        return returnValue;
    }

    public static final int[][] applyBinaryOperation(IntegerBinaryOperation op, int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("applyBinaryOperation", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix1[i][j], matrix2[i][j]);
            }
        }
        return returnValue;
    }

    public static final int[][] applyUnaryOperation(IntegerUnaryOperation op, int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = op.operate(matrix[i][j]);
            }
        }
        return returnValue;
    }

    public static final int[][] bitwiseAnd(int[][] matrix, int z) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] & z;
            }
        }
        return returnValue;
    }

    public static final int[][] bitwiseAnd(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("bitwiseAnd", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] & matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] bitwiseComplement(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = ~matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] bitwiseOr(int[][] matrix, int z) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] | z;
            }
        }
        return returnValue;
    }

    public static final int[][] bitwiseOr(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("bitwiseOr", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] | matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] bitwiseXor(int[][] matrix, int z) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] ^ z;
            }
        }
        return returnValue;
    }

    public static final int[][] bitwiseXor(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("bitwiseXor", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] ^ matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] crop(int[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        int[][] returnValue = new int[rowSpan][colSpan];
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
        }
        return returnValue;
    }

    public static final int[][] diag(int[] array) {
        int n = array.length;
        int[][] returnValue = new int[n][n];
        for (int i = 0; i < n; ++i) {
            returnValue[i][i] = array[i];
        }
        return returnValue;
    }

    public static final int[][] divide(int[][] matrix, int z) {
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix)][IntegerMatrixMath._columns(matrix)];
        for (int i = 0; i < IntegerMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < IntegerMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] / z;
            }
        }
        return returnValue;
    }

    public static final int[][] divideElements(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] / matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final int[] fromMatrixToArray(int[][] matrix) {
        return IntegerMatrixMath.fromMatrixToArray(matrix, IntegerMatrixMath._rows(matrix), IntegerMatrixMath._columns(matrix));
    }

    public static final int[] fromMatrixToArray(int[][] matrix, int maxRow, int maxCol) {
        int[] returnValue = new int[maxRow * maxCol];
        for (int i = 0; i < maxRow; ++i) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
        }
        return returnValue;
    }

    public static final int[][] identity(int dim) {
        int[][] returnValue = new int[dim][dim];
        for (int i = 0; i < dim; ++i) {
            returnValue[i][i] = 1;
        }
        return returnValue;
    }

    public static final int[][] identityMatrixInt(int dim) {
        return IntegerMatrixMath.identity(dim);
    }

    public static final void matrixCopy(int[][] srcMatrix, int[][] destMatrix) {
        IntegerMatrixMath.matrixCopy(srcMatrix, 0, 0, destMatrix, 0, 0, IntegerMatrixMath._rows(srcMatrix), IntegerMatrixMath._columns(srcMatrix));
    }

    public static final void matrixCopy(int[][] srcMatrix, int srcRowStart, int srcColStart, int[][] destMatrix, int destRowStart, int destColStart, int rowSpan, int colSpan) {
        for (int i = 0; i < rowSpan; ++i) {
            System.arraycopy(srcMatrix[srcRowStart + i], srcColStart, destMatrix[destRowStart + i], destColStart, colSpan);
        }
    }

    public static final int[][] modulo(int[][] matrix, int z) {
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix)][IntegerMatrixMath._columns(matrix)];
        for (int i = 0; i < IntegerMatrixMath._rows(matrix); ++i) {
            for (int j = 0; j < IntegerMatrixMath._columns(matrix); ++j) {
                returnValue[i][j] = matrix[i][j] % z;
            }
        }
        return returnValue;
    }

    public static final int[][] modulo(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("modulo", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] % matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] multiply(int[][] matrix, int scaleFactor) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j] * scaleFactor;
            }
        }
        return returnValue;
    }

    public static final int[] multiply(int[][] matrix, int[] array) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        int[] returnValue = new int[columns];
        for (int i = 0; i < columns; ++i) {
            int sum = 0;
            for (int j = 0; j < rows; ++j) {
                sum += matrix[j][i] * array[j];
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final int[] multiply(int[] array, int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        int[] returnValue = new int[rows];
        for (int i = 0; i < rows; ++i) {
            int sum = 0;
            for (int j = 0; j < columns; ++j) {
                sum += matrix[i][j] * array[j];
            }
            returnValue[i] = sum;
        }
        return returnValue;
    }

    public static final int[][] multiply(int[][] matrix1, int[][] matrix2) {
        int[][] returnValue = new int[IntegerMatrixMath._rows(matrix1)][matrix2[0].length];
        for (int i = 0; i < IntegerMatrixMath._rows(matrix1); ++i) {
            for (int j = 0; j < matrix2[0].length; ++j) {
                int sum = 0;
                for (int k = 0; k < matrix2.length; ++k) {
                    sum += matrix1[i][k] * matrix2[k][j];
                }
                returnValue[i][j] = sum;
            }
        }
        return returnValue;
    }

    public static final int[][] multiplyElements(int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] * matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] negative(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = -matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] shiftArithmetic(int[][] matrix, int shiftAmount) {
        int[][] returnValue;
        block5: {
            int columns;
            int rows;
            block4: {
                rows = IntegerMatrixMath._rows(matrix);
                columns = IntegerMatrixMath._columns(matrix);
                returnValue = new int[rows][columns];
                if (shiftAmount < 0) break block4;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        returnValue[i][j] = matrix[i][j] << shiftAmount;
                    }
                }
                break block5;
            }
            if (shiftAmount >= 0) break block5;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    returnValue[i][j] = matrix[i][j] >>> -shiftAmount;
                }
            }
        }
        return returnValue;
    }

    public static final int[][] shiftLogical(int[][] matrix, int shiftAmount) {
        int[][] returnValue;
        block5: {
            int columns;
            int rows;
            block4: {
                rows = IntegerMatrixMath._rows(matrix);
                columns = IntegerMatrixMath._columns(matrix);
                returnValue = new int[rows][columns];
                if (shiftAmount < 0) break block4;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        returnValue[i][j] = matrix[i][j] << shiftAmount;
                    }
                }
                break block5;
            }
            if (shiftAmount >= 0) break block5;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    returnValue[i][j] = matrix[i][j] >> -shiftAmount;
                }
            }
        }
        return returnValue;
    }

    public static final int[][] subtract(int[][] matrix1, int[][] matrix2) {
        IntegerMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        int[][] returnValue = new int[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix1[i][j] - matrix2[i][j];
            }
        }
        return returnValue;
    }

    public static final int sum(int[][] matrix) {
        int sum = 0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                sum += matrix[i][j];
            }
        }
        return sum;
    }

    public static final Complex[][] toComplexMatrix(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        Complex[][] returnValue = new Complex[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = new Complex(matrix[i][j], 0.0);
            }
        }
        return returnValue;
    }

    public static final double[][] toDoubleMatrix(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final float[][] toFloatMatrix(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        float[][] returnValue = new float[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final long[][] toLongMatrix(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        long[][] returnValue = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[i][j] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final int[][] toMatrixFromArray(int[] array, int rows, int cols) {
        int[][] returnValue = new int[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
        }
        return returnValue;
    }

    public static final String toString(int[][] matrix) {
        return IntegerMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(int[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        for (int i = 0; i < IntegerMatrixMath._rows(matrix); ++i) {
            sb.append(vectorBegin);
            for (int j = 0; j < IntegerMatrixMath._columns(matrix); ++j) {
                sb.append(Integer.toString(matrix[i][j]));
                if (j >= IntegerMatrixMath._columns(matrix) - 1) continue;
                sb.append(elementDelimiter);
            }
            sb.append(vectorEnd);
            if (i >= IntegerMatrixMath._rows(matrix) - 1) continue;
            sb.append(vectorDelimiter);
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final int trace(int[][] matrix) {
        int dim = IntegerMatrixMath._checkSquare("trace", matrix);
        int sum = 0;
        for (int i = 0; i < dim; ++i) {
            sum += matrix[i][i];
        }
        return sum;
    }

    public static final int[][] transpose(int[][] matrix) {
        int rows = IntegerMatrixMath._rows(matrix);
        int columns = IntegerMatrixMath._columns(matrix);
        int[][] returnValue = new int[columns][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                returnValue[j][i] = matrix[i][j];
            }
        }
        return returnValue;
    }

    public static final boolean within(int[][] matrix1, int[][] matrix2, int distance) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("within", matrix1, matrix2);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (matrix1[i][j] <= matrix2[i][j] + distance && matrix1[i][j] >= matrix2[i][j] - distance) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean within(int[][] matrix1, int[][] matrix2, int[][] errorMatrix) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        IntegerMatrixMath._checkSameDimension("within", matrix1, matrix2);
        IntegerMatrixMath._checkSameDimension("within", matrix1, errorMatrix);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (matrix1[i][j] <= matrix2[i][j] + errorMatrix[i][j] && matrix1[i][j] >= matrix2[i][j] - errorMatrix[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    protected static final void _checkSameDimension(String caller, int[][] matrix1, int[][] matrix2) {
        int rows = IntegerMatrixMath._rows(matrix1);
        int columns = IntegerMatrixMath._columns(matrix1);
        if (rows != IntegerMatrixMath._rows(matrix2) || columns != IntegerMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.IntegerMatrixMath." + caller + "() : one matrix " + IntegerMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + IntegerMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, int[][] matrix) {
        if (IntegerMatrixMath._rows(matrix) != IntegerMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.IntegerMatrixMath." + caller + "() : matrix argument " + IntegerMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return IntegerMatrixMath._rows(matrix);
    }

    protected static final int _columns(int[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(int[][] matrix) {
        return "[" + IntegerMatrixMath._rows(matrix) + " x " + IntegerMatrixMath._columns(matrix) + "]";
    }

    protected static final int _rows(int[][] matrix) {
        return matrix.length;
    }
}

