/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.IntegerBinaryOperation;
import ptolemy.math.IntegerUnaryOperation;

public class IntegerArrayMath {
    protected IntegerArrayMath() {
    }

    public static final int[] add(int[] array, int z) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i] + z;
        }
        return returnValue;
    }

    public static final int[] add(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.add");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array1[i] + array2[i];
        }
        return returnValue;
    }

    public static final int[] allocCopy(int[] array) {
        int elements = array.length;
        int[] newArray = new int[elements];
        System.arraycopy(array, 0, newArray, 0, elements);
        return newArray;
    }

    public static final int[] append(int[] array1, int[] array2) {
        return IntegerArrayMath.append(array1, 0, array1.length, array2, 0, array2.length);
    }

    public static final int[] append(int[] array1, int idx1, int length1, int[] array2, int idx2, int length2) {
        int[] returnValue = new int[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(array1, idx1, returnValue, 0, length1);
        }
        if (length2 > 0) {
            System.arraycopy(array2, idx2, returnValue, length1, length2);
        }
        return returnValue;
    }

    public static final int[] applyBinaryOperation(IntegerBinaryOperation op, int[] array, int z) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = op.operate(array[i], z);
        }
        return returnValue;
    }

    public static final int[] applyBinaryOperation(IntegerBinaryOperation op, int z, int[] array) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = op.operate(array[i], z);
        }
        return returnValue;
    }

    public static final int[] applyBinaryOperation(IntegerBinaryOperation op, int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.applyBinaryOperation");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = op.operate(array1[i], array2[i]);
        }
        return returnValue;
    }

    public static final int[] applyUnaryOperation(IntegerUnaryOperation op, int[] array) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = op.operate(array[i]);
        }
        return returnValue;
    }

    public static final int[] bitwiseAnd(int[] array, int z) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i] & z;
        }
        return returnValue;
    }

    public static final int[] bitwiseAnd(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.bitwiseAnd");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array1[i] & array2[i];
        }
        return returnValue;
    }

    public static final int[] bitwiseComplement(int[] array) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = ~array[i];
        }
        return returnValue;
    }

    public static final int[] bitwiseOr(int[] array, int z) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i] | z;
        }
        return returnValue;
    }

    public static final int[] bitwiseOr(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.bitwiseOr");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array1[i] | array2[i];
        }
        return returnValue;
    }

    public static final int[] bitwiseXor(int[] array, int z) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i] ^ z;
        }
        return returnValue;
    }

    public static final int[] bitwiseXor(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.bitwiseXor");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array1[i] ^ array2[i];
        }
        return returnValue;
    }

    public static final int[] divide(int[] array, int z) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i] / z;
        }
        return returnValue;
    }

    public static final int[] divideElements(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.divideElements");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array1[i] / array2[i];
        }
        return returnValue;
    }

    public static final int dotProduct(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.dotProduct");
        int sum = 0;
        for (int i = 0; i < length; ++i) {
            sum += array1[i] * array2[i];
        }
        return sum;
    }

    public static final int[] limit(int[] array, int bottom, int top) {
        int[] returnValue = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            returnValue[i] = array[i] > top || array[i] == Integer.MAX_VALUE ? top : (array[i] < bottom || array[i] == Integer.MIN_VALUE ? bottom : array[i]);
        }
        return returnValue;
    }

    public static final int[] modulo(int[] array, int z) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i] % z;
        }
        return returnValue;
    }

    public static final int[] modulo(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.modulo");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array1[i] % array2[i];
        }
        return returnValue;
    }

    public static final int[] multiply(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.multiply");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array1[i] * array2[i];
        }
        return returnValue;
    }

    public static final int[] multiply(int[] array, int factor) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i] * factor;
        }
        return returnValue;
    }

    public static final int[] negative(int[] array) {
        int length = array.length;
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = -array[i];
        }
        return returnValue;
    }

    public static final int[] padMiddle(int[] array, int newLength) {
        int length = array.length;
        int entriesNeeded = newLength - length;
        if (entriesNeeded < 0) {
            throw new IllegalArgumentException("ptolemy.math.IntegerArrayMath.padMiddle() : newLength must be  >= length of array.");
        }
        if (entriesNeeded == 0) {
            return IntegerArrayMath.resize(array, newLength);
        }
        double halfLength = (double)length * 0.5;
        int halfLengthFloor = (int)Math.floor(halfLength);
        int halfLengthCeil = (int)Math.ceil(halfLength);
        int[] returnValue = new int[newLength];
        System.arraycopy(array, 0, returnValue, 0, halfLengthCeil);
        System.arraycopy(array, halfLengthFloor, returnValue, newLength - halfLengthCeil, halfLengthCeil);
        return returnValue;
    }

    public static final int[] resize(int[] array, int newLength) {
        return IntegerArrayMath.resize(array, newLength, 0);
    }

    public static final int[] resize(int[] array, int newLength, int startIdx) {
        int[] returnValue = new int[newLength];
        int copySize = Math.min(newLength, array.length - startIdx);
        if (startIdx >= array.length && copySize > 0) {
            throw new IllegalArgumentException("resize():  the start index '" + startIdx + "' is greather than equal to the array length '" + array.length + "' and the number of items to be copied '" + copySize + "' is greater than zero.");
        }
        if (copySize > 0) {
            System.arraycopy(array, startIdx, returnValue, 0, copySize);
        }
        return returnValue;
    }

    public static final int[] scale(int[] array, int scaleFactor) {
        int[] returnValue = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            returnValue[i] = scaleFactor * array[i];
        }
        return returnValue;
    }

    public static final int[] shiftArithmetic(int[] array, int shiftAmount) {
        int[] returnValue;
        block3: {
            block2: {
                returnValue = new int[array.length];
                if (shiftAmount < 0) break block2;
                for (int i = 0; i < array.length; ++i) {
                    returnValue[i] = array[i] << shiftAmount;
                }
                break block3;
            }
            if (shiftAmount >= 0) break block3;
            for (int i = 0; i < array.length; ++i) {
                returnValue[i] = array[i] >>> -shiftAmount;
            }
        }
        return returnValue;
    }

    public static final int[] shiftLogical(int[] array, int shiftAmount) {
        int[] returnValue;
        block3: {
            block2: {
                returnValue = new int[array.length];
                if (shiftAmount < 0) break block2;
                for (int i = 0; i < array.length; ++i) {
                    returnValue[i] = array[i] << shiftAmount;
                }
                break block3;
            }
            if (shiftAmount >= 0) break block3;
            for (int i = 0; i < array.length; ++i) {
                returnValue[i] = array[i] >> -shiftAmount;
            }
        }
        return returnValue;
    }

    public static final int[] subtract(int[] array1, int[] array2) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.subtract");
        int[] returnValue = new int[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array1[i] - array2[i];
        }
        return returnValue;
    }

    public static final int sumOfSquares(int[] array) {
        int sum = 0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i] * array[i];
        }
        return sum;
    }

    public static final Complex[] toComplexArray(int[] array) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = new Complex(array[i], 0.0);
        }
        return returnValue;
    }

    public static final double[] toDoubleArray(int[] array) {
        int length = array.length;
        double[] returnValue = new double[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i];
        }
        return returnValue;
    }

    public static final float[] toFloatArray(int[] array) {
        int length = array.length;
        float[] returnValue = new float[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i];
        }
        return returnValue;
    }

    public static final long[] toLongArray(int[] array) {
        int length = array.length;
        long[] returnValue = new long[length];
        for (int i = 0; i < length; ++i) {
            returnValue[i] = array[i];
        }
        return returnValue;
    }

    public static final String toString(int[] array) {
        return IntegerArrayMath.toString(array, ", ", "{", "}");
    }

    public static final String toString(int[] array, String elementDelimiter, String vectorBegin, String vectorEnd) {
        int length = array.length;
        StringBuffer sb = new StringBuffer();
        sb.append(vectorBegin);
        for (int i = 0; i < length; ++i) {
            sb.append(Integer.toString(array[i]));
            if (i >= length - 1) continue;
            sb.append(elementDelimiter);
        }
        sb.append(vectorEnd);
        return new String(sb);
    }

    public static final boolean within(int[] array1, int[] array2, int maxError) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.within");
        for (int i = 0; i < length; ++i) {
            if (array1[i] <= array2[i] + maxError && array1[i] >= array2[i] - maxError) continue;
            return false;
        }
        return true;
    }

    public static final boolean within(int[] array1, int[] array2, int[] maxError) {
        int length = IntegerArrayMath._commonLength(array1, array2, "IntegerArrayMath.within");
        for (int i = 0; i < length; ++i) {
            if (array1[i] <= array2[i] + maxError[i] && array1[i] >= array2[i] - maxError[i]) continue;
            return false;
        }
        return true;
    }

    protected static final int _commonLength(int[] array1, int[] array2, String methodName) {
        if (array1 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : first input array is null.");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : second input array is null.");
        }
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input arrays must have the same length, " + "but the first array has length " + array1.length + " and the second array has length " + array2.length + ".");
        }
        return array1.length;
    }
}

