/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

public class ExtendedMath {
    public static final double SQRT_2 = Math.sqrt(2.0);
    public static final double ONE_OVER_SQRT_2 = 1.0 / SQRT_2;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static final double SINGLE_PRECISION_SMALLEST_NORMALIZED_POSITIVE_DOUBLE = Math.pow(2.0, -126.0);
    public static final double DOUBLE_PRECISION_SMALLEST_NORMALIZED_POSITIVE_DOUBLE = Math.pow(2.0, -1022.0);
    public static final double DOUBLE_PRECISION_SIGNIFICAND_ONLY = 2.0 - Math.pow(2.0, -52.0);
    public static final double SINGLE_PRECISION_SIGNIFICAND_ONLY = 2.0 - Math.pow(2.0, -23.0);
    private static final double _ONEOVERLN2 = 1.0 / Math.log(2.0);
    private static final double _ONEOVERLN10 = 1.0 / Math.log(10.0);

    public static final double acosh(double x) {
        if (x < 1.0) {
            throw new IllegalArgumentException("ExtendedMath.acosh: Argument is required to be greater than 1.  Got " + x);
        }
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static final double asinh(double x) {
        double result = x < 0.0 ? -Math.log(-x + Math.sqrt(x * x + 1.0)) : Math.log(x + Math.sqrt(x * x + 1.0));
        return result;
    }

    public static final double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static int gcd(int u, int v) {
        if (u < 0) {
            u = -u;
        }
        if (v < 0) {
            v = -v;
        }
        while (u > 0) {
            if (u < v) {
                int t = u;
                u = v;
                v = t;
                continue;
            }
            u %= v;
        }
        return v;
    }

    public static final double log10(double x) {
        return Math.log(x) * _ONEOVERLN10;
    }

    public static final double log2(double x) {
        return Math.log(x) * _ONEOVERLN2;
    }

    public static double remainder(double f1, double f2) {
        return Math.IEEEremainder(f1, f2);
    }

    public static final int roundToInt(double x) {
        long returnValue = Math.round(x);
        if (returnValue >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (returnValue <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)returnValue;
    }

    public static final int sgn(double x) {
        if (x < 0.0) {
            return -1;
        }
        return 1;
    }

    public static final double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static final double tanh(double x) {
        return ExtendedMath.sinh(x) / ExtendedMath.cosh(x);
    }
}

