/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public final class Workspace
implements Nameable,
Serializable {
    private LinkedList _directory = new LinkedList();
    private String _name;
    private long _version = 0L;
    private transient Thread _writer;
    private int _waitingWriteRequests = 0;
    private int _writeDepth = 0;
    private transient Thread _lastReader = null;
    private transient AccessRecord _lastReaderRecord = null;
    private transient HashMap _readerRecords = new HashMap();
    private long _numReaders = 0L;

    public Workspace() {
        this.setName("");
    }

    public Workspace(String name) {
        this.setName(name);
    }

    public synchronized void add(NamedObj item) throws IllegalActionException {
        if (item.workspace() != this) {
            throw new IllegalActionException((Nameable)this, item, "Cannot add an item to the directory of a workspace that it is not in.");
        }
        if (item.getContainer() != null) {
            throw new IllegalActionException((Nameable)this, item, "Cannot add an object with a container to a workspace directory.");
        }
        if (this._directory.indexOf(item) >= 0) {
            throw new IllegalActionException((Nameable)this, item, "Object is already listed in the workspace directory.");
        }
        this._directory.add(item);
        this.incrVersion();
    }

    @Override
    public synchronized String description() {
        return this.description(-1);
    }

    public synchronized String description(int detail) {
        return this._description(detail, 0, 0);
    }

    public synchronized Enumeration directory() {
        return Collections.enumeration(this._directory);
    }

    public synchronized List directoryList() {
        return Collections.unmodifiableList(this._directory);
    }

    public final synchronized void doneReading() {
        Thread current = Thread.currentThread();
        AccessRecord record = null;
        record = current == this._lastReader ? this._lastReaderRecord : this._getAccessRecord(current, false);
        if (record == null) {
            throw new InvalidStateException(this, "Workspace: doneReading() called without a prior matching call to getReadAccess()!");
        }
        if (record.readDepth > 0) {
            --record.readDepth;
            if (record.readDepth == 0) {
                --this._numReaders;
                this.notifyAll();
            }
        } else if (record.failedReadAttempts > 0) {
            --record.failedReadAttempts;
        } else {
            throw new InvalidStateException(this, "Workspace: doneReading() called without a prior matching call to getReadAccess()!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void doneWriting() {
        Thread current = Thread.currentThread();
        AccessRecord record = null;
        record = current == this._lastReader ? this._lastReaderRecord : this._getAccessRecord(current, false);
        this.incrVersion();
        if (current != this._writer) {
            if (record == null || record.failedWriteAttempts <= 0) throw new InvalidStateException(this, "Workspace: doneWriting called without a prior matching call to getWriteAccess().");
            --record.failedWriteAttempts;
            return;
        } else {
            if (this._writeDepth <= 0) throw new InvalidStateException(this, "Workspace: doneWriting called without a prior matching call to getWriteAccess().");
            --this._writeDepth;
            if (this._writeDepth != 0) return;
            this._writer = null;
            this.notifyAll();
        }
    }

    @Override
    public NamedObj getContainer() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getFullName() {
        return this._name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getName(NamedObj relativeTo) {
        return this._name;
    }

    public final synchronized void getReadAccess() {
        Thread current = Thread.currentThread();
        AccessRecord record = null;
        record = current == this._lastReader ? this._lastReaderRecord : this._getAccessRecord(current, true);
        if (record.readDepth > 0) {
            ++record.readDepth;
            return;
        }
        if (current == this._writer) {
            ++record.readDepth;
            ++this._numReaders;
            return;
        }
        ++record.failedReadAttempts;
        while (this._waitingWriteRequests != 0 || this._writer != null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                throw new InternalErrorException(current.getName() + " - thread interrupted while waiting to get " + "read access: " + ex.getMessage());
            }
        }
        --record.failedReadAttempts;
        ++record.readDepth;
        ++this._numReaders;
    }

    public final synchronized long getVersion() {
        return this._version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void getWriteAccess() {
        Thread current = Thread.currentThread();
        if (current == this._writer) {
            ++this._writeDepth;
            return;
        }
        AccessRecord record = null;
        record = current == this._lastReader ? this._lastReaderRecord : this._getAccessRecord(current, true);
        ++this._waitingWriteRequests;
        ++record.failedWriteAttempts;
        try {
            while (true) {
                if (this._writer == null && (this._numReaders == 0L || this._numReaders == 1L && record.readDepth > 0)) {
                    this._writer = current;
                    this._writeDepth = 1;
                    --record.failedWriteAttempts;
                    return;
                }
                this.wait();
                continue;
                break;
            }
        }
        catch (InterruptedException ex) {
            throw new InternalErrorException(current.getName() + " - thread interrupted while waiting to get " + "write access: " + ex.getMessage());
        }
        finally {
            --this._waitingWriteRequests;
            if (this._waitingWriteRequests == 0 && this._writer == null) {
                this.notifyAll();
            }
        }
    }

    public boolean handleModelError(NamedObj context, IllegalActionException exception) throws IllegalActionException {
        throw exception;
    }

    public final synchronized void incrVersion() {
        ++this._version;
    }

    public synchronized void remove(NamedObj item) {
        this._directory.remove(item);
        this.incrVersion();
    }

    public synchronized void removeAll() {
        this._directory.clear();
        this.incrVersion();
    }

    @Override
    public synchronized void setName(String name) {
        if (name == null) {
            name = "";
        }
        this._name = name;
        this.incrVersion();
    }

    public String toString() {
        return this.getClass().getName() + " {" + this.getFullName() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(Object obj) throws InterruptedException {
        int depth = 0;
        depth = this._releaseAllReadPermissions();
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait();
            }
        }
        finally {
            this._reacquireReadPermissions(depth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(Object obj, long timeout) throws InterruptedException {
        int depth = 0;
        depth = this._releaseAllReadPermissions();
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait(timeout);
            }
        }
        finally {
            this._reacquireReadPermissions(depth);
        }
    }

    protected synchronized String _description(int detail, int indent, int bracket) {
        StringBuffer result = new StringBuffer(NamedObj._getIndentPrefix(indent));
        if (bracket == 1 || bracket == 2) {
            result.append("{");
        }
        if ((detail & 1) != 0) {
            result.append(this.getClass().getName());
            if ((detail & 2) != 0) {
                result.append(" ");
            }
        }
        if ((detail & 2) != 0) {
            result.append("{" + this.getFullName() + "}");
        }
        if ((detail & 8) != 0) {
            if ((detail & 3) != 0) {
                result.append(" ");
            }
            result.append("directory {\n");
            Enumeration enumeration = this.directory();
            while (enumeration.hasMoreElements()) {
                NamedObj obj = (NamedObj)enumeration.nextElement();
                if ((detail & 0x10) == 0) {
                    detail &= 0xFFFFFFF7;
                }
                result.append(obj._description(detail, indent + 1, 2) + "\n");
            }
            result.append("}");
        }
        if (bracket == 2) {
            result.append("}");
        }
        return result.toString();
    }

    private final AccessRecord _getAccessRecord(Thread current, boolean createNew) {
        AccessRecord record;
        if (this._readerRecords == null) {
            this._readerRecords = new HashMap();
        }
        if ((record = (AccessRecord)this._readerRecords.get(current)) == null) {
            Iterator records = this._readerRecords.values().iterator();
            while (records.hasNext()) {
                AccessRecord aRecord = (AccessRecord)records.next();
                if (aRecord.failedReadAttempts != 0 || aRecord.failedWriteAttempts != 0 || aRecord.readDepth != 0 || aRecord == this._lastReaderRecord) continue;
                records.remove();
            }
            if (createNew) {
                record = new AccessRecord();
                this._readerRecords.put(current, record);
            }
        }
        if (record != null) {
            this._lastReader = current;
            this._lastReaderRecord = record;
        }
        return record;
    }

    private synchronized void _reacquireReadPermissions(int count) {
        if (count == 0) {
            return;
        }
        Thread current = Thread.currentThread();
        AccessRecord record = null;
        record = current == this._lastReader ? this._lastReaderRecord : this._getAccessRecord(current, false);
        if (record == null || count > record.failedReadAttempts) {
            throw new InvalidStateException(this, "Trying to reacquire read permission not in record.");
        }
        while (true) {
            if (current == this._writer || this._waitingWriteRequests == 0 && this._writer == null) {
                ++this._numReaders;
                record.failedReadAttempts -= count;
                record.readDepth = count;
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                throw new InternalErrorException("Thread interrupted while waiting for read access!" + ex.getMessage());
            }
        }
    }

    private synchronized int _releaseAllReadPermissions() {
        Thread current = Thread.currentThread();
        AccessRecord record = null;
        record = current == this._lastReader ? this._lastReaderRecord : this._getAccessRecord(current, false);
        if (record == null || record.readDepth == 0) {
            return 0;
        }
        --this._numReaders;
        this.notifyAll();
        int result = record.readDepth;
        record.failedReadAttempts += result;
        record.readDepth = 0;
        return result;
    }

    private static final class AccessRecord {
        public int failedReadAttempts = 0;
        public int failedWriteAttempts = 0;
        public int readDepth = 0;

        private AccessRecord() {
        }
    }
}

