/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedList;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Nameable;

public class KernelRuntimeException
extends RuntimeException {
    private Throwable _cause;
    private Collection _causes;
    private String _message;

    public KernelRuntimeException() {
        this(null, null, null, null);
    }

    public KernelRuntimeException(String detail) {
        this(null, null, null, detail);
    }

    public KernelRuntimeException(Throwable cause, String detail) {
        this(null, null, cause, detail);
    }

    public KernelRuntimeException(Nameable object, String detail) {
        this(object, null, null, detail);
    }

    public KernelRuntimeException(Nameable object1, Nameable object2, Throwable cause, String detail) {
        this._causes = new LinkedList();
        this._causes.add(object1);
        this._causes.add(object2);
        this._setMessage(KernelException.generateMessage(object1, object2, cause, detail));
        this._setCause(cause);
    }

    public KernelRuntimeException(Collection objects, Throwable cause, String detail) {
        this._causes = objects;
        this._setMessage(KernelException.generateMessage(objects, cause, detail));
        this._setCause(cause);
    }

    @Override
    public Throwable getCause() {
        return this._cause;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    public Collection getNameables() {
        return this._causes;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err));
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this._cause != null) {
            printWriter.print("Caused by: ");
            this._cause.printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    protected void _setCause(Throwable cause) {
        this._cause = cause;
    }

    protected void _setMessage(String message) {
        this._message = message == null ? "" : message;
    }
}

