/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;

public final class CrossRefList
implements Serializable {
    private long _listVersion = 0L;
    private int _size = 0;
    private CrossRef _headNode;
    private CrossRef _lastNode;
    private Object _container;

    public CrossRefList(Object container) {
        this._container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrossRefList(Object container, CrossRefList originalList) {
        this(container);
        CrossRefList crossRefList = originalList;
        synchronized (crossRefList) {
            if (originalList.size() == 0) {
                return;
            }
            CrossRef p = originalList._headNode;
            while (p != null) {
                if (p._far._nearList() != null) {
                    try {
                        this.link(p._far._nearList());
                    }
                    catch (IllegalActionException ex) {
                        throw new InternalErrorException(null, (Throwable)ex, null);
                    }
                }
                p = p._next;
            }
        }
    }

    public synchronized Object first() {
        if (this._headNode != null) {
            return this._headNode._farContainer();
        }
        return null;
    }

    public synchronized Object get(int index) {
        if (index < 0 || index >= this._size) {
            return null;
        }
        int count = 0;
        CrossRef result = this._headNode;
        while (result != null && count++ < index) {
            result = result._next;
        }
        if (result != null) {
            return result._farContainer();
        }
        return null;
    }

    public synchronized Enumeration getContainers() {
        return new CrossRefEnumeration();
    }

    public synchronized void insertLink(int index, CrossRefList farList) throws IllegalActionException {
        if (farList == this) {
            throw new IllegalActionException("CrossRefLink.link: Illegal self-link.");
        }
        ++this._listVersion;
        CrossRef localCrossRef = new CrossRef(index);
        if (farList != null) {
            CrossRefList crossRefList = farList;
            crossRefList.getClass();
            localCrossRef._far = crossRefList.new CrossRef(localCrossRef);
        }
    }

    public synchronized boolean isLinked(Object obj) {
        if (obj == null || this._size == 0) {
            return false;
        }
        CrossRef p = this._headNode;
        while (p != null) {
            Object far = p._farContainer();
            if (far != null && far.equals(obj)) {
                return true;
            }
            p = p._next;
        }
        return false;
    }

    public synchronized void link(CrossRefList farList) throws IllegalActionException {
        if (farList == this) {
            throw new IllegalActionException("CrossRefLink.link: Illegal self-link.");
        }
        ++this._listVersion;
        CrossRef localCrossRef = new CrossRef();
        if (farList != null) {
            CrossRefList crossRefList = farList;
            crossRefList.getClass();
            localCrossRef._far = crossRefList.new CrossRef(localCrossRef);
        }
    }

    public synchronized int size() {
        return this._size;
    }

    public synchronized void unlink(int index) {
        int count = 0;
        CrossRef toDelete = this._headNode;
        while (toDelete != null && count++ < index) {
            toDelete = toDelete._next;
        }
        if (toDelete != null) {
            toDelete._dissociate();
        }
    }

    public synchronized void unlink(Object obj) {
        if (obj == null || this._size == 0) {
            return;
        }
        CrossRef p = this._headNode;
        while (p != null) {
            CrossRef n = p._next;
            Object far = p._farContainer();
            if (far != null && far.equals(obj)) {
                p._dissociate();
            }
            p = n;
        }
    }

    public synchronized void unlinkAll() {
        if (this._size == 0) {
            return;
        }
        CrossRef p = this._headNode;
        while (p != null) {
            CrossRef n = p._next;
            p._dissociate();
            p = n;
        }
        this._headNode = null;
        this._lastNode = null;
        this._size = 0;
    }

    private class CrossRefEnumeration
    implements Enumeration {
        private long _enumeratorVersion;
        private CrossRef _ref;

        public CrossRefEnumeration() {
            this._enumeratorVersion = CrossRefList.this._listVersion;
            this._ref = CrossRefList.this._headNode;
        }

        @Override
        public boolean hasMoreElements() {
            if (this._enumeratorVersion != CrossRefList.this._listVersion) {
                throw new InvalidStateException("CrossRefList.hasMoreElements(): The list has been modified.");
            }
            return this._ref != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this._enumeratorVersion != CrossRefList.this._listVersion) {
                throw new InvalidStateException("CrossRefList.nextElement(): The list has been modified.");
            }
            if (this._ref == null) {
                throw new NoSuchElementException("exhausted enumeration");
            }
            CrossRef p = this._ref;
            Object v = this._ref._farContainer();
            this._ref = p._next;
            return v;
        }
    }

    protected class CrossRef
    implements Serializable {
        protected CrossRef _far;
        private CrossRef _next;
        private CrossRef _previous;

        private CrossRef() {
            this((CrossRef)null);
        }

        private CrossRef(CrossRef spouse) {
            this._far = spouse;
            if (CrossRefList.this._size > 0) {
                this._previous = CrossRefList.this._lastNode;
                ((CrossRefList)CrossRefList.this)._lastNode._next = this;
                CrossRefList.this._lastNode = this;
            } else {
                CrossRefList.this._lastNode = this;
                CrossRefList.this._headNode = this;
            }
            ++CrossRefList.this._size;
        }

        private CrossRef(int index) {
            if (index == 0) {
                if (CrossRefList.this._size == 0) {
                    CrossRefList.this._lastNode = this;
                    CrossRefList.this._headNode = this;
                } else {
                    this._next = CrossRefList.this._headNode;
                    ((CrossRefList)CrossRefList.this)._headNode._previous = this;
                    CrossRefList.this._headNode = this;
                }
            } else {
                CrossRef previous = CrossRefList.this._headNode;
                if (previous == null && index > 0) {
                    previous = new CrossRef();
                    CrossRefList.this._headNode = previous;
                    CrossRefList.this._lastNode = previous;
                }
                int ind = 1;
                while (ind++ < index) {
                    if (previous._next == null) {
                        CrossRef newCrossRef;
                        previous._next = newCrossRef = new CrossRef();
                        newCrossRef._previous = previous;
                        CrossRefList.this._lastNode = newCrossRef;
                        previous = newCrossRef;
                        continue;
                    }
                    previous = previous._next;
                }
                if (previous != null) {
                    if (CrossRefList.this._lastNode == previous) {
                        CrossRefList.this._lastNode = this;
                    }
                    this._next = previous._next;
                    previous._next = this;
                    this._previous = previous;
                } else {
                    CrossRefList.this._lastNode = this;
                    CrossRefList.this._headNode = this;
                }
            }
            ++CrossRefList.this._size;
        }

        private Object _nearContainer() {
            return CrossRefList.this._container;
        }

        private synchronized Object _farContainer() {
            if (this._far != null) {
                return this._far._nearContainer();
            }
            return null;
        }

        private CrossRefList _nearList() {
            return CrossRefList.this;
        }

        private synchronized void _dissociate() {
            this._unlink();
            if (this._far != null) {
                this._far._unlink();
            }
        }

        private synchronized void _unlink() {
            ++CrossRefList.this._listVersion;
            if (this._next != null) {
                this._next._previous = this._previous;
            } else {
                CrossRefList.this._lastNode = this._previous;
            }
            if (this._previous != null) {
                this._previous._next = this._next;
            } else {
                CrossRefList.this._headNode = this._next;
            }
            CrossRefList.this._size--;
        }
    }
}

