/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.CrossRefList;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class ComponentPort
extends Port {
    private transient List _deepLinkedPorts;
    private transient long _deepLinkedPortsVersion = -1L;
    private transient List _deepLinkedInPorts;
    private transient long _deepLinkedInPortsVersion = -1L;
    private transient boolean _isOpqaue;
    private transient long _isOpaqueVersion = -1L;

    public ComponentPort() {
    }

    public ComponentPort(Workspace workspace) {
        super(workspace);
    }

    public ComponentPort(ComponentEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ComponentPort newObject = (ComponentPort)super.clone(workspace);
        newObject._insideLinks = new CrossRefList(newObject);
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List deepConnectedPortList() {
        try {
            this._workspace.getReadAccess();
            List list = this._deepConnectedPortList(null);
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration deepConnectedPorts() {
        return Collections.enumeration(this.deepConnectedPortList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List deepInsidePortList() {
        try {
            this._workspace.getReadAccess();
            List list = this._deepInsidePortList(null);
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration deepInsidePorts() {
        return Collections.enumeration(this.deepInsidePortList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertInsideLink(int index, Relation relation) throws IllegalActionException {
        if (relation != null) {
            this.insertLink(index, relation);
            return;
        }
        try {
            this._workspace.getWriteAccess();
            this._insideLinks.insertLink(index, null);
            ((Entity)this.getContainer()).connectionsChanged(this);
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertLink(int index, Relation relation) throws IllegalActionException {
        if (relation != null && this._workspace != relation.workspace()) {
            throw new IllegalActionException((Nameable)this, relation, "Cannot link because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            if (relation == null) {
                this._relationsList.insertLink(index, null);
            } else {
                this._checkLink(relation);
                if (this._isInsideLinkable(relation.getContainer())) {
                    this._insideLinks.insertLink(index, relation._linkList);
                } else {
                    this._relationsList.insertLink(index, relation._linkList);
                }
            }
            ((Entity)this.getContainer()).connectionsChanged(this);
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List insidePortList() {
        try {
            this._workspace.getReadAccess();
            LinkedList result = new LinkedList();
            for (Relation relation : this.insideRelationList()) {
                if (relation == null) continue;
                result.addAll(relation.linkedPortList(this));
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Enumeration insidePorts() {
        return Collections.enumeration(this.insidePortList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List insideRelationList() {
        try {
            this._workspace.getReadAccess();
            LinkedList result = new LinkedList();
            Enumeration relations = this._insideLinks.getContainers();
            while (relations.hasMoreElements()) {
                result.add(relations.nextElement());
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration insideRelations() {
        try {
            this._workspace.getReadAccess();
            Enumeration enumeration = this._insideLinks.getContainers();
            return enumeration;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeeplyConnected(ComponentPort port) {
        if (port == null) {
            return false;
        }
        try {
            this._workspace.getReadAccess();
            boolean bl = this.deepConnectedPortList().contains(port);
            return bl;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInsideGroupLinked(Relation r) {
        try {
            this._workspace.getReadAccess();
            for (Relation groupRelation : r.relationGroupList()) {
                if (!this.isInsideLinked(groupRelation)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public boolean isInsideLinked(Relation relation) {
        return this._insideLinks.isLinked(relation);
    }

    public boolean isOpaque() {
        long workspaceVersion = this._workspace.getVersion();
        if (this._isOpaqueVersion != workspaceVersion) {
            ComponentEntity entity = (ComponentEntity)this.getContainer();
            this._isOpqaue = entity == null ? true : entity.isOpaque();
            this._isOpaqueVersion = workspaceVersion;
        }
        return this._isOpqaue;
    }

    public void liberalLink(ComponentRelation relation) throws IllegalActionException {
        if (relation != null) {
            this._checkLiberalLink(relation);
        }
        this._doLink(relation);
    }

    @Override
    public void link(Relation relation) throws IllegalActionException {
        if (relation != null) {
            this._checkLink(relation);
        }
        this._doLink(relation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numInsideLinks() {
        try {
            this._workspace.getReadAccess();
            int n = this._insideLinks.size();
            return n;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContainer(Entity entity) throws IllegalActionException, NameDuplicationException {
        if (entity != null && this._workspace != entity.workspace()) {
            throw new IllegalActionException((Nameable)this, entity, "Cannot set container because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            super.setContainer(entity);
            if (entity == null) {
                this.unlinkAllInside();
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    @Override
    public void unlink(Relation relation) {
        if (relation != null && this._isInsideLinkable(relation.getContainer())) {
            this.unlinkInside(relation);
        } else {
            super.unlink(relation);
        }
    }

    @Override
    public void unlinkAll() {
        super.unlinkAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkAllInside() {
        try {
            this._workspace.getWriteAccess();
            this._insideLinks.unlinkAll();
            Entity container = (Entity)this.getContainer();
            if (container != null) {
                container.connectionsChanged(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkInside(int index) {
        try {
            this._workspace.getWriteAccess();
            this._insideLinks.unlink(index);
            Entity container = (Entity)this.getContainer();
            if (container != null) {
                container.connectionsChanged(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkInside(Relation relation) {
        try {
            this._workspace.getWriteAccess();
            this._insideLinks.unlink(relation);
            Entity container = (Entity)this.getContainer();
            if (container != null) {
                container.connectionsChanged(this);
            }
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    @Override
    protected void _checkContainer(Entity container) throws IllegalActionException {
        if (!(container instanceof ComponentEntity) && container != null) {
            throw new IllegalActionException((Nameable)container, this, "ComponentPort can only be contained by ComponentEntity");
        }
    }

    protected void _checkLiberalLink(Relation relation) throws IllegalActionException {
        if (relation != null) {
            if (!(relation instanceof ComponentRelation)) {
                throw new IllegalActionException((Nameable)this, relation, "Attempt to link to an incompatible relation (expected ComponentRelation).");
            }
            Entity container = (Entity)this.getContainer();
            if (container == null) {
                throw new IllegalActionException((Nameable)this, relation, "Port must have a container to establish a link.");
            }
            if (container.isClassDefinition() && container != relation.getContainer()) {
                throw new IllegalActionException((Nameable)this, relation, "Cannot establish a link to a port contained by a class definition");
            }
            relation._checkPort(this);
        }
    }

    @Override
    protected void _checkLink(Relation relation) throws IllegalActionException {
        super._checkLink(relation);
        if (relation != null) {
            NamedObj relationContainer;
            if (!(relation instanceof ComponentRelation)) {
                throw new IllegalActionException((Nameable)this, relation, "Attempt to link to an incompatible relation (expected ComponentRelation).");
            }
            Entity container = (Entity)this.getContainer();
            if (container != (relationContainer = relation.getContainer()) && container.getContainer() != relationContainer) {
                throw new IllegalActionException((Nameable)this, relation, "Link crosses levels of the hierarchy");
            }
            if (container.isClassDefinition() && container != relationContainer) {
                throw new IllegalActionException((Nameable)this, relation, "Cannot establish a link to a port contained by a class definition");
            }
            relation._checkPort(this);
        }
    }

    protected List _deepConnectedPortList(LinkedList path) {
        if (this._deepLinkedPortsVersion == this._workspace.getVersion()) {
            return this._deepLinkedPorts;
        }
        if (path == null) {
            path = new LinkedList<ComponentPort>();
        } else if (path.indexOf(this) >= 0) {
            throw new InvalidStateException(path, "Loop in topology!");
        }
        path.add(0, this);
        Iterator nearRelations = this.linkedRelationList().iterator();
        LinkedList<ComponentPort> result = new LinkedList<ComponentPort>();
        while (nearRelations.hasNext()) {
            ComponentRelation relation = (ComponentRelation)nearRelations.next();
            if (relation == null) continue;
            for (ComponentPort port : relation.linkedPortList(this)) {
                if (port._isInsideLinkable(relation.getContainer())) {
                    if (port.isOpaque()) {
                        result.add(port);
                        continue;
                    }
                    result.addAll(port._deepConnectedPortList(path));
                    continue;
                }
                if (port.isOpaque()) {
                    result.add(port);
                    continue;
                }
                result.addAll(port._deepInsidePortList(path));
            }
        }
        this._deepLinkedPorts = Collections.unmodifiableList(result);
        this._deepLinkedPortsVersion = this._workspace.getVersion();
        path.remove(0);
        return this._deepLinkedPorts;
    }

    protected Enumeration _deepConnectedPorts(LinkedList path) {
        return Collections.enumeration(this._deepConnectedPortList(path));
    }

    protected List _deepInsidePortList(LinkedList path) {
        if (this._deepLinkedInPortsVersion == this._workspace.getVersion()) {
            return this._deepLinkedInPorts;
        }
        if (path == null) {
            path = new LinkedList<ComponentPort>();
        } else if (path.indexOf(this) >= 0) {
            throw new InvalidStateException(path, "Loop in topology!");
        }
        path.add(0, this);
        LinkedList<ComponentPort> result = new LinkedList<ComponentPort>();
        for (Relation relation : this.insideRelationList()) {
            if (relation == null) continue;
            for (ComponentPort port : relation.linkedPortList(this)) {
                if (port._isInsideLinkable(relation.getContainer())) {
                    if (port.isOpaque()) {
                        result.add(port);
                        continue;
                    }
                    result.addAll(port._deepConnectedPortList(path));
                    continue;
                }
                if (port.isOpaque()) {
                    result.add(port);
                    continue;
                }
                result.addAll(port._deepInsidePortList(path));
            }
        }
        this._deepLinkedInPorts = Collections.unmodifiableList(result);
        this._deepLinkedInPortsVersion = this._workspace.getVersion();
        path.remove(0);
        return this._deepLinkedInPorts;
    }

    protected Enumeration _deepInsidePorts(LinkedList path) {
        return Collections.enumeration(this._deepInsidePortList(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _description(int detail, int indent, int bracket) {
        try {
            this._workspace.getReadAccess();
            StringBuffer result = new StringBuffer();
            if (bracket == 1 || bracket == 2) {
                result.append(super._description(detail, indent, 1));
            } else {
                result.append(super._description(detail, indent, 0));
            }
            if ((detail & 4) != 0) {
                if (result.toString().trim().length() > 0) {
                    result.append(" ");
                }
                detail &= 0xFFFFFFFB;
                result.append("insidelinks {\n");
                for (Relation relation : this.insideRelationList()) {
                    if (relation != null) {
                        result.append(relation._description(detail, indent + 1, 2) + "\n");
                        continue;
                    }
                    result.append(ComponentPort._getIndentPrefix(indent + 1) + "null\n");
                }
                result.append(ComponentPort._getIndentPrefix(indent) + "}");
            }
            if (bracket == 2) {
                result.append("}");
            }
            String string = result.toString();
            return string;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _isInsideLinkable(Nameable entity) {
        try {
            this._workspace.getReadAccess();
            NamedObj portContainer = this.getContainer();
            while (entity != null) {
                if (portContainer == entity) {
                    boolean bl = true;
                    return bl;
                }
                entity = entity.getContainer();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doLink(Relation relation) throws IllegalActionException {
        if (relation != null && this._workspace != relation.workspace()) {
            throw new IllegalActionException((Nameable)this, relation, "Cannot link because workspaces are different.");
        }
        try {
            this._workspace.getWriteAccess();
            if (relation == null) {
                this._relationsList.link(null);
            } else if (this._isInsideLinkable(relation.getContainer())) {
                this._insideLinks.link(relation._linkList);
            } else {
                this._relationsList.link(relation._linkList);
            }
            ((Entity)this.getContainer()).connectionsChanged(this);
        }
        finally {
            this._workspace.doneWriting();
        }
    }
}

