/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis.strategy;

import ptolemy.graph.Graph;
import ptolemy.graph.analysis.analyzer.GraphAnalyzer;
import ptolemy.graph.analysis.strategy.Strategy;

public abstract class CachedStrategy
extends Strategy
implements GraphAnalyzer {
    private Object _cachedResult = null;
    private Graph _graph;
    private long _lastComputation;
    private boolean _cachingEnabled = true;

    public CachedStrategy(Graph graph) {
        this._graph = graph;
        this.reset();
    }

    public boolean cachingStatus() {
        return this._cachingEnabled;
    }

    public void disableCaching() {
        this._cachingEnabled = false;
    }

    public void enableCaching() {
        this._cachingEnabled = true;
    }

    public Object getCachedResult() {
        return this._cachedResult;
    }

    @Override
    public Graph graph() {
        return this._graph;
    }

    public boolean obsolete() {
        return this._lastComputation < this.graph().changeCount();
    }

    public void reset() {
        this._lastComputation = -1L;
    }

    public void setCachedResult(CachedStrategy cacher) {
        this._cachedResult = cacher.getCachedResult();
    }

    @Override
    public String toString() {
        return "Cached strategy.";
    }

    protected Object _compute() {
        return null;
    }

    protected Object _convertResult(Object result) {
        return result;
    }

    protected final Object _result() {
        Object result = null;
        if (this._cachingEnabled && this.obsolete()) {
            this._cachedResult = this._compute();
            this._registerComputation();
            result = this._cachedResult;
        } else {
            result = this._cachingEnabled ? this._cachedResult : this._compute();
        }
        return this._convertResult(result);
    }

    private void _registerComputation() {
        this._lastComputation = this.graph().changeCount();
    }
}

