/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis;

import ptolemy.graph.Graph;
import ptolemy.graph.analysis.Analysis;
import ptolemy.graph.analysis.analyzer.Analyzer;
import ptolemy.graph.analysis.analyzer.ZeroLengthCycleAnalyzer;
import ptolemy.graph.analysis.strategy.FloydWarshallZeroLengthCycleStrategy;
import ptolemy.graph.mapping.ToDoubleMapping;

public class ZeroLengthCycleAnalysis
extends Analysis {
    public ZeroLengthCycleAnalysis(Graph graph, ToDoubleMapping edgeLengths) {
        super(new FloydWarshallZeroLengthCycleStrategy(graph, edgeLengths));
    }

    public ZeroLengthCycleAnalysis(ZeroLengthCycleAnalyzer analyzer) {
        super(analyzer);
    }

    public boolean hasZeroLengthCycle() {
        return ((ZeroLengthCycleAnalyzer)this.analyzer()).hasZeroLengthCycle();
    }

    @Override
    public String toString() {
        return "Zero-length cycle analysis using the following analyzer:\n" + this.analyzer().toString();
    }

    @Override
    public boolean validAnalyzerInterface(Analyzer analyzer) {
        return analyzer instanceof ZeroLengthCycleAnalyzer;
    }
}

