/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import ptolemy.graph.CPO;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.GraphConstructionException;
import ptolemy.graph.GraphStateException;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.TransitiveClosureAnalysis;
import ptolemy.graph.analysis.strategy.CachedStrategy;

public class DirectedAcyclicGraph
extends DirectedGraph
implements CPO {
    private boolean[][] _closure = null;
    private boolean[][] _tranClosureTranspose = null;
    private TransitiveClosureAnalysis _transitiveClosureAnalysis;
    private Object _bottom = null;
    private Object _top = null;

    public DirectedAcyclicGraph() {
    }

    public DirectedAcyclicGraph(int nodeCount) {
        super(nodeCount);
    }

    @Override
    public Object bottom() {
        this._validate();
        return this._bottom;
    }

    @Override
    public int compare(Object e1, Object e2) {
        this._validate();
        int i1 = this.nodeLabel(e1);
        int i2 = this.nodeLabel(e2);
        return this._compareNodeId(i1, i2);
    }

    @Override
    public Object[] downSet(Object e) {
        this._validateDual();
        return this._upSetShared(e);
    }

    @Override
    public Object greatestElement(Object[] subset) {
        this._validateDual();
        return this._leastElementShared(subset);
    }

    @Override
    public Object greatestLowerBound(Object e1, Object e2) {
        this._validateDual();
        return this._lubShared(e1, e2);
    }

    @Override
    public Object greatestLowerBound(Object[] subset) {
        this._validateDual();
        return this._lubShared(subset);
    }

    @Override
    public boolean isLattice() {
        this._validate();
        if (this.bottom() == null || this.top() == null) {
            return false;
        }
        Object[] nodes = DirectedAcyclicGraph.weightArray(this.nodes());
        for (int i = 0; i < nodes.length - 1; ++i) {
            for (int j = i + 1; j < nodes.length; ++j) {
                if (this.leastUpperBound(nodes[i], nodes[j]) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object leastElement(Object[] subset) {
        this._validate();
        return this._leastElementShared(subset);
    }

    @Override
    public Object leastUpperBound(Object e1, Object e2) {
        this._validate();
        return this._lubShared(e1, e2);
    }

    @Override
    public Object leastUpperBound(Object[] subset) {
        this._validate();
        return this._lubShared(subset);
    }

    @Override
    public Object top() {
        this._validate();
        return this._top;
    }

    public Object[] topologicalSort() {
        this._validate();
        int size = this.nodeCount();
        int[] indeg = new int[size];
        for (int i = 0; i < size; ++i) {
            indeg[i] = this.inputEdgeCount(this.node(i));
        }
        Object[] result = new Object[size];
        boolean finished = false;
        boolean active = true;
        int nextResultIndex = 0;
        while (!finished) {
            active = false;
            finished = true;
            for (int id = 0; id < size; ++id) {
                if (indeg[id] > 0) {
                    active = true;
                }
                if (indeg[id] != 0) continue;
                finished = false;
                result[nextResultIndex++] = this.nodeWeight(id);
                int n = id;
                indeg[n] = indeg[n] - 1;
                Iterator outputEdges = this.outputEdges(this.node(id)).iterator();
                while (outputEdges.hasNext()) {
                    Node sink = ((Edge)outputEdges.next()).sink();
                    int n2 = this.nodeLabel(sink);
                    indeg[n2] = indeg[n2] - 1;
                }
            }
            if (!finished || !active) continue;
            throw new GraphStateException("DirectedAcyclicGraph.topologicalSort: Graph is cyclic.");
        }
        return result;
    }

    @Override
    public Object[] topologicalSort(Object[] weights) {
        int i;
        this._validate();
        int N = weights.length;
        int[] ids = new int[N];
        for (i = 0; i < N; ++i) {
            ids[i] = this.nodeLabel(weights[i]);
        }
        for (i = 0; i < N - 1; ++i) {
            for (int j = i + 1; j < N; ++j) {
                if (this._compareNodeId(ids[i], ids[j]) != 1) continue;
                int tmp = ids[i];
                ids[i] = ids[j];
                ids[j] = tmp;
            }
        }
        Object[] result = new Object[N];
        for (int i2 = 0; i2 < N; ++i2) {
            result[i2] = this.nodeWeight(ids[i2]);
        }
        return result;
    }

    @Override
    public Object[] upSet(Object e) {
        this._validate();
        return this._upSetShared(e);
    }

    @Override
    protected Edge _addEdge(Node node1, Node node2, boolean weighted, Object weight) {
        if (node1 == node2) {
            throw new GraphConstructionException("Cannot add a self loop in an acyclic graph.\nA self loop was attempted on the following node.\n" + node1.toString());
        }
        return super._addEdge(node1, node2, weighted, weight);
    }

    @Override
    protected void _initializeAnalyses() {
        super._initializeAnalyses();
        this._transitiveClosureAnalysis = new TransitiveClosureAnalysis(this);
    }

    private int _compareNodeId(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        if (this._closure[i1][i2]) {
            return -1;
        }
        if (this._closure[i2][i1]) {
            return 1;
        }
        return 2;
    }

    private Object _leastElementNodeId(int[] ids) {
        int virtualLength;
        int numberOfRemovedElements;
        LinkedList<Integer> incomparables = new LinkedList<Integer>();
        for (virtualLength = ids.length; virtualLength > 1; virtualLength -= numberOfRemovedElements) {
            int virtualIndex = 0;
            numberOfRemovedElements = 0;
            int i = 0;
            block6: while (i < virtualLength - 1) {
                switch (this._compareNodeId(ids[i++], ids[i++])) {
                    case -1: 
                    case 0: {
                        ids[virtualIndex++] = ids[i - 2];
                        ++numberOfRemovedElements;
                        continue block6;
                    }
                    case 1: {
                        ids[virtualIndex++] = ids[i - 1];
                        ++numberOfRemovedElements;
                        continue block6;
                    }
                    case 2: {
                        incomparables.addLast(ids[i - 2]);
                        incomparables.addLast(ids[i - 1]);
                        numberOfRemovedElements += 2;
                        continue block6;
                    }
                }
                throw new GraphStateException("Bugs in code! Inconsistent data structure!");
            }
            if (i != virtualLength - 1) continue;
            ids[virtualIndex] = ids[i];
        }
        if (virtualLength == 0) {
            return null;
        }
        if (incomparables.size() != 0) {
            ListIterator iterator = incomparables.listIterator(0);
            while (iterator.hasNext()) {
                int result = this._compareNodeId(ids[0], (Integer)iterator.next());
                if (result != 1 && result != 2) continue;
                return null;
            }
        }
        return this.nodeWeight(ids[0]);
    }

    private Object _leastElementShared(Object[] subset) {
        if (subset.length == 1) {
            if (this.containsNodeWeight(subset[0])) {
                return subset[0];
            }
            throw new IllegalArgumentException("Object not in CPO.");
        }
        if (subset.length == 2) {
            int i2;
            int i1 = this.nodeLabel(subset[0]);
            int result = this._compareNodeId(i1, i2 = this.nodeLabel(subset[1]));
            if (result == -1 || result == 0) {
                return subset[0];
            }
            if (result == 1) {
                return subset[1];
            }
            return null;
        }
        int[] ids = new int[subset.length];
        for (int i = 0; i < subset.length; ++i) {
            ids[i] = this.nodeLabel(subset[i]);
        }
        return this._leastElementNodeId(ids);
    }

    private Object _lubShared(Object e1, Object e2) {
        int i2;
        int i1 = this.nodeLabel(e1);
        int result = this._compareNodeId(i1, i2 = this.nodeLabel(e2));
        if (result == -1 || result == 0) {
            return e2;
        }
        if (result == 1) {
            return e1;
        }
        int size = this.nodeCount();
        boolean[] isUpperBound = new boolean[size];
        int numUpperBound = 0;
        for (int i = 0; i < size; ++i) {
            isUpperBound[i] = false;
            if (!this._closure[i1][i] || !this._closure[i2][i]) continue;
            isUpperBound[i] = true;
            ++numUpperBound;
        }
        if (numUpperBound == 0) {
            return null;
        }
        int[] upperBound = new int[numUpperBound];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (!isUpperBound[i]) continue;
            upperBound[count++] = i;
        }
        if (numUpperBound == 1) {
            return this.nodeWeight(upperBound[0]);
        }
        return this._leastElementNodeId(upperBound);
    }

    private Object _lubShared(Object[] subset) {
        int[] subsetId = new int[subset.length];
        for (int i = 0; i < subset.length; ++i) {
            subsetId[i] = this.nodeLabel(subset[i]);
        }
        int size = this.nodeCount();
        int numUB = 0;
        int[] ubId = new int[size];
        for (int i = 0; i < size; ++i) {
            boolean isUB = true;
            for (int j = 0; j < subsetId.length; ++j) {
                int compare = this._compareNodeId(i, subsetId[j]);
                if (compare != -1 && compare != 2) continue;
                isUB = false;
                break;
            }
            if (!isUB) continue;
            ubId[numUB++] = i;
        }
        int[] ids = new int[numUB];
        for (int i = 0; i < numUB; ++i) {
            ids[i] = ubId[i];
        }
        return this._leastElementNodeId(ids);
    }

    private Object[] _upSetShared(Object e) {
        int id = this.nodeLabel(e);
        ArrayList<Object> upset = new ArrayList<Object>(this._closure.length);
        upset.add(e);
        for (int i = 0; i < this._closure.length; ++i) {
            if (!this._closure[id][i]) continue;
            upset.add(this.nodeWeight(i));
        }
        return upset.toArray();
    }

    private void _validate() {
        int i;
        boolean[][] transitiveClosure = this.transitiveClosure();
        if (!((CachedStrategy)this._transitiveClosureAnalysis.analyzer()).obsolete() && this.isAcyclic()) {
            this._closure = transitiveClosure;
            return;
        }
        if (!this.isAcyclic()) {
            throw new GraphStateException("DirectedAcyclicGraph._validate: Graph is cyclic.");
        }
        this._bottom = null;
        for (i = 0; i < this.nodeCount(); ++i) {
            if (this.inputEdgeCount(this.node(i)) != 0) continue;
            if (this._bottom == null) {
                this._bottom = this.nodeWeight(i);
                continue;
            }
            this._bottom = null;
            break;
        }
        this._top = null;
        for (i = 0; i < this.nodeCount(); ++i) {
            if (this.outputEdgeCount(this.node(i)) != 0) continue;
            if (this._top == null) {
                this._top = this.nodeWeight(i);
                continue;
            }
            this._top = null;
            break;
        }
        this._closure = transitiveClosure;
        this._tranClosureTranspose = null;
    }

    private void _validateDual() {
        this._validate();
        boolean[][] transitiveClosure = this.transitiveClosure();
        if (this._tranClosureTranspose == null) {
            int size = transitiveClosure.length;
            this._tranClosureTranspose = new boolean[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    this._tranClosureTranspose[i][j] = transitiveClosure[j][i];
                }
            }
        }
        this._closure = this._tranClosureTranspose;
    }
}

