/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sr.lib;

import javax.swing.text.BadLocationException;
import ptolemy.actor.lib.gui.Display;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class NonStrictDisplay
extends Display {
    private static final String ABSENT_STRING = "absent";
    private static final String UNDEFINED_STRING = "undefined";

    public NonStrictDisplay(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public boolean isStrict() {
        return false;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int width = this.input.getWidth();
        for (int i = 0; i < width; ++i) {
            String value;
            if (this.input.isKnown(i)) {
                if (this.input.hasToken(i)) {
                    Token token = this.input.get(i);
                    if (this.textArea == null) continue;
                    value = token.toString();
                    if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                } else {
                    value = ABSENT_STRING;
                }
            } else {
                value = UNDEFINED_STRING;
            }
            this.textArea.append(value);
            if (width > i + 1) {
                this.textArea.append("\n");
            }
            try {
                int lineOffset = this.textArea.getLineStartOffset(this.textArea.getLineCount() - 1);
                this.textArea.setCaretPosition(lineOffset);
                continue;
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        if (this.textArea != null) {
            this.textArea.append("\n");
        }
        return true;
    }
}

